/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.upgrade.entity.DeployResultEnum;
import kd.bos.devportal.upgrade.entity.DeployResultInfo;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;

public class BizAppInstallDetailMsgList
extends AbstractFormPlugin
implements ClickListener {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_ENTRY_DMFILENAME = "dmfilename";
    private static final String KEY_TREEENTRYENTITY = "treeentryentity";
    private static final String KEY_ENTRY_FILENAME = "filename";
    private static final String KEY_ENTRY_DEPLOYRESULT = "deployresult";
    private static final String KEY_ENTRY_DETAIL = "detail";
    private static final String ERRORFORM = "errorform";
    private static final String ERRORMSG = "errormsg";

    public void afterCreateNewData(EventObject evt) {
        Boolean oldMode = Boolean.parseBoolean((String)this.getView().getFormShowParameter().getCustomParam("oldMode"));
        if (oldMode.booleanValue()) {
            this.renderListTable();
        } else {
            this.showDeployDetailMsg();
        }
    }

    private void showDeployDetailMsg() {
        List installMsg = (List)this.getView().getFormShowParameter().getCustomParam("installmsg");
        if (installMsg != null && !installMsg.isEmpty()) {
            ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(installMsg.size());
            int curRowIndex = 0;
            for (String msg : installMsg) {
                DeployResultInfo patchDeployInfo = (DeployResultInfo)SerializationUtils.fromJsonString((String)msg, DeployResultInfo.class);
                this.getModel().createNewEntryRow(KEY_TREEENTRYENTITY);
                int currRootRowIndex = curRowIndex;
                this.treeEntrySetRootRowVal(patchDeployInfo, currRootRowIndex);
                cellStyles.add(this.setCellStyle(KEY_ENTRY_DEPLOYRESULT, patchDeployInfo.getResult(), currRootRowIndex));
                List<DeployResultInfo> dmZipDeployInfoList = patchDeployInfo.getSubDeployResultInfoList();
                if (dmZipDeployInfoList == null || dmZipDeployInfoList.isEmpty()) continue;
                for (DeployResultInfo dmZipDeployInfo : dmZipDeployInfoList) {
                    this.getModel().insertEntryRow(KEY_TREEENTRYENTITY, currRootRowIndex);
                    int curDMZipRowIndex = ++curRowIndex;
                    this.treeEntrySetSubRowValue(dmZipDeployInfo, curDMZipRowIndex, currRootRowIndex);
                    cellStyles.add(this.setCellStyle(KEY_ENTRY_DEPLOYRESULT, dmZipDeployInfo.getResult(), curDMZipRowIndex));
                    List<DeployResultInfo> dmEntryDeployInfoList = dmZipDeployInfo.getSubDeployResultInfoList();
                    if (dmEntryDeployInfoList == null || dmEntryDeployInfoList.isEmpty()) continue;
                    Collections.sort(dmEntryDeployInfoList);
                    int dmZipEntryFileCnt = dmEntryDeployInfoList.size();
                    int[] fileRowIndex = this.getModel().batchInsertEntryRow(KEY_TREEENTRYENTITY, curDMZipRowIndex, dmZipEntryFileCnt);
                    for (int n = 0; n < dmZipEntryFileCnt; ++n) {
                        DeployResultInfo dmZipEntryDeployInfo = dmEntryDeployInfoList.get(n);
                        this.treeEntrySetSubRowValue(dmZipEntryDeployInfo, fileRowIndex[n], curDMZipRowIndex);
                        cellStyles.add(this.setCellStyle(KEY_ENTRY_DEPLOYRESULT, dmZipEntryDeployInfo.getResult(), fileRowIndex[n]));
                        ++curRowIndex;
                    }
                }
                ++curRowIndex;
            }
            AbstractGrid grid = (AbstractGrid)this.getControl(KEY_TREEENTRYENTITY);
            grid.setCellStyle(cellStyles);
        }
    }

    private void treeEntrySetRootRowVal(DeployResultInfo deployInfo, int index) {
        String fileName = deployInfo.getFileName();
        String result = deployInfo.getResult();
        String resultVal = "";
        if (StringUtils.equalsIgnoreCase((CharSequence)result, (CharSequence)DeployResultEnum.SUCCESS.getCode())) {
            resultVal = ResManager.loadKDString((String)"\u6210\u529f", (String)"BizAppInstallDetailMsgList_0", (String)"bos-devportal-plugin", (Object[])new Object[0]);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)result, (CharSequence)DeployResultEnum.WARN.getCode())) {
            resultVal = ResManager.loadKDString((String)"\u6210\u529f(\u6709\u8b66\u544a)", (String)"BizAppInstallDetailMsgList_1", (String)"bos-devportal-plugin", (Object[])new Object[0]);
            this.getModel().setValue(KEY_ENTRY_DETAIL, deployInfo.getWarnMsgList(), index);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)result, (CharSequence)DeployResultEnum.FAIL.getCode())) {
            resultVal = ResManager.loadKDString((String)"\u5931\u8d25", (String)"BizAppInstallDetailMsgList_2", (String)"bos-devportal-plugin", (Object[])new Object[0]);
            this.getModel().setValue(KEY_ENTRY_DETAIL, deployInfo.getErrorMsgList(), index);
        }
        this.getModel().setValue(KEY_ENTRY_FILENAME, (Object)fileName, index);
        this.getModel().setValue(KEY_ENTRY_DEPLOYRESULT, (Object)resultVal, index);
    }

    private void treeEntrySetSubRowValue(DeployResultInfo deployInfo, int curRowIndex, int parentRowIndex) {
        String fileName = deployInfo.getFileName();
        String result = deployInfo.getResult();
        String resultVal = "";
        if (StringUtils.equalsIgnoreCase((CharSequence)result, (CharSequence)DeployResultEnum.SUCCESS.getCode())) {
            resultVal = ResManager.loadKDString((String)"\u6210\u529f", (String)"BizAppInstallDetailMsgList_0", (String)"bos-devportal-plugin", (Object[])new Object[0]);
            this.getModel().setValue(KEY_ENTRY_DETAIL, deployInfo.getInfo(), curRowIndex, parentRowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)result, (CharSequence)DeployResultEnum.WARN.getCode())) {
            resultVal = ResManager.loadKDString((String)"\u6210\u529f(\u6709\u8b66\u544a)", (String)"BizAppInstallDetailMsgList_1", (String)"bos-devportal-plugin", (Object[])new Object[0]);
            this.getModel().setValue(KEY_ENTRY_DETAIL, deployInfo.getWarnMsgList(), curRowIndex, parentRowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)result, (CharSequence)DeployResultEnum.FAIL.getCode())) {
            resultVal = ResManager.loadKDString((String)"\u5931\u8d25", (String)"BizAppInstallDetailMsgList_2", (String)"bos-devportal-plugin", (Object[])new Object[0]);
            this.getModel().setValue(KEY_ENTRY_DETAIL, deployInfo.getErrorMsgList(), curRowIndex, parentRowIndex);
        }
        if (fileName.endsWith("@rebuild")) {
            fileName = fileName.replace("@rebuild", "");
            resultVal = String.format(ResManager.loadKDString((String)"\u91cd\u5efa\u8fd0\u884c\u671f\u5143\u6570\u636e%s", (String)"BizAppInstallDetailMsgList_3", (String)"bos-devportal-plugin", (Object[])new Object[0]), resultVal);
        }
        this.getModel().setValue(KEY_ENTRY_FILENAME, (Object)fileName, curRowIndex, parentRowIndex);
        this.getModel().setValue(KEY_ENTRY_DEPLOYRESULT, (Object)resultVal, curRowIndex, parentRowIndex);
    }

    private CellStyle setCellStyle(String fieldKey, String value, int rowIndex) {
        String fontColor = "black";
        if (StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)DeployResultEnum.SUCCESS.getCode())) {
            fontColor = "#1ba854";
        } else if (StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)DeployResultEnum.WARN.getCode())) {
            fontColor = "#ff991c";
        } else if (StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)DeployResultEnum.FAIL.getCode())) {
            fontColor = "red";
        }
        CellStyle cellStyle = new CellStyle();
        cellStyle.setRow(rowIndex);
        cellStyle.setFieldKey(fieldKey);
        cellStyle.setForeColor(fontColor);
        return cellStyle;
    }

    private void renderListTable() {
        Map installMsg = (Map)this.getView().getFormShowParameter().getCustomParam("installmsg");
        if (installMsg.size() > 0) {
            String errorMsg;
            String formIdOrNum;
            Map lostPageMap;
            int errorCount;
            int successCount;
            List errorList = (List)installMsg.get("errorlist");
            List successList = (List)installMsg.get("successlist");
            List repeatList = (List)installMsg.get("repeatsqllist");
            if (successList == null) {
                successCount = 0;
            } else {
                successList = successList.stream().filter(f -> !f.isEmpty()).collect(Collectors.toList());
                successCount = successList.size();
            }
            if (errorList == null) {
                errorCount = 0;
            } else {
                errorList = errorList.stream().filter(f -> !f.isEmpty()).collect(Collectors.toList());
                errorCount = errorList.size();
            }
            int repeatCount = repeatList == null ? 0 : repeatList.size();
            int allCount = errorCount + successCount + repeatCount;
            if (allCount > 0) {
                this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, allCount);
            }
            for (int i = 0; i < errorCount; ++i) {
                if (errorList.size() <= 0) continue;
                lostPageMap = (Map)errorList.get(i);
                for (Map.Entry entry : lostPageMap.entrySet()) {
                    formIdOrNum = (String)entry.getKey();
                    errorMsg = (String)entry.getValue();
                    this.getModel().setValue(ERRORFORM, (Object)formIdOrNum, i);
                    this.getModel().setValue(ERRORMSG, (Object)errorMsg, i);
                }
            }
            for (int h = 0; h < repeatCount; ++h) {
                if (repeatList.size() <= 0) continue;
                lostPageMap = (Map)repeatList.get(h);
                for (Map.Entry entry : lostPageMap.entrySet()) {
                    formIdOrNum = (String)entry.getKey();
                    errorMsg = (String)entry.getValue();
                    this.getModel().setValue(ERRORFORM, (Object)formIdOrNum, h + errorCount);
                    this.getModel().setValue(ERRORMSG, (Object)errorMsg, h + errorCount);
                }
            }
            for (int j = 0; j < successCount; ++j) {
                if (successList.size() <= 0) continue;
                lostPageMap = (Map)successList.get(j);
                for (Map.Entry entry : lostPageMap.entrySet()) {
                    formIdOrNum = (String)entry.getKey();
                    errorMsg = (String)entry.getValue();
                    this.getModel().setValue(ERRORFORM, (Object)formIdOrNum, j + errorCount + repeatCount);
                    this.getModel().setValue(ERRORMSG, (Object)errorMsg, j + errorCount + repeatCount);
                }
            }
        }
    }
}

