/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.upgrade.entity.DeployResultEnum;
import kd.bos.devportal.upgrade.entity.DeployResultInfo;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;

public class BizAppInstallMsg
extends AbstractFormPlugin
implements ClickListener {
    private static final String INSTALLMSG = "installmsg";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private int succCnt = 0;
    private int warnCnt = 0;
    private int failCnt = 0;

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"showdetail"});
    }

    public void afterCreateNewData(EventObject e) {
        if (this.isOldMode()) {
            this.showResultByOldMode();
            return;
        }
        Label successMsgLabel = (Label)this.getControl("successmessage");
        List installMsg = (List)this.getView().getFormShowParameter().getCustomParam(INSTALLMSG);
        this.getAllDeployResultCnt(installMsg);
        String succMsg = String.format(ResManager.loadKDString((String)"\u6210\u529f\uff1a%s \u4e2a\u6587\u4ef6", (String)"BizAppInstallMsg_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), this.succCnt);
        if (this.warnCnt > 0) {
            succMsg = String.format(ResManager.loadKDString((String)"%1$s ; \u5ffd\u7565\u6267\u884c\uff1a%2$s \u4e2a\u6587\u4ef6", (String)"BizAppInstallMsg_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), succMsg, this.warnCnt);
        }
        successMsgLabel.setText(succMsg);
        if (this.failCnt > 0) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u5931\u8d25\uff1a%s \u4e2a\u6587\u4ef6", (String)"BizAppInstallMsg_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), this.failCnt);
            Label errorMsgLabel = (Label)this.getControl("errormessage");
            errorMsgLabel.setText(errMsg);
        }
        super.afterCreateNewData(e);
    }

    private boolean isOldMode() {
        return Boolean.parseBoolean((String)this.getView().getFormShowParameter().getCustomParam("oldMode"));
    }

    private void showResultByOldMode() {
        int error;
        int success;
        Label successMsg = (Label)this.getControl("successmessage");
        Label errorMsg = (Label)this.getControl("errormessage");
        Map installMsg = (Map)this.getView().getFormShowParameter().getCustomParam(INSTALLMSG);
        List errorList = (List)installMsg.get("errorlist");
        List successList = (List)installMsg.get("successlist");
        List repeatSqlList = (List)installMsg.get("repeatsqllist");
        if (successList == null) {
            success = 0;
        } else {
            successList = successList.stream().filter(f -> !f.isEmpty()).collect(Collectors.toList());
            success = successList.size();
        }
        if (errorList == null) {
            error = 0;
        } else {
            errorList = errorList.stream().filter(f -> !f.isEmpty()).collect(Collectors.toList());
            error = errorList.size();
        }
        int repeatSql = repeatSqlList == null ? 0 : repeatSqlList.size();
        if (repeatSql > 0) {
            successMsg.setText(String.format(ResManager.loadKDString((String)"\u6210\u529f\uff1a%1$s\u4e2a\u6587\u4ef6 ; \u91cd\u590d\u6267\u884c\uff1a%2$s\u4e2a\u6587\u4ef6", (String)"BizAppInstallMsg_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), success, repeatSql));
        } else {
            successMsg.setText(String.format(ResManager.loadKDString((String)"\u6210\u529f\uff1a%1$s\u4e2a\u6587\u4ef6", (String)"BizAppInstallMsg_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), success));
        }
        if (error > 0) {
            errorMsg.setText(String.format(ResManager.loadKDString((String)"\u5931\u8d25\uff1a%1$s\u4e2a\u6587\u4ef6", (String)"BizAppInstallMsg_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), error));
        }
    }

    private void getAllDeployResultCnt(List<String> installMsg) {
        for (String dmDeployInfoStr : installMsg) {
            DeployResultInfo patchDeployInfo = (DeployResultInfo)SerializationUtils.fromJsonString((String)dmDeployInfoStr, DeployResultInfo.class);
            List<DeployResultInfo> subDeployResult = patchDeployInfo.getSubDeployResultInfoList();
            if (subDeployResult == null || subDeployResult.isEmpty()) continue;
            this.getAllDeployResultCnt(patchDeployInfo);
        }
    }

    private void getAllDeployResultCnt(DeployResultInfo deployResultInfo) {
        String deployResult = deployResultInfo.getResult();
        List<DeployResultInfo> subDeployResult = deployResultInfo.getSubDeployResultInfoList();
        if (subDeployResult != null && !subDeployResult.isEmpty()) {
            for (DeployResultInfo subResultInfo : subDeployResult) {
                this.getAllDeployResultCnt(subResultInfo);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)DeployResultEnum.SUCCESS.getCode(), (CharSequence)deployResult)) {
            ++this.succCnt;
        } else if (StringUtils.equalsIgnoreCase((CharSequence)DeployResultEnum.WARN.getCode(), (CharSequence)deployResult)) {
            ++this.warnCnt;
        } else if (StringUtils.equalsIgnoreCase((CharSequence)DeployResultEnum.FAIL.getCode(), (CharSequence)deployResult)) {
            ++this.failCnt;
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase()) {
            case "showdetail": {
                if (this.isOldMode()) {
                    this.showOldDetailErrorMsg();
                    break;
                }
                this.showDetailErrorMsg();
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        FormShowParameter param = this.getView().getFormShowParameter();
        String parentPageId = (String)param.getCustomParam("parentPageId");
        if (StringUtils.isNotBlank((CharSequence)parentPageId)) {
            IFormView parentView = this.getView().getView(parentPageId);
            parentView.close();
            this.getView().sendFormAction(parentView);
        }
    }

    private void showDetailErrorMsg() {
        List installMsg = (List)this.getView().getFormShowParameter().getCustomParam(INSTALLMSG);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.NewWindow);
        parameter.setFormId("bos_devp_installappli_inh");
        parameter.setCaption(ResManager.loadKDString((String)"\u5e94\u7528\u5b89\u88c5\u4fe1\u606f\u8be6\u60c5", (String)"BizAppInstallMsg_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        parameter.setCustomParam(INSTALLMSG, (Object)installMsg);
        this.getView().showForm(parameter);
    }

    private void showOldDetailErrorMsg() {
        Map installMsg = (Map)this.getView().getFormShowParameter().getCustomParam(INSTALLMSG);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devp_installapplist");
        parameter.setCustomParam("oldMode", (Object)"true");
        parameter.setCaption(ResManager.loadKDString((String)"\u5e94\u7528\u5b89\u88c5\u4fe1\u606f\u8be6\u60c5", (String)"BizAppInstallMsg_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        parameter.setCustomParam(INSTALLMSG, (Object)installMsg);
        this.getView().showForm(parameter);
    }
}

