/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.MoveEntryDown;
import kd.bos.form.operate.MoveEntryUp;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class BizAppInstallSequencePlugin
extends AbstractFormPlugin {
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String APPSEQENTRYENTITY = "appseqentryentity";
    private static final String KEY_APPID = "appid";
    private static final String KEY_APPNAME = "appname";
    private static final String KEY_APPTYPE = "apptype";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"confirm"});
    }

    public void afterCreateNewData(EventObject e) {
        List bizAppIdList;
        String selectAppIds = (String)this.getView().getFormShowParameter().getCustomParam("selectappids");
        if (StringUtils.isBlank((CharSequence)selectAppIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u5143\u6570\u636e\u3002", (String)"BizAppInstallSequencePlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        List selectAppList = (List)SerializationUtils.fromJsonString((String)selectAppIds, List.class);
        String bizAppIdListCache = this.getPageCache().get("changedappids");
        if (StringUtils.isNotBlank((CharSequence)bizAppIdListCache) && !(bizAppIdList = (List)SerializationUtils.fromJsonString((String)bizAppIdListCache, List.class)).isEmpty()) {
            selectAppList = bizAppIdList;
        }
        this.getAppSequenceEntryEntity(selectAppList);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        if (e.getSource() instanceof MoveEntryUp || e.getSource() instanceof MoveEntryDown) {
            AbstractGrid grid = (AbstractGrid)this.getControl(APPSEQENTRYENTITY);
            int index = grid.getEntryState().getFocusRow();
            String bizAppIdListCache = this.getPageCache().get("appidlist");
            List bizAppIdList = (List)SerializationUtils.fromJsonString((String)bizAppIdListCache, List.class);
            DynamicObject bizAppInfo = this.getModel().getEntryRowEntity(APPSEQENTRYENTITY, index);
            String currentAppId = bizAppInfo.getString(KEY_APPID);
            int currentIndex = bizAppIdList.indexOf(currentAppId);
            if (e.getSource() instanceof MoveEntryUp && "moveentryup".equals(((MoveEntryUp)e.getSource()).getOperateKey())) {
                if (index <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u5df2\u662f\u7b2c\u4e00\u884c\u3002", (String)"BizAppInstallSequencePlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(2000));
                    e.setCancel(true);
                } else {
                    Collections.swap(bizAppIdList, currentIndex, currentIndex - 1);
                    e.setCancel(true);
                }
            } else if (e.getSource() instanceof MoveEntryDown && "moveentrydown".equals(((MoveEntryDown)e.getSource()).getOperateKey())) {
                DynamicObject nextRow = this.getModel().getEntryRowEntity(APPSEQENTRYENTITY, index + 1);
                if (nextRow == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u5df2\u662f\u6700\u540e\u4e00\u884c\u3002", (String)"BizAppInstallSequencePlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(2000));
                    e.setCancel(true);
                } else {
                    Collections.swap(bizAppIdList, currentIndex, currentIndex + 1);
                    e.setCancel(true);
                }
            }
            this.getPageCache().put("changedappids", SerializationUtils.toJsonString((Object)bizAppIdList));
            this.getView().getModel().beginInit();
            this.getView().getModel().createNewData();
            this.getView().getModel().endInit();
            this.getView().updateView();
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("confirm".equalsIgnoreCase(key)) {
            this.confirm();
        }
    }

    private void confirm() {
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(APPSEQENTRYENTITY);
        LinkedHashMap<String, String> appInfo = new LinkedHashMap<String, String>();
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String bizAppId = dynamicObject.getString(KEY_APPID);
            String bizAppNumber = dynamicObject.getString("appnumber");
            appInfo.put(bizAppId, bizAppNumber);
        }
        this.getView().returnDataToParent(appInfo);
        this.getView().close();
    }

    private void getAppSequenceEntryEntity(List<String> selectAppList) {
        final ArrayList<Object> appInfoList = new ArrayList<Object>();
        for (String bizAppId : selectAppList) {
            HashMap<String, String> appInfo = new HashMap<String, String>();
            appInfo.put(KEY_APPID, bizAppId);
            AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
            String appnumber = appMetadata.getNumber();
            appInfo.put("appnum", appnumber);
            String appName = appMetadata.getName().getLocaleValue();
            appInfo.put(KEY_APPNAME, appName);
            String appType = appMetadata.getDevType();
            appInfo.put(KEY_APPTYPE, appType);
            appInfoList.add(appInfo);
        }
        ArrayList<String> appIdList = new ArrayList<String>();
        if (!appInfoList.isEmpty()) {
            this.getModel().deleteEntryData(APPSEQENTRYENTITY);
            this.getModel().batchCreateNewEntryRow(APPSEQENTRYENTITY, appInfoList.size());
            int i = 0;
            for (Map map : appInfoList) {
                String bizAppId = (String)map.get(KEY_APPID);
                appIdList.add(bizAppId);
                String bizAppNum = (String)map.get("appnum");
                String bizAppName = (String)map.get(KEY_APPNAME);
                String bizAppType = (String)map.get(KEY_APPTYPE);
                this.getModel().setValue(KEY_APPID, (Object)bizAppId, i);
                this.getModel().setValue("appnumber", (Object)bizAppNum, i);
                this.getModel().setValue(KEY_APPNAME, (Object)bizAppName, i);
                if ("2".equals(bizAppType)) {
                    this.getModel().setValue(KEY_APPTYPE, (Object)2, i);
                } else {
                    this.getModel().setValue(KEY_APPTYPE, (Object)1, i);
                }
                ++i;
            }
        }
        this.getPageCache().put("appidlist", SerializationUtils.toJsonString(appIdList));
        AbstractGrid grid = (AbstractGrid)this.getControl(APPSEQENTRYENTITY);
        EntryGrid entryGrid = (EntryGrid)grid;
        entryGrid.addPackageDataListener((Consumer)new Consumer<PackageDataEvent>(){

            @Override
            public void accept(PackageDataEvent e) {
                int seq = e.getRowData().getInt("seq");
                if (e.getSource() instanceof OperationColumn && "operationcolumnap".equalsIgnoreCase(((OperationColumn)e.getSource()).getKey())) {
                    List operationColItems = (List)e.getFormatValue();
                    if (seq == 1) {
                        for (OperationColItem operationColItem : operationColItems) {
                            if (!"moveentryup".equalsIgnoreCase(operationColItem.getOperationKey())) continue;
                            operationColItem.setLocked(true);
                        }
                    }
                    if (seq == appInfoList.size()) {
                        for (OperationColItem operationColItem : operationColItems) {
                            if (!"moveentrydown".equalsIgnoreCase(operationColItem.getOperationKey())) continue;
                            operationColItem.setLocked(true);
                        }
                    }
                }
            }
        });
    }
}

