/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class BizAppMenuListPlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener {
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String ENTRYENTITY = "entryentity";
    private static final String DESCRIPTION = "description";
    private static final String KEY_LEVEL = "level";
    private static final String KEY_MENUID = "menuid";
    private static final String KEY_MENUNAME = "menuname";

    public void registerListener(EventObject e) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRYENTITY);
        grid.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"confirm"});
    }

    public void afterCreateNewData(EventObject evt) {
        this.renderListTable();
    }

    private void renderListTable() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String bizAppId = (String)fsp.getCustomParam("bizappid");
        boolean isParent = (Boolean)fsp.getCustomParam("isparent");
        String selectNodeId = (String)fsp.getCustomParam("selectnodeid");
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        List menuElements = appMeta.getAppMenus();
        JSONArray menuItems = new JSONArray();
        JSONArray appIds = DevportalUtil.getBizAppIds(bizAppId);
        OperationStatus operationStatus = fsp.getStatus();
        for (AppMenuElement menuElement : menuElements) {
            String parentMenuId = menuElement.getParentId();
            String menuId = menuElement.getId();
            if (menuId.endsWith("#hpce") || !StringUtils.isBlank((CharSequence)parentMenuId) && !appIds.contains((Object)parentMenuId)) continue;
            JSONObject resMap = new JSONObject();
            resMap.put("number", (Object)menuElement.getNumber());
            resMap.put("name", menuElement.getName().getDefaultItem());
            resMap.put(DESCRIPTION, (Object)menuElement.getDescription().getLocaleValue());
            resMap.put("parentid", (Object)menuElement.getParentId());
            resMap.put("id", (Object)menuId);
            resMap.put(KEY_LEVEL, (Object)ResManager.loadKDString((String)"1 \u7ea7", (String)"BizAppMenuListPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            menuItems.add((Object)resMap);
            if (isParent && !OperationStatus.ADDNEW.equals((Object)operationStatus)) continue;
            this.recursionMenuInfo(menuElements, menuItems, menuId, true, operationStatus, selectNodeId);
        }
        JSONArray list = new JSONArray();
        for (int j = 0; j < menuItems.size(); ++j) {
            list.add((Object)menuItems.getJSONObject(j));
        }
        if (list.size() > 0) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, list.size() + 1);
        } else {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, 1);
        }
        this.getModel().setValue(KEY_LEVEL, (Object)ResManager.loadKDString((String)"\u6839\u8282\u70b9", (String)"BizAppMenuListPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), 0);
        this.getModel().setValue(KEY_MENUID, (Object)bizAppId, 0);
        this.getModel().setValue(KEY_MENUNAME, (Object)appMeta.getName().getLocaleValue(), 0);
        this.getModel().setValue(DESCRIPTION, (Object)"", 0);
        for (int i = 0; i < list.size(); ++i) {
            JSONObject jo = (JSONObject)list.get(i);
            this.getModel().setValue(KEY_LEVEL, jo.get((Object)KEY_LEVEL), i + 1);
            this.getModel().setValue(KEY_MENUID, jo.get((Object)"id"), i + 1);
            this.getModel().setValue(KEY_MENUNAME, jo.get((Object)"name"), i + 1);
            this.getModel().setValue(DESCRIPTION, jo.get((Object)DESCRIPTION), i + 1);
        }
    }

    private JSONArray recursionMenuInfo(List<AppMenuElement> menuElements, JSONArray menuItems, String filterMenuId, boolean isLeaf, OperationStatus operationStatus, String selectNodeId) {
        if (isLeaf) {
            for (AppMenuElement menuElement : menuElements) {
                String menuId = menuElement.getId();
                String parentMenuId = menuElement.getParentId();
                if (!filterMenuId.equals(parentMenuId) || OperationStatus.EDIT.equals((Object)operationStatus) && (selectNodeId.equals(menuId) || parentMenuId.equals(menuId))) continue;
                JSONObject menuInfo = new JSONObject();
                menuInfo.put("name", menuElement.getName().getDefaultItem());
                menuInfo.put("number", (Object)menuElement.getNumber());
                menuInfo.put(DESCRIPTION, (Object)menuElement.getDescription().getLocaleValue());
                menuInfo.put("parentid", (Object)parentMenuId);
                menuInfo.put("id", (Object)menuId);
                menuInfo.put(KEY_LEVEL, (Object)ResManager.loadKDString((String)"2 \u7ea7", (String)"BizAppMenuListPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                menuItems.add((Object)menuInfo);
            }
        }
        return menuItems;
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("confirm".equalsIgnoreCase(key)) {
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRYENTITY);
            int row = grid.getEntryState().getFocusRow();
            if (row >= 0) {
                HashMap<String, String> ret = new HashMap<String, String>();
                ret.put(KEY_MENUID, (String)this.getModel().getValue(KEY_MENUID, row));
                ret.put(KEY_MENUNAME, (String)this.getModel().getValue(KEY_MENUNAME, row));
                ret.put(DESCRIPTION, (String)this.getModel().getValue(DESCRIPTION, row));
                this.getView().returnDataToParent(ret);
                this.getView().close();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"BizAppMenuListPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
        }
    }
}

