/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import com.alibaba.fastjson.JSONArray;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.devportal.AppElement;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.MoveEntryDown;
import kd.bos.form.operate.MoveEntryUp;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetaLogType;
import kd.bos.metadata.dao.MetaType;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataLogService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class BizAppMenuTreePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
HyperLinkClickListener {
    private static final String MENU_TREE = "menutreeview";
    private static final String MENUENTRYENTITY = "menuentryentity";
    private static final String MENUID = "menuid";
    private static final String CHECKEDNODEID = "checkednodeid";
    private static final String PARENTID = "parentid";
    private static final String BIZPARENTAPPID = "bizparentappid";
    private static final String MENUSEQ = "menuseq";
    private static final String MENUNAME = "menuname";
    private static final String PARENTMENUID = "parentmenuid";
    private static final String MOVEENTRYUP = "moveentryup";
    private static final String MOVEENTRYDOWN = "moveentrydown";
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DELETE = "btndelete";
    private static final String BTN_RETSET = "btnretset";
    private static final String BTN_NEWSON = "btnnewson";
    private static final String DELETENODECALLBACK = "deleteNodeCallBack";
    private static final String DELETENODEIDS = "deletenodeids";
    private static final String EDITCALLBACK = "editCallBack";
    private static final String NODELEVEL = "nodelevel";
    private static final String HPCE = "#hpce";
    private static final String FORMNAME = "formname";
    private static final String FORMNUMBER = "formnumber";
    private static final String APPNAME = "appname";
    private static final String OPENTYPE = "opentype";
    private static final String VISIABLE = "visiable";
    private static final String NODEID = "nodeid";
    private static final String PARENTNODEID = "parentnodeid";
    private static final String FORMID = "formid";
    private static final String ISPARENT = "isparent";
    private static final String CHECKEDPARENTNODEID = "checkedparentnodeid";
    private static final String BOS_DEVP_APPMENUMETA = "bos_devp_appmenumeta";
    private static Log logger = LogFactory.getLog(BizAppMenuTreePlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_NEW, BTN_EDIT, BTN_DELETE, BTN_RETSET, BTN_NEWSON});
        TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        AbstractGrid grid = (AbstractGrid)this.getControl(MENUENTRYENTITY);
        grid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"menuoperateflexpanel", MENUID, "operationcolumnap"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{MENUID});
        }
        this.createHelpCenter(bizAppId);
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataById((String)bizAppId, (boolean)false);
        String appType = metadata.getDevType();
        if (!"2".equals(appType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_RETSET});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_NEW, BTN_EDIT, BTN_DELETE});
        this.renderMenuTree(metadata);
        this.showMenuList(bizAppId, metadata);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if ("checkboxfield".equalsIgnoreCase(propertyName)) {
            TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
            Map nodeInfo = tree.getTreeState().getFocusNode();
            if (nodeInfo.get("id") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u4e2a\u83dc\u5355\u4f5c\u4e3a\u6dfb\u52a0\u6570\u636e\u7684\u7236\u83dc\u5355\u3002", (String)"BizAppMenuTreePlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]));
                return;
            }
            String nodeId = nodeInfo.get("id").toString();
            String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
            AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataById((String)bizAppId, (boolean)false);
            this.showMenuList(nodeId, metadata);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        TreeView tree;
        Map nodeInfo;
        String menuId;
        AppMenuElement menu;
        int i;
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
        String bizAppName = (String)this.getView().getFormShowParameter().getCustomParam("bizappname");
        AbstractGrid grid = (AbstractGrid)this.getControl(MENUENTRYENTITY);
        int index = grid.getEntryState().getFocusRow();
        DynamicObject bizMenuInfo = this.getModel().getEntryRowEntity(MENUENTRYENTITY, index);
        Integer currentSeq = bizMenuInfo.getInt(MENUSEQ);
        String currentMenuId = bizMenuInfo.getString(MENUID);
        String currentParentMenuId = bizMenuInfo.getString(PARENTMENUID);
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataById((String)bizAppId, (boolean)false);
        JSONArray appIds = DevportalUtil.getBizAppIds(bizAppId);
        if (e.getSource() instanceof MoveEntryUp) {
            if (MOVEENTRYUP.equals(((MoveEntryUp)e.getSource()).getOperateKey())) {
                if (index <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u5df2\u7ecf\u662f\u7b2c\u4e00\u884c\u3002", (String)"BizAppMenuTreePlugin_1", (String)"bos-devportal-plugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    e.setCancel(true);
                } else {
                    DynamicObject beforeRow = this.getModel().getEntryRowEntity(MENUENTRYENTITY, index - 1);
                    Integer beforeMenuSeq = beforeRow.getInt(MENUSEQ);
                    String beforeMenuId = beforeRow.getString(MENUID);
                    String beforeParentMenuId = beforeRow.getString(PARENTMENUID);
                    if (currentParentMenuId.equals(beforeMenuId) || (StringUtils.isBlank((CharSequence)currentParentMenuId) || appIds.contains((Object)currentParentMenuId)) && StringUtils.isNotBlank((CharSequence)beforeParentMenuId) && !appIds.contains((Object)beforeParentMenuId)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u79fb\u53ea\u80fd\u5728\u540c\u7ea7\u83dc\u5355\u79fb\u52a8\u3002", (String)"BizAppMenuTreePlugin_2", (String)"bos-devportal-plugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    if (beforeMenuSeq.equals(currentSeq)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u4e0e\u4e0a\u4e00\u884c\u83dc\u5355\u5e8f\u53f7\u4e00\u81f4,\u8bf7\u5728\u83dc\u5355\u4fee\u6539\u4e2d\u8c03\u6574\u5e8f\u53f7\u3002", (String)"BizAppMenuTreePlugin_3", (String)"bos-devportal-plugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    for (i = 0; i < appMeta.getAppMenus().size(); ++i) {
                        menu = (AppMenuElement)appMeta.getAppMenus().get(i);
                        menuId = menu.getId();
                        if (menuId.equals(currentMenuId)) {
                            menu.setSeq(beforeMenuSeq.shortValue());
                            continue;
                        }
                        if (!menuId.equals(beforeMenuId)) continue;
                        menu.setSeq(currentSeq.shortValue());
                    }
                    e.setCancel(true);
                    ThreadCache.put((Object)"AppMetaDao.querySubApp.ignoreExtApp", (Object)"true");
                    AppMetaServiceHelper.save((AppMetadata)appMeta);
                    BizAppMenuTreePlugin.writeLog(bizAppId, MetaLogType.AppMenuSave);
                    ThreadCache.remove((Object)"AppMetaDao.querySubApp.ignoreExtApp");
                }
            }
        } else if (e.getSource() instanceof MoveEntryDown && MOVEENTRYDOWN.equals(((MoveEntryDown)e.getSource()).getOperateKey())) {
            DynamicObject nextRow = this.getModel().getEntryRowEntity(MENUENTRYENTITY, index + 1);
            if (nextRow == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u884c\u3002", (String)"BizAppMenuTreePlugin_4", (String)"bos-devportal-plugin", (Object[])new Object[0]), Integer.valueOf(2000));
                e.setCancel(true);
            } else {
                Integer nextMenuSeq = nextRow.getInt(MENUSEQ);
                String nextMenuId = nextRow.getString(MENUID);
                String nextParentMenuId = nextRow.getString(PARENTMENUID);
                if (currentMenuId.equals(nextParentMenuId) || StringUtils.isNotBlank((CharSequence)currentParentMenuId) && !appIds.contains((Object)currentParentMenuId) && (StringUtils.isBlank((CharSequence)nextParentMenuId) || appIds.contains((Object)currentParentMenuId))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u79fb\u53ea\u80fd\u5728\u540c\u7ea7\u83dc\u5355\u79fb\u52a8\u3002", (String)"BizAppMenuTreePlugin_5", (String)"bos-devportal-plugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                if (nextMenuSeq.equals(currentSeq)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u4e0e\u4e0b\u4e00\u884c\u83dc\u5355\u5e8f\u53f7\u4e00\u81f4,\u8bf7\u5728\u83dc\u5355\u4fee\u6539\u4e2d\u8c03\u6574\u5e8f\u53f7\u3002", (String)"BizAppMenuTreePlugin_6", (String)"bos-devportal-plugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                for (i = 0; i < appMeta.getAppMenus().size(); ++i) {
                    menu = (AppMenuElement)appMeta.getAppMenus().get(i);
                    menuId = menu.getId();
                    if (menuId.equals(currentMenuId)) {
                        menu.setSeq(nextMenuSeq.shortValue());
                        continue;
                    }
                    if (!menuId.equals(nextMenuId)) continue;
                    menu.setSeq(currentSeq.shortValue());
                }
                e.setCancel(true);
                ThreadCache.put((Object)"AppMetaDao.querySubApp.ignoreExtApp", (Object)"true");
                AppMetaServiceHelper.save((AppMetadata)appMeta);
                BizAppMenuTreePlugin.writeLog(bizAppId, MetaLogType.AppMenuSave);
                ThreadCache.remove((Object)"AppMetaDao.querySubApp.ignoreExtApp");
            }
        }
        if ((nodeInfo = (tree = (TreeView)this.getView().getControl(MENU_TREE)).getTreeState().getFocusNode()).get("id") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u4e2a\u83dc\u5355\u4f5c\u4e3a\u6dfb\u52a0\u6570\u636e\u7684\u7236\u83dc\u5355\u3002", (String)"BizAppMenuTreePlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            return;
        }
        String nodeId = nodeInfo.get("id").toString();
        String nodeText = nodeInfo.get("text").toString();
        String parentNodeID = nodeInfo.get(PARENTID).toString();
        TreeNode root = new TreeNode("", bizAppId, bizAppName);
        AppMetadata appEditMeta = AppMetaServiceHelper.loadAppMetadataById((String)bizAppId, (boolean)false);
        List<TreeNode> nodeList = this.getNodeList(appEditMeta);
        DevportalUtil.buildNode(root, nodeList);
        tree.updateNode(root);
        TreeNode newNode = new TreeNode(parentNodeID, nodeId, nodeText);
        tree.focusNode(newNode);
        tree.showNode(nodeId);
        tree.treeNodeClick(parentNodeID, nodeId);
        this.getPageCache().put("root", SerializationUtils.toJsonString((Object)root));
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackID = evt.getCallBackId();
        if (DELETENODECALLBACK.equalsIgnoreCase(callBackID) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            String bizAppID = (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
            Boolean isDeleteOK = this.deleteNodeInfo(this.getPageCache().get(DELETENODEIDS).split("&"));
            if (isDeleteOK.booleanValue()) {
                TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("root"), TreeNode.class);
                TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
                Map nodeInfo = tree.getTreeState().getFocusNode();
                String parentNodeID = nodeInfo.get(PARENTID).toString();
                TreeNode parentNode = root.getTreeNode(parentNodeID, 5);
                String nodeID = nodeInfo.get("id").toString();
                root.deleteChildNode(nodeID);
                if (parentNode.getChildren().size() == 0) {
                    parentNode.setChildren(null);
                }
                this.getPageCache().put("root", SerializationUtils.toJsonString((Object)root));
                tree.updateNode(root);
                tree.focusNode(parentNode);
                TreeNodeEvent event = new TreeNodeEvent((Object)tree, (Object)"", (Object)parentNodeID);
                this.treeNodeClick(event);
                tree.showNode(parentNodeID);
                if (!parentNodeID.equals(bizAppID)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{BTN_NEW, BTN_NEWSON});
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u83dc\u5355\u5220\u9664\u6210\u529f\u3002", (String)"BizAppMenuTreePlugin_7", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83dc\u5355\u5220\u9664\u5931\u8d25\u3002", (String)"BizAppMenuTreePlugin_8", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataById((String)bizAppId, (boolean)false);
        String appType = appMetadata.getDevType();
        String bizAppName = appMetadata.getAppElement().getName().getLocaleValue();
        TreeNode root = new TreeNode("", bizAppId, bizAppName);
        List<TreeNode> nodeList = this.getNodeList(appMetadata);
        root.addChildren(nodeList);
        if (evt.getReturnData() != null) {
            if ("addnewCallBack".equalsIgnoreCase(actionId)) {
                Map returnDataMap = (Map)evt.getReturnData();
                String nodeId = (String)returnDataMap.get(MENUID);
                String parentNodeId = (String)returnDataMap.get(PARENTMENUID);
                if (StringUtils.isBlank((CharSequence)parentNodeId)) {
                    parentNodeId = bizAppId;
                }
                String menuName = (String)returnDataMap.get(MENUNAME);
                TreeNode newNode = new TreeNode(parentNodeId, nodeId, menuName);
                tree.addNode(newNode);
                newNode.setIsOpened(true);
                tree.updateNode(root);
                tree.focusNode(newNode);
                TreeNodeEvent event = new TreeNodeEvent((Object)tree, (Object)parentNodeId, (Object)nodeId);
                this.treeNodeClick(event);
                tree.showNode(parentNodeId);
                this.getPageCache().put("root", SerializationUtils.toJsonString((Object)root));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u83dc\u5355\u4fdd\u5b58\u6210\u529f\u3002", (String)"BizAppMenuTreePlugin_9", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            } else if (EDITCALLBACK.equalsIgnoreCase(actionId)) {
                JSONArray InheritAppIds;
                Map returnDataMap = (Map)evt.getReturnData();
                String nodeId = this.getPageCache().get(CHECKEDNODEID);
                String parentNodeId = (String)returnDataMap.get(PARENTMENUID);
                if (StringUtils.isBlank((CharSequence)parentNodeId)) {
                    parentNodeId = bizAppId;
                }
                if ("2".equals(appType) && (InheritAppIds = DevportalUtil.getBizAppIds(bizAppId)).contains((Object)parentNodeId)) {
                    parentNodeId = bizAppId;
                }
                String menuName = (String)returnDataMap.get(MENUNAME);
                TreeNode newNode = new TreeNode(parentNodeId, nodeId, menuName);
                tree.addNode(newNode);
                newNode.setIsOpened(true);
                this.getPageCache().put("root", SerializationUtils.toJsonString((Object)root));
                tree.updateNode(root);
                tree.focusNode(newNode);
                TreeNodeEvent event = new TreeNodeEvent((Object)tree, (Object)parentNodeId, (Object)nodeId);
                this.treeNodeClick(event);
                tree.showNode(parentNodeId);
                String visibleChange = (String)returnDataMap.get("visibleChange");
                if (visibleChange != null && "true".equals(visibleChange)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u83dc\u5355\u4fdd\u5b58\u6210\u529f\uff0c\u6ce8\u610f\uff1a\u4e0b\u7ea7\u83dc\u5355\u53ef\u89c1\u6027\u5df2\u8ddf\u968f\u6539\u53d8\u3002", (String)"BizAppMenuTreePlugin_31", (String)"bos-devportal-plugin", (Object[])new Object[0]));
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u83dc\u5355\u4fdd\u5b58\u6210\u529f\u3002", (String)"BizAppMenuTreePlugin_9", (String)"bos-devportal-plugin", (Object[])new Object[0]));
                }
            } else if ("resetorimenu".equalsIgnoreCase(actionId)) {
                Map resetTreeNode = (Map)evt.getReturnData();
                String returnMenuId = (String)resetTreeNode.get("id");
                String retrunParentMenuId = (String)resetTreeNode.get(PARENTID);
                String parentAppId = this.getPageCache().get(BIZPARENTAPPID);
                if ("".equals(retrunParentMenuId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9664\u6839\u8282\u70b9\u5916\u7684\u83dc\u5355\u8fdb\u884c\u91cd\u7f6e\u3002", (String)"BizAppMenuTreePlugin_10", (String)"bos-devportal-plugin", (Object[])new Object[0]));
                    return;
                }
                AppMetadata parentMetadata = AppMetaServiceHelper.loadAppMetadataById((String)parentAppId, (boolean)false);
                List parentMenus = parentMetadata.getAppMenus();
                ArrayList<String> menuElements = new ArrayList<String>();
                menuElements.add(returnMenuId);
                Set<String> menuSet = new LinkedHashSet<String>();
                menuSet = this.getMenuIds(parentMenus, menuElements, menuSet);
                menuSet.add(returnMenuId);
                List extAppMenus = appMetadata.getAppMenus();
                for (AppMenuElement parentAppMenu : parentMenus) {
                    String parentAppMenuId = parentAppMenu.getId();
                    if (!menuSet.contains(parentAppMenuId)) continue;
                    extAppMenus.add(parentAppMenu);
                    AppMetaServiceHelper.deleteMenuById((String)parentAppMenuId, (String)bizAppId);
                }
                ThreadCache.put((Object)"AppMetaDao.querySubApp.ignoreExtApp", (Object)"true");
                AppMetaServiceHelper.save((AppMetadata)appMetadata);
                BizAppMenuTreePlugin.writeLog(bizAppId, MetaLogType.AppMenuSave);
                ThreadCache.remove((Object)"AppMetaDao.querySubApp.ignoreExtApp");
                AppMetadata extNewMetadata = AppMetaServiceHelper.loadAppMetadataById((String)bizAppId, (boolean)false);
                this.renderMenuTree(extNewMetadata);
                TreeNode newRoot = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("root"), TreeNode.class);
                tree.updateNode(newRoot);
                tree.focusNode(newRoot);
                tree.showNode(returnMenuId);
                TreeNodeEvent event = new TreeNodeEvent((Object)tree, (Object)"", (Object)bizAppId);
                this.treeNodeClick(event);
                this.getPageCache().put("root", SerializationUtils.toJsonString((Object)newRoot));
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
        String nodeLevel = this.getPageCache().get(NODELEVEL);
        Map nodeLevelMap = new HashMap();
        if (StringUtils.isNotBlank((CharSequence)nodeLevel)) {
            nodeLevelMap = (Map)SerializationUtils.fromJsonString((String)nodeLevel, Map.class);
        }
        if (nodeId.equals(bizAppId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_NEW, BTN_EDIT, BTN_DELETE});
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_NEWSON});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_EDIT, BTN_DELETE, BTN_NEW, BTN_NEWSON});
        }
        Integer nodeLevelVal = (Integer)nodeLevelMap.get(nodeId);
        if (nodeLevelVal != null && 3 == nodeLevelVal) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_NEWSON});
        }
        if (nodeId.endsWith(HPCE)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_NEWSON, BTN_DELETE});
        }
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        this.showMenuList(nodeId, appMeta);
    }

    private void getMenuTreeNode(List<AppMenuElement> menuElements, List<String> parentMenuIds, List<TreeNode> parentMenuList, Map<String, Integer> nodeLevel, Integer level) {
        ArrayList<String> menuIds = new ArrayList<String>();
        ArrayList<TreeNode> menuList = new ArrayList<TreeNode>();
        for (AppMenuElement menuElement : menuElements) {
            String parentMenuId = menuElement.getParentId();
            String menuId = menuElement.getId();
            String menuName = menuElement.getName().getLocaleValue();
            if (!parentMenuIds.contains(parentMenuId)) continue;
            nodeLevel.put(menuId, level);
            menuIds.add(menuId);
            TreeNode treeNode = new TreeNode(parentMenuId, menuId, menuName, false);
            menuList.add(treeNode);
        }
        if (!menuList.isEmpty()) {
            for (int i = 0; i < parentMenuList.size(); ++i) {
                TreeNode pNode = parentMenuList.get(i);
                DevportalUtil.buildNode(pNode, menuList);
            }
            Integer n = level;
            Integer n2 = level = Integer.valueOf(level + 1);
            this.getMenuTreeNode(menuElements, menuIds, menuList, nodeLevel, level);
        }
    }

    private List<TreeNode> getNodeList(AppMetadata appMeta) {
        String bizAppId = appMeta.getBizappId();
        JSONArray appIds = DevportalUtil.getBizAppIds(bizAppId);
        List menuElements = appMeta.getAppMenus();
        ArrayList<String> menuIds = new ArrayList<String>(menuElements.size());
        for (AppMenuElement menuElement : menuElements) {
            String menuId = menuElement.getId();
            menuIds.add(menuId);
        }
        ArrayList<String> firMenuIds = new ArrayList<String>();
        ArrayList<TreeNode> firMenuList = new ArrayList<TreeNode>();
        for (AppMenuElement menuElement : menuElements) {
            String parentMenuId = menuElement.getParentId();
            String menuId = menuElement.getId();
            String menuName = menuElement.getName().getLocaleValue();
            if (!StringUtils.isBlank((CharSequence)parentMenuId) && !appIds.contains((Object)parentMenuId) && menuIds.contains(parentMenuId)) continue;
            firMenuIds.add(menuId);
            TreeNode treeNode = new TreeNode(bizAppId, menuId, menuName);
            firMenuList.add(treeNode);
        }
        HashMap<String, Integer> nodeLevel = new HashMap<String, Integer>();
        this.getMenuTreeNode(menuElements, firMenuIds, firMenuList, nodeLevel, 2);
        this.getPageCache().put(NODELEVEL, SerializationUtils.toJsonString(nodeLevel));
        return firMenuList;
    }

    private Set<Map<String, Object>> recursionMenuInfo(List<AppMenuElement> menuElements, Set<Map<String, Object>> menuList, Set<String> refFormIds, String filterMenuId, boolean isChecked, boolean showNextMenus) {
        if (isChecked) {
            for (AppMenuElement menuElement : menuElements) {
                String menuId = menuElement.getId();
                String parentMenuId = menuElement.getParentId();
                if (!filterMenuId.equals(parentMenuId)) continue;
                HashMap<String, Object> menuInfo = new HashMap<String, Object>(10);
                menuInfo.put(MENUNAME, menuElement.getName().getLocaleValue());
                String formId = menuElement.getFormId();
                refFormIds.add(formId);
                menuInfo.put(FORMNUMBER, menuElement.getFormNumber());
                menuInfo.put(OPENTYPE, menuElement.getOpenType());
                menuInfo.put(VISIABLE, menuElement.getVisible());
                menuInfo.put(PARENTID, parentMenuId);
                menuInfo.put("id", menuId);
                menuInfo.put(MENUSEQ, menuElement.getSeq());
                menuInfo.put(FORMID, formId);
                menuList.add(menuInfo);
                if (!showNextMenus) continue;
                this.recursionMenuInfo(menuElements, menuList, refFormIds, menuId, isChecked, showNextMenus);
            }
        }
        return menuList;
    }

    public void showMenuList(String selectNodeId, AppMetadata appMeta) {
        String appName;
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
        List menuElements = appMeta.getAppMenus();
        JSONArray appIds = DevportalUtil.getBizAppIds(bizAppId);
        LinkedHashSet<Map<String, Object>> selectedMenuInfos = new LinkedHashSet<Map<String, Object>>();
        ArrayList<String> menuIds = new ArrayList<String>(menuElements.size());
        for (AppMenuElement menuElement : menuElements) {
            String menuId = menuElement.getId();
            menuIds.add(menuId);
        }
        final boolean isChecked = (Boolean)this.getModel().getValue("checkboxfield");
        HashSet<String> refFormIds = new HashSet<String>(10);
        HashMap<String, String> formNameMapping = new HashMap<String, String>(10);
        HashMap formRefAppNameMapping = new HashMap(10);
        for (AppMenuElement menuElement : menuElements) {
            String string = menuElement.getId();
            String parentMenuId = menuElement.getParentId();
            DynamicObject[] menuInfo = new HashMap(10);
            String string2 = menuElement.getFormId();
            refFormIds.add(string2);
            menuInfo.put(FORMNUMBER, menuElement.getFormNumber());
            menuInfo.put(MENUNAME, menuElement.getName().getLocaleValue());
            menuInfo.put(OPENTYPE, menuElement.getOpenType());
            menuInfo.put(VISIABLE, menuElement.getVisible());
            menuInfo.put(PARENTID, parentMenuId);
            menuInfo.put(FORMID, string2);
            menuInfo.put("id", string);
            menuInfo.put(MENUSEQ, menuElement.getSeq());
            menuInfo.put("menutype", menuElement.getMenuType());
            menuInfo.put("linkurl", menuElement.getLinkUrl());
            if (selectNodeId.equals(string)) {
                selectedMenuInfos.add((Map<String, Object>)menuInfo);
                if (isChecked) {
                    this.recursionMenuInfo(menuElements, selectedMenuInfos, refFormIds, string, isChecked, isChecked);
                    continue;
                }
                this.recursionMenuInfo(menuElements, selectedMenuInfos, refFormIds, string, true, false);
                continue;
            }
            if (!selectNodeId.equals(bizAppId) || !StringUtils.isBlank((CharSequence)parentMenuId) && !appIds.contains((Object)parentMenuId) && menuIds.contains(parentMenuId)) continue;
            selectedMenuInfos.add((Map<String, Object>)menuInfo);
            if (!isChecked) continue;
            this.recursionMenuInfo(menuElements, selectedMenuInfos, refFormIds, string, isChecked, isChecked);
        }
        if (!refFormIds.isEmpty()) {
            DynamicObject[] formObjs = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)"id,name,bizappid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)refFormIds.toArray())});
            HashMap formAppMapping = new HashMap(formObjs.length);
            for (DynamicObject dynamicObject : formObjs) {
                String formId = dynamicObject.getString("id");
                String formName = dynamicObject.getString("name");
                String refAppId = dynamicObject.getString("bizappid");
                formNameMapping.put(formId, formName);
                if (!StringUtils.isNotBlank((CharSequence)refAppId)) continue;
                formAppMapping.put(formId, refAppId);
            }
            DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)formAppMapping.values().toArray())});
            HashMap<String, String> appNameMapping = new HashMap<String, String>(dynamicObjectArray.length);
            for (DynamicObject appObj : dynamicObjectArray) {
                String appId = appObj.getString("id");
                appName = appObj.getString("name");
                if (!StringUtils.isNotBlank((CharSequence)appName)) continue;
                appNameMapping.put(appId, appName);
            }
            for (Map.Entry entry : formAppMapping.entrySet()) {
                String app = (String)entry.getValue();
                String appName2 = (String)appNameMapping.get(app);
                if (!StringUtils.isNotBlank((CharSequence)appName2)) continue;
                formRefAppNameMapping.put(entry.getKey(), appName2);
            }
        }
        boolean hasHelpCenter = false;
        for (Map map : selectedMenuInfos) {
            String menuId = (String)map.get("id");
            if (!menuId.endsWith(HPCE)) continue;
            hasHelpCenter = true;
        }
        final int appNum = selectedMenuInfos.size();
        if (appNum > 0) {
            AbstractGrid abstractGrid = (AbstractGrid)this.getControl(MENUENTRYENTITY);
            EntryGrid entryGrid = (EntryGrid)abstractGrid;
            final boolean helpCenterflag = hasHelpCenter;
            entryGrid.addPackageDataListener((Consumer)new Consumer<PackageDataEvent>(){

                @Override
                public void accept(PackageDataEvent e) {
                    block6: {
                        List operationColItems;
                        int seq;
                        block7: {
                            seq = e.getRowData().getInt("seq");
                            if (!(e.getSource() instanceof OperationColumn) || !"operationcolumnap".equalsIgnoreCase(((OperationColumn)e.getSource()).getKey())) break block6;
                            operationColItems = (List)e.getFormatValue();
                            if (!isChecked) break block7;
                            for (OperationColItem operationColItem : operationColItems) {
                                if (!BizAppMenuTreePlugin.MOVEENTRYUP.equalsIgnoreCase(operationColItem.getOperationKey()) && !BizAppMenuTreePlugin.MOVEENTRYDOWN.equalsIgnoreCase(operationColItem.getOperationKey())) continue;
                                operationColItem.setLocked(true);
                            }
                            break block6;
                        }
                        if (seq == 1) {
                            for (OperationColItem operationColItem : operationColItems) {
                                if (!BizAppMenuTreePlugin.MOVEENTRYUP.equalsIgnoreCase(operationColItem.getOperationKey())) continue;
                                operationColItem.setLocked(true);
                            }
                        }
                        if (seq == appNum - 1) {
                            for (OperationColItem operationColItem : operationColItems) {
                                if (!BizAppMenuTreePlugin.MOVEENTRYDOWN.equalsIgnoreCase(operationColItem.getOperationKey()) || !helpCenterflag) continue;
                                operationColItem.setLocked(true);
                            }
                        }
                        if (seq != appNum) break block6;
                        for (OperationColItem operationColItem : operationColItems) {
                            if (!BizAppMenuTreePlugin.MOVEENTRYDOWN.equalsIgnoreCase(operationColItem.getOperationKey()) && !helpCenterflag) continue;
                            operationColItem.setLocked(true);
                        }
                    }
                }
            });
            this.getModel().deleteEntryData(MENUENTRYENTITY);
            this.getModel().batchCreateNewEntryRow(MENUENTRYENTITY, selectedMenuInfos.size());
            Iterator iterator = selectedMenuInfos.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                String openType;
                Map menuJsonObject = (Map)iterator.next();
                this.getModel().setValue(MENUNAME, menuJsonObject.get(MENUNAME), i);
                String refformId = (String)menuJsonObject.get(FORMID);
                this.getModel().setValue(FORMNAME, formNameMapping.get(refformId), i);
                this.getModel().setValue(FORMNUMBER, menuJsonObject.get(FORMNUMBER), i);
                appName = (String)formRefAppNameMapping.get(refformId);
                if (appName != null) {
                    this.getModel().setValue(APPNAME, (Object)appName, i);
                }
                openType = "0".equals(openType = (String)menuJsonObject.get(OPENTYPE)) || "MainNewTabPage".equals(openType) || StringUtils.isBlank((CharSequence)openType) ? ResManager.loadKDString((String)"\u65b0\u9875\u7b7e", (String)"BizAppMenuTreePlugin_11", (String)"bos-devportal-plugin", (Object[])new Object[0]) : ("NewWindow".equals(openType) ? ResManager.loadKDString((String)"\u65b0\u7a97\u53e3", (String)"BizAppMenuTreePlugin_12", (String)"bos-devportal-plugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6a21\u6001\u663e\u793a", (String)"BizAppMenuTreePlugin_13", (String)"bos-devportal-plugin", (Object[])new Object[0]));
                String visiable = (String)menuJsonObject.get(VISIABLE);
                visiable = "true".equals(visiable) || "1".equals(visiable) ? ResManager.loadKDString((String)"\u53ef\u89c1", (String)"BizAppMenuTreePlugin_14", (String)"bos-devportal-plugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0d\u53ef\u89c1", (String)"BizAppMenuTreePlugin_15", (String)"bos-devportal-plugin", (Object[])new Object[0]);
                this.getModel().setValue(OPENTYPE, (Object)openType, i);
                this.getModel().setValue(VISIABLE, (Object)visiable, i);
                this.getModel().setValue(MENUID, menuJsonObject.get("id"), i);
                this.getModel().setValue(PARENTMENUID, menuJsonObject.get(PARENTID), i);
                this.getModel().setValue(MENUSEQ, menuJsonObject.get(MENUSEQ), i);
                ++i;
            }
        } else {
            this.getModel().deleteEntryData(MENUENTRYENTITY);
        }
    }

    public void click(EventObject evt) {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_NEW.equalsIgnoreCase(key)) {
            this.addNode(bizAppId, "addnewnode", ResManager.loadKDString((String)"\u65b0\u589e\u540c\u7ea7\u83dc\u5355", (String)"BizAppMenuTreePlugin_16", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        } else if (BTN_NEWSON.equals(key)) {
            this.addNode(bizAppId, "addnewsonnode", ResManager.loadKDString((String)"\u65b0\u589e\u5b50\u7ea7\u83dc\u5355", (String)"BizAppMenuTreePlugin_17", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        } else if (BTN_EDIT.equalsIgnoreCase(key)) {
            this.editNode(bizAppId);
        } else if (BTN_DELETE.equalsIgnoreCase(key)) {
            this.deleteNode(bizAppId);
        } else if (BTN_RETSET.equalsIgnoreCase(key)) {
            this.resetAppMenu(bizAppId);
        }
    }

    private void addNode(String bizAppId, String addType, String title) {
        TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
        Map nodeInfo = tree.getTreeState().getFocusNode();
        if (nodeInfo.get("id") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u83dc\u5355\u3002", (String)"BizAppMenuTreePlugin_18", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            return;
        }
        String nodeID = nodeInfo.get("id").toString();
        String parentNodeID = nodeInfo.get(PARENTID).toString();
        boolean isParent = (Boolean)nodeInfo.get("isParent");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(NODEID, nodeID);
        map.put(PARENTNODEID, parentNodeID);
        map.put(ISPARENT, isParent);
        map.put("bizappid", bizAppId);
        map.put("addtype", addType);
        HashMap<String, String> pageCacheMap = new HashMap<String, String>();
        pageCacheMap.put(CHECKEDNODEID, nodeID);
        pageCacheMap.put(CHECKEDPARENTNODEID, parentNodeID);
        pageCacheMap.put("bizappid", bizAppId);
        this.getPageCache().put(pageCacheMap);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setFormId(BOS_DEVP_APPMENUMETA);
        parameter.setCaption(title);
        parameter.setCustomParams(map);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addnewCallBack"));
        this.getView().showForm(parameter);
    }

    private void editNode(String bizAppId) {
        TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
        Map nodeInfo = tree.getTreeState().getFocusNode();
        if (nodeInfo.get("id") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u4e2a\u83dc\u5355\u4f5c\u4e3a\u6dfb\u52a0\u6570\u636e\u7684\u7236\u83dc\u5355\u3002", (String)"BizAppMenuTreePlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            return;
        }
        String nodeID = nodeInfo.get("id").toString();
        if (nodeID.equals(bizAppId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e94\u7528\u8282\u70b9\u4e0d\u53ef\u7f16\u8f91\u3002", (String)"BizAppMenuTreePlugin_19", (String)"bos-devportal-plugin", (Object[])new Object[0]), Integer.valueOf(1000));
            return;
        }
        String parentNodeID = nodeInfo.get(PARENTID).toString();
        boolean isParent = (Boolean)nodeInfo.get("isParent");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(NODEID, nodeID);
        map.put(PARENTNODEID, parentNodeID);
        map.put(ISPARENT, isParent);
        map.put("bizappid", bizAppId);
        HashMap<String, String> pageCacheMap = new HashMap<String, String>();
        pageCacheMap.put(CHECKEDNODEID, nodeID);
        pageCacheMap.put(CHECKEDPARENTNODEID, parentNodeID);
        pageCacheMap.put("bizappid", bizAppId);
        this.getPageCache().put(pageCacheMap);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setFormId(BOS_DEVP_APPMENUMETA);
        parameter.setCaption(ResManager.loadKDString((String)"\u4fee\u6539\u83dc\u5355", (String)"BizAppMenuTreePlugin_20", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        parameter.setCustomParams(map);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EDITCALLBACK));
        this.getView().showForm(parameter);
    }

    private void deleteNode(String bizAppId) {
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            this.getView().showTipNotification(DevportalUtil.getNoPermissionTip());
            return;
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("root"), TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
        Map nodeInfo = tree.getTreeState().getFocusNode();
        if (nodeInfo.get("id") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u5220\u9664\u8282\u70b9\u3002", (String)"BizAppMenuTreePlugin_21", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            return;
        }
        String nodeID = nodeInfo.get("id").toString();
        if (root.getId().equalsIgnoreCase(nodeID)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e94\u7528\u8282\u70b9\u4e0d\u53ef\u5220\u9664\u3002", (String)"BizAppMenuTreePlugin_22", (String)"bos-devportal-plugin", (Object[])new Object[0]), Integer.valueOf(1000));
            return;
        }
        Boolean IsHaveLeaf = Boolean.FALSE;
        TreeNode checkedNode = root.getTreeNode(nodeID, 4);
        String nodeName = checkedNode.getText();
        StringBuilder sb = new StringBuilder();
        sb.append(nodeID);
        if (checkedNode.getChildren() != null) {
            IsHaveLeaf = Boolean.TRUE;
            for (TreeNode childNode : checkedNode.getChildren()) {
                sb.append('&');
                sb.append(childNode.getId());
                if (childNode.getChildren() == null) continue;
                for (TreeNode thirdChildren : childNode.getChildren()) {
                    sb.append('&');
                    sb.append(thirdChildren.getId());
                }
            }
        }
        this.getPageCache().put(DELETENODEIDS, sb.toString());
        if (IsHaveLeaf.booleanValue()) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u5220\u9664\u201c%s\u201d\u53ca\u5176\u5b50\u83dc\u5355\u5417\uff1f", (String)"BizAppMenuTreePlugin_23", (String)"bos-devportal-plugin", (Object[])new Object[0]), nodeName), MessageBoxOptions.YesNo, new ConfirmCallBackListener(DELETENODECALLBACK));
        } else {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u5220\u9664 %s \u5417\uff1f", (String)"BizAppMenuTreePlugin_24", (String)"bos-devportal-plugin", (Object[])new Object[0]), nodeName), MessageBoxOptions.YesNo, new ConfirmCallBackListener(DELETENODECALLBACK));
        }
    }

    private Boolean deleteNodeInfo(Object[] ids) {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
        if (ids == null || ids.length == 0 || ids.length == 1 && "createNewNodeID".equalsIgnoreCase(ids[0].toString())) {
            return Boolean.TRUE;
        }
        Boolean isDeleteOK = Boolean.FALSE;
        try {
            for (Object id : ids) {
                AppMetaServiceHelper.deleteMenuById((String)id.toString(), (String)bizAppId);
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", "BizAppMenuTreePlugin_25", "bos-devportal-plugin");
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u5220\u9664\u83dc\u5355", "BizAppMenuTreePlugin_26", "bos-devportal-plugin");
                AppUtils.addOpLog((String)"bos_devportal_menu", (String)"delete", (String)"bos_devportal_menu", (String)"1", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, (String[])new String[0]);
            }
            isDeleteOK = Boolean.TRUE;
            BizAppMenuTreePlugin.writeLog(bizAppId, MetaLogType.AppMenuDelete);
        }
        catch (Exception e) {
            String message = String.format("error:%s,", e.getMessage());
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{message});
        }
        return isDeleteOK;
    }

    private void resetAppMenu(String bizAppId) {
        AppMetadata extAppMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        String bizParentAppId = extAppMeta.getParentId();
        this.getPageCache().put(BIZPARENTAPPID, bizParentAppId);
        AppMetadata parentAppMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizParentAppId, (boolean)false);
        AppElement parentAppElement = parentAppMeta.getAppElement();
        String parentAppName = parentAppElement.getName().getLocaleValue();
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u83dc\u5355", (String)"BizAppMenuTreePlugin_27", (String)"bos-devportal-plugin", (Object[])new Object[0]), parentAppName));
        parameter.setFormId("bos_devp_menuoritree");
        parameter.setCustomParam("bizappid", (Object)bizParentAppId);
        parameter.setCustomParam("bizappname", (Object)parentAppName);
        parameter.setCustomParam("currentAppId", (Object)extAppMeta.getBizappId());
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "resetorimenu");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void renderMenuTree(AppMetadata metadata) {
        String bizAppId = metadata.getBizappId();
        String bizAppName = metadata.getAppElement().getName().getLocaleValue();
        TreeNode root = new TreeNode("", bizAppId, bizAppName);
        List<TreeNode> nodeList = this.getNodeList(metadata);
        root.addChildren(nodeList);
        this.getPageCache().put("root", SerializationUtils.toJsonString((Object)root));
        TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
        tree.addNode(root);
        tree.focusNode(root);
        tree.showNode(bizAppId);
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
        int rowIndex = e.getRowIndex();
        String menuId = this.getModel().getValue(MENUID, rowIndex).toString();
        String menuParentId = this.getModel().getValue(PARENTMENUID, rowIndex).toString();
        if (menuId.equals(bizAppId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0d\u8981\u9009\u62e9\u6839\u8282\u70b9\u3002", (String)"BizAppMenuTreePlugin_28", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)menuParentId)) {
            menuParentId = bizAppId;
        }
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        List appMenus = appMeta.getAppMenus();
        JSONArray appIds = DevportalUtil.getBizAppIds(bizAppId);
        boolean isParent = false;
        if (appIds.contains((Object)menuParentId)) {
            for (AppMenuElement appMenuElement : appMenus) {
                String metaMenuParentId = appMenuElement.getParentId();
                if (!metaMenuParentId.equals(menuId)) continue;
                isParent = true;
                break;
            }
        }
        HashMap<String, Object> operateMenu = new HashMap<String, Object>();
        operateMenu.put(NODEID, menuId);
        operateMenu.put(PARENTNODEID, menuParentId);
        operateMenu.put("bizappid", bizAppId);
        operateMenu.put(ISPARENT, isParent);
        HashMap<String, String> pageCacheMap = new HashMap<String, String>();
        pageCacheMap.put(CHECKEDNODEID, menuId);
        pageCacheMap.put(CHECKEDPARENTNODEID, menuParentId);
        pageCacheMap.put("bizappid", bizAppId);
        this.getPageCache().put(pageCacheMap);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            operateMenu.put("status", "view");
        }
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setFormId(BOS_DEVP_APPMENUMETA);
        parameter.setCaption(ResManager.loadKDString((String)"\u4fee\u6539\u83dc\u5355", (String)"BizAppMenuTreePlugin_20", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        parameter.setCustomParams(operateMenu);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EDITCALLBACK));
        this.getView().showForm(parameter);
    }

    private void createHelpCenter(String bizAppId) {
        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataById((String)bizAppId, (boolean)false);
        String appType = appMetadata.getDevType();
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            return;
        }
        boolean hasHelpCenterMenu = false;
        for (AppMenuElement menuElement : appMetadata.getAppMenus()) {
            String formNum = menuElement.getFormNumber();
            if (!"bas_appstarted".equals(formNum)) continue;
            hasHelpCenterMenu = true;
        }
        if (!hasHelpCenterMenu && !"2".equals(appType)) {
            AppMenuElement helpCenter = new AppMenuElement();
            String helpCenterUuid = Uuid16.create().toString();
            String subHelpCenterUuid = helpCenterUuid.substring(0, 11);
            String helpCenterId = subHelpCenterUuid + HPCE;
            helpCenter.setId(helpCenterId);
            helpCenter.setParentId(bizAppId);
            Short menuSeq = 32766;
            helpCenter.setSeq(menuSeq.shortValue());
            helpCenter.setFormNumber("bas_appstarted");
            helpCenter.setFormId("/WXHVRP15OWF");
            LocaleString localeFormName = new LocaleString(ResManager.loadKDString((String)"\u5e94\u7528\u5165\u95e8\u4e2d\u5fc3", (String)"BizAppMenuTreePlugin_29", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            helpCenter.setFormName(localeFormName.getLocaleValue());
            helpCenter.setParameter(" ");
            helpCenter.setVectorImage("kdfont kdfont-tishixinxi_l");
            helpCenter.setIconShortcut("/icons/pc/entrance/helpcentre.png");
            LocaleString localeName = new LocaleString(ResManager.loadKDString((String)"\u5e2e\u52a9\u4e2d\u5fc3", (String)"BizAppMenuTreePlugin_30", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            helpCenter.setName(localeName);
            LocaleString localeCaption = new LocaleString(ResManager.loadKDString((String)"\u5e2e\u52a9\u4e2d\u5fc3", (String)"BizAppMenuTreePlugin_30", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            helpCenter.setCaption(localeCaption);
            LocaleString localeDesc = new LocaleString(ResManager.loadKDString((String)"\u5e2e\u52a9\u4e2d\u5fc3", (String)"BizAppMenuTreePlugin_30", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            helpCenter.setDescription(localeDesc);
            boolean visibleFlag = this.isAppWhiteList(bizAppId, "isapphelper");
            if (visibleFlag) {
                helpCenter.setVisible("1");
            } else {
                helpCenter.setVisible("0");
            }
            appMetadata.getAppMenus().add(helpCenter);
            ThreadCache.put((Object)"AppMetaDao.querySubApp.ignoreExtApp", (Object)"true");
            AppMetaServiceHelper.save((AppMetadata)appMetadata);
            ThreadCache.remove((Object)"AppMetaDao.querySubApp.ignoreExtApp");
        }
    }

    private boolean isAppWhiteList(String appId, String formNum) {
        String sql = String.format("select 1 from %s where FBIZAPPID = ? AND F%s = '1'", "T_DEVP_APPWHITELIST", formNum);
        Object[] params = new SqlParameter[]{new SqlParameter(":FBIZAPPID", 12, (Object)appId)};
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt(1) > 0;
                }
                return Boolean.FALSE;
            }
        };
        return (Boolean)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    public Set<String> getMenuIds(List<AppMenuElement> appMenuElementList, List<String> menuList, Set<String> menuSet) {
        ArrayList<String> tempMenuList = new ArrayList<String>();
        for (AppMenuElement menuElement : appMenuElementList) {
            String menuId = menuElement.getId();
            String parentMenuId = menuElement.getParentId();
            if (!menuList.contains(parentMenuId)) continue;
            tempMenuList.add(menuId);
            menuSet.add(menuId);
        }
        if (!tempMenuList.isEmpty()) {
            this.getMenuIds(appMenuElementList, tempMenuList, menuSet);
        }
        return menuSet;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        IPageCache page = this.getPageCache();
        if (page.get("root") != null) {
            page.remove("root");
        }
        if (page.get(DELETENODEIDS) != null) {
            page.remove(DELETENODEIDS);
        }
        if (page.get(CHECKEDNODEID) != null) {
            page.remove(CHECKEDNODEID);
        }
        if (page.get(CHECKEDPARENTNODEID) != null) {
            page.remove(CHECKEDPARENTNODEID);
        }
        if (page.get("bizappid") != null) {
            page.remove("bizappid");
        }
        if (page.get(BIZPARENTAPPID) != null) {
            page.remove(BIZPARENTAPPID);
        }
        page.remove(NODELEVEL);
    }

    private String getFormName(String formId) {
        String formName = "";
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            try {
                AbstractMetadata formMeta = MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Form);
                if (formMeta != null) {
                    if ("PrintModel".equals(formMeta.getModelType())) {
                        PrintMetadata pm = (PrintMetadata)formMeta;
                        formName = pm.getName().getLocaleValue();
                    } else {
                        FormMetadata fm = (FormMetadata)formMeta;
                        formName = fm.getName().getLocaleValue();
                    }
                }
            }
            catch (Exception exception) {
                logger.info(exception.getMessage());
            }
        }
        return formName;
    }

    private static void writeLog(String appId, MetaLogType type) {
        try {
            long logId = DB.genGlobalLongId();
            MetadataLogService logService = (MetadataLogService)ServiceFactory.getService(MetadataLogService.class);
            logService.addAppMetaLog(appId, (int)type.getValue(), logId, (int)MetaType.App.getValue());
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
    }
}

