/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.devportal.business.PermissionVerify;
import kd.bos.devportal.business.hosting.ResultMessage;
import kd.bos.devportal.business.util.DevportalVerify;
import kd.bos.devportal.common.DevportalCache;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.UrlUtil;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaLogType;
import kd.bos.metadata.dao.MetaType;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.devportal.AppReader;
import kd.bos.mservice.svc.picture.IImage;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataLogService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class BizAppPlugin
extends AbstractBasePlugIn
implements ClickListener,
BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(BizAppPlugin.class);
    private static final String MAINFORMTYPE = "mainformtype";
    private static final String BTNSAVE = "btnsave";
    private static final String BACKIMAGEAP = "backimageap";
    private static final String IMAGEAP = "imageap";
    private static final String IMAGE = "image";
    private static final String REFAPP = "refapp";
    private static final String OPENTTYPE = "openttype";
    private static final String HOMEURL = "homeurl";
    private static final String DBROUTE = "dbroute";
    private static final String BACKIMAGE = "backimage";
    private static final String MAINFORMID = "mainformid";
    private static final String INHERITPATH = "inheritpath";
    private static final String MAINFORMNAME = "mainformname";
    private static final String MASTERID = "masterid";
    private static final String USERTYPE = "usertype";
    private static final String INDUSTRY = "industry";
    private static final String ORGFUNC = "orgfunc";
    private static final String OPENTYPE = "opentype";
    private static final String DESCRIPTION = "description";
    private static final String BIZCLOUD = "bizcloud";
    private static final String ALLUSERAPP = "alluserapp";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{MAINFORMTYPE, MAINFORMNAME, "dependency", BTNSAVE, IMAGEAP, BACKIMAGEAP});
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(BIZCLOUD);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.initRefApp();
    }

    public void afterCreateNewData(EventObject e) {
        BaseShowParameter parameter = (BaseShowParameter)this.getView().getFormShowParameter();
        if (OperationStatus.ADDNEW.equals((Object)parameter.getStatus())) {
            DynamicObject cloudIndustry;
            String bizCloudId = (String)parameter.getCustomParam("bizcloudid");
            String bizCloudNumber = (String)parameter.getCustomParam("bizcloudnumber");
            String appType = (String)parameter.getCustomParam("apptype");
            if ("EXTEND_APP".equals(appType) && StringUtils.isBlank((CharSequence)bizCloudId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u65b0\u589e\u4e1a\u52a1\u4e91\uff0c\u5728\u4e1a\u52a1\u4e91\u4e0b\u65b0\u589e\u4e1a\u52a1\u5e94\u7528\u3002", (String)"BizAppPlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]));
                return;
            }
            if (StringUtils.isBlank((CharSequence)bizCloudNumber) && StringUtils.isNotBlank((CharSequence)bizCloudId)) {
                bizCloudNumber = BusinessDataServiceHelper.loadSingleFromCache((Object)bizCloudId, (String)"bos_devportal_bizcloud", (String)"number").getString("number");
            }
            this.getModel().setValue(BIZCLOUD, (Object)bizCloudId);
            String appIsv = AppUtils.getDeveloperInfo();
            this.getModel().setValue("isv", (Object)appIsv);
            if ("EXTEND_APP".equals(appType)) {
                String bizAppId = (String)parameter.getCustomParam("bizappid");
                DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)bizAppId, (String)"bos_devportal_bizapp");
                if (obj != null) {
                    DataEntityPropertyCollection props = obj.getDataEntityType().getProperties();
                    for (IDataEntityProperty prop : props) {
                        String key = prop.getName();
                        if ("isv".equals(key) || "id".equals(key) || prop instanceof DynamicLocaleProperty) continue;
                        if (prop instanceof MuliLangTextProp) {
                            OrmLocaleValue localValue = (OrmLocaleValue)prop.getValue((Object)obj);
                            this.getModel().setValue(key, (Object)localValue);
                            continue;
                        }
                        Object val = prop.getValue((Object)obj);
                        this.getModel().setValue(key, val);
                    }
                    String parentInheritPath = obj.getString(INHERITPATH);
                    String inheritPath = "";
                    if (StringUtils.isNotBlank((CharSequence)parentInheritPath)) {
                        if (parentInheritPath.startsWith(",")) {
                            parentInheritPath = parentInheritPath.substring(1, parentInheritPath.length());
                        }
                        inheritPath = parentInheritPath + "," + bizAppId;
                    } else {
                        inheritPath = bizAppId;
                    }
                    this.getModel().setValue(INHERITPATH, (Object)inheritPath);
                }
                String number = AppReader.getAppNumberById((String)bizAppId);
                number = AppUtils.autoExtendedNumber((String)number);
                number = AppUtils.autoAppNumber((String)bizCloudId, (String)number, (String)"_ext");
                this.getModel().setValue("number", (Object)number.toLowerCase());
                this.getModel().setValue("type", (Object)"2");
                this.getModel().setValue("parentid", (Object)bizAppId);
                String masterId = bizAppId;
                if (obj != null && StringUtils.isNotBlank((CharSequence)obj.getString(MASTERID))) {
                    masterId = obj.getString(MASTERID);
                }
                this.getModel().setValue(MASTERID, (Object)masterId);
            } else {
                this.getModel().setValue(USERTYPE, (Object)1);
                this.getModel().setValue("deploystatus", (Object)1);
                int sequence = 1;
                if (StringUtils.isNotBlank((CharSequence)bizCloudId)) {
                    sequence = DevportalUtil.getMaxSeq(bizCloudId) + 1;
                }
                this.getModel().setValue("sequence", (Object)sequence);
                String imageDefaultUrl = "icons/pc/application/gongyingxietong_48_48.png";
                this.getModel().setValue(IMAGE, (Object)imageDefaultUrl);
                this.setImageAp(imageDefaultUrl);
                this.setDbroute(bizCloudNumber);
                this.getModel().setValue("type", (Object)"0");
            }
            if (StringUtils.isNotBlank((CharSequence)bizCloudId) && (cloudIndustry = BusinessDataServiceHelper.loadSingleFromCache((Object)bizCloudId, (String)"bos_devportal_bizcloud", (String)INDUSTRY)) != null) {
                String cloudIndustryId = cloudIndustry.get("industry_id").toString();
                this.getModel().setValue(INDUSTRY, (Object)cloudIndustryId);
            }
        }
    }

    private void setDbroute(String bizCloudNumber) {
        if (StringUtils.isNotBlank((CharSequence)bizCloudNumber) && DevportalUtil.acctIsvIsKingdee()) {
            this.getModel().setValue(DBROUTE, (Object)bizCloudNumber.toLowerCase());
        } else {
            this.getModel().setValue(DBROUTE, (Object)"secd");
        }
    }

    private void setImageAp(String imageUrl) {
        IImage imageap = (IImage)this.getControl(IMAGEAP);
        imageap.setUrl(imageUrl);
    }

    private void setBackImageAp(String imageUrl) {
        IImage backimageap = (IImage)this.getControl(BACKIMAGEAP);
        backimageap.setUrl(imageUrl);
    }

    public void afterBindData(EventObject e) {
        String version;
        String appType;
        BaseShowParameter parameter;
        long start;
        block41: {
            start = System.currentTimeMillis();
            parameter = (BaseShowParameter)this.getView().getFormShowParameter();
            if (StringUtils.isBlank((CharSequence)ISVService.getISVInfo().getId())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{BTNSAVE});
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5f00\u53d1\u5546\u6743\u9650\uff0c\u8bf7\u4f7f\u7528\u8d85\u7ea7\u7ba1\u7406\u5458\u5728\u7cfb\u7edf\u7ba1\u7406\u4e2d\u8bbe\u7f6e\u5f00\u53d1\u5546\u6807\u8bc6\u3002", (String)"BizAppPlugin_1", (String)"bos-devportal-plugin", (Object[])new Object[0]));
                return;
            }
            if (OperationStatus.EDIT.equals((Object)parameter.getStatus()) && !AppUtils.checkResourceBelongsToCurDeveloper((String)parameter.getPkId().toString())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{BTNSAVE});
            }
            String bizCloudId = (String)parameter.getCustomParam("bizcloudid");
            String bizCloudNumber = (String)parameter.getCustomParam("bizcloudnumber");
            appType = (String)parameter.getCustomParam("apptype");
            if ("EXTEND_APP".equals(appType) && StringUtils.isBlank((CharSequence)bizCloudId)) {
                DynamicObject cloudObj = this.getModel().getDataEntity().getDynamicObject(BIZCLOUD);
                if (cloudObj != null) {
                    bizCloudId = cloudObj.getString("id");
                    bizCloudNumber = cloudObj.getString("number");
                }
                if (StringUtils.isBlank((CharSequence)bizCloudId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u65b0\u589e\u4e1a\u52a1\u4e91\uff0c\u5728\u4e1a\u52a1\u4e91\u4e0b\u65b0\u589e\u4e1a\u52a1\u5e94\u7528\u3002", (String)"BizAppPlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]));
                    return;
                }
            }
            if (StringUtils.isBlank((CharSequence)bizCloudNumber) && StringUtils.isNotBlank((CharSequence)bizCloudId)) {
                bizCloudNumber = BusinessDataServiceHelper.loadSingleFromCache((Object)bizCloudId, (String)"bos_devportal_bizcloud", (String)"number").getString("number");
            }
            if (DevportalUtil.isExtendApp((String)this.getModel().getValue("type"))) {
                String refAppId;
                JSONObject instance;
                this.getView().setEnable(Boolean.FALSE, new String[]{DBROUTE});
                this.getView().setEnable(Boolean.FALSE, new String[]{"db"});
                this.getView().setEnable(Boolean.FALSE, new String[]{BIZCLOUD});
                this.getView().setEnable(Boolean.FALSE, new String[]{INDUSTRY});
                this.getView().setEnable(Boolean.FALSE, new String[]{REFAPP});
                this.getView().setEnable(Boolean.FALSE, new String[]{ORGFUNC});
                this.getView().setEnable(Boolean.FALSE, new String[]{MAINFORMTYPE});
                String dbRoute = (String)this.getModel().getValue(DBROUTE);
                if (dbRoute != null) {
                    dbRoute = dbRoute.toLowerCase();
                }
                if (StringUtils.isNotBlank((Object)(instance = DevportalUtil.getDbInstanceInfo(dbRoute)).get((Object)"number"))) {
                    this.getModel().setValue("db", (Object)instance.get((Object)"number").toString());
                }
                if (StringUtils.isNotBlank((CharSequence)(refAppId = (String)this.getModel().getValue("refapp_id")))) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{REFAPP});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{REFAPP});
                }
            } else {
                DynamicObject industry;
                if (!"0".equals(this.getModel().getValue("type"))) {
                    this.getModel().setValue("type", (Object)"0");
                }
                if ((industry = (DynamicObject)this.getModel().getValue(INDUSTRY)) != null) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{INDUSTRY});
                    this.getView().setVisible(Boolean.TRUE, new String[]{REFAPP});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{REFAPP});
                }
                String refappid = (String)this.getModel().getValue("refapp_id");
                if (StringUtils.isNotBlank((CharSequence)refappid)) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{REFAPP});
                } else {
                    this.getView().setEnable(Boolean.TRUE, new String[]{REFAPP});
                }
            }
            if ("1".equals(this.getModel().getValue(MAINFORMTYPE))) {
                this.getView().setEnable(Boolean.FALSE, new String[]{OPENTTYPE});
                this.getView().setVisible(Boolean.FALSE, new String[]{MAINFORMNAME});
                this.getView().setVisible(Boolean.TRUE, new String[]{HOMEURL});
                if (!this.getPageCache().getAll().containsKey("URL")) {
                    this.getPageCache().put("URL", (String)this.getModel().getValue(HOMEURL));
                    this.getPageCache().put(MAINFORMNAME, "");
                    this.getPageCache().put(MAINFORMID, "");
                    this.getPageCache().put(OPENTYPE, "0");
                }
            } else if ("0".equals(this.getModel().getValue(MAINFORMTYPE))) {
                String mainFormId;
                this.getView().setVisible(Boolean.TRUE, new String[]{MAINFORMNAME});
                this.getView().setVisible(Boolean.FALSE, new String[]{HOMEURL});
                if (!this.getPageCache().getAll().containsKey(MAINFORMNAME)) {
                    this.getPageCache().put(MAINFORMNAME, (String)this.getModel().getValue(MAINFORMNAME));
                    this.getPageCache().put(MAINFORMID, (String)this.getModel().getValue(MAINFORMID));
                    this.getPageCache().put("URL", "");
                    this.getPageCache().put(OPENTYPE, (String)this.getModel().getValue(OPENTTYPE));
                }
                if (StringUtils.isNotBlank((CharSequence)(mainFormId = (String)this.getModel().getValue(MAINFORMID)))) {
                    try {
                        DynamicObject form = BusinessDataServiceHelper.loadSingle((Object)mainFormId, (String)"bos_formmeta", (String)"name");
                        String mainFormName = ((OrmLocaleValue)form.get("name")).toString();
                        this.setMainFormName(mainFormName);
                    }
                    catch (KDException exception) {
                        if (!"bos.orm.read.dataNotExist".equals(exception.getErrorCode().getCode())) break block41;
                        this.setMainFormName(null);
                    }
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)((String)this.getModel().getValue(MAINFORMTYPE)))) {
            this.getModel().beginInit();
            this.getModel().setValue(MAINFORMTYPE, (Object)0);
            this.getModel().endInit();
            this.getView().updateView();
        }
        List userList = UserServiceHelper.getAllUserType((boolean)false);
        QFilter enableFilter = new QFilter("id", "in", (Object)userList);
        QFilter[] enableFilters = new QFilter[]{enableFilter};
        Map userInfoMap = BusinessDataServiceHelper.loadFromCache((String)"bos_usertype", (String)"id,name,ispreset", (QFilter[])enableFilters, (String)"id");
        ArrayList<Object> userModleItem = new ArrayList<Object>(userList.size());
        for (Map.Entry entry : userInfoMap.entrySet()) {
            DynamicObject userInfo = (DynamicObject)entry.getValue();
            String userId = userInfo.getString("id");
            boolean isPreset = userInfo.getBoolean("ispreset");
            HashMap map = new HashMap(16);
            map.putAll((OrmLocaleValue)userInfo.get("name"));
            ComboItem item = new ComboItem(LocaleString.fromMap(map), userId);
            if (DevportalUtil.isExtendApp((String)this.getModel().getValue("type")) && isPreset) {
                item.setDisable(true);
            }
            userModleItem.add(item);
        }
        ComboEdit userCombo = (ComboEdit)this.getView().getControl(USERTYPE);
        userCombo.setComboItems(userModleItem);
        ComboEdit modeltypeCombo = (ComboEdit)this.getView().getControl(ORGFUNC);
        List<ComboItem> modleItem = DevportalUtil.getOrgFuncComboItems();
        modeltypeCombo.setComboItems(modleItem);
        ComboEdit dbCombo = (ComboEdit)this.getView().getControl("db");
        ArrayList<ComboItem> dbInstenceItem = new ArrayList<ComboItem>();
        JSONArray dbInstanceList = DevportalUtil.getDbInstanceList();
        if (dbInstanceList.size() > 0) {
            for (Object object : dbInstanceList) {
                JSONObject dbInstance = (JSONObject)object;
                String dbNumber = (String)dbInstance.get((Object)"number");
                String localeDesc = (String)dbInstance.get((Object)"name");
                if (!Lang.zh_CN.name().equals(Lang.get().toString())) {
                    localeDesc = dbNumber;
                }
                dbInstenceItem.add(new ComboItem(new LocaleString(localeDesc), dbNumber));
            }
            dbCombo.setComboItems(dbInstenceItem);
        }
        String dbRouteKey = (String)this.getModel().getValue(DBROUTE);
        JSONObject instance = DevportalUtil.getDbInstanceInfo(dbRouteKey);
        String dbCache = null;
        if (!instance.isEmpty()) {
            dbCache = instance.getString("number");
        }
        this.getPageCache().put("init_dbRoute_value", dbCache);
        if (!instance.isEmpty() && !dbInstanceList.isEmpty()) {
            String dbNumber;
            String currentDbNumber = instance.getString("number");
            for (int i = 0; i < dbInstanceList.size(); ++i) {
                JSONObject dbInstance = dbInstanceList.getJSONObject(i);
                String dbNumber2 = dbInstance.getString("number");
                if (!StringUtils.equals((CharSequence)currentDbNumber, (CharSequence)dbNumber2)) continue;
                this.getModel().setValue("db", (Object)currentDbNumber);
                break;
            }
            if (StringUtils.isBlank((CharSequence)(dbNumber = (String)this.getModel().getValue("db"))) || "".equals(dbNumber)) {
                this.getModel().setValue("db", (Object)"sys");
            }
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"type"});
        String image = (String)this.getModel().getValue(IMAGE);
        String backimage = (String)this.getModel().getValue(BACKIMAGE);
        if (StringUtils.isNotBlank((CharSequence)image)) {
            this.setImageAp(image);
        }
        if (StringUtils.isNotBlank((CharSequence)backimage)) {
            this.setBackImageAp(backimage);
        }
        if (OperationStatus.EDIT.equals((Object)parameter.getStatus())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{INDUSTRY});
            String bizAppNum = (String)this.getModel().getValue("number");
            String bizAppSimNum = (String)this.getModel().getValue("simplenumber");
            this.getModel().setValue("number", (Object)bizAppNum.toLowerCase());
            this.getModel().setValue("simplenumber", (Object)bizAppSimNum.toLowerCase());
            ILocaleString objDesc = (ILocaleString)this.getModel().getValue(DESCRIPTION);
            if (StringUtils.isBlank((Object)objDesc)) {
                String bizAppId = (String)this.getModel().getValue("id");
                AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
                LocaleString metaDesc = appMeta.getAppElement().getDescription();
                this.getModel().setValue(DESCRIPTION, (Object)metaDesc);
            }
        }
        if ("EXTEND_APP".equals(appType)) {
            String bizAppId = (String)parameter.getCustomParam("bizappid");
            AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
            LocaleString metaDesc = appMeta.getAppElement().getDescription();
            this.getModel().setValue(DESCRIPTION, (Object)metaDesc);
        }
        if (StringUtils.isNotBlank((CharSequence)(version = this.getBizAppVersion((String)this.getModel().getValue("id"))))) {
            this.getModel().setValue("version", (Object)version);
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"version"});
        this.getModel().setDataChanged(false);
        logger.debug("BizAppPlugin-afterBindData cost time:" + (double)(System.currentTimeMillis() - start) / 1000.0 + "s");
    }

    private void setMainFormName(String mainFormName) {
        this.getModel().beginInit();
        this.getModel().setValue(MAINFORMNAME, (Object)mainFormName);
        this.getModel().endInit();
        this.getView().updateView(MAINFORMNAME);
        this.getPageCache().put(MAINFORMNAME, (String)this.getModel().getValue(MAINFORMNAME));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        BaseShowParameter parameter = (BaseShowParameter)this.getView().getFormShowParameter();
        if (OperationStatus.EDIT.equals((Object)parameter.getStatus()) && !DevportalUtil.checkIsvPermission((String)this.getModel().getValue("isv"))) {
            return;
        }
        String propertyName = e.getProperty().getName();
        if (ORGFUNC.equals(propertyName)) {
            String orgfunc = (String)e.getChangeSet()[0].getNewValue();
            this.getModel().beginInit();
            this.getModel().setValue(ORGFUNC, (Object)orgfunc);
            this.getModel().endInit();
        } else if ("number".equals(propertyName)) {
            String number = (String)e.getChangeSet()[0].getNewValue();
            number = DevportalUtil.autoIsvNumber(number);
            this.getModel().beginInit();
            this.getModel().setValue("number", (Object)number);
            this.getModel().endInit();
        } else if (BIZCLOUD.equals(propertyName)) {
            DynamicObject bizCloud = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (bizCloud != null) {
                String cloudNum = bizCloud.getString("number");
                ComboEdit dbRouteCombo = (ComboEdit)this.getView().getControl(DBROUTE);
                List<ComboItem> dbRouteItem = DevportalUtil.getDBRouteComboItems(cloudNum);
                dbRouteCombo.setComboItems(dbRouteItem);
            }
        } else if (INDUSTRY.equals(propertyName)) {
            DynamicObject industry = (DynamicObject)this.getModel().getValue(INDUSTRY);
            if (industry != null) {
                this.getView().setVisible(Boolean.TRUE, new String[]{REFAPP});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{REFAPP});
            }
        } else if ("db".equals(propertyName)) {
            String instanceNumber = (String)this.getModel().getValue("db");
            this.getModel().setValue(DBROUTE, (Object)instanceNumber);
        } else if (MAINFORMTYPE.equals(propertyName)) {
            if ("1".equals(this.getModel().getValue(MAINFORMTYPE))) {
                this.getModel().beginInit();
                this.getModel().setValue(OPENTTYPE, (Object)1);
                this.getView().setEnable(Boolean.FALSE, new String[]{OPENTTYPE});
                this.getView().setVisible(Boolean.FALSE, new String[]{MAINFORMNAME});
                this.getView().setVisible(Boolean.TRUE, new String[]{HOMEURL});
                this.getModel().setValue(HOMEURL, (Object)this.getPageCache().get("URL"));
                this.getModel().setValue(MAINFORMNAME, null);
                this.getModel().setValue(MAINFORMID, null);
                this.getModel().endInit();
            } else {
                this.getModel().beginInit();
                this.getView().setEnable(Boolean.TRUE, new String[]{OPENTTYPE});
                this.getView().setVisible(Boolean.TRUE, new String[]{MAINFORMNAME});
                this.getView().setVisible(Boolean.FALSE, new String[]{HOMEURL});
                this.getModel().setValue(MAINFORMNAME, (Object)this.getPageCache().get(MAINFORMNAME));
                this.getModel().setValue(MAINFORMID, (Object)this.getPageCache().get(MAINFORMID));
                this.getModel().setValue(HOMEURL, null);
                this.getModel().setValue(OPENTTYPE, (Object)this.getPageCache().get(OPENTYPE));
                this.getModel().endInit();
            }
            this.getView().updateView();
        } else if (MAINFORMNAME.equals(propertyName)) {
            this.getModel().beginInit();
            this.getModel().setValue(MAINFORMNAME, (Object)this.getPageCache().get(MAINFORMNAME));
            this.getModel().setValue(MAINFORMID, (Object)this.getPageCache().get(MAINFORMID));
            this.getModel().setValue(HOMEURL, null);
            this.getPageCache().put(MAINFORMNAME, (String)this.getModel().getValue(MAINFORMNAME));
            this.getPageCache().put(MAINFORMID, (String)this.getModel().getValue(MAINFORMID));
            this.getModel().endInit();
            this.getView().updateView();
        } else if (HOMEURL.equals(propertyName)) {
            this.getModel().beginInit();
            this.getPageCache().put("URL", (String)this.getModel().getValue(HOMEURL));
            this.getModel().setValue(HOMEURL, (Object)this.getPageCache().get("URL"));
            this.getModel().setValue(MAINFORMNAME, null);
            this.getModel().setValue(MAINFORMID, null);
            this.getModel().endInit();
        } else if (OPENTTYPE.equals(propertyName) && "0".equals(this.getModel().getValue(MAINFORMTYPE))) {
            this.getPageCache().put(OPENTYPE, (String)this.getModel().getValue(OPENTTYPE));
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if ("saveapphome".equals(e.getName())) {
            JSONObject errorMessage = DevportalUtil.saveMetaOfPage(this.getView(), this.getModel().getDataEntity(), this.getView().getFormShowParameter());
            if (errorMessage.containsKey((Object)ResultMessage.RESULT.toString())) {
                this.getView().showTipNotification(errorMessage.getString(ResultMessage.RESULT.toString()));
            } else {
                this.getView().getFormShowParameter().setStatus(OperationStatus.EDIT);
                this.getView().addClientCallBack("configapphome", Integer.valueOf(100));
            }
        } else if ("configapphome".equals(e.getName())) {
            JSONObject errorMessage = DevportalUtil.configAppHome(this.getView(), this.getModel().getDataEntity(), this.getView().getFormShowParameter());
            if (errorMessage.containsKey((Object)ResultMessage.RESULT.toString())) {
                this.getView().showTipNotification(errorMessage.getString(ResultMessage.RESULT.toString()));
            } else {
                this.getModel().setDataChanged(false);
                String formId = (String)this.getModel().getValue(MAINFORMID);
                QFilter[] filters = new QFilter[]{new QFilter("form", "=", (Object)formId)};
                DynamicObject unitRelForm = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_devportal_unitrelform", (String)"bizapp,bizunit", (QFilter[])filters);
                if (unitRelForm != null) {
                    HashMap<String, Object> retData = new HashMap<String, Object>();
                    retData.put("bizAppId", this.getModel().getValue("id"));
                    retData.put("homeFuncId", unitRelForm.getString("bizunit"));
                    retData.put("homeFormId", formId);
                    this.getView().setClientReturnData(retData);
                }
                this.getView().close();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Donothing source = (Donothing)args.getSource();
        if (source instanceof Donothing && "donothing".equals(source.getOperateKey())) {
            String url;
            Object db = this.getModel().getValue("db");
            if (StringUtils.isBlank((Object)db)) {
                String message = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e94\u7528\u5206\u5e93\u3002", (String)"BizAppPlugin_9", (String)"bos-devportal-plugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(message);
                args.setCancel(true);
                return;
            }
            String dbRouteValue = this.getPageCache().get("init_dbRoute_value");
            if (StringUtils.isNotBlank((CharSequence)dbRouteValue) && !dbRouteValue.equals(db)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u9ed8\u8ba4\u5e94\u7528\u5206\u5e93\u5df2\u4fee\u6539\uff0c\u73b0\u6709\u5355\u636e\u9700\u8981\u91cd\u65b0\u4fdd\u5b58\u624d\u80fd\u751f\u6548\u3002", (String)"BizAppPlugin_13", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            }
            ILocaleString name = this.getModel().getDataEntity().getLocaleString("name");
            String type = (String)this.getModel().getValue(MAINFORMTYPE);
            if (type.equals("1") && !StringUtils.isBlank((CharSequence)(url = (String)this.getModel().getValue(HOMEURL))) && !UrlUtil.checkUrl((String)url)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u683c\u5f0f\u4e0d\u5408\u6cd5\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u94fe\u63a5\u5730\u5740\u3002", (String)"BizAppPlugin_12", (String)"bos-devportal-plugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (name == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5e94\u7528\u540d\u79f0\u3002", (String)"BizAppPlugin_11", (String)"bos-devportal-plugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean existName = false;
            for (Map.Entry it : name.entrySet()) {
                if (StringUtils.isBlank((CharSequence)((CharSequence)it.getValue()))) continue;
                existName = true;
                if (((String)it.getValue()).length() <= 50) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540d\u79f0\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\u4e2a\u5b57\u7b26\u3002", (String)"BizAppPlugin_10", (String)"bos-devportal-plugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!existName) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5e94\u7528\u540d\u79f0\u3002", (String)"BizAppPlugin_11", (String)"bos-devportal-plugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String userType = (String)this.getModel().getValue(USERTYPE);
            if (StringUtils.isNotBlank((CharSequence)userType) && userType.length() > 100) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9002\u7528\u7528\u6237\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100\u4e2a\u5b57\u7b26\u3002", (String)"BizAppPlugin_14", (String)"bos-devportal-plugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("donothing".equals(afterDoOperationEventArgs.getOperateKey()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            boolean appSuccess = DevportalUtil.saveAppInfo(this.getModel(), this.getView());
            this.getPageCache().put("appSuccess", String.valueOf(appSuccess));
            String appId = (String)this.getModel().getValue("id");
            BizAppPlugin.writeLog(appId);
            if (appSuccess && OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
                HashMap<String, Object> retData = new HashMap<String, Object>();
                retData.put("bizAppId", this.getModel().getValue("id"));
                this.getView().setClientReturnData(retData);
                if ("1".equals((String)this.getModel().getValue(MAINFORMTYPE))) {
                    this.getModel().setDataChanged(false);
                    this.getView().close();
                } else {
                    this.getView().addClientCallBack("saveapphome", Integer.valueOf(100));
                }
                this.clearUserPermission();
            } else if (appSuccess) {
                HashMap<String, Object> retData = new HashMap<String, Object>();
                retData.put("bizAppId", this.getModel().getValue("id"));
                this.getView().setClientReturnData(retData);
                this.getModel().setDataChanged(false);
                this.getView().close();
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        boolean success;
        super.beforeClosed(e);
        String openType = (String)this.getView().getFormShowParameter().getCustomParam("openType");
        String appSuccess = this.getPageCache().get("appSuccess");
        boolean bl = success = StringUtils.isBlank((CharSequence)appSuccess) ? false : Boolean.parseBoolean(appSuccess);
        if (StringUtils.isNotBlank((CharSequence)openType) && "devnew".equals(openType) && success) {
            DynamicObject cloud = (DynamicObject)this.getModel().getValue(BIZCLOUD);
            String bizAppId = (String)this.getModel().getValue("id");
            String bizAppName = this.getModel().getValue("name") == null ? "" : ((OrmLocaleValue)this.getModel().getValue("name")).getLocaleValue();
            String cloudId = "";
            if (cloud != null) {
                cloudId = cloud.getString("id");
            }
            HashMap<String, String> retData = new HashMap<String, String>(2);
            retData.put("bizappId", bizAppId);
            retData.put("bizappName", bizAppName);
            retData.put("bizcloudId", cloudId);
            this.getView().returnDataToParent(retData);
        }
    }

    public void click(EventObject evt) {
        String arg;
        Control c = (Control)evt.getSource();
        switch (arg = c.getKey().toLowerCase()) {
            case "mainformname": {
                this.selectParent();
                break;
            }
            case "imageap": 
            case "backimageap": {
                this.selectImage(arg);
                break;
            }
        }
    }

    private void clearUserPermission() {
        Object devPermission = DevportalVerify.getParameter((String)"dev_permission");
        if (devPermission != null && ((Boolean)devPermission).booleanValue()) {
            long userId = RequestContext.get().getCurrUserId();
            DevportalCache.clearPermissionUser((Long)userId);
        }
    }

    private void setCurrentPermission(String bizAppId) {
        PermissionVerify verify = new PermissionVerify();
        Object devMode = DevportalVerify.getParameter((String)"dev_governance_mode");
        Object devPermission = DevportalVerify.getParameter((String)"dev_permission");
        if (devPermission == null || !((Boolean)devPermission).booleanValue() || devMode == null) {
            return;
        }
        String mode = (String)devMode;
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject app = BusinessDataServiceHelper.loadSingle((Object)bizAppId, (String)"bos_devportal_bizapp");
        QFilter qFilter = new QFilter("account", "=", (Object)userId);
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObject[] appIsolations = BusinessDataServiceHelper.load((String)"bos_app_isolation", (String)"accounttype, account, isolationapp", (QFilter[])qFilters);
        DevportalCache.clearPermission((Long)userId, (String)mode);
        if (appIsolations.length > 0) {
            DynamicObjectCollection appCollection = (DynamicObjectCollection)appIsolations[0].get("isolationapp");
            DynamicObjectType type = appCollection.getDynamicObjectType();
            DynamicObject obj = new DynamicObject(type);
            obj.set("fbasedataid", (Object)app);
            appCollection.add((Object)obj);
            SaveServiceHelper.save((DynamicObject[])appIsolations);
        } else {
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"bos_app_isolation");
            boolean isAdmin = verify.hasPermission();
            DynamicObjectCollection isolationapp = object.getDynamicObjectCollection("isolationapp");
            DynamicObjectType type = isolationapp.getDynamicObjectType();
            DynamicObject obj = new DynamicObject(type);
            obj.set("fbasedataid", (Object)app);
            isolationapp.add((Object)obj);
            object.set("accounttype", (Object)"sys");
            object.set("account", (Object)userId);
            object.set("creater", (Object)userId);
            object.set("admin", (Object)isAdmin);
            DynamicObject[] apps = new DynamicObject[]{object};
            SaveServiceHelper.save((DynamicObject[])apps);
        }
    }

    private void initRefApp() {
        BasedataEdit appF7 = (BasedataEdit)this.getControl(REFAPP);
        appF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setCustomParam("runtime", (Object)Boolean.FALSE);
        });
    }

    private void selectParent() {
        String appId = (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
        if ("1".equals(this.getModel().getValue(MAINFORMTYPE))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5916\u90e8\u94fe\u63a5\u9700\u8981\u60a8\u624b\u52a8\u914d\u7f6e\u5e94\u7528\u9996\u9875\uff0c\u82e5\u4e3a\u4e91\u4e4b\u5bb6\u5e94\u7528\u586b\u5199\u201cyzj\u201d\u5373\u53ef", (String)"BizAppPlugin_5", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            return;
        }
        if (appId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b0\u589e\u5e94\u7528\u4e0d\u9700\u8981\u60a8\u6307\u5b9a\u5e94\u7528\u9996\u9875\uff0c\u7cfb\u7edf\u4f1a\u9ed8\u8ba4\u6267\u884c\u6807\u51c6\u5e94\u7528\u9996\u9875\u3002", (String)"BizAppPlugin_6", (String)"bos-devportal-plugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        String masterId = appId;
        String inheritPath = "'" + appId + "'";
        DynamicObject appObj = BusinessDataServiceHelper.loadSingleFromCache((Object)appId, (String)"bos_devportal_bizapp");
        String[] ids = null;
        if (appObj != null && StringUtils.isNotBlank((CharSequence)appObj.getString(INHERITPATH))) {
            for (String id : ids = appObj.getString(INHERITPATH).split(",")) {
                inheritPath = "'" + id + "'," + inheritPath;
            }
            masterId = appObj.getString(MASTERID);
        }
        String sql = "select top 1 a.FBIZUNITID, b.FNUMBER, b.FID from t_meta_bizunitrelform a, t_meta_formdesign b where a.FBIZAPPID in (" + inheritPath + ") and a.FFORMID = b.FID and (b.FINHERITPATH like '%ccd20bac000001ac%' or b.FINHERITPATH like '%/8T+06O/GOEH%');";
        boolean isExist = false;
        try (DataSet ds = DB.queryDataSet((String)"DEVPORTAL.SelectListPlugin.buildRootOfMainPageInApp", (DBRoute)DBRoute.meta, (String)sql, null);){
            Iterator rows = ds.iterator();
            if (rows.hasNext()) {
                isExist = true;
            }
        }
        if (!isExist) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ee7\u627f\u81ea\u6807\u51c6\u5e94\u7528\u7684\u9996\u9875\u9875\u9762\u4e0d\u5b58\u5728\uff0c\u8bf7\u81ea\u884c\u914d\u7f6e\u3002", (String)"BizAppPlugin_7", (String)"bos-devportal-plugin", (Object[])new Object[0]), Integer.valueOf(5000));
            return;
        }
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"bos_formmeta", (boolean)false);
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u8868\u5355\u9009\u62e9\u9875\u9762", (String)"BizAppPlugin_8", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        listShowParameter.setFormId("bos_devp_formtreelistf7");
        listShowParameter.setCustomParam("onlyvisible", (Object)Boolean.FALSE);
        listShowParameter.setCustomParam("onlydeployed", (Object)Boolean.FALSE);
        listShowParameter.setCustomParam("scence", (Object)"selectMainPageInApp");
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectParent"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void selectImage(String arg) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ide_pictureselector");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, arg);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (returnData != null) {
            this.closedCallBackProcess(actionId, returnData);
        }
    }

    private void closedCallBackProcess(String actionId, Object returnData) {
        Map ret;
        if ("selectParent".equals(actionId)) {
            ListSelectedRowCollection rt = (ListSelectedRowCollection)returnData;
            this.getModel().beginInit();
            this.getModel().setValue(MAINFORMID, rt.get(0).getPrimaryKeyValue());
            this.getModel().setValue(MAINFORMNAME, (Object)rt.get(0).getName());
            this.getModel().endInit();
            this.getPageCache().put(MAINFORMNAME, (String)this.getModel().getValue(MAINFORMNAME));
            this.getPageCache().put(MAINFORMID, (String)this.getModel().getValue(MAINFORMID));
            this.getView().updateView();
        } else if ("selectApp".equals(actionId)) {
            Map ret2 = (Map)returnData;
            if (ret2 != null) {
                this.getModel().setValue("dependency", ret2.get("nodename"));
                this.getModel().setValue("dependencyid", ret2.get("nodeid"));
            }
        } else if (IMAGEAP.equals(actionId)) {
            Map ret3 = (Map)returnData;
            if (ret3 != null) {
                String imageUrl = (String)ret3.get("value");
                IImage imageAp = (IImage)this.getControl(IMAGEAP);
                if (StringUtils.isNotBlank((CharSequence)imageUrl)) {
                    imageAp.setUrl(imageUrl);
                    this.getModel().setValue(IMAGE, (Object)imageUrl);
                } else {
                    imageAp.setUrl("icons/pc/entrance/addicon_48_48.png");
                    this.getModel().setValue(IMAGE, (Object)"");
                }
            }
        } else if (BACKIMAGEAP.equals(actionId) && (ret = (Map)returnData) != null) {
            String backimageUrl = (String)ret.get("value");
            IImage backimageAp = (IImage)this.getControl(BACKIMAGEAP);
            if (StringUtils.isNotBlank((CharSequence)backimageUrl)) {
                backimageAp.setUrl(backimageUrl);
                this.getModel().setValue(BACKIMAGE, (Object)backimageUrl);
            } else {
                backimageAp.setUrl("icons/pc/entrance/addicon_48_48.png");
                this.getModel().setValue(BACKIMAGE, (Object)"");
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String formId = this.getView().getFormShowParameter().getFormId();
        if (StringUtils.equals((CharSequence)"bos_devpn_app_layout", (CharSequence)formId)) {
            QFilter qFilter = new QFilter("ismodel", "=", (Object)false);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(qFilter);
        }
    }

    private static void writeLog(String appId) {
        try {
            long logId = DB.genGlobalLongId();
            MetadataLogService logService = (MetadataLogService)ServiceFactory.getService(MetadataLogService.class);
            logService.addAppMetaLog(appId, (int)MetaLogType.AppSave.getValue(), logId, (int)MetaType.App.getValue());
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
    }

    private String getBizAppVersion(String bizAppId) {
        String appVersion = "";
        DynamicObject appObj = BusinessDataServiceHelper.loadSingleFromCache((Object)bizAppId, (String)"bos_devportal_bizapp", (String)"version");
        if (appObj != null) {
            appVersion = appObj.getString("version");
        }
        if (StringUtils.isBlank((CharSequence)appVersion)) {
            appVersion = DevportalUtil.getAppVerion((String)this.getModel().getValue("number"));
        }
        return appVersion;
    }
}

