/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class BizChooseUnitPlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener {
    private static final String FORMLIST = "formlist";
    private static final String NUMBER = "number";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"confirm"});
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(FORMLIST);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        String bizAppType = appMetadata.getDevType();
        ArrayList filterFucPacks = new ArrayList();
        List appFunPackets = appMetadata.getAppFunctionPackets();
        filterFucPacks.addAll(appFunPackets);
        ArrayList formList = new ArrayList(filterFucPacks.size());
        for (AppFunctionPacketElement appFunPacket : filterFucPacks) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", appFunPacket.getId());
            map.put(NUMBER, appFunPacket.getNumber());
            map.put("name", appFunPacket.getName().getLocaleValue());
            map.put("type", appFunPacket.getType());
            formList.add(map);
        }
        if (formList.size() > 0) {
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow(FORMLIST, formList.size());
            int i = 0;
            for (Map map : formList) {
                model.setValue("id", map.get("id"), i);
                model.setValue(NUMBER, map.get(NUMBER), i);
                model.setValue("name", map.get("name"), i);
                if ("1".equals(bizAppType) || "3".equals(bizAppType)) {
                    FieldEdit fieldEdit = (FieldEdit)this.getControl("type");
                    fieldEdit.setVisible(null, false);
                } else {
                    model.setValue("type", map.get("type"), i);
                }
                ++i;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "confirm": {
                this.confirm();
                break;
            }
        }
    }

    private void confirm() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(FORMLIST);
        int row = grid.getEntryState().getFocusRow();
        if (row == -1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"BizChooseUnitPlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            return;
        }
        if (row > 0 || row == 0) {
            HashMap<String, Object> ret = new HashMap<String, Object>(4);
            ret.put("id", this.getModel().getValue("id", row));
            ret.put(NUMBER, this.getModel().getValue(NUMBER, row));
            ret.put("name", this.getModel().getValue("name", row));
            ret.put("type", this.getModel().getValue("type", row));
            this.getView().returnDataToParent(ret);
            this.getView().close();
        }
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        this.confirm();
    }
}

