/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.mservice.svc.picture.IImage;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class BizCloudPlugin
extends AbstractBasePlugIn
implements ClickListener {
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String IMAGEAP = "imageap";
    private static final String BTNSAVE = "btnsave";
    private static final String SEQUENCE = "sequence";
    private static final String IMAGE = "image";
    private static final String BOS_DEVPORTAL_BIZCLOUD = "bos_devportal_bizcloud";
    private static final String KEY_NUMBER = "number";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{IMAGEAP, BTNSAVE});
        this.initAppF7();
    }

    private void initAppF7() {
        BaseShowParameter baseShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        if (OperationStatus.EDIT.equals((Object)baseShowParameter.getStatus())) {
            String cloudId = (String)baseShowParameter.getPkId();
            ArrayList<String> list = new ArrayList<String>();
            list.add(cloudId);
            BasedataEdit appF7 = (BasedataEdit)this.getControl("baseapp");
            appF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.setCustomParam("bizcloudids", (Object)list);
                showParameter.setCustomParam("runtime", (Object)Boolean.FALSE);
            });
            appF7.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
                String bizAppId = (String)beforeF7ViewDetailEvent.getPkId();
                beforeF7ViewDetailEvent.setCancel(true);
                BaseShowParameter parameter = new BaseShowParameter();
                parameter.setFormId("bos_devportal_app_layout");
                parameter.setPkId((Object)bizAppId);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)parameter);
            });
        }
    }

    public void afterCreateNewData(EventObject e) {
        BaseShowParameter baseShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        IDataModel model = this.getModel();
        if (OperationStatus.ADDNEW.equals((Object)baseShowParameter.getStatus())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"baseapp"});
            int seq = this.getMaxSeq() + 1;
            model.setValue(SEQUENCE, (Object)seq);
        }
    }

    public void afterBindData(EventObject e) {
        BaseShowParameter baseShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        IDataModel model = this.getModel();
        if (OperationStatus.EDIT.equals((Object)baseShowParameter.getStatus())) {
            String image;
            String isv = (String)this.getModel().getValue("isv");
            if (!DevportalUtil.checkIsvPermission(isv)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{BTNSAVE});
                this.getView().setEnable(Boolean.FALSE, new String[]{"flexpanelap4"});
            }
            if (StringUtils.isNotBlank((CharSequence)(image = (String)model.getValue(IMAGE)))) {
                IImage imageap = (IImage)this.getControl(IMAGEAP);
                imageap.setUrl(image);
            }
        } else if (OperationStatus.VIEW.equals((Object)baseShowParameter.getStatus())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{IMAGEAP});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"version"});
    }

    public void click(EventObject evt) {
        String arg;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (arg = c.getKey().toLowerCase()) {
            case "imageap": {
                this.selectImage(arg);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        BaseShowParameter parameter = (BaseShowParameter)this.getView().getFormShowParameter();
        if (OperationStatus.EDIT.equals((Object)parameter.getStatus()) && !DevportalUtil.checkIsvPermission((String)this.getModel().getValue("isv"))) {
            return;
        }
        String propertyName = e.getProperty().getName();
        if (KEY_NUMBER.equals(propertyName)) {
            String number = (String)e.getChangeSet()[0].getNewValue();
            String isv = ISVService.getISVInfo().getId();
            number = DevportalUtil.autoIsvNumber(number, isv);
            this.getModel().beginInit();
            this.getModel().setValue(KEY_NUMBER, (Object)number);
            this.getModel().endInit();
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        Control c = (Control)evt.getSource();
        if (BTNSAVE.equalsIgnoreCase(c.getKey())) {
            BaseShowParameter baseShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
            String isv = (String)this.getModel().getValue("isv");
            if (OperationStatus.EDIT.equals((Object)baseShowParameter.getStatus()) && !DevportalUtil.checkIsvPermission(isv)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u672c\u5f00\u53d1\u5546\u521b\u5efa\u4e0d\u53ef\u4fee\u6539", (String)"BizCloudPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            String tipNotification = null;
            if (StringUtils.isBlank((Object)this.getModel().getValue(SEQUENCE))) {
                tipNotification = ResManager.loadKDString((String)"\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizCloudPlugin_12", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
            } else if (StringUtils.isBlank((Object)this.getModel().getValue(KEY_NUMBER))) {
                tipNotification = ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizCloudPlugin_13", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
            }
            if (tipNotification == null) {
                String localeId = RequestContext.get().getLang().toString();
                boolean isEmpty = true;
                Map map = (Map)this.getModel().getValue("name");
                if (map.get(localeId) != null && !((String)map.get(localeId)).trim().isEmpty()) {
                    isEmpty = false;
                }
                if (isEmpty) {
                    tipNotification = ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizCloudPlugin_14", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
                }
            }
            if (StringUtils.isBlank((Object)this.getModel().getValue("version"))) {
                tipNotification = ResManager.loadKDString((String)"\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizCloudPlugin_15", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
            } else if (StringUtils.isBlank((Object)this.getModel().getValue("type"))) {
                tipNotification = ResManager.loadKDString((String)"\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizCloudPlugin_16", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
            }
            if (StringUtils.isNotEmpty((CharSequence)tipNotification)) {
                this.getView().showTipNotification(tipNotification);
                evt.setCancel(true);
                return;
            }
            String number = (String)this.getModel().getValue(KEY_NUMBER);
            number = DevportalUtil.autoIsvNumber(number, isv);
            this.getModel().setValue(KEY_NUMBER, (Object)number);
            this.checkNumberDup(evt);
            this.getModel().setValue("isv", (Object)ISVService.getISVInfo().getId());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("save".equals(afterDoOperationEventArgs.getObjectId()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            MetadataDao.cleanAllPortalAppCache();
            JSONObject object = new JSONObject();
            object.put("msg", (Object)"success");
            this.getView().returnDataToParent((Object)object);
            this.getView().close();
        }
    }

    private void selectImage(String arg) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ide_pictureselector");
        CloseCallBack ccb = new CloseCallBack((IFormPlugin)this, arg);
        parameter.setCloseCallBack(ccb);
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map ret;
        super.closedCallBack(e);
        if (IMAGEAP.equals(e.getActionId()) && (ret = (Map)e.getReturnData()) != null) {
            IImage imageAp = (IImage)this.getControl(IMAGEAP);
            String imageUrl = (String)ret.get("value");
            if (StringUtils.isNotBlank((CharSequence)imageUrl)) {
                imageAp.setUrl(imageUrl);
                this.getModel().setValue(IMAGE, (Object)imageUrl);
            } else {
                imageAp.setUrl("images/pc/cardbackground/cloud_ pingtai.png");
                this.getModel().setValue(IMAGE, (Object)"");
            }
        }
    }

    private int getMaxSeq() {
        String selectFields = "id,sequence";
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)BOS_DEVPORTAL_BIZCLOUD, (String)selectFields, null, (String)"sequence desc", (int)1);
        int maxIndex = 0;
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            maxIndex = dynamicObjects[0].getInt(SEQUENCE);
        }
        return maxIndex;
    }

    private void checkNumberDup(BeforeClickEvent evt) {
        String id;
        QFilter q2;
        QFilter q1;
        QFilter[] filters;
        boolean exists;
        BaseShowParameter parameter = (BaseShowParameter)this.getView().getFormShowParameter();
        String regex = "[a-z0-9A-Z_]+";
        String number = (String)this.getModel().getValue(KEY_NUMBER);
        boolean flag = Pattern.matches(regex, number);
        if (!flag) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5fc5\u987b\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"BizCloudPlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(5000));
            evt.setCancel(true);
            return;
        }
        if (number.startsWith("_") || number.endsWith("_")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4ee5\u4e0b\u5212\u7ebf\u5f00\u5934\u6216\u7ed3\u5c3e\u3002", (String)"BizCloudPlugin_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(5000));
            evt.setCancel(true);
            return;
        }
        if (number.length() > 20) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc720\u4e2a\u5b57\u7b26\u3002", (String)"BizCloudPlugin_10", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(5000));
            evt.setCancel(true);
            return;
        }
        if (OperationStatus.ADDNEW.equals((Object)parameter.getStatus())) {
            QFilter q = new QFilter(KEY_NUMBER, "=", (Object)number);
            QFilter[] filters2 = new QFilter[]{q};
            boolean exists2 = QueryServiceHelper.exists((String)BOS_DEVPORTAL_BIZCLOUD, (QFilter[])filters2);
            if (exists2) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"BizCloudPlugin_11", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        } else if (OperationStatus.EDIT.equals((Object)parameter.getStatus()) && (exists = QueryServiceHelper.exists((String)BOS_DEVPORTAL_BIZCLOUD, (QFilter[])(filters = new QFilter[]{q1 = new QFilter(KEY_NUMBER, "=", (Object)number), q2 = new QFilter("id", "!=", (Object)(id = parameter.getPkId().toString()))})))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"BizCloudPlugin_11", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
    }
}

