/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.devportal.util.MetaDataUtil;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.service.IFormDesignService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BizCopyPagePlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final Log log = LogFactory.getLog(BizCopyPagePlugin.class);
    private static final String BIZUNITNAME = "bizunitname";
    private static final String COPYNAME = "copyname";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String KEY_COPYNUMBER = "copynumber";
    private static final String KEY_COPY = "_copy";
    private static final String BIZAPPID = "bizappid";
    private static final String KEY_BIZUNITID = "bizunitid";
    private static final String KEY_BIZCLOUND = "bizcloudid";
    private static final String KEY_SUCCESS = "success";
    private static final String PARENTID = "parentId";
    private static IFormDesignService formDesignService;

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok"});
        TextEdit bizUnit = (TextEdit)this.getView().getControl(BIZUNITNAME);
        bizUnit.addButtonClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String pageName = (String)parameter.getCustomParam("pagename");
        String pageNumber = (String)parameter.getCustomParam("pagenumber");
        this.getModel().setValue(COPYNAME, (Object)String.format(ResManager.loadKDString((String)"%s_\u590d\u5236", (String)"BizCopyPagePlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), pageName));
        this.getModel().setValue(KEY_COPYNUMBER, (Object)(pageNumber + KEY_COPY));
        String formDefaultName = String.format(ResManager.loadKDString((String)"%s_\u590d\u5236", (String)"BizCopyPagePlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), pageName);
        String formDefaultNumber = pageNumber + KEY_COPY;
        formDefaultNumber = DevportalUtil.autoIsvNumber(formDefaultNumber);
        formDefaultNumber = DevportalUtil.autoFormNumber(formDefaultNumber, KEY_COPY);
        formDefaultName = DevportalUtil.autoFormName(formDefaultName);
        this.getView().getModel().setValue(COPYNAME, (Object)formDefaultName);
        this.getView().getModel().setValue(KEY_COPYNUMBER, (Object)formDefaultNumber);
        String bizAppId = (String)parameter.getCustomParam(BIZAPPID);
        String bizUnitId = (String)parameter.getCustomParam(KEY_BIZUNITID);
        this.getModel().setValue(BIZAPPID, (Object)bizAppId);
        this.getModel().setValue(KEY_BIZUNITID, (Object)bizUnitId);
        AppFunctionPacketElement functionPacket = AppMetaServiceHelper.getFunctionPacketById((String)bizUnitId, (String)bizAppId, (boolean)false);
        if (functionPacket != null) {
            this.getModel().setValue(BIZUNITNAME, (Object)functionPacket.getName().getLocaleValue());
        }
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        this.getModel().setValue(KEY_BIZCLOUND, (Object)appMeta.getBizCloudID());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (KEY_COPYNUMBER.equals(propertyName)) {
            String sourceNum = (String)e.getChangeSet()[0].getNewValue();
            sourceNum = DevportalUtil.autoIsvNumber(sourceNum);
            this.getModel().beginInit();
            this.getModel().setValue(KEY_COPYNUMBER, (Object)sourceNum);
            this.getModel().endInit();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map ret = (Map)e.getReturnData();
        if (ret != null && "chooseunitcallback".equals(e.getActionId())) {
            String bizUnitId = (String)ret.get("id");
            String bizUnitName = (String)ret.get("name");
            this.getModel().setValue(KEY_BIZUNITID, (Object)bizUnitId);
            this.getModel().setValue(BIZUNITNAME, (Object)bizUnitName);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase()) {
            case "btnok": {
                this.btnok();
                break;
            }
            case "bizunitname": {
                this.chooseUnit();
                break;
            }
        }
    }

    private void chooseUnit() {
        String appId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        String bizunitid = (String)this.getView().getFormShowParameter().getCustomParam(KEY_BIZUNITID);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_chosebizunit");
        parameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u529f\u80fd\u5206\u7ec4", (String)"BizCopyPagePlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(BIZAPPID, (Object)appId);
        parameter.setCustomParam("thisunitid", (Object)bizunitid);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "chooseunitcallback");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void btnok() {
        ILocaleString formName = (ILocaleString)this.getModel().getValue(COPYNAME);
        if (StringUtils.isBlank((Object)formName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u540d\u79f0\u201d\u5b57\u6bb5\u3002", (String)"BizCopyPagePlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String formNumber = (String)this.getModel().getValue(KEY_COPYNUMBER);
        if (StringUtils.isBlank((CharSequence)formNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u7f16\u7801\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizCopyPagePlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (formNumber.endsWith("_mob")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u5355\u6807\u8bc6\u4e0d\u80fd\u7528\u201c_mob\u201d\u505a\u4e3a\u540e\u7f00\uff0c\u907f\u514d\u4e0e\u7cfb\u7edf\u5173\u952e\u5b57\u51b2\u7a81\u3002", (String)"BizCopyPagePlugin_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        MetaDataUtil metaDataUtil = new MetaDataUtil();
        if (metaDataUtil.checkNumber(formNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"BizCopyPagePlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String regex = "[a-z0-9A-Z_]+";
        boolean flag = Pattern.matches(regex, formNumber);
        if (!flag) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5fc5\u987b\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"BizCopyPagePlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (formNumber.startsWith("_") || formNumber.endsWith("_")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4ee5\u4e0b\u5212\u7ebf\u5f00\u5934\u6216\u7ed3\u5c3e\u3002", (String)"BizCopyPagePlugin_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (formNumber.length() > 25) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc725\u4e2a\u5b57\u7b26\u3002", (String)"BizCopyPagePlugin_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> message = new HashMap<String, Object>();
        Map<Object, Object> result = new HashMap();
        String bizFormId = (String)this.getView().getFormShowParameter().getCustomParam("bizformid");
        String bizUnitId = (String)this.getModel().getValue(KEY_BIZUNITID);
        String bizAppId = (String)this.getModel().getValue(BIZAPPID);
        String bizCloudId = (String)this.getModel().getValue(KEY_BIZCLOUND);
        AbstractMetadata meta = MetadataDao.readMeta((String)bizFormId, (MetaCategory)MetaCategory.Form);
        String modelType = meta.getModelType();
        if (!(StringUtils.equals((CharSequence)modelType, (CharSequence)"PrintModel") || StringUtils.equals((CharSequence)modelType, (CharSequence)"BillFormModel") || StringUtils.equals((CharSequence)modelType, (CharSequence)"BaseFormModel"))) {
            message.put(KEY_SUCCESS, Boolean.FALSE);
            message.put("message", ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u590d\u5236\u8be5\u7c7b\u578b\u8868\u5355\u3002", (String)"BizCopyPagePlugin_12", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().returnDataToParent(message);
            this.getView().close();
            return;
        }
        if (!StringUtils.equals((CharSequence)modelType, (CharSequence)"PrintModel")) {
            FormMetadata formMetadata = (FormMetadata)meta;
            if (!StringUtils.equals((CharSequence)formMetadata.getId(), (CharSequence)formMetadata.getEntityId())) {
                message.put(KEY_SUCCESS, Boolean.FALSE);
                message.put("message", ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u590d\u5236\u8be5\u7c7b\u578b\u8868\u5355\u3002", (String)"BizCopyPagePlugin_12", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                this.getView().returnDataToParent(message);
                this.getView().close();
                return;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(BIZAPPID, bizAppId);
            map.put(KEY_BIZUNITID, bizUnitId);
            map.put("modelType", modelType);
            map.put("id", formNumber);
            map.put("name", formName);
            map.put("srcFormId", bizFormId);
            map.put("islayout", Boolean.FALSE);
            map.put("entityId", bizFormId);
            map.put("isCopy", Boolean.TRUE);
            map.put(PARENTID, meta.getParentId());
            HashMap<String, Object> designerData = new HashMap();
            try (TXHandle tx = TX.required();){
                try {
                    designerData = metaDataUtil.createBlankModel(map);
                    result = metaDataUtil.save(designerData);
                }
                catch (Exception e) {
                    log.error("copy meta error", (Throwable)e);
                    tx.markRollback();
                    throw e;
                }
            }
            boolean isSuccess = (Boolean)result.get(KEY_SUCCESS);
            if (isSuccess) {
                try (TXHandle h = TX.required();){
                    DynamicObject dObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_devportal_unitrelform");
                    dObject.set("bizapp", (Object)bizAppId);
                    dObject.set("bizunit", (Object)bizUnitId);
                    dObject.set("form", designerData.get("id"));
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObject});
                }
            } else {
                message.put(KEY_SUCCESS, Boolean.FALSE);
                message.put("message", ResManager.loadKDString((String)"\u590d\u5236\u5931\u8d25\u3002", (String)"BizCopyPagePlugin_13", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                this.getView().returnDataToParent(message);
                this.getView().close();
                return;
            }
            result.put("id", designerData.get("id"));
        } else {
            try (TXHandle tx = TX.required((String)"mdl_BizCopyPagePlugin_btnok");){
                try {
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("bizFormId", bizFormId);
                    params.put("bizAppId", bizAppId);
                    params.put("bizUnitId", bizUnitId);
                    params.put("formNumber", formNumber);
                    params.put("tplName", formName.getLocaleValue());
                    result = this.getOrCreateDesignService().copyPrintMetadata(params);
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    tx.markRollback();
                    message.put(KEY_SUCCESS, Boolean.FALSE);
                    if (result.get(KEY_SUCCESS) != null && !((Boolean)result.get(KEY_SUCCESS)).booleanValue() && result.get("errors") != null) {
                        message.put("message", ((ErrorInfo)((ArrayList)result.get("errors")).get(0)).getError());
                    } else {
                        message.put("message", ResManager.loadKDString((String)"\u521b\u5efa\u5931\u8d25\u3002", (String)"BizCopyPagePlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                    }
                    this.getView().returnDataToParent(message);
                    this.getView().close();
                    if (tx != null) {
                        if (var15_17 != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable) {
                                var15_17.addSuppressed(throwable);
                            }
                        } else {
                            tx.close();
                        }
                    }
                    return;
                }
            }
        }
        message.put(KEY_SUCCESS, result.get(KEY_SUCCESS));
        message.put(KEY_BIZCLOUND, bizCloudId);
        message.put(BIZAPPID, bizAppId);
        message.put(KEY_BIZUNITID, bizUnitId);
        message.put("bizpageid", result.get("id"));
        this.getView().returnDataToParent(message);
        this.getView().close();
    }

    private IFormDesignService getOrCreateDesignService() {
        if (formDesignService == null) {
            formDesignService = (IFormDesignService)TypesContainer.createInstance((String)"kd.bos.designer.PrintDesignerService");
        }
        return formDesignService;
    }
}

