/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.util.FileUtils;

public class BizExportSourcePlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final Log logger = LogFactory.getLog(BizExportSourcePlugin.class);
    private static final String USER_HOME = System.getProperty("user.home");
    private static final String DOWNLOADPATH = "KINGDEEDOWNLOAD";
    private static final String SUCCESS = "EXPORT_SUCCESS";
    private static final String SOURCENAME = "sourcename";
    private static final String ENTRYENTITY = "entryentity";
    private static final String SOURCE_TYPE = "source_type";
    private static final String SOURCE_NAME = "source_name";
    private static final String FIRCUSTOMVARIABLE = "fircustomvariable";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"confirm"});
    }

    public void afterCreateNewData(EventObject e) {
        String sourceType = (String)this.getView().getFormShowParameter().getCustomParam("type");
        String bizId = (String)this.getView().getFormShowParameter().getCustomParam("bizid");
        String bizNumber = (String)this.getView().getFormShowParameter().getCustomParam("bizformnumber");
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
        String bizUnitId = (String)this.getView().getFormShowParameter().getCustomParam("bizunitid");
        Object showLayoutValue = this.getView().getFormShowParameter().getCustomParam("showLayout");
        boolean showlayout = showLayoutValue instanceof Boolean ? (Boolean)showLayoutValue : Boolean.parseBoolean(String.valueOf(showLayoutValue));
        String bizAppName = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false).getName().getLocaleValue();
        AppFunctionPacketElement appFuncElement = AppMetaServiceHelper.getFunctionPacketById((String)bizUnitId, (String)bizAppId, (boolean)false);
        String bizUnitName = appFuncElement.getName().getLocaleValue();
        this.getModel().setValue("appname", (Object)bizAppName);
        this.getModel().setValue("unitname", (Object)bizUnitName);
        if ("PAGE_TYPE".equals(sourceType)) {
            AbstractMetadata formMeta = MetadataDao.readMeta((String)bizId, (MetaCategory)MetaCategory.Form);
            LocaleString loaclName = null;
            String entityId = null;
            if (formMeta instanceof FormMetadata) {
                loaclName = ((FormMetadata)formMeta).getName();
                entityId = ((FormMetadata)formMeta).getEntityId();
                showlayout = showlayout && StringUtils.equals((CharSequence)formMeta.getId(), (CharSequence)entityId);
            } else if (formMeta instanceof PrintMetadata) {
                loaclName = ((PrintMetadata)formMeta).getName();
                showlayout = false;
            }
            if (loaclName == null) {
                return;
            }
            String formName = loaclName.getLocaleValue();
            this.getModel().setValue(SOURCENAME, (Object)formName);
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, 1);
            this.getModel().setValue(SOURCE_TYPE, (Object)ResManager.loadKDString((String)"\u5143\u6570\u636e", (String)"BizExportSourcePlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), 0);
            this.getModel().setValue(SOURCE_NAME, (Object)formName, 0);
            this.getModel().setValue(FIRCUSTOMVARIABLE, (Object)bizId, 0);
            this.getModel().setValue("seccustomvariable", (Object)bizNumber, 0);
            if (showlayout) {
                this.getPageCache().put("includeLayout", "true");
                this.addPageayout(entityId, bizAppId);
            }
        } else if ("SCRIPT_TYPE".equals(sourceType)) {
            String formName = BusinessDataServiceHelper.loadSingleFromCache((Object)bizId, (String)"ide_pluginscript", (String)"txt_scriptname").getString("txt_scriptname");
            this.getModel().setValue(SOURCENAME, (Object)formName);
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, 1);
            this.getModel().setValue(SOURCE_TYPE, (Object)ResManager.loadKDString((String)"\u5143\u6570\u636e", (String)"BizExportSourcePlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), 0);
            this.getModel().setValue(SOURCE_NAME, (Object)formName, 0);
            this.getModel().setValue(FIRCUSTOMVARIABLE, (Object)bizId, 0);
        } else if ("UNITTEST_TYPE".equals(sourceType)) {
            String formName = BusinessDataServiceHelper.loadSingleFromCache((Object)bizId, (String)"ide_unit_test_detail", (String)"multi_txt_name").getString("multi_txt_name");
            this.getModel().setValue(SOURCENAME, (Object)formName);
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, 1);
            this.getModel().setValue(SOURCE_TYPE, (Object)ResManager.loadKDString((String)"sql\u811a\u672c", (String)"BizExportSourcePlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), 0);
            this.getModel().setValue(SOURCE_NAME, (Object)formName, 0);
            this.getModel().setValue(FIRCUSTOMVARIABLE, (Object)bizId, 0);
        }
    }

    private void addPageayout(String entityId, String bizAppId) {
        String masterId = MetadataDao.getMasterId((String)entityId);
        SqlBuilder builder = new SqlBuilder();
        builder.append("select t1.fnumber,t1.fmodeltype,t1.fmodifierid,t1.fmodifydate,t1.fid,t1.ftype,t1.fbizappid ,t1.fisv , t2.fname  from t_meta_formdesign t1  left join t_meta_formdesign_l t2 on t1.fid=t2.fid and t2.flocaleid = ? where ", new Object[]{new SqlParameter(":flocaleid", 12, (Object)Lang.get().toString())}).appendIn("t1.fmodeltype", (Object[])new String[]{"BillFormModel", "BaseFormModel"}).append(" and t1.fbizappid = ? ", new Object[]{new SqlParameter(":fbizappid", 12, (Object)bizAppId)}).append(" and t1.fid != ?", new Object[]{new SqlParameter(":fid", 12, (Object)masterId)}).append(" and ", new Object[0]).appendIn("t1.fentityid", (Object[])new String[]{masterId, entityId});
        List list = (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)builder, rs -> {
            ArrayList datas = new ArrayList(10);
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>(7);
                map.put(SOURCENAME, rs.getString("fname"));
                map.put(SOURCE_TYPE, ResManager.loadKDString((String)"\u5143\u6570\u636e\uff08\u5e03\u5c40\uff09", (String)"BizExportSourcePlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                map.put(SOURCE_NAME, rs.getString("fname"));
                map.put(FIRCUSTOMVARIABLE, rs.getString("fid"));
                map.put("seccustomvariable", rs.getString("fnumber"));
                datas.add(map);
            }
            return datas;
        });
        if (list.isEmpty()) {
            return;
        }
        int[] rows = this.getModel().batchCreateNewEntryRow(ENTRYENTITY, list.size());
        int index = rows[0];
        for (Map item : list) {
            this.getModel().setValue(SOURCE_TYPE, item.get(SOURCE_TYPE), index);
            this.getModel().setValue(SOURCE_NAME, item.get(SOURCE_NAME), index);
            this.getModel().setValue(FIRCUSTOMVARIABLE, item.get(FIRCUSTOMVARIABLE), index);
            ++index;
        }
    }

    public void afterBindData(EventObject e) {
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        int count = this.getModel().getEntryRowCount(ENTRYENTITY);
        int[] selectRows = new int[count];
        for (int i = 0; i < count; ++i) {
            selectRows[i] = i;
        }
        boolean hasLayout = Boolean.parseBoolean(this.getPageCache().get("includeLayout"));
        if (hasLayout && count > 0) {
            grid.selectRows(new int[]{0}, 0);
        } else {
            grid.selectRows(selectRows, 0);
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase()) {
            case "confirm": {
                this.exportSource();
                break;
            }
        }
    }

    private void exportSource() {
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u5185\u5bb9\u3002", (String)"BizExportSourcePlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
        String bizId = (String)this.getView().getFormShowParameter().getCustomParam("bizid");
        String bizNumber = (String)this.getView().getFormShowParameter().getCustomParam("bizformnumber");
        if ("PAGE_TYPE".equals(type)) {
            this.exportPageSource(bizAppId, selectIndex, bizId, bizNumber);
        } else if ("SCRIPT_TYPE".equals(type)) {
            DevportalUtil.exportScriptCallBack(bizId, this.getView());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportPageSource(String bizAppId, int[] selectIndex, String bizId, String bizNumber) {
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        boolean hasLayout = Boolean.parseBoolean(this.getPageCache().get("includeLayout"));
        String bizAppNumber = appMeta.getNumber();
        String appVersion = appMeta.getAppElement().getVersion();
        String appNumberPath = USER_HOME + File.separator + DOWNLOADPATH + File.separator + bizAppNumber;
        String traceIdHash = Hashing.sha256().hashString((CharSequence)RequestContext.get().getTraceId(), Charsets.UTF_8).toString();
        String traceIdPath = appNumberPath + File.separator + traceIdHash;
        String localPath = traceIdPath + File.separator + "datamodel" + File.separator + appVersion + File.separator + "main" + File.separator + bizAppNumber;
        ArrayList<File> fileList = new ArrayList<File>();
        if (hasLayout) {
            for (int row : selectIndex) {
                String formPkid = (String)this.getModel().getValue(FIRCUSTOMVARIABLE, row);
                DevportalUtil.expFormMetadata(formPkid, localPath, "EXPORT_PAGE");
            }
        } else {
            DevportalUtil.expFormMetadata(bizId, localPath, "EXPORT_PAGE");
        }
        InputStream in = null;
        try {
            DevportalUtil.zipFiles(bizNumber, localPath, fileList);
            String downloadFile = FileUtils.cleanString((String)(localPath + File.separator + bizNumber + ".zip"));
            Path downloadPath = Paths.get(DevportalUtil.checkFilePath(downloadFile), new String[0]);
            in = Files.newInputStream(downloadPath, new OpenOption[0]);
            String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(bizNumber + ".zip", in, 5000);
            this.getView().openUrl(urls);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
            return;
        }
        finally {
            try {
                String filePath;
                File traceIdFile;
                if (in != null) {
                    in.close();
                }
                if ((traceIdFile = new File(filePath = FileUtils.cleanString((String)traceIdPath.replace('.', '%').replace('/', '%')))).exists()) {
                    boolean appNumDelete;
                    AppUtils.deleteKd((File)traceIdFile);
                    String checkFilePath = FileUtils.cleanString((String)appNumberPath.replace('.', '%').replace('/', '%'));
                    File appNumberFile = new File(checkFilePath);
                    if (appNumberFile.listFiles().length == 0 && (appNumDelete = appNumberFile.delete())) {
                        logger.debug(appNumberFile + "delete:" + appNumDelete);
                    }
                }
            }
            catch (IOException ioExp) {
                logger.error((Throwable)ioExp);
            }
        }
        this.getView().returnDataToParent((Object)SUCCESS);
        this.getView().close();
    }
}

