/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.devportal.util.MetaDataUtil;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class BizExtAppExtPagePlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final Log log = LogFactory.getLog(BizExtAppExtPagePlugin.class);
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String EXTPAGENUMBER = "extpagenumber";
    private static final String KEY_SUCCESS = "success";
    private static final String KEY_ERRORS = "errors";
    private static final String KEY_MESSAGE = "message";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"confirm"});
    }

    public void afterCreateNewData(EventObject e) {
        Object oriBizPageName = this.getView().getFormShowParameter().getCustomParam("oriBizPageName");
        String oriBizPageNumber = (String)this.getView().getFormShowParameter().getCustomParam("oriBizPageNumber");
        String formDefaultNumber = AppUtils.autoExtendedNumber((String)oriBizPageNumber);
        formDefaultNumber = DevportalUtil.autoFormNumber(formDefaultNumber, "_ext");
        this.getModel().setValue("extpagename", oriBizPageName);
        this.getModel().setValue(EXTPAGENUMBER, (Object)formDefaultNumber);
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "confirm": {
                this.confirm();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (EXTPAGENUMBER.equals(propertyName)) {
            String sourceNum = (String)e.getChangeSet()[0].getNewValue();
            String extNum = DevportalUtil.autoIsvNumber(sourceNum);
            this.getModel().beginInit();
            this.getModel().setValue(EXTPAGENUMBER, (Object)extNum);
            this.getModel().endInit();
        }
    }

    private void confirm() {
        String extBizAppId = (String)this.getView().getFormShowParameter().getCustomParam("extBizAppId");
        String oriBizunitId = (String)this.getView().getFormShowParameter().getCustomParam("oriBizunitId");
        String oriFormId = (String)this.getView().getFormShowParameter().getCustomParam("oriFormId");
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam("modelType");
        if ("PrintModel".equals(modelType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5957\u6253\u7c7b\u578b\u4e0d\u5141\u8bb8\u6269\u5c55\u3002", (String)"BizExtAppExtPagePlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        this.saveFormAndBindForm(oriBizunitId, extBizAppId, oriFormId, modelType);
    }

    private void saveFormAndBindForm(String oriUnitId, String extBizAppId, String oriFormId, String modelType) {
        String formId;
        String extPageNumber = (String)this.getModel().getValue(EXTPAGENUMBER);
        ILocaleString extPageName = (ILocaleString)this.getModel().getValue("extpagename");
        if (StringUtils.isEmpty((CharSequence)(extPageNumber = DevportalUtil.autoIsvNumber(extPageNumber)).trim()) || StringUtils.isBlank((Object)extPageName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u6216\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizExtAppExtPagePlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        MetaDataUtil metaDataUtil = new MetaDataUtil();
        if (metaDataUtil.checkNumber(extPageNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"BizExtAppExtPagePlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String regex = "[a-z0-9A-Z_]+";
        Boolean flag = Pattern.matches(regex, extPageNumber);
        if (!flag.booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5fc5\u987b\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"BizExtAppExtPagePlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (extPageNumber.startsWith("_") || extPageNumber.endsWith("_")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4ee5\u4e0b\u5212\u7ebf\u5f00\u5934\u6216\u7ed3\u5c3e\u3002", (String)"BizExtAppExtPagePlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (extPageNumber.length() > 25) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc725\u4e2a\u5b57\u7b26\u3002", (String)"BizExtAppExtPagePlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (extPageNumber.endsWith("_mob")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u5355\u6807\u8bc6\u4e0d\u80fd\u7528\u201c_mob\u201d\u505a\u4e3a\u540e\u7f00\uff0c\u907f\u514d\u4e0e\u7cfb\u7edf\u5173\u952e\u5b57\u51b2\u7a81\u3002", (String)"BizExtAppExtPagePlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        this.getModel().setDataChanged(false);
        String bizcloudId = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)extBizAppId, (boolean)false).getBizCloudID();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bizappid", extBizAppId);
        map.put("bizunitid", oriUnitId);
        map.put("name", extPageName);
        map.put("id", extPageNumber);
        map.put("modelType", modelType);
        map.put("parentId", oriFormId);
        map.put("devType", "2");
        String parentEntityId = (String)this.getView().getFormShowParameter().getCustomParam("entityid");
        if (!parentEntityId.equals(oriFormId) && !"PrintModel".equals(modelType)) {
            map.put("entityId", parentEntityId);
        }
        HashMap<String, Object> message = new HashMap<String, Object>();
        Map<Object, Object> save = new HashMap();
        try (TXHandle tx = TX.required((String)"mdl_BizExtAppExtPagePlugin_saveFormAndBindForm");){
            Map<String, Object> content = metaDataUtil.createBlankModel(map);
            save = metaDataUtil.save(content);
            if (save.get(KEY_SUCCESS) != null && !((Boolean)save.get(KEY_SUCCESS)).booleanValue()) {
                message.put(KEY_SUCCESS, Boolean.FALSE);
                if (save.get(KEY_SUCCESS) != null && !((Boolean)save.get(KEY_SUCCESS)).booleanValue() && save.get(KEY_ERRORS) != null) {
                    message.put(KEY_MESSAGE, ((ErrorInfo)((ArrayList)save.get(KEY_ERRORS)).get(0)).getError());
                } else {
                    message.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u521b\u5efa\u5931\u8d25\u3002", (String)"BizExtAppExtPagePlugin_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                }
                this.getView().returnDataToParent(message);
                this.getView().close();
                return;
            }
            try {
                formId = (String)content.get("id");
                DynamicObject newUnitrelform = BusinessDataServiceHelper.newDynamicObject((String)"bos_devportal_unitrelform");
                newUnitrelform.set("bizapp", (Object)extBizAppId);
                newUnitrelform.set("bizunit", (Object)oriUnitId);
                newUnitrelform.set("form", (Object)formId);
                MainEntityType unitrelformEntityType = EntityMetadataCache.getDataEntityType((String)"bos_devportal_unitrelform");
                BusinessDataServiceHelper.save((IDataEntityType)unitrelformEntityType, (Object[])new DynamicObject[]{newUnitrelform});
            }
            catch (NullPointerException nullPointerException) {
                tx.markRollback();
                log.error((Throwable)nullPointerException);
                message.put(KEY_SUCCESS, Boolean.FALSE);
                message.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u521b\u5efa\u5931\u8d25\u3002", (String)"BizExtAppExtPagePlugin_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                this.getView().returnDataToParent(message);
                this.getView().close();
                return;
            }
            catch (Exception e) {
                tx.markRollback();
                log.error((Throwable)e);
                message.put(KEY_SUCCESS, Boolean.FALSE);
                if (save.get(KEY_SUCCESS) != null && !((Boolean)save.get(KEY_SUCCESS)).booleanValue() && save.get(KEY_ERRORS) != null) {
                    message.put(KEY_MESSAGE, ((ErrorInfo)((ArrayList)save.get(KEY_ERRORS)).get(0)).getError());
                } else {
                    message.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u521b\u5efa\u5931\u8d25\u3002", (String)"BizExtAppExtPagePlugin_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                }
                this.getView().returnDataToParent(message);
                this.getView().close();
                return;
            }
        }
        JSONObject arg = new JSONObject();
        arg.put("bizcloudid", (Object)bizcloudId);
        arg.put("bizappid", (Object)extBizAppId);
        arg.put("bizunitid", (Object)oriUnitId);
        arg.put("bizpageid", (Object)formId);
        message.put(KEY_SUCCESS, Boolean.TRUE);
        message.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u521b\u5efa\u6210\u529f\u3002", (String)"BizExtAppExtPagePlugin_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        message.put("data", arg);
        this.getView().returnDataToParent(message);
        this.getView().close();
    }
}

