/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.devportal.util.MetaDataUtil;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BizFastInheritPagePlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final Log log = LogFactory.getLog(BizFastInheritPagePlugin.class);
    private static final String BTN_OK = "btnok";
    private static final String BIZAPPID = "bizappid";
    private static final String BIZUNITID = "bizunitid";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String PARENTID = "parentid";
    private static final String KEY_NUMBER = "number";
    private static final String BOS_FORMMETA = "bos_formmeta";
    private static final String MODELTYPE = "modeltype";
    private static final String KEY_SUCCESS = "success";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnlast", BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("currentappid");
        List selectAppId = (List)this.getView().getFormShowParameter().getCustomParam("appid");
        String bizUnitId = (String)this.getView().getFormShowParameter().getCustomParam("unitid");
        this.getPageCache().put(BIZAPPID, bizAppId);
        this.getPageCache().put("selectappid", SerializationUtils.toJsonString((Object)selectAppId));
        this.getPageCache().put(BIZUNITID, bizUnitId);
        String parentId = (String)this.getView().getFormShowParameter().getCustomParam("formid");
        if (StringUtils.isBlank((CharSequence)parentId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u70b9\u51fb\u3010\u4e0a\u4e00\u6b65\u3011\uff0c\u9009\u62e9\u8981\u7ee7\u627f\u7684\u9875\u9762\u3002", (String)"BizFastInheritPagePlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_OK});
            return;
        }
        this.getPageCache().put(PARENTID, parentId);
        String parentName = (String)this.getView().getFormShowParameter().getCustomParam("name");
        String parentNumber = (String)this.getView().getFormShowParameter().getCustomParam(KEY_NUMBER);
        String formDefaultName = String.format(ResManager.loadKDString((String)"%s_\u7ee7\u627f", (String)"BizFastInheritPagePlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), parentName);
        String formDefaultNumber = parentNumber + "_inh";
        formDefaultNumber = DevportalUtil.autoIsvNumber(formDefaultNumber);
        formDefaultNumber = DevportalUtil.autoFormNumber(formDefaultNumber, "_inh");
        formDefaultName = DevportalUtil.autoFormName(formDefaultName);
        this.getView().getModel().setValue("name", (Object)formDefaultName);
        this.getView().getModel().setValue(KEY_NUMBER, (Object)formDefaultNumber);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (KEY_NUMBER.equals(propertyName)) {
            String sourceNum = (String)e.getChangeSet()[0].getNewValue();
            sourceNum = DevportalUtil.autoIsvNumber(sourceNum);
            this.getModel().beginInit();
            this.getModel().setValue(KEY_NUMBER, (Object)sourceNum);
            this.getModel().endInit();
        }
    }

    public void click(EventObject evt) {
        String key;
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "btnlast": {
                this.btnlast();
                break;
            }
            case "btnok": {
                this.btnok();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("fastInheritCallBack".equals(e.getActionId())) {
            ListSelectedRowCollection rt = (ListSelectedRowCollection)e.getReturnData();
            if (rt != null && rt.size() > 0) {
                String parentId = (String)rt.get(0).getPrimaryKeyValue();
                this.getPageCache().put(PARENTID, parentId);
                if (StringUtils.isNotBlank((CharSequence)parentId)) {
                    String formDefaultName = String.format(ResManager.loadKDString((String)"%s_\u7ee7\u627f", (String)"BizFastInheritPagePlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), rt.get(0).getName());
                    String formDefaultNumber = rt.get(0).getNumber() + "_inh";
                    formDefaultNumber = DevportalUtil.autoIsvNumber(formDefaultNumber);
                    formDefaultNumber = DevportalUtil.autoFormNumber(formDefaultNumber, "_inh");
                    formDefaultName = DevportalUtil.autoFormName(formDefaultName);
                    this.getView().getModel().setValue("name", (Object)formDefaultName);
                    this.getView().getModel().setValue(KEY_NUMBER, (Object)formDefaultNumber);
                    this.getView().setEnable(Boolean.TRUE, new String[]{BTN_OK});
                } else {
                    this.getView().getModel().setValue("name", (Object)"");
                    this.getView().getModel().setValue(KEY_NUMBER, (Object)"");
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u70b9\u51fb\u3010\u4e0a\u4e00\u6b65\u3011\uff0c\u9009\u62e9\u8981\u7ee7\u627f\u7684\u9875\u9762\u3002", (String)"BizFastInheritPagePlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                    this.getView().setEnable(Boolean.FALSE, new String[]{BTN_OK});
                }
            } else {
                this.getView().close();
            }
        }
    }

    private void btnlast() {
        this.getPageCache().remove(PARENTID);
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)BOS_FORMMETA, (boolean)false);
        if (listShowParameter != null) {
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u8868\u5355\u9009\u62e9\u9875\u9762", (String)"BizFastInheritPagePlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            listShowParameter.setFormId("bos_devp_formtreelistf7");
            listShowParameter.setCustomParam("bizappids", (Object)SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("selectappid"), String.class));
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            listShowParameter.setCustomParam("runtime", (Object)Boolean.FALSE);
            QFilter filter = new QFilter(MODELTYPE, "!=", (Object)"PrintModel");
            String appType = (String)this.getView().getFormShowParameter().getCustomParam("apptype");
            if (StringUtils.isNotBlank((CharSequence)appType)) {
                QFilter q = new QFilter("type", "!=", (Object)"2");
                filter.and(q);
            }
            qFilters.add(filter);
            ListFilterParameter listFilterParameter = new ListFilterParameter(qFilters, null);
            listShowParameter.setListFilterParameter(listFilterParameter);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fastInheritCallBack"));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    private void btnok() {
        String formId;
        DynamicObject parentEntityObject;
        String parentEntityId;
        DynamicObject parentFormObject;
        String parentFormId;
        String parentId = this.getPageCache().get(PARENTID);
        String bizAppId = this.getPageCache().get(BIZAPPID);
        String bizUnitId = this.getPageCache().get(BIZUNITID);
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            this.getView().showTipNotification(DevportalUtil.getNoPermissionTip());
            return;
        }
        ILocaleString formName = (ILocaleString)this.getModel().getValue("name");
        if (StringUtils.isBlank((Object)formName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizFastInheritPagePlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String formNumber = (String)this.getModel().getValue(KEY_NUMBER);
        if (StringUtils.isEmpty((CharSequence)formNumber.trim())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u7f16\u7801\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizFastInheritPagePlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        MetaDataUtil metaDataUtil = new MetaDataUtil();
        if (metaDataUtil.checkNumber(formNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u8f93\u5165\u7684\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"BizFastInheritPagePlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String regex = "[a-z0-9A-Z_]+";
        boolean flag = Pattern.matches(regex, formNumber);
        if (!flag) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5fc5\u987b\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"BizFastInheritPagePlugin_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (formNumber.startsWith("_") || formNumber.endsWith("_")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4ee5\u4e0b\u5212\u7ebf\u5f00\u5934\u6216\u7ed3\u5c3e\u3002", (String)"BizFastInheritPagePlugin_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (formNumber.length() > 25) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc725\u4e2a\u5b57\u7b26\u3002", (String)"BizFastInheritPagePlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)parentId, (String)BOS_FORMMETA, (String)MODELTYPE);
        String modelType = obj.getString(MODELTYPE);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)parentId) && !(parentFormId = (parentFormObject = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)BOS_FORMMETA)).getString("id")).equals(parentEntityId = (parentEntityObject = parentFormObject.getDynamicObject("basedatafield")).getString("id"))) {
            map.put("entityId", parentEntityId);
            map.put("islayout", Boolean.TRUE);
        }
        map.put(BIZAPPID, bizAppId);
        map.put(BIZUNITID, bizUnitId);
        map.put("modelType", modelType);
        map.put("id", formNumber);
        map.put("name", formName);
        map.put("parentId", parentId);
        HashMap<String, Object> message = new HashMap<String, Object>();
        Map<Object, Object> save = new HashMap();
        this.getModel().setDataChanged(false);
        try (TXHandle tx = TX.required((String)"mdl_BizInheritPagePlugin_btnok");){
            try {
                HashMap<String, Object> content = new HashMap();
                content = metaDataUtil.createBlankModel(map);
                save = metaDataUtil.save(content);
                if (save.get(KEY_SUCCESS) != null && !((Boolean)save.get(KEY_SUCCESS)).booleanValue()) {
                    throw new RuntimeException();
                }
                formId = (String)content.get("id");
                QFilter q1 = new QFilter("form", "=", (Object)formId);
                QFilter q2 = new QFilter("bizunit", "=", (Object)bizUnitId);
                QFilter[] filters = new QFilter[]{q1, q2};
                DeleteServiceHelper.delete((String)"bos_devportal_unitrelform", (QFilter[])filters);
                DynamicObject dObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_devportal_unitrelform");
                dObject.set("bizapp", (Object)bizAppId);
                dObject.set("bizunit", (Object)bizUnitId);
                dObject.set("form", (Object)formId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObject});
            }
            catch (Exception e) {
                log.error((Throwable)e);
                tx.markRollback();
                message.put(KEY_SUCCESS, Boolean.FALSE);
                if (save.get(KEY_SUCCESS) != null && !((Boolean)save.get(KEY_SUCCESS)).booleanValue() && save.get("errors") != null) {
                    message.put("message", ((ErrorInfo)((ArrayList)save.get("errors")).get(0)).getError());
                } else {
                    message.put("message", String.format(ResManager.loadKDString((String)"\u521b\u5efa\u5931\u8d25\uff0c%s\u3002", (String)"BizFastInheritPagePlugin_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), e.getMessage()));
                }
                this.getView().returnDataToParent(message);
                this.getView().close();
                if (tx != null) {
                    if (var16_16 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var16_16.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return;
            }
        }
        String bizCloudId = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false).getBizCloudID();
        message.put(KEY_SUCCESS, Boolean.TRUE);
        message.put("bizcloudid", bizCloudId);
        message.put(BIZAPPID, bizAppId);
        message.put(BIZUNITID, bizUnitId);
        message.put("bizpageid", formId);
        this.getView().returnDataToParent(message);
        this.getView().close();
    }
}

