/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.designer.dao.GitSaveMetadata;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.devportal.util.MetaDataUtil;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BizInheritPagePlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String BIZUNITNAME = "bizunitname";
    private static final String INHNUMBER = "inhnumber";
    private static final String BIZ_APPID = "bizAppId";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String BIZUNITID = "bizunitid";
    private static final String KEY_BIZAPPID = "bizappid";
    private static final String PARENTID = "parentId";
    private static final String DEVTYPE = "devType";
    private static final String KEY_SUCCESS = "success";
    private static final Log log = LogFactory.getLog(BizInheritPagePlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        TextEdit bizUnit = (TextEdit)this.getView().getControl(BIZUNITNAME);
        bizUnit.addButtonClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String parentName = (String)this.getView().getFormShowParameter().getCustomParam("parentName");
        String parentNumber = (String)this.getView().getFormShowParameter().getCustomParam("parentNumber");
        String formDefaultName = String.format(ResManager.loadKDString((String)"%s_\u7ee7\u627f", (String)"BizInheritPagePlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), parentName);
        String formDefaultNumber = parentNumber + "_inh";
        formDefaultNumber = DevportalUtil.autoIsvNumber(formDefaultNumber);
        formDefaultNumber = DevportalUtil.autoFormNumber(formDefaultNumber, "_inh");
        formDefaultName = DevportalUtil.autoFormName(formDefaultName);
        this.getView().getModel().setValue("inhname", (Object)formDefaultName);
        this.getView().getModel().setValue(INHNUMBER, (Object)formDefaultNumber);
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZ_APPID);
        String bizunitid = (String)this.getView().getFormShowParameter().getCustomParam(BIZUNITID);
        this.getModel().setValue(BIZ_APPID, (Object)bizAppId);
        this.getModel().setValue(BIZUNITID, (Object)bizunitid);
        AppFunctionPacketElement functionPacket = AppMetaServiceHelper.getFunctionPacketById((String)bizunitid, (String)bizAppId, (boolean)false);
        this.getModel().setValue(BIZUNITNAME, (Object)functionPacket.getName().getLocaleValue());
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        this.getModel().setValue("bizcloudId", (Object)appMeta.getBizCloudID());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (INHNUMBER.equals(propertyName)) {
            String sourceNum = (String)e.getChangeSet()[0].getNewValue();
            sourceNum = DevportalUtil.autoIsvNumber(sourceNum);
            this.getModel().beginInit();
            this.getModel().setValue(INHNUMBER, (Object)sourceNum);
            this.getModel().endInit();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map ret = (Map)e.getReturnData();
        if (ret != null && "chooseunitcallback".equals(e.getActionId())) {
            String bizUnitId = (String)ret.get("id");
            String bizUnitName = (String)ret.get("name");
            this.getModel().setValue(BIZUNITID, (Object)bizUnitId);
            this.getModel().setValue(BIZUNITNAME, (Object)bizUnitName);
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "btnok": {
                this.btnok();
                break;
            }
            case "bizunitname": {
                this.chooseUnit();
                break;
            }
        }
    }

    private void chooseUnit() {
        String appId = (String)this.getView().getFormShowParameter().getCustomParam(BIZ_APPID);
        String bizunitid = (String)this.getView().getFormShowParameter().getCustomParam(BIZUNITID);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_chosebizunit");
        parameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u529f\u80fd\u5206\u7ec4", (String)"BizInheritPagePlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(KEY_BIZAPPID, (Object)appId);
        parameter.setCustomParam("thisunitid", (Object)bizunitid);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "chooseunitcallback");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void btnok() {
        String formId;
        Map<String, Object> form;
        String devType;
        DynamicObject parentEntityObject;
        String parentEntityId;
        DynamicObject parentFormObject;
        String parentFormId;
        String bizAppId = (String)this.getModel().getValue(BIZ_APPID);
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            this.getView().showTipNotification(DevportalUtil.getNoPermissionTip());
            return;
        }
        ILocaleString formName = (ILocaleString)this.getModel().getValue("inhname");
        String formNumber = (String)this.getModel().getValue(INHNUMBER);
        if (StringUtils.isBlank((Object)formName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u540d\u79f0\u201d\u5b57\u6bb5\u3002", (String)"BizInheritPagePlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)formNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b57\u6bb5\u201c\u7f16\u7801\u201d\u3002", (String)"BizInheritPagePlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (formNumber.endsWith("_mob")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u5355\u6807\u8bc6\u4e0d\u80fd\u7528\u201c_mob\u201d\u505a\u4e3a\u540e\u7f00\uff0c\u907f\u514d\u4e0e\u7cfb\u7edf\u5173\u952e\u5b57\u51b2\u7a81\u3002", (String)"BizInheritPagePlugin_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        MetaDataUtil metaDataUtil = new MetaDataUtil();
        if (metaDataUtil.checkNumber(formNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u8f93\u5165\u7684\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"BizInheritPagePlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String regex = "[a-z0-9A-Z_]+";
        boolean flag = Pattern.matches(regex, formNumber);
        if (!flag) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5fc5\u987b\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"BizInheritPagePlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (formNumber.startsWith("_") || formNumber.endsWith("_")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4ee5\u4e0b\u5212\u7ebf\u5f00\u5934\u6216\u7ed3\u5c3e\u3002", (String)"BizInheritPagePlugin_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (formNumber.length() > 25) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e25\u3002", (String)"BizInheritPagePlugin_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String bizcloudId = (String)this.getModel().getValue("bizcloudId");
        String bizunitid = (String)this.getModel().getValue(BIZUNITID);
        String parentId = (String)this.getView().getFormShowParameter().getCustomParam(PARENTID);
        String modeltype = (String)this.getView().getFormShowParameter().getCustomParam("modeltype");
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)parentId) && !(parentFormId = (parentFormObject = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)"bos_formmeta")).getString("id")).equals(parentEntityId = (parentEntityObject = parentFormObject.getDynamicObject("basedatafield")).getString("id"))) {
            map.put("entityId", parentEntityId);
            map.put("islayout", Boolean.TRUE);
        }
        map.put(KEY_BIZAPPID, bizAppId);
        map.put(BIZUNITID, bizunitid);
        map.put("modelType", modeltype);
        map.put("id", formNumber);
        map.put("name", formName);
        map.put(PARENTID, parentId);
        List<Map<String, Object>> formList = this.findParentAndType(parentId);
        if (formList.size() > 0 && "2".equals(devType = (String)(form = formList.get(0)).get(DEVTYPE))) {
            map.put(DEVTYPE, "2");
        }
        HashMap<String, Object> message = new HashMap<String, Object>();
        Map<Object, Object> save = new HashMap();
        this.getModel().setDataChanged(false);
        try (TXHandle tx = TX.required((String)"mdl_BizInheritPagePlugin_btnok");){
            try {
                Map<Object, Object> content = new HashMap();
                content = "PrintModel".equals(modeltype) ? metaDataUtil.createPrintModel(map) : metaDataUtil.createBlankModel(map);
                save = metaDataUtil.save(content);
                if (save.get(KEY_SUCCESS) != null && !((Boolean)save.get(KEY_SUCCESS)).booleanValue()) {
                    throw new RuntimeException();
                }
                formId = (String)content.get("id");
                QFilter q1 = new QFilter("form", "=", (Object)formId);
                QFilter q2 = new QFilter("bizunit", "=", (Object)bizunitid);
                QFilter[] filters = new QFilter[]{q1, q2};
                DeleteServiceHelper.delete((String)"bos_devportal_unitrelform", (QFilter[])filters);
                DynamicObject dObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_devportal_unitrelform");
                dObject.set("bizapp", (Object)bizAppId);
                dObject.set("bizunit", (Object)bizunitid);
                dObject.set("form", (Object)formId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObject});
                this.saveMetadataToRepository(bizAppId, formId);
            }
            catch (Exception e) {
                tx.markRollback();
                message.put(KEY_SUCCESS, Boolean.FALSE);
                if (save.get(KEY_SUCCESS) != null && !((Boolean)save.get(KEY_SUCCESS)).booleanValue() && save.get("errors") != null) {
                    message.put("message", ((ErrorInfo)((ArrayList)save.get("errors")).get(0)).getError());
                } else {
                    message.put("message", String.format(ResManager.loadKDString((String)"\u521b\u5efa\u5931\u8d25\u3002%s", (String)"BizInheritPagePlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), e.getMessage()));
                }
                this.getView().returnDataToParent(message);
                this.getView().close();
                if (tx != null) {
                    if (var17_17 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var17_17.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return;
            }
        }
        message.put(KEY_SUCCESS, Boolean.TRUE);
        message.put("bizcloudid", bizcloudId);
        message.put(KEY_BIZAPPID, bizAppId);
        message.put(BIZUNITID, bizunitid);
        message.put("bizpageid", formId);
        this.getView().returnDataToParent(message);
        this.getView().close();
    }

    private List<Map<String, Object>> findParentAndType(String formId) {
        String sql = "select FNUMBER,FMASTERID,FPARENTID,FTYPE from T_META_FORMDESIGN where FID = ?";
        List formList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])new Object[]{formId}, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws SQLException {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(4);
                HashMap<String, String> map = new HashMap<String, String>(4);
                while (rs.next()) {
                    map.put(BizInheritPagePlugin.PARENTID, rs.getString("FPARENTID"));
                    map.put("masterId", rs.getString("FMASTERID"));
                    map.put(BizInheritPagePlugin.DEVTYPE, rs.getString("FTYPE"));
                    map.put("formNumber", rs.getString("FNUMBER"));
                    list.add(map);
                }
                return list;
            }
        });
        return formList;
    }

    private void saveMetadataToRepository(String bizAppId, String id) {
        try {
            GitSaveMetadata saveMetadata = new GitSaveMetadata();
            String gitSessionId = (String)this.getView().getFormShowParameter().getCustomParam("sessionId");
            saveMetadata.saveMetadataToRepository(gitSessionId, bizAppId, id, "page");
        }
        catch (Exception e) {
            log.info("git save metadata error", (Object)e);
        }
    }
}

