/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.hosting.SVNCommonUtil;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BizLoginSVNPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(BizLoginSVNPlugin.class);
    private static final String IS_CHECKED = "isChecked";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String SVNOPERATEKEY = "svnoperatekey";
    private static final String ISCHECKED = "ischecked";
    private static final String CACHE_REGIONINFO = "SVN_LOGININFO";
    private static final String USERNAME = "username";
    private static final String HIDEITEM = "password";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String bizAppId = (String)formShowParameter.getCustomParam("bizappid");
        String svnPath = null;
        String type = (String)formShowParameter.getCustomParam("type");
        if ("svnmanage".equals(type)) {
            svnPath = (String)formShowParameter.getCustomParam("svnurl");
            if (StringUtils.isBlank((CharSequence)svnPath)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165SVN\u5730\u5740\u3002", (String)"BizLoginSVNPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
        } else {
            svnPath = this.getSVNPathByAppId(bizAppId);
            if (StringUtils.isBlank((CharSequence)svnPath)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6eSVN\u8def\u5f84\u3002", (String)"BizLoginSVNPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
        }
        this.getModel().setValue("svnPath", (Object)svnPath);
        String svnOperateKey = (String)formShowParameter.getCustomParam(SVNOPERATEKEY);
    }

    private String getSVNPathByAppId(String appId) {
        QFilter[] filters = new QFilter[]{new QFilter("bizappid", "=", (Object)appId)};
        DynamicObject svnManage = BusinessDataServiceHelper.loadSingle((String)"svnmanage", (String)"id,svnserver,svnurl,mobilealone,mobilesvnurl", (QFilter[])filters);
        if (svnManage != null) {
            String svnServer = svnManage.getString("svnserver");
            if ("customserver".equals(svnServer)) {
                if (svnManage.getBoolean("mobilealone")) {
                    this.getPageCache().put("mobilesvnurl", svnManage.getString("mobilesvnurl"));
                }
                return svnManage.getString("svnurl");
            }
            if ("nextserver".equals(svnServer)) {
                String svnUrl = AppUtils.getSvnUrl();
                String path = svnManage.getString("svnurl");
                if (StringUtils.isNotBlank((CharSequence)svnUrl) && StringUtils.isNotBlank((CharSequence)path)) {
                    return svnUrl + path;
                }
            }
        }
        return null;
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "btnok": {
                this.btnok();
                break;
            }
        }
    }

    private void btnok() {
        String userName = (String)this.getModel().getValue(USERNAME);
        String passWord = (String)this.getModel().getValue(HIDEITEM);
        if (StringUtils.isBlank((CharSequence)userName) || StringUtils.isBlank((CharSequence)passWord)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7528\u6237\u540d\u548c\u5bc6\u7801\u3002", (String)"BizLoginSVNPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String svnPath = (String)this.getModel().getValue("svnpath");
        try {
            SVNCommonUtil.checkSVNAuthentication((String)svnPath, (String)userName, (String)passWord);
        }
        catch (Exception e) {
            logger.warn("svn\u6743\u9650\u6821\u9a8c\u5931\u8d25", (Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u7528\u6237\u540d\u5bc6\u7801\u662f\u5426\u6b63\u786e\uff0c\u6216\u8005\u662f\u5426\u5177\u6709\u64cd\u4f5c\u6743\u9650\u3002", (String)"BizLoginSVNPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        boolean ischecked = (Boolean)this.getModel().getValue(IS_CHECKED);
        JSONObject msg = new JSONObject();
        msg.put("svnpath", (Object)svnPath);
        String mobilesvnurl = this.getPageCache().get("mobilesvnurl");
        msg.put("mobilesvnurl", (Object)mobilesvnurl);
        msg.put(USERNAME, (Object)userName);
        msg.put(HIDEITEM, (Object)Encrypters.encode((String)passWord));
        msg.put(ISCHECKED, (Object)ischecked);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        msg.put("svnoperate", parameter.getCustomParam("svnoperate"));
        msg.put(SVNOPERATEKEY, parameter.getCustomParam(SVNOPERATEKEY));
        msg.put("svnoperateid", parameter.getCustomParam("svnoperateid"));
        msg.put("svnoperatetype", parameter.getCustomParam("svnoperatetype"));
        if (!ischecked) {
            DistributeSessionlessCache loginInfoCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(CACHE_REGIONINFO, new DistributeCacheHAPolicy());
            loginInfoCache.put(USERNAME, (Object)userName, 10800);
            loginInfoCache.put(HIDEITEM, (Object)Encrypters.encode((String)passWord), 10800);
        }
        this.getView().returnDataToParent((Object)msg.toJSONString());
        this.getView().close();
    }
}

