/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class BizMenuTreePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
RowClickEventListener,
TreeNodeQueryListener {
    public static final String NODE_CACHE = "node_cache";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String MENU_TREE = "menutreeview";
    private static final String MENU_ENTRY_ENTITY = "menuentryentity";
    private static final String ALL_MENUS = "allmenus";
    private static final String CLOUD_NODE = "cloudnode";
    private static final String APP_NODE = "appnode";
    private static final String FIRST_MENU_NODE = "firmenunode";
    private static final String SECOND_MENU_NODE = "secmenunode";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_NAME = "name";
    private static final String KEY_TREE_ID = "treeid";
    private static final String KEY_BIZCLDID = "_bizcldid";
    private static final String CLOUD_ID = "cloudid";
    private static final String CLOUD_NUMBER = "cloudnumber";
    private static final String CLOUD_NAME = "cloudname";
    private static final String APP_ID = "appid";
    private static final String APP_NUMBER = "appnumber";
    private static final String APP_NAME = "appname";
    private static final String KEY_BIZ_APPID = "_bizappid";
    private static final String KEY_LEVEL = "level";
    private static final String KEY_LEVEL_TYPE = "leveltype";
    private static final String PAGE_NUM = "pagenum";
    private static final String MENU_ID = "menuid";
    private static final String MENU_NAME = "menuname";
    private static final String MENU_NUMBER = "menunumber";
    private static final String MENU_ID_2 = "menuid2";
    private static final String MENU_NAME_2 = "menuname2";
    private static final String MENU_NUMBER_2 = "menunumber2";
    private static final String BTN_CONFIRM = "confirm";
    private static final String REF_FORM_NUMBER = "refFormNumber";
    private static final String BIZ_CLOUD_ID = "bizcldid";
    private static final String BIZ_APP_ID = "bizappid";
    private static final Log logger = LogFactory.getLog(BizMenuTreePlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_CONFIRM});
        TreeView menuTree = (TreeView)this.getView().getControl(MENU_TREE);
        menuTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        menuTree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        AbstractGrid grid = (AbstractGrid)this.getControl(MENU_ENTRY_ENTITY);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.renderMenuTree();
        this.renderEntry();
    }

    private void renderMenuTree() {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(10);
        String rootNodeTitle = ResManager.loadKDString((String)"\u83dc\u5355\u6811", (String)"BizMenuTreePlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
        TreeNode rootNode = new TreeNode("", ALL_MENUS, rootNodeTitle);
        List<String> clouds = this.getSysRuntimeCloud();
        for (String cloud : clouds) {
            JSONObject appAndCloudInfo = JSONObject.parseObject((String)cloud);
            JSONObject cloudInfo = appAndCloudInfo.getJSONObject("cloudinfo");
            String bizCloudId = cloudInfo.getString("id");
            String bizCloudName = cloudInfo.getString(KEY_NAME);
            String bizCloudNumber = cloudInfo.getString(KEY_NUMBER);
            String cloudTreeId = bizCloudId + KEY_BIZCLDID;
            TreeNode cloudNode = new TreeNode(ALL_MENUS, cloudTreeId, bizCloudName);
            ArrayList appNode = new ArrayList(10);
            cloudNode.addChildren(appNode);
            treeNodes.add(cloudNode);
        }
        rootNode.addChildren(treeNodes);
        TreeView menuTree = (TreeView)this.getView().getControl(MENU_TREE);
        menuTree.addNode(rootNode);
        menuTree.focusNode(rootNode);
        menuTree.showNode(ALL_MENUS);
        this.getPageCache().put("treeNode_cache", SerializationUtils.toJsonString((Object)rootNode));
    }

    private void renderEntry() {
        List<String> clouds = this.getSysRuntimeCloud();
        IDataModel model = this.getModel();
        model.deleteEntryData(MENU_ENTRY_ENTITY);
        if (clouds == null || clouds.isEmpty()) {
            return;
        }
        model.batchCreateNewEntryRow(MENU_ENTRY_ENTITY, clouds.size());
        for (int i = 0; i < clouds.size(); ++i) {
            JSONObject appAndCloudInfo = JSONObject.parseObject((String)clouds.get(i));
            JSONObject cloudInfo = appAndCloudInfo.getJSONObject("cloudinfo");
            model.setValue(KEY_LEVEL, (Object)this.getLevelName(CLOUD_NODE), i);
            model.setValue(KEY_LEVEL_TYPE, (Object)CLOUD_NODE, i);
            model.setValue(KEY_NAME, (Object)cloudInfo.getString(KEY_NAME), i);
            model.setValue(KEY_TREE_ID, (Object)cloudInfo.getString("id"), i);
            model.setValue(PAGE_NUM, (Object)"", i);
        }
    }

    public String getLevelName(String level) {
        switch (level) {
            case "cloudnode": {
                return ResManager.loadKDString((String)"\u4e91\u8282\u70b9", (String)"BizMenuTreePlugin_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
            }
            case "appnode": {
                return ResManager.loadKDString((String)"\u5e94\u7528\u8282\u70b9", (String)"BizMenuTreePlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
            }
            case "firmenunode": {
                return ResManager.loadKDString((String)"\u4e00\u7ea7\u83dc\u5355\u8282\u70b9", (String)"BizMenuTreePlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
            }
            case "secmenunode": {
                return ResManager.loadKDString((String)"\u4e8c\u7ea7\u83dc\u5355\u8282\u70b9", (String)"BizMenuTreePlugin_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
            }
        }
        return "";
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        this.queryTreeNodeChildren(new TreeNodeEvent(evt.getSource(), (Object)"", (Object)nodeId));
        String nodeCache = this.getPageCache().get(NODE_CACHE);
        if (!StringUtils.isNotBlank((CharSequence)nodeCache)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{MENU_ENTRY_ENTITY});
            this.getView().setVisible(Boolean.TRUE, new String[]{"showtips"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{MENU_ENTRY_ENTITY});
        this.getView().setVisible(Boolean.FALSE, new String[]{"showtips"});
        Map nodeCacheMap = (Map)SerializationUtils.fromJsonString((String)nodeCache, Map.class);
        if (nodeId.endsWith(BIZ_CLOUD_ID)) {
            String cloudId = nodeId.split("_")[0];
            List appsInfo = BizAppServiceHelp.getRuntimeMainConsoleInfoByCloudId((String)cloudId);
            logger.debug(cloudId + " : BizAppServiceHelp.getRuntimeMainConsoleInfoByCloudId(cloudId) : " + SerializationUtils.toJsonString((Object)appsInfo));
            IDataModel model = this.getModel();
            model.deleteEntryData(MENU_ENTRY_ENTITY);
            if (appsInfo == null || appsInfo.isEmpty()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{MENU_ENTRY_ENTITY});
                this.getView().setVisible(Boolean.TRUE, new String[]{"showtips"});
                return;
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{MENU_ENTRY_ENTITY});
            this.getView().setVisible(Boolean.FALSE, new String[]{"showtips"});
            model.batchCreateNewEntryRow(MENU_ENTRY_ENTITY, appsInfo.size());
            for (int i = 0; i < appsInfo.size(); ++i) {
                JSONObject appInfo = JSONObject.parseObject((String)((String)appsInfo.get(i)));
                String bizAppId = appInfo.getString("id");
                String bizAppName = appInfo.getString(KEY_NAME);
                model.setValue(KEY_LEVEL, (Object)this.getLevelName(APP_NODE), i);
                model.setValue(KEY_LEVEL_TYPE, (Object)APP_NODE, i);
                model.setValue(KEY_NAME, (Object)bizAppName, i);
                model.setValue(KEY_TREE_ID, (Object)bizAppId, i);
                model.setValue(PAGE_NUM, (Object)"", i);
            }
        } else if (nodeId.endsWith(BIZ_APP_ID)) {
            this.setEntry(nodeCacheMap, FIRST_MENU_NODE, MENU_ID, MENU_NAME);
        } else if (nodeId.endsWith(FIRST_MENU_NODE)) {
            this.setEntry(nodeCacheMap, SECOND_MENU_NODE, MENU_ID_2, MENU_NAME_2);
        }
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(MENU_ENTRY_ENTITY);
        grid.clearEntryState();
    }

    private void setEntry(Map<String, Map<String, Object>> nodeCacheMap, String level, String menuId, String menuName) {
        if (nodeCacheMap.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{MENU_ENTRY_ENTITY});
            this.getView().setVisible(Boolean.TRUE, new String[]{"showtips"});
            return;
        }
        Collection<Map<String, Object>> values = nodeCacheMap.values();
        ArrayList<Map<String, Object>> listData = new ArrayList<Map<String, Object>>(values);
        IDataModel model = this.getModel();
        model.deleteEntryData(MENU_ENTRY_ENTITY);
        if (listData.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{MENU_ENTRY_ENTITY});
            this.getView().setVisible(Boolean.TRUE, new String[]{"showtips"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{MENU_ENTRY_ENTITY});
        this.getView().setVisible(Boolean.FALSE, new String[]{"showtips"});
        model.batchCreateNewEntryRow(MENU_ENTRY_ENTITY, listData.size());
        for (int i = 0; i < listData.size(); ++i) {
            Map info = (Map)listData.get(i);
            model.setValue(KEY_LEVEL, (Object)this.getLevelName(level), i);
            model.setValue(KEY_LEVEL_TYPE, (Object)level, i);
            model.setValue(KEY_NAME, info.get(menuName), i);
            model.setValue(KEY_TREE_ID, info.get(menuId), i);
            model.setValue(PAGE_NUM, info.get(REF_FORM_NUMBER), i);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (!BTN_CONFIRM.equalsIgnoreCase(key)) {
            return;
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl(MENU_ENTRY_ENTITY);
        int row = grid.getEntryState().getFocusRow();
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(MENU_ENTRY_ENTITY);
        if (-1 == row || dynamicObjects == null || dynamicObjects.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"BizMenuTreePlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        String id = (String)this.getModel().getValue(KEY_TREE_ID, row);
        String level = (String)this.getModel().getValue(KEY_LEVEL_TYPE, row);
        String pageNumber = (String)this.getModel().getValue(PAGE_NUM, row);
        if (!(APP_NODE.equalsIgnoreCase(level) || FIRST_MENU_NODE.equalsIgnoreCase(level) || SECOND_MENU_NODE.equalsIgnoreCase(level))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e94\u7528\u6216\u83dc\u5355\u8282\u70b9\u3002", (String)"BizMenuTreePlugin_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        String nodeCache = this.getPageCache().get(NODE_CACHE);
        Map nodeCacheMap = (Map)SerializationUtils.fromJsonString((String)nodeCache, Map.class);
        Map returnData = (Map)nodeCacheMap.get(id + this.getSuffixByLevel(level));
        if (APP_NODE.equalsIgnoreCase(level)) {
            this.getView().returnDataToParent((Object)returnData);
            this.getView().close();
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)pageNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u89e3\u7ed1\u83dc\u5355\u7ed1\u5b9a\u7684\u9875\u9762\uff0c\u518d\u53d1\u5e03\u8f7b\u5206\u6790\u83dc\u5355\u3002", (String)"BizMenuTreePlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        this.getView().returnDataToParent((Object)returnData);
        this.getView().close();
    }

    private String getSuffixByLevel(String level) {
        String suffix = "";
        switch (level) {
            case "appnode": {
                suffix = KEY_BIZ_APPID;
                break;
            }
            case "firmenunode": {
                suffix = "_firmenunode";
                break;
            }
            case "secmenunode": {
                suffix = "_secmenunode";
                break;
            }
        }
        return suffix;
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        if (-1 == row) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"BizMenuTreePlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        String level = (String)this.getModel().getValue(KEY_LEVEL_TYPE, row);
        if (!(APP_NODE.equalsIgnoreCase(level) || FIRST_MENU_NODE.equalsIgnoreCase(level) || SECOND_MENU_NODE.equalsIgnoreCase(level))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e94\u7528\u6216\u83dc\u5355\u8282\u70b9\u3002", (String)"BizMenuTreePlugin_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        if (APP_NODE.equalsIgnoreCase(level)) {
            return;
        }
        String pageNum = (String)this.getModel().getValue(PAGE_NUM, row);
        if (StringUtils.isNotBlank((CharSequence)pageNum)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u89e3\u7ed1\u83dc\u5355\u7ed1\u5b9a\u7684\u9875\u9762\uff0c\u518d\u53d1\u5e03\u8f7b\u5206\u6790\u83dc\u5355\u3002", (String)"BizMenuTreePlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
    }

    private List<String> getSysRuntimeCloud() {
        String selectFields = "id, sequence, number, name";
        ArrayList<String> info = new ArrayList<String>();
        Map cloudMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizcloud", (String)selectFields, null, (String)"sequence");
        if (cloudMap == null || cloudMap.size() == 0) {
            return null;
        }
        JSONObject cloudValue = new JSONObject();
        for (DynamicObject cloud : cloudMap.values()) {
            try {
                String cloudId = cloud.getString("id");
                JSONObject cloudInfo = new JSONObject();
                Short sequence = (short)cloud.getInt("sequence");
                cloudInfo.put("id", (Object)cloudId);
                cloudInfo.put(KEY_NUMBER, (Object)cloud.getString(KEY_NUMBER));
                cloudInfo.put(KEY_NAME, (Object)cloud.getLocaleString(KEY_NAME).getLocaleValue());
                cloudInfo.put("sequence", (Object)sequence);
                cloudValue.put("cloudinfo", (Object)cloudInfo);
                info.add(cloudValue.toJSONString());
                cloudInfo.clear();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        return info;
    }

    public void queryTreeNodeChildren(TreeNodeEvent event) {
        String nodeId = (String)event.getNodeId();
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(10);
        TreeView treeView = new TreeView();
        if (StringUtils.isNotBlank((Object)event.getSource())) {
            treeView = (TreeView)event.getSource();
        }
        if (StringUtils.isNotBlank((CharSequence)nodeId)) {
            if (nodeId.endsWith(BIZ_CLOUD_ID)) {
                this.expCloudNode(nodeId, treeNodes, treeView);
            } else if (nodeId.endsWith(BIZ_APP_ID)) {
                this.expAppNode(nodeId, treeNodes, treeView);
            } else if (nodeId.endsWith(FIRST_MENU_NODE)) {
                this.expFirMenuNode(nodeId);
            }
        }
    }

    private void expCloudNode(String nodeId, List<TreeNode> treeNodes, TreeView treeView) {
        String cloudId = nodeId.split("_")[0];
        String bizCloudNumber = (String)BusinessDataServiceHelper.loadSingleFromCache((Object)cloudId, (String)"bos_devportal_bizcloud", (String)KEY_NUMBER).get(KEY_NUMBER);
        String bizCloudName = ((ILocaleString)BusinessDataServiceHelper.loadSingleFromCache((Object)cloudId, (String)"bos_devportal_bizcloud", (String)KEY_NAME).get(KEY_NAME)).getLocaleValue();
        List appsInfo = BizAppServiceHelp.getRuntimeMainConsoleInfoByCloudId((String)cloudId);
        if (appsInfo == null || appsInfo.isEmpty()) {
            TreeNode rootNode;
            TreeNode currentNode;
            this.getView().setVisible(Boolean.FALSE, new String[]{MENU_ENTRY_ENTITY});
            this.getView().setVisible(Boolean.TRUE, new String[]{"showtips"});
            String cache = this.getPageCache().get("treeNode_cache");
            if (StringUtils.isNotBlank((CharSequence)cache) && (currentNode = (rootNode = (TreeNode)SerializationUtils.fromJsonString((String)cache, TreeNode.class)).getTreeNode(nodeId, 10)) != null) {
                currentNode.setChildren(null);
                treeView.updateNode(currentNode);
            }
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{MENU_ENTRY_ENTITY});
        this.getView().setVisible(Boolean.FALSE, new String[]{"showtips"});
        HashMap nodeCache = new HashMap(appsInfo.size());
        for (int i = 0; i < appsInfo.size(); ++i) {
            JSONObject appInfo = JSONObject.parseObject((String)((String)appsInfo.get(i)));
            String bizAppId = appInfo.getString("id");
            String bizAppNumber = appInfo.getString(KEY_NUMBER);
            String bizAppName = appInfo.getString(KEY_NAME);
            String appTreeId = bizAppId + KEY_BIZ_APPID;
            HashMap<String, String> appReturnData = new HashMap<String, String>(7);
            appReturnData.put(KEY_LEVEL, APP_NODE);
            appReturnData.put(CLOUD_ID, cloudId);
            appReturnData.put(CLOUD_NUMBER, bizCloudNumber);
            appReturnData.put(CLOUD_NAME, bizCloudName);
            appReturnData.put(APP_ID, bizAppId);
            appReturnData.put(APP_NUMBER, bizAppNumber);
            appReturnData.put(APP_NAME, bizAppName);
            TreeNode appNode = new TreeNode(nodeId, appTreeId, bizAppName, appReturnData);
            ArrayList tn = new ArrayList(10);
            appNode.addChildren(tn);
            treeNodes.add(appNode);
            nodeCache.put(appTreeId, appReturnData);
        }
        treeView.addNodes(treeNodes);
        this.getPageCache().put(NODE_CACHE, SerializationUtils.toJsonString(nodeCache));
    }

    private void expAppNode(String nodeId, List<TreeNode> treeNodes, TreeView treeView) {
        String bizAppId = nodeId.split("_")[0];
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)bizAppId, (String)"bos_devportal_bizapp", (String)"number, name, bizcloud.id");
        if (dynamicObject == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{MENU_ENTRY_ENTITY});
            this.getView().setVisible(Boolean.TRUE, new String[]{"showtips"});
            this.getPageCache().put(NODE_CACHE, null);
            return;
        }
        String bizAppNumber = dynamicObject.getString(KEY_NUMBER);
        String bizAppName = ((ILocaleString)dynamicObject.get(KEY_NAME)).getLocaleValue();
        String bizCloudId = dynamicObject.getString("bizcloud.id");
        DynamicObject dynamicObject1 = BusinessDataServiceHelper.loadSingleFromCache((Object)bizCloudId, (String)"bos_devportal_bizcloud", (String)"number, name");
        String bizCloudNumber = dynamicObject1.getString(KEY_NUMBER);
        String bizCloudName = ((ILocaleString)dynamicObject1.get(KEY_NAME)).getLocaleValue();
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        if (appMeta == null) {
            return;
        }
        List menuInfos = AppMetadataCache.getAppMenusInfoByAppId((String)bizAppId);
        if (menuInfos.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{MENU_ENTRY_ENTITY});
            this.getView().setVisible(Boolean.TRUE, new String[]{"showtips"});
            this.getPageCache().put(NODE_CACHE, null);
            return;
        }
        HashMap nodeCache = new HashMap(menuInfos.size());
        for (AppMenuInfo menu : menuInfos) {
            if (StringUtils.isBlank((CharSequence)menu.getParentId()) || !StringUtils.equals((CharSequence)menu.getParentId(), (CharSequence)bizAppId)) continue;
            String menuId = menu.getId();
            String menuTreeId = menuId + "_" + FIRST_MENU_NODE;
            String menuNumber = menu.getId();
            String menuName = menu.getName() == null ? null : menu.getName().getLocaleValue();
            String unknownName = ResManager.loadKDString((String)"\u65e0\u540d\u83dc\u5355", (String)"BizMenuTreePlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
            menuName = menuName == null ? unknownName : menuName;
            HashMap<String, String> returnData = new HashMap<String, String>(10);
            returnData.put(KEY_LEVEL, FIRST_MENU_NODE);
            returnData.put(CLOUD_ID, bizCloudId);
            returnData.put(CLOUD_NUMBER, bizCloudNumber);
            returnData.put(CLOUD_NAME, bizCloudName);
            returnData.put(APP_ID, bizAppId);
            returnData.put(APP_NUMBER, bizAppNumber);
            returnData.put(APP_NAME, bizAppName);
            returnData.put(MENU_ID, menuId);
            returnData.put(MENU_NUMBER, menuNumber);
            returnData.put(MENU_NAME, menuName);
            returnData.put(REF_FORM_NUMBER, menu.getFormId());
            TreeNode firstMenuNode = new TreeNode(nodeId, menuTreeId, menuName, returnData);
            treeNodes.add(firstMenuNode);
            nodeCache.put(menuTreeId, returnData);
        }
        treeView.addNodes(treeNodes);
        this.getPageCache().put(NODE_CACHE, SerializationUtils.toJsonString(nodeCache));
    }

    private void expFirMenuNode(String nodeId) {
        String firMenuNodeId = nodeId.split("_")[0];
        Object[] parameters = new SqlParameter[]{new SqlParameter(":fid", 12, (Object)firMenuNodeId)};
        String sql = "select fappid from t_meta_menuruntime where fid = ?";
        String bizAppNumber = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])parameters, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    return resultSet.getString(1);
                }
                return "";
            }
        });
        String bizAppId = BizAppServiceHelp.getAppIdByAppNumber((String)bizAppNumber);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)bizAppId, (String)"bos_devportal_bizapp", (String)"number, name, bizcloud.id");
        String bizAppName = ((ILocaleString)dynamicObject.get(KEY_NAME)).getLocaleValue();
        String bizCloudId = dynamicObject.getString("bizcloud.id");
        DynamicObject dynamicObject1 = BusinessDataServiceHelper.loadSingleFromCache((Object)bizCloudId, (String)"bos_devportal_bizcloud", (String)"number, name");
        String bizCloudNumber = dynamicObject1.getString(KEY_NUMBER);
        String bizCloudName = ((ILocaleString)dynamicObject1.get(KEY_NAME)).getLocaleValue();
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        if (appMeta == null) {
            return;
        }
        List menuInfos = AppMetadataCache.getAppMenusInfoByAppId((String)bizAppId);
        HashMap<String, AppMenuInfo> appMenuInfoMap = new HashMap<String, AppMenuInfo>(menuInfos.size());
        for (AppMenuInfo menuInfo : menuInfos) {
            appMenuInfoMap.put(menuInfo.getId(), menuInfo);
        }
        HashMap nodeCache = new HashMap(menuInfos.size());
        for (AppMenuInfo menu1 : menuInfos) {
            if (StringUtils.isBlank((CharSequence)menu1.getParentId()) || !firMenuNodeId.equals(menu1.getParentId())) continue;
            String menu1Id = menu1.getId();
            String menu1Number = menu1.getId();
            AppMenuInfo parentMenu = (AppMenuInfo)appMenuInfoMap.get(firMenuNodeId);
            String parentNumber = "";
            String parentName = "";
            if (null != parentMenu) {
                parentNumber = parentMenu.getId();
                parentName = parentMenu.getName() == null ? null : parentMenu.getName().getLocaleValue();
            }
            String menu1name = menu1.getName() == null ? null : menu1.getName().getLocaleValue();
            String unknownName1 = ResManager.loadKDString((String)"\u65e0\u540d\u83dc\u5355", (String)"BizMenuTreePlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
            menu1name = menu1name == null ? unknownName1 : menu1name;
            HashMap<String, String> returnData = new HashMap<String, String>(13);
            returnData.put(KEY_LEVEL, SECOND_MENU_NODE);
            returnData.put(CLOUD_ID, bizCloudId);
            returnData.put(CLOUD_NUMBER, bizCloudNumber);
            returnData.put(CLOUD_NAME, bizCloudName);
            returnData.put(APP_ID, bizAppId);
            returnData.put(APP_NUMBER, bizAppNumber);
            returnData.put(APP_NAME, bizAppName);
            returnData.put(MENU_ID, firMenuNodeId);
            returnData.put(MENU_NUMBER, parentNumber);
            returnData.put(MENU_NAME, parentName);
            returnData.put(MENU_ID_2, menu1Id);
            returnData.put(MENU_NUMBER_2, menu1Number);
            returnData.put(MENU_NAME_2, menu1name);
            returnData.put(REF_FORM_NUMBER, menu1.getFormId());
            nodeCache.put(menu1Id + "_" + SECOND_MENU_NODE, returnData);
        }
        if (nodeCache.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{MENU_ENTRY_ENTITY});
            this.getView().setVisible(Boolean.TRUE, new String[]{"showtips"});
        }
        this.getPageCache().put(NODE_CACHE, SerializationUtils.toJsonString(nodeCache));
    }
}

