/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BizMovePagePlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(BizMovePagePlugin.class);
    private static final String KEY_BIZUNITNAME = "bizunitname";
    private static final String KEY_BIZAPPID = "bizappid";
    private static final String KEY_BIZCLOUDID = "bizcloudId";
    private static final String KEY_BIZUNITID = "bizunitid";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok"});
        TextEdit bizUnit = (TextEdit)this.getView().getControl(KEY_BIZUNITNAME);
        bizUnit.addButtonClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String bizAppId = (String)parameter.getCustomParam(KEY_BIZAPPID);
        String bizUnitId = (String)parameter.getCustomParam(KEY_BIZUNITID);
        AppFunctionPacketElement functionPacket = AppMetaServiceHelper.getFunctionPacketById((String)bizUnitId, (String)bizAppId, (boolean)false);
        this.getModel().setValue(KEY_BIZUNITNAME, (Object)functionPacket.getName().getLocaleValue());
        this.getModel().setValue(KEY_BIZUNITID, (Object)bizUnitId);
        this.getModel().setValue(KEY_BIZAPPID, (Object)bizAppId);
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        this.getModel().setValue(KEY_BIZCLOUDID, (Object)appMeta.getBizCloudID());
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map ret = (Map)e.getReturnData();
        if (ret != null && "chooseunitcallback".equals(e.getActionId())) {
            String bizUnitId = (String)ret.get("nodeid");
            String bizUnitName = (String)ret.get("nodename");
            String bizAppId = (String)ret.get("appid");
            this.getModel().setValue(KEY_BIZUNITNAME, (Object)bizUnitName);
            if (StringUtils.isNotBlank((CharSequence)bizAppId) && StringUtils.isNotBlank((CharSequence)bizUnitId)) {
                this.getModel().setValue(KEY_BIZUNITID, (Object)bizUnitId);
                this.getModel().setValue(KEY_BIZAPPID, (Object)bizAppId);
                AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
                this.getModel().setValue(KEY_BIZCLOUDID, (Object)appMeta.getBizCloudID());
            }
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase()) {
            case "btnok": {
                this.btnok();
                break;
            }
            case "bizunitname": {
                this.chooseUnit();
                break;
            }
        }
    }

    private void chooseUnit() {
        String appId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_BIZAPPID);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devportal_selectunit");
        parameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u529f\u80fd\u5206\u7ec4", (String)"BizMovePagePlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        JSONObject map = new JSONObject();
        map.put("appid", (Object)appId);
        map.put("runtime", (Object)Boolean.FALSE);
        parameter.setCustomParams((Map)map);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "chooseunitcallback");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void btnok() {
        String bizcloudId = (String)this.getModel().getValue(KEY_BIZCLOUDID);
        String bizAppId = (String)this.getModel().getValue(KEY_BIZAPPID);
        String bizUnitId = (String)this.getModel().getValue(KEY_BIZUNITID);
        String bizUnitName = (String)this.getModel().getValue(KEY_BIZUNITNAME);
        String bizFormId = (String)this.getView().getFormShowParameter().getCustomParam("bizformid");
        if (StringUtils.isBlank((CharSequence)bizUnitId) || StringUtils.isBlank((CharSequence)bizAppId) || StringUtils.isBlank((CharSequence)bizUnitName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79fb\u52a8\u4f4d\u7f6e\u3002", (String)"BizMovePagePlugin_1", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            return;
        }
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            this.getView().showTipNotification(DevportalUtil.getNoPermissionTip());
            return;
        }
        try (TXHandle tx = TX.required((String)"mdl_BizMovePagePlugin_btnok");){
            try {
                QFilter[] filters = new QFilter[]{new QFilter("form", "=", (Object)bizFormId)};
                DeleteServiceHelper.delete((String)"bos_devportal_unitrelform", (QFilter[])filters);
                DynamicObject dObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_devportal_unitrelform");
                dObject.set("bizapp", (Object)bizAppId);
                dObject.set("bizunit", (Object)bizUnitId);
                dObject.set("form", (Object)bizFormId);
                DynamicObject[] dObjects = new DynamicObject[]{dObject};
                SaveServiceHelper.save((DynamicObject[])dObjects);
            }
            catch (Exception e) {
                tx.markRollback();
                log.error((Throwable)e);
            }
        }
        JSONObject arg = new JSONObject();
        arg.put(KEY_BIZCLOUDID, (Object)bizcloudId);
        arg.put(KEY_BIZAPPID, (Object)bizAppId);
        arg.put(KEY_BIZUNITID, (Object)bizUnitId);
        arg.put("bizpageid", (Object)bizFormId);
        this.getView().returnDataToParent((Object)arg);
        this.getView().close();
    }
}

