/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class BizOriAppMenuTreePlugin
extends AbstractFormPlugin
implements ClickListener,
TreeNodeClickListener {
    private static final String KEY_TREEVIEWAP = "treeviewap";

    public void registerListener(EventObject e) {
        TreeView tree = (TreeView)this.getView().getControl(KEY_TREEVIEWAP);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"reset"});
    }

    public void afterCreateNewData(EventObject e) {
        String bizAppID = (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
        String bizAppName = (String)this.getView().getFormShowParameter().getCustomParam("bizappname");
        TreeNode root = new TreeNode("", bizAppID, bizAppName);
        root.setIsOpened(true);
        List<TreeNode> nodeList = this.getNodeList(bizAppID);
        BizOriAppMenuTreePlugin.buildNode(root, nodeList);
        this.getPageCache().put("root", SerializationUtils.toJsonString((Object)root));
        TreeView tree = (TreeView)this.getView().getControl(KEY_TREEVIEWAP);
        tree.addNode(root);
        tree.focusNode(root);
        tree.treeNodeClick("", root.getId());
    }

    private void getMenuTreeNode(List<AppMenuElement> menuElements, List<String> parentMenuIds, List<TreeNode> parentMenuList, Map<String, Integer> nodeLevel, Integer level) {
        ArrayList<String> menuIds = new ArrayList<String>();
        ArrayList<TreeNode> menuList = new ArrayList<TreeNode>();
        for (AppMenuElement menuElement : menuElements) {
            String parentMenuId = menuElement.getParentId();
            String menuId = menuElement.getId();
            String menuName = (String)menuElement.getName().getDefaultItem();
            if (!parentMenuIds.contains(parentMenuId)) continue;
            nodeLevel.put(menuId, level);
            menuIds.add(menuId);
            TreeNode treeNode = new TreeNode(parentMenuId, menuId, menuName, false);
            menuList.add(treeNode);
        }
        if (!menuList.isEmpty()) {
            for (int i = 0; i < parentMenuList.size(); ++i) {
                TreeNode pNode = parentMenuList.get(i);
                BizOriAppMenuTreePlugin.buildNode(pNode, menuList);
            }
            Integer n = level;
            Integer n2 = level = Integer.valueOf(level + 1);
            this.getMenuTreeNode(menuElements, menuIds, menuList, nodeLevel, level);
        }
    }

    private List<TreeNode> getNodeList(String bizAppId) {
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        String appParentId = appMeta.getMasterId();
        List menuElements = appMeta.getAppMenus();
        ArrayList<String> firMenuIds = new ArrayList<String>();
        ArrayList<TreeNode> firMenuList = new ArrayList<TreeNode>();
        for (AppMenuElement menuElement : menuElements) {
            String parentMenuId = menuElement.getParentId();
            String menuId = menuElement.getId();
            String menuName = (String)menuElement.getName().getDefaultItem();
            if (!StringUtils.isBlank((CharSequence)parentMenuId) && !parentMenuId.equals(bizAppId) && (!StringUtils.isNotBlank((CharSequence)appParentId) || !parentMenuId.equals(appParentId))) continue;
            parentMenuId = bizAppId;
            firMenuIds.add(menuId);
            TreeNode treeNode = new TreeNode(bizAppId, menuId, menuName);
            firMenuList.add(treeNode);
        }
        HashMap<String, Integer> nodeLevel = new HashMap<String, Integer>();
        this.getMenuTreeNode(menuElements, firMenuIds, firMenuList, nodeLevel, 2);
        this.getPageCache().put("nodelevel", SerializationUtils.toJsonString(nodeLevel));
        return firMenuList;
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "reset": {
                this.resetOriAppMenu();
                break;
            }
        }
    }

    private void resetOriAppMenu() {
        TreeView selectTree = (TreeView)this.getView().getControl(KEY_TREEVIEWAP);
        Map treeNode = selectTree.getTreeState().getFocusNode();
        String parentMenuId = (String)treeNode.get("parentid");
        if (StringUtils.isBlank((CharSequence)parentMenuId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9664\u6839\u8282\u70b9\u5916\u7684\u83dc\u5355\u8fdb\u884c\u91cd\u7f6e\u3002", (String)"BizAppMenuTreePlugin_10", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            return;
        }
        String currentAppId = (String)this.getView().getFormShowParameter().getCustomParam("currentAppId");
        String parentAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
        boolean exists = false;
        if (StringUtils.equals((CharSequence)parentMenuId, (CharSequence)parentAppId)) {
            exists = true;
        } else {
            List menuElements;
            AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)currentAppId, (boolean)false);
            if (appMeta != null && (menuElements = appMeta.getAppMenus()) != null) {
                exists = menuElements.stream().anyMatch(i -> parentMenuId.equals(i.getId()));
            }
        }
        if (exists) {
            this.getView().returnDataToParent((Object)treeNode);
            this.getView().close();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u83dc\u5355\u7684\u7236\u83dc\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u91cd\u7f6e\u7236\u83dc\u5355\u3002", (String)"BizOriAppMenuTreePlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        }
    }

    public static TreeNode buildNode(TreeNode pnode, List<TreeNode> childNode) {
        HashMap<String, TreeNode> leafNodeMap = new HashMap<String, TreeNode>();
        BizOriAppMenuTreePlugin.getLeafNodes(leafNodeMap, pnode);
        for (int i = 0; i < childNode.size(); ++i) {
            TreeNode cnode = childNode.get(i);
            String parentID = cnode.getParentid();
            TreeNode parNode = (TreeNode)leafNodeMap.get(parentID);
            if (parNode == null) continue;
            int seq = 0;
            if (parNode.getChildren() != null) {
                seq = parNode.getChildren().size();
            }
            parNode.addChild(seq, cnode);
        }
        return pnode;
    }

    public static void getLeafNodes(Map<String, TreeNode> map, TreeNode node) {
        if (node.getChildren() != null) {
            for (TreeNode childNode : node.getChildren()) {
                BizOriAppMenuTreePlugin.getLeafNodes(map, childNode);
            }
        } else {
            map.put(node.getId(), node);
            return;
        }
    }
}

