/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.designer.dao.GitSaveMetadata;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.devportal.util.LayoutPageType;
import kd.bos.devportal.util.MetaDataUtil;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BizPageLayoutPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(BizPageLayoutPlugin.class);
    private static final String KEY_LAYOUTNUMBER = "layoutnumber";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String DEVICETYPE = "devicetype";
    private static final String PAGETYPE = "pagetype";
    private static final String KEY_SUCCESS = "success";
    private static final String KEY_MESSAGE = "message";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if ("btnok".equals(key)) {
            this.confirm();
        }
    }

    public void afterCreateNewData(EventObject e) {
        String parentName = (String)this.getView().getFormShowParameter().getCustomParam("pagename");
        String parentNumber = (String)this.getView().getFormShowParameter().getCustomParam("pagenumber");
        String formDefaultName = String.format(ResManager.loadKDString((String)"%s_\u5e03\u5c40", (String)"BizPageLayoutPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), parentName);
        String formDefaultNumber = parentNumber + "_layout";
        formDefaultNumber = DevportalUtil.autoIsvNumber(formDefaultNumber);
        formDefaultNumber = DevportalUtil.autoFormNumber(formDefaultNumber, "_layout");
        formDefaultName = DevportalUtil.autoFormName(formDefaultName);
        this.getView().getModel().setValue("layoutname", (Object)formDefaultName);
        this.getView().getModel().setValue(KEY_LAYOUTNUMBER, (Object)formDefaultNumber);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (KEY_LAYOUTNUMBER.equals(propertyName)) {
            String sourceNum = (String)e.getChangeSet()[0].getNewValue();
            sourceNum = DevportalUtil.autoIsvNumber(sourceNum);
            this.getModel().beginInit();
            this.getModel().setValue(KEY_LAYOUTNUMBER, (Object)sourceNum);
            this.getModel().endInit();
        } else if (DEVICETYPE.equals(propertyName)) {
            String deviceName = this.getModel().getValue(DEVICETYPE).toString();
            if ("Mobile".equals(deviceName)) {
                this.getModel().setValue(PAGETYPE, (Object)"Empty");
                this.getView().setEnable(Boolean.FALSE, new String[]{PAGETYPE});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{PAGETYPE});
            }
        }
    }

    private void confirm() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Object> message = new HashMap<String, Object>();
        Map<Object, Object> save = new HashMap();
        String deviceName = this.getModel().getValue(DEVICETYPE).toString();
        String layoutnumber = this.getModel().getValue(KEY_LAYOUTNUMBER).toString();
        layoutnumber = DevportalUtil.autoIsvNumber(layoutnumber);
        ILocaleString layoutname = (ILocaleString)this.getModel().getValue("layoutname");
        String pageType = this.getModel().getValue(PAGETYPE).toString();
        String bizAppId = this.getView().getFormShowParameter().getCustomParam("bizappid").toString();
        String bizUnitId = this.getView().getFormShowParameter().getCustomParam("bizunitid").toString();
        String modelType = this.getView().getFormShowParameter().getCustomParam("modeltype").toString();
        String entityId = this.getView().getFormShowParameter().getCustomParam("entityid").toString();
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            this.getView().showTipNotification(DevportalUtil.getNoPermissionTip());
            return;
        }
        String errorMsg = this.validateNameAndNumber(layoutnumber, layoutname);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            this.getView().showTipNotification(errorMsg);
            return;
        }
        if ("Mobile".equals(deviceName)) {
            modelType = modelType.endsWith("BillFormModel") ? "MobileBillFormModel" : (modelType.endsWith("BaseFormModel") ? "MobileBillFormModel" : "MobileFormModel");
        }
        map.put("entityId", entityId);
        map.put("modelType", modelType);
        map.put("id", layoutnumber);
        map.put("name", layoutname);
        map.put("islayout", Boolean.TRUE);
        map.put("bizappid", bizAppId);
        map.put("bizunitid", bizUnitId);
        map.put("isRuntime", Boolean.TRUE);
        try (TXHandle tx = TX.required((String)"mdl_BizPageLayoutPlugin_confirm");){
            try {
                MetaDataUtil metaDataUtil = new MetaDataUtil();
                Map<String, Object> content = LayoutPageType.Inherit.toString().equals(pageType) || StringUtils.isBlank((CharSequence)pageType) ? metaDataUtil.createOriginalLayout(map) : metaDataUtil.createBlankModel(map);
                save = metaDataUtil.save(content);
                if (save.get(KEY_SUCCESS) != null && !((Boolean)save.get(KEY_SUCCESS)).booleanValue()) {
                    throw new Exception();
                }
                String formId = (String)content.get("id");
                QFilter q1 = new QFilter("form", "=", (Object)formId);
                QFilter q2 = new QFilter("bizunit", "=", (Object)bizUnitId);
                QFilter[] filters = new QFilter[]{q1, q2};
                DeleteServiceHelper.delete((String)"bos_devportal_unitrelform", (QFilter[])filters);
                DynamicObject dObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_devportal_unitrelform");
                dObject.set("bizapp", (Object)bizAppId);
                dObject.set("bizunit", (Object)bizUnitId);
                dObject.set("form", (Object)formId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObject});
                this.saveMetadataToRepository(bizAppId, formId);
            }
            catch (Exception e) {
                tx.markRollback();
                log.error((Throwable)e);
                message.put(KEY_SUCCESS, Boolean.FALSE);
                if (save.get(KEY_SUCCESS) != null && !((Boolean)save.get(KEY_SUCCESS)).booleanValue() && save.get("errors") != null) {
                    message.put(KEY_MESSAGE, ((ErrorInfo)((ArrayList)save.get("errors")).get(0)).getError());
                } else {
                    message.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u521b\u5efa\u5931\u8d25\u3002", (String)"BizPageLayoutPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                }
                this.getView().returnDataToParent(message);
                this.getView().close();
                if (tx != null) {
                    if (var14_14 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var14_14.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return;
            }
        }
        message.put(KEY_SUCCESS, Boolean.TRUE);
        message.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u521b\u5efa\u6210\u529f\u3002", (String)"BizPageLayoutPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        this.getView().returnDataToParent(message);
        this.getView().close();
    }

    private String validateNameAndNumber(String number, ILocaleString name) {
        MetaDataUtil metaDataUtil;
        StringBuilder buffer = new StringBuilder();
        String regex = "[a-z0-9A-Z_]+";
        if (StringUtils.isEmpty((CharSequence)number.trim())) {
            buffer.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b57\u6bb5\u7f16\u7801\u3002", (String)"BizPageLayoutPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0])).append("\r\n");
        } else if (number.endsWith("_devportal")) {
            buffer.append(ResManager.loadKDString((String)"\u4e3a\u4e86\u533a\u5206svn\u811a\u672c\u6587\u4ef6\u547d\u540d\uff0c\u7f16\u7801\u4e0d\u80fd\u4ee5\u201c_devportal\u201d\u7ed3\u5c3e\u3002", (String)"BizPageLayoutPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0])).append("\r\n");
        } else if (!Pattern.matches(regex, number)) {
            buffer.append(ResManager.loadKDString((String)"\u7f16\u7801\u5fc5\u987b\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"BizPageLayoutPlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0])).append("\r\n");
        } else if (number.startsWith("_") || number.endsWith("_")) {
            buffer.append(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4ee5\u4e0b\u5212\u7ebf\u5f00\u5934\u6216\u7ed3\u5c3e\u3002", (String)"BizPageLayoutPlugin_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0])).append("\r\n");
        } else if (number.length() > 25) {
            buffer.append(ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc725\u4e2a\u5b57\u7b26\u3002", (String)"BizPageLayoutPlugin_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0])).append("\r\n");
        } else if (number.endsWith("_mob")) {
            buffer.append(ResManager.loadKDString((String)"\u8868\u5355\u6807\u8bc6\u4e0d\u80fd\u7528\u201c_mob\u201d\u505a\u4e3a\u540e\u7f00\uff0c\u907f\u514d\u4e0e\u7cfb\u7edf\u5173\u952e\u5b57\u51b2\u7a81\u3002", (String)"BizPageLayoutPlugin_10", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((Object)name)) {
            buffer.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u540d\u79f0\u3002", (String)"BizPageLayoutPlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0])).append("\r\n");
        }
        if ((metaDataUtil = new MetaDataUtil()).checkNumber(number)) {
            buffer.append(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"BizPageLayoutPlugin_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0])).append("\r\n");
        }
        return buffer.toString();
    }

    private void saveMetadataToRepository(String bizAppId, String id) {
        try {
            GitSaveMetadata saveMetadata = new GitSaveMetadata();
            String gitSessionId = (String)this.getView().getFormShowParameter().getCustomParam("sessionId");
            saveMetadata.saveMetadataToRepository(gitSessionId, bizAppId, id, "page");
        }
        catch (Exception e) {
            log.info("git save metadata error", (Object)e);
        }
    }
}

