/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.dao.DesignerData;
import kd.bos.devportal.business.util.BizPageOperationUtil;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.Plugin;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.param.ParameterReader;
import kd.bos.script.debug.DebugConfig;
import kd.bos.service.IFormDesignService;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class BizPagePreviewAndDebugPlugin
extends AbstractFormPlugin
implements ClickListener {
    public static final String BOS_MOBILEPREVIEW = "bos_mobilepreview";
    public static final String FORM_ID = "formId";
    public static final String PARAM_MODEL_TYPE = "modelType";
    private static final Log log = LogFactory.getLog(BizPagePreviewAndDebugPlugin.class);
    private static final String DEBUG = "debug";
    private static final String KEY_PREVIEW = "preview";
    private static final String FORMNUMBER = "formnumber";
    private static final String MODELTYPE = "modeltype";
    private static final String FORMID = "formid";
    private static final String PARATYPE = "paratype";
    private static final String PRINTMODEL = "PrintModel";
    private static final String PROJECTNAME = "bos-devportal-plugin";
    private static final String MOBILEFORM = "mobileform";
    private static final String NUMBER = "number";
    private static IFormDesignService formDesignService;

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_PREVIEW, DEBUG});
    }

    public void afterCreateNewData(EventObject e) {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        if (map != null) {
            String formNumber = (String)map.get(FORMNUMBER);
            String modelType = (String)map.get(MODELTYPE);
            this.getPageCache().put(FORMNUMBER, formNumber);
            this.getPageCache().put(MODELTYPE, modelType);
            this.getPageCache().put("devtype", (String)map.get("devtype"));
            this.getPageCache().put(FORMID, (String)map.get(FORMID));
            this.getModel().setValue("name", map.get("formname"));
            this.getModel().setValue(PARATYPE, (Object)this.setComboEdit(modelType));
            if ("ReportFormModel".equals(modelType) || PRINTMODEL.equals(modelType)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{DEBUG});
            } else {
                boolean existJS = this.existJS(formNumber);
                if (existJS) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{DEBUG});
                } else {
                    this.getView().setEnable(Boolean.FALSE, new String[]{DEBUG});
                }
            }
            boolean debugMode = DebugConfig.isDebugEnabled();
            if (!debugMode) {
                this.getView().setEnable(Boolean.FALSE, new String[]{DEBUG});
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "preview": {
                this.preview();
                break;
            }
            case "debug": {
                this.debugPage();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (PARATYPE.equals(propertyName)) {
            String formNumber = this.getPageCache().get(FORMNUMBER);
            String modelType = this.getPageCache().get(MODELTYPE);
            if (!"ReportFormModel".equals(modelType) && !PRINTMODEL.equals(modelType)) {
                boolean existJS = this.existJS(formNumber);
                if (existJS) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{DEBUG});
                } else {
                    this.getView().setEnable(Boolean.FALSE, new String[]{DEBUG});
                }
                boolean debugMode = DebugConfig.isDebugEnabled();
                if (!debugMode) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{DEBUG});
                }
            }
        }
    }

    private String setComboEdit(String modelType) {
        ComboEdit modeltypeCombo = (ComboEdit)this.getView().getControl(PARATYPE);
        String appId = this.getView().getFormShowParameter().getAppId();
        ArrayList<ComboItem> modleItem = new ArrayList<ComboItem>();
        modeltypeCombo.setComboItems(modleItem);
        if ("BillFormModel".equals(modelType) || "BaseFormModel".equals(modelType)) {
            modleItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8868\u5355", (String)"BizPagePreviewAndDebugPlugin_0", (String)PROJECTNAME, (Object[])new Object[0])), "form"));
            modleItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5217\u8868", (String)"BizPagePreviewAndDebugPlugin_1", (String)PROJECTNAME, (Object[])new Object[0])), "list"));
            if (!"devnew".equalsIgnoreCase(appId)) {
                modleItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u79fb\u52a8\u8868\u5355", (String)"BizPagePreviewAndDebugPlugin_2", (String)PROJECTNAME, (Object[])new Object[0])), MOBILEFORM));
                modleItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u79fb\u52a8\u5217\u8868", (String)"BizPagePreviewAndDebugPlugin_3", (String)PROJECTNAME, (Object[])new Object[0])), "mobilelist"));
            }
        } else if ("PCLayout".equals(modelType)) {
            modleItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8868\u5355", (String)"BizPagePreviewAndDebugPlugin_0", (String)PROJECTNAME, (Object[])new Object[0])), "form"));
            modleItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5217\u8868", (String)"BizPagePreviewAndDebugPlugin_1", (String)PROJECTNAME, (Object[])new Object[0])), "list"));
        } else if ("MobileBillFormModel".equals(modelType)) {
            modleItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u79fb\u52a8\u8868\u5355", (String)"BizPagePreviewAndDebugPlugin_2", (String)PROJECTNAME, (Object[])new Object[0])), MOBILEFORM));
            modleItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u79fb\u52a8\u5217\u8868", (String)"BizPagePreviewAndDebugPlugin_3", (String)PROJECTNAME, (Object[])new Object[0])), "mobilelist"));
        } else if ("MobileFormModel".equals(modelType) || "MobUserGuideFormModel".equals(modelType)) {
            modleItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u79fb\u52a8\u8868\u5355", (String)"BizPagePreviewAndDebugPlugin_2", (String)PROJECTNAME, (Object[])new Object[0])), MOBILEFORM));
        } else if ("LogBillFormModel".equals(modelType)) {
            modleItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8868\u5355", (String)"BizPagePreviewAndDebugPlugin_0", (String)PROJECTNAME, (Object[])new Object[0])), "form"));
            modleItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5217\u8868", (String)"BizPagePreviewAndDebugPlugin_1", (String)PROJECTNAME, (Object[])new Object[0])), "list"));
        } else if ("KMModel".equals(modelType)) {
            modleItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8868\u5355", (String)"BizPagePreviewAndDebugPlugin_0", (String)PROJECTNAME, (Object[])new Object[0])), "form"));
            modleItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5217\u8868", (String)"BizPagePreviewAndDebugPlugin_1", (String)PROJECTNAME, (Object[])new Object[0])), "list"));
        } else if ("QueryListModel".equals(modelType)) {
            modleItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5217\u8868", (String)"BizPagePreviewAndDebugPlugin_1", (String)PROJECTNAME, (Object[])new Object[0])), "list"));
        } else {
            modleItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8868\u5355", (String)"BizPagePreviewAndDebugPlugin_0", (String)PROJECTNAME, (Object[])new Object[0])), "form"));
        }
        modeltypeCombo.setComboItems(modleItem);
        if (modleItem != null && modleItem.size() > 0) {
            return ((ComboItem)modleItem.get(0)).getValue();
        }
        return null;
    }

    private void preview() {
        String id = this.getPageCache().get(FORMID);
        String formNumber = this.getPageCache().get(FORMNUMBER);
        String paraType = "";
        try {
            paraType = (String)this.getModel().getValue(PARATYPE);
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
            this.getView().showTipNotification(exception.toString());
            return;
        }
        String modelType = this.getPageCache().get(MODELTYPE);
        if (StringUtils.isBlank((CharSequence)formNumber) || StringUtils.isBlank((CharSequence)modelType)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8868\u5355\u53c2\u6570\u6709\u8bef\uff0c\u9884\u89c8\u5931\u8d25\u3002", (String)"BizPagePreviewAndDebugPlugin_4", (String)PROJECTNAME, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)paraType)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53c2\u6570\u7c7b\u578b\u3002", (String)"BizPagePreviewAndDebugPlugin_5", (String)PROJECTNAME, (Object[])new Object[0]));
            return;
        }
        if (paraType.startsWith("mobile")) {
            HashMap<String, String> para = new HashMap<String, String>();
            para.put(FORM_ID, BOS_MOBILEPREVIEW);
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
            if (MOBILEFORM.equals(paraType)) {
                showParameter.setCustomParam(PARAM_MODEL_TYPE, (Object)"MobileBillFormModel");
                if ("MobileFormModel".equals(modelType) || "MobileBillFormModel".equals(modelType) || "MobUserGuideFormModel".equals(modelType)) {
                    showParameter.setCustomParam(NUMBER, (Object)formNumber);
                } else {
                    showParameter.setCustomParam(NUMBER, (Object)(formNumber + "_mob"));
                }
            } else {
                showParameter.setCustomParam(PARAM_MODEL_TYPE, (Object)"MobileListModel");
                showParameter.setCustomParam(NUMBER, (Object)formNumber);
            }
            showParameter.getOpenStyle().setShowType(ShowType.NewWindow);
            showParameter.setClientParam(KEY_PREVIEW, (Object)"true");
            this.getView().showForm(showParameter);
        } else if ("list".equals(paraType)) {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId(formNumber);
            parameter.getOpenStyle().setShowType(ShowType.NewWindow);
            this.previewShowForm((FormShowParameter)parameter);
        } else if (PRINTMODEL.equals(modelType)) {
            PrintMetadata printMeta = (PrintMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form);
            if (printMeta != null) {
                String entityNumber = DesignerData.getEntityNumberById((String)printMeta.getEntityId());
                String downloadUrl = this.getOrCreateDesignService().preview(this.getView().getPageId(), entityNumber, printMeta.getKey());
                if (StringUtils.isBlank((CharSequence)downloadUrl)) {
                    return;
                }
                if (StringUtils.isNotBlank((CharSequence)downloadUrl)) {
                    this.getView().openUrl(downloadUrl);
                } else {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u6253\u5370\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u53ef\u80fd\u662f\u6a21\u677f\u7ed1\u5b9a\u5b57\u6bb5\u5df2\u5728\u5355\u636e\u4e2d\u5220\u9664", (String)"BizPagePreviewAndDebugPlugin_6", (String)PROJECTNAME, (Object[])new Object[0]), MessageBoxOptions.OK);
                }
            }
        } else {
            HashMap<String, String> para = new HashMap<String, String>();
            para.put(FORM_ID, formNumber);
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
            showParameter.getOpenStyle().setShowType(ShowType.NewWindow);
            showParameter.setAppId(BizAppServiceHelp.getAppIdByFormNum((String)formNumber));
            this.previewShowForm(showParameter);
        }
        this.getView().close();
    }

    private void previewShowForm(FormShowParameter showParameter) {
        String ppageid = this.getView().getFormShowParameter().getParentPageId();
        IFormView pview = this.getView().getViewNoPlugin(ppageid);
        pview.showForm(showParameter);
        this.getView().sendFormAction(pview);
    }

    private void debugPage() {
        String formNumber = this.getPageCache().get(FORMNUMBER);
        String modelType = this.getPageCache().get(MODELTYPE);
        String paraType = "";
        try {
            paraType = (String)this.getModel().getValue(PARATYPE);
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
            this.getView().showTipNotification(exception.toString());
            return;
        }
        if (StringUtils.isBlank((CharSequence)paraType)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53c2\u6570\u7c7b\u578b\u3002", (String)"BizPagePreviewAndDebugPlugin_5", (String)PROJECTNAME, (Object[])new Object[0]));
            return;
        }
        if (PRINTMODEL.equals(modelType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5957\u6253\u9875\u9762\u6682\u4e0d\u652f\u6301\u8be5\u8c03\u8bd5\u5165\u53e3\uff0c\u8bf7\u5148\u9884\u89c8\uff0c\u518d\u6309\u5feb\u6377\u952e\uff1actrl+alt+d,\u8fdb\u5165\u8c03\u8bd5\u9875\u9762\u3002", (String)"BizPagePreviewAndDebugPlugin_7", (String)PROJECTNAME, (Object[])new Object[0]));
            return;
        }
        String debugPageId = this.getDebugPageId(formNumber);
        if (StringUtils.isBlank((CharSequence)debugPageId)) {
            String msg = String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301%s\u7c7b\u578b\u7684\u9875\u9762\u8c03\u8bd5\u3002", (String)"BizPagePreviewAndDebugPlugin_8", (String)PROJECTNAME, (Object[])new Object[0]), paraType);
            this.getView().showErrorNotification(msg);
            return;
        }
        BizPageOperationUtil.debugPage((String)debugPageId, (AbstractFormPlugin)this);
        this.getView().close();
    }

    private String getDebugPageId(String formNumber) {
        String debugPageId = null;
        String paraType = (String)this.getModel().getValue(PARATYPE);
        if (paraType.endsWith("form")) {
            HashMap<String, String> para = new HashMap<String, String>();
            para.put(FORM_ID, formNumber);
            FormShowParameter parameter = FormShowParameter.createFormShowParameter(para);
            parameter.getOpenStyle().setShowType(ShowType.NewWindow);
            PageCache pageCache = new PageCache(parameter.getPageId());
            Map config = FormConfigFactory.createConfig((FormShowParameter)parameter);
            pageCache.put("formconfig", SerializationUtils.toJsonString((Object)config));
            debugPageId = parameter.getPageId();
        } else if ("list".equals(paraType)) {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId(formNumber);
            parameter.getOpenStyle().setShowType(ShowType.NewWindow);
            PageCache pageCache = new PageCache(parameter.getPageId());
            Map config = FormConfigFactory.createConfig((FormShowParameter)parameter);
            pageCache.put("formconfig", SerializationUtils.toJsonString((Object)config));
            debugPageId = parameter.getPageId();
        }
        return debugPageId;
    }

    private boolean isCanDebug() {
        Map map = ParameterReader.loadPublicParameterFromCache();
        return map.get("kdedebug") == null || (Boolean)map.get("kdedebug") != false;
    }

    private boolean existJS(String formNumber) {
        boolean flag;
        block5: {
            block4: {
                if (!this.isCanDebug()) {
                    return false;
                }
                flag = false;
                String paraType = (String)this.getModel().getValue(PARATYPE);
                if (!paraType.endsWith("form")) break block4;
                HashMap<String, String> para = new HashMap<String, String>();
                para.put(FORM_ID, formNumber);
                FormShowParameter parameter = FormShowParameter.createFormShowParameter(para);
                parameter.getOpenStyle().setShowType(ShowType.NewWindow);
                new PageCache(parameter.getPageId());
                FormConfigFactory.createConfig((FormShowParameter)parameter);
                if (parameter.getFormConfig() == null) break block5;
                List plugins = parameter.getFormConfig().getPlugins();
                for (int i = 0; i < plugins.size(); ++i) {
                    Plugin plugin = (Plugin)plugins.get(i);
                    if (plugin.getType() != 1 || !plugin.isEnabled()) continue;
                    flag = true;
                }
                break block5;
            }
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId(formNumber);
            parameter.getOpenStyle().setShowType(ShowType.NewWindow);
            new PageCache(parameter.getPageId());
            FormConfigFactory.createConfig((FormShowParameter)parameter);
            if (parameter.getFormConfig() != null) {
                List plugins = parameter.getFormConfig().getPlugins();
                for (int i = 0; i < plugins.size(); ++i) {
                    Plugin plugin = (Plugin)plugins.get(i);
                    if (plugin.getType() != 1 || !plugin.isEnabled()) continue;
                    flag = true;
                }
            }
        }
        return flag;
    }

    private IFormDesignService getOrCreateDesignService() {
        if (formDesignService == null) {
            formDesignService = (IFormDesignService)TypesContainer.createInstance((String)"kd.bos.designer.PrintDesignerService");
        }
        return formDesignService;
    }
}

