/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.devportal.util.MetaDataUtil;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public class BizPagePrintPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(BizPagePrintPlugin.class);
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String PRINTNUMBER = "printnumber";
    private static final String SUCCESS = "success";
    private static final String MESSAGE = "message";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if ("btnok".equals(key)) {
            this.confirm();
        }
    }

    public void afterCreateNewData(EventObject e) {
        String parentName = (String)this.getView().getFormShowParameter().getCustomParam("pagename");
        String parentNumber = (String)this.getView().getFormShowParameter().getCustomParam("pagenumber");
        String formDefaultName = String.format(ResManager.loadKDString((String)"%s_\u6253\u5370", (String)"BizPagePrintPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), parentName);
        String formDefaultNumber = parentNumber + "_prt";
        String isv = ISVService.getISVInfo().getId();
        if ("kingdee".equals(isv)) {
            formDefaultNumber = formDefaultNumber + "_s";
            formDefaultNumber = DevportalUtil.autoFormNumber(formDefaultNumber, "_prt_s");
        } else {
            formDefaultNumber = DevportalUtil.autoFormNumber(formDefaultNumber, "_prt");
        }
        formDefaultName = DevportalUtil.autoFormName(formDefaultName);
        this.getView().getModel().setValue("printname", (Object)formDefaultName);
        this.getView().getModel().setValue(PRINTNUMBER, (Object)formDefaultNumber);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (PRINTNUMBER.equals(propertyName)) {
            String sourceNum = (String)e.getChangeSet()[0].getNewValue();
            sourceNum = DevportalUtil.autoIsvNumber(sourceNum);
            this.getModel().beginInit();
            this.getModel().setValue(PRINTNUMBER, (Object)sourceNum);
            this.getModel().endInit();
        }
    }

    private void confirm() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Object> message = new HashMap<String, Object>();
        Map<Object, Object> save = new HashMap();
        String layoutnumber = this.getModel().getValue(PRINTNUMBER).toString();
        layoutnumber = DevportalUtil.autoIsvNumber(layoutnumber);
        ILocaleString layoutname = (ILocaleString)this.getModel().getValue("printname");
        String bizAppId = this.getView().getFormShowParameter().getCustomParam("bizappid").toString();
        String bizUnitId = this.getView().getFormShowParameter().getCustomParam("bizunitid").toString();
        String entityId = this.getView().getFormShowParameter().getCustomParam("entityid").toString();
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            this.getView().showTipNotification(DevportalUtil.getNoPermissionTip());
            return;
        }
        if (StringUtils.isBlank((Object)layoutname)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u540d\u79f0\u201d\u5b57\u6bb5\u3002", (String)"BizPagePrintPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isEmpty((CharSequence)layoutnumber.trim())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u7f16\u7801\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizPagePrintPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        MetaDataUtil metaDataUtil = new MetaDataUtil();
        if (metaDataUtil.checkNumber(layoutnumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"BizPagePrintPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String regex = "[a-z0-9A-Z_]+";
        boolean flag = Pattern.matches(regex, layoutnumber);
        if (!flag) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5fc5\u987b\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"BizPagePrintPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (layoutnumber.startsWith("_") || layoutnumber.endsWith("_")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4ee5\u4e0b\u5212\u7ebf\u5f00\u5934\u6216\u7ed3\u5c3e\u3002", (String)"BizPagePrintPlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (layoutnumber.endsWith("_devportal")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3a\u4e86\u533a\u5206svn\u811a\u672c\u6587\u4ef6\u547d\u540d\uff0c\u7f16\u7801\u4e0d\u80fd\u4ee5\u201c_devportal\u201d\u7ed3\u5c3e\u3002", (String)"BizPagePrintPlugin_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (layoutnumber.length() > 36) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc736\u4e2a\u5b57\u7b26\u3002", (String)"BizPagePrintPlugin_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        map.put("entityId", entityId);
        map.put("modelType", "PrintModel");
        map.put("id", layoutnumber);
        map.put("name", layoutname);
        map.put("isprint", Boolean.TRUE);
        map.put("bizappid", bizAppId);
        map.put("bizunitid", bizUnitId);
        try (TXHandle tx = TX.required((String)"mdl_BizPagePrintPlugin_confirm");){
            try {
                Map<String, Object> content = metaDataUtil.createPrintModel(map);
                save = metaDataUtil.save(content);
                if (save.get(SUCCESS) != null && !((Boolean)save.get(SUCCESS)).booleanValue()) {
                    throw new Exception();
                }
                String formId = (String)content.get("id");
                ORM orm = ORM.create();
                QFilter q1 = new QFilter("form", "=", (Object)formId);
                QFilter q2 = new QFilter("bizunit", "=", (Object)bizUnitId);
                QFilter[] filters = new QFilter[]{q1, q2};
                orm.delete("bos_devportal_unitrelform", filters);
                DynamicObject dObject = orm.newDynamicObject("bos_devportal_unitrelform");
                dObject.set("bizapp", (Object)bizAppId);
                dObject.set("bizunit", (Object)bizUnitId);
                dObject.set("form", (Object)formId);
                orm.insert(dObject);
            }
            catch (Exception e) {
                tx.markRollback();
                log.error((Throwable)e);
                message.put(SUCCESS, Boolean.FALSE);
                if (save.get(SUCCESS) != null && !((Boolean)save.get(SUCCESS)).booleanValue() && save.get("errors") != null) {
                    message.put(MESSAGE, ((ErrorInfo)((ArrayList)save.get("errors")).get(0)).getError());
                } else {
                    message.put(MESSAGE, ResManager.loadKDString((String)"\u521b\u5efa\u5931\u8d25\u3002", (String)"BizPagePrintPlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                }
                this.getView().returnDataToParent(message);
                this.getView().close();
                if (tx != null) {
                    if (var13_13 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var13_13.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return;
            }
        }
        message.put(SUCCESS, Boolean.TRUE);
        message.put(MESSAGE, ResManager.loadKDString((String)"\u521b\u5efa\u6210\u529f\u3002", (String)"BizPagePrintPlugin_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        this.getView().returnDataToParent(message);
        this.getView().close();
    }
}

