/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.baserecordset.AbstractDataSetOperater;
import kd.bos.devportal.common.hosting.SVNCommonUtil;
import kd.bos.devportal.common.hosting.SVNUtil;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.service.botp.BOTPServiceFactory;
import kd.bos.service.botp.IBOTPFileUtilProxy;

public class BizSVNLoginPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(BizSVNLoginPlugin.class);
    private static final String N = "username";
    private static final String P = "password";
    private static final String ISSAVE = "issave";
    private static final String SMGUSERNAME = "smgusername";
    private static final String SMGPW = "smgpassword";
    private static final String SHOWALLPAGES = "showallpages";
    private static final String SHOWAPP = "showapp";
    private static final String DATASET = "dataset";
    private static final String PROJECTNAME = "bos-devportal-plugin";
    private static final String ERROR = "error";
    private static final String TP = "type";
    private static final String SVN_PATH = "svnpath";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
        String username = (String)this.getView().getFormShowParameter().getCustomParam(N);
        String password = (String)this.getView().getFormShowParameter().getCustomParam(P);
        boolean issave = (Boolean)this.getView().getFormShowParameter().getCustomParam(ISSAVE);
        String type = (String)this.getView().getFormShowParameter().getCustomParam(TP);
        IBOTPFileUtilProxy botpFileUtilProxy = (IBOTPFileUtilProxy)BOTPServiceFactory.getSingletonService(IBOTPFileUtilProxy.class);
        if (type != null && DATASET.equals(type)) {
            username = SessionManager.getCurrent().get(SMGUSERNAME);
            password = SessionManager.getCurrent().get(SMGPW);
            if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
                issave = true;
            }
            this.getPageCache().put(TP, DATASET);
            this.getView().setVisible(Boolean.FALSE, new String[]{SHOWALLPAGES});
            this.getView().setVisible(Boolean.FALSE, new String[]{SHOWAPP});
        } else if (botpFileUtilProxy.getConvertRuleType().equals(type) || botpFileUtilProxy.getWriteBackRuleType().equals(type) || botpFileUtilProxy.getBalanceUpdateType().equals(type)) {
            username = SessionManager.getCurrent().get(SMGUSERNAME);
            password = SessionManager.getCurrent().get(SMGPW);
            if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
                issave = true;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{SHOWALLPAGES});
            this.getView().setVisible(Boolean.FALSE, new String[]{SHOWAPP});
            this.getPageCache().put(TP, type);
        }
        if (issave) {
            this.getModel().setValue(ISSAVE, (Object)String.valueOf(issave));
        }
        if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
            this.getModel().setValue(N, (Object)username);
            try {
                password = Encrypters.decode((String)password);
            }
            catch (Exception erro) {
                log.error((Throwable)erro);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bc6\u7801\u89e3\u6790\u51fa\u9519", (String)"BizSVNLoginPlugin_0", (String)PROJECTNAME, (Object[])new Object[0]));
                return;
            }
            this.getModel().setValue(P, (Object)password);
        }
        String svnPath = AppUtils.getSVNPathByAppId((String)bizAppId);
        this.getModel().setValue("svnPath", (Object)svnPath);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if ("btnok".equals(key)) {
            this.login();
        } else if ("btncancel".equals(key)) {
            this.cancel();
        }
    }

    private void login() {
        IDataModel model = this.getModel();
        String username = (String)model.getValue(N);
        String password = (String)model.getValue(P);
        String svnPath = (String)model.getValue(SVN_PATH);
        if (StringUtils.isBlank((CharSequence)svnPath)) {
            this.getView().showMessage(ResManager.loadKDString((String)"SVN\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u5728SVN\u7ba1\u7406\u4e2d\u521b\u5efa\u3002", (String)"BizSVNLoginPlugin_3", (String)PROJECTNAME, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7528\u6237\u540d\u3002", (String)"BizSVNLoginPlugin_1", (String)PROJECTNAME, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7528\u6237\u5bc6\u7801\u3002", (String)"BizSVNLoginPlugin_2", (String)PROJECTNAME, (Object[])new Object[0]));
            return;
        }
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
        JSONObject svnMsg = SVNUtil.getSVNMsgByAppId((String)bizAppId);
        if (svnMsg.get((Object)ERROR) != null) {
            this.getView().showErrorNotification(svnMsg.get((Object)ERROR).toString());
            return;
        }
        try {
            SVNCommonUtil.checkSVNAuthentication((String)svnPath, (String)username, (String)password);
        }
        catch (Exception e) {
            log.error("svn\u6743\u9650\u6821\u9a8c\u5931\u8d25", (Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u7528\u6237\u6743\u9650\u3002", (String)"BizSVNLoginPlugin_6", (String)PROJECTNAME, (Object[])new Object[0]));
            return;
        }
        password = Encrypters.encode((String)password);
        String annotation = (String)model.getValue("annotation");
        boolean isSave = (Boolean)model.getValue(ISSAVE);
        String showallpages = String.valueOf(model.getValue(SHOWALLPAGES));
        String showapp = String.valueOf(model.getValue(SHOWAPP));
        String t = (String)this.getView().getFormShowParameter().getCustomParam(TP);
        svnMsg.put(N, (Object)username);
        svnMsg.put(P, (Object)password);
        svnMsg.put("annotation", (Object)annotation);
        svnMsg.put(TP, (Object)t);
        svnMsg.put(SHOWALLPAGES, (Object)showallpages);
        svnMsg.put(SHOWAPP, (Object)showapp);
        JSONObject checkInMsg = new JSONObject();
        String type = this.getPageCache().get(TP);
        IBOTPFileUtilProxy botpFileUtilProxy = (IBOTPFileUtilProxy)BOTPServiceFactory.getSingletonService(IBOTPFileUtilProxy.class);
        if (type != null && DATASET.equals(type)) {
            JSONArray ids = JSONArray.parseArray((String)this.getView().getFormShowParameter().getCustomParam("ids").toString());
            svnMsg.put("ids", (Object)ids);
            String number = (String)this.getView().getFormShowParameter().getCustomParam("number");
            AbstractDataSetOperater dbOperator = new AbstractDataSetOperater(number, svnMsg);
            checkInMsg = dbOperator.commitBaseDataToSvn();
        } else if (botpFileUtilProxy.getConvertRuleType().equals(type) || botpFileUtilProxy.getWriteBackRuleType().equals(type) || botpFileUtilProxy.getBalanceUpdateType().equals(type)) {
            JSONArray ruleIds = (JSONArray)JSONArray.parse((String)this.getView().getFormShowParameter().getCustomParam("ruleids").toString());
            checkInMsg = botpFileUtilProxy.chickInRule(type, svnMsg, ruleIds, bizAppId);
        }
        if (checkInMsg.get((Object)ERROR) != null) {
            this.getView().showErrorNotification(checkInMsg.get((Object)ERROR).toString());
            return;
        }
        if (checkInMsg.get((Object)"ERROR") != null) {
            String result = (String)checkInMsg.get((Object)"ERROR");
            log.debug(result);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u7528\u6237\u6743\u9650\u3002", (String)"BizSVNLoginPlugin_6", (String)PROJECTNAME, (Object[])new Object[0]));
        } else if (checkInMsg.get((Object)"notification") != null) {
            this.getView().close();
            this.getView().showMessage(checkInMsg.get((Object)"notification").toString());
        } else if (checkInMsg.get((Object)"NOPATH") != null) {
            this.getPageCache().put("svnMsg", svnMsg.toJSONString());
            this.getPageCache().put("bizAppId", bizAppId);
            this.getView().showMessage(ResManager.loadKDString((String)"SVN\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u5728SVN\u7ba1\u7406\u4e2d\u521b\u5efa\u3002", (String)"BizSVNLoginPlugin_3", (String)PROJECTNAME, (Object[])new Object[0]));
        } else {
            this.saveUserName(type, isSave, username, password, svnMsg);
            this.getView().close();
            this.getView().showMessage(ResManager.loadKDString((String)"\u7b7e\u5165\u6210\u529f\u3002", (String)"BizSVNLoginPlugin_4", (String)PROJECTNAME, (Object[])new Object[0]));
        }
    }

    private void cancel() {
        this.getView().close();
    }

    private void saveUserName(String type, boolean isSave, String username, String password, JSONObject svnMsg) {
        IBOTPFileUtilProxy botpFileUtilProxy = (IBOTPFileUtilProxy)BOTPServiceFactory.getSingletonService(IBOTPFileUtilProxy.class);
        if ("scene".equals(type) || botpFileUtilProxy.getConvertRuleType().equals(type) || botpFileUtilProxy.getWriteBackRuleType().equals(type)) {
            if (isSave) {
                SessionManager.getCurrent().put(SMGUSERNAME, username);
                SessionManager.getCurrent().put(SMGPW, password);
            } else {
                SessionManager.getCurrent().put(SMGUSERNAME, "");
                SessionManager.getCurrent().put(SMGPW, "");
            }
        } else if (isSave) {
            svnMsg.remove((Object)"localpath");
            svnMsg.remove((Object)SVN_PATH);
            svnMsg.remove((Object)"clientManager");
            svnMsg.remove((Object)"commitClient");
            svnMsg.remove((Object)"repository");
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("SAVE_SVN_MSG", (Object)svnMsg);
        } else {
            svnMsg.clear();
            svnMsg.put(N, (Object)"");
            svnMsg.put(P, (Object)"");
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("SAVE_SVN_MSG", (Object)svnMsg);
        }
    }
}

