/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.db.DB;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaLogType;
import kd.bos.metadata.dao.MetaType;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataLogService;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class BizUnitPlugin
extends AbstractBasePlugIn
implements ClickListener {
    private static Log logger = LogFactory.getLog(BizUnitPlugin.class);
    private static final String PARENTUNIT = "parentunit";
    private static final String BTN_SAVE = "btnsave";
    private static final String BIZAPP = "bizapp";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String KEY_NUMBER = "number";
    private static final String PARENTUNITID = "parentunitid";
    private static final String THISUNITID = "thisunitid";
    private static final String DESCRIPTION = "description";
    private static final String ISLEAF = "isleaf";
    private static final String BIZAPPID = "bizappid";

    public void registerListener(EventObject e) {
        TextEdit edt = (TextEdit)this.getView().getControl(PARENTUNIT);
        edt.addButtonClickListener((ClickListener)this);
        Button btn = (Button)this.getView().getControl(BTN_SAVE);
        btn.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase()) {
            case "parentunit": {
                this.openParentUnit();
                break;
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control c = (Control)evt.getSource();
        if (BTN_SAVE.equalsIgnoreCase(c.getKey())) {
            String[][] arg = new String[][]{{"seq", ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"BizUnitPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0])}, {KEY_NUMBER, ResManager.loadKDString((String)"\u7f16\u7801", (String)"BizUnitPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0])}, {"name", ResManager.loadKDString((String)"\u540d\u79f0", (String)"BizUnitPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0])}, {BIZAPP, ResManager.loadKDString((String)"\u4e1a\u52a1\u5e94\u7528", (String)"BizUnitPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0])}};
            StringBuilder errorMsg = new StringBuilder();
            for (int i = 0; i < arg.length; ++i) {
                String msg;
                if ("name".equals(arg[i][0])) {
                    String localeId = RequestContext.get().getLang().toString();
                    boolean isEmpty = true;
                    Map map = (Map)this.getModel().getValue(arg[i][0]);
                    if (map.get(localeId) != null && !((String)map.get(localeId)).isEmpty()) {
                        isEmpty = false;
                    }
                    if (!isEmpty) continue;
                    String msg2 = String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizUnitPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), arg[i][1]);
                    errorMsg.append(msg2);
                    continue;
                }
                if (BIZAPP.equals(arg[i][0])) {
                    if (!StringUtils.isBlank((Object)this.getModel().getValue(arg[i][0] + "_id"))) continue;
                    msg = String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizUnitPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), arg[i][1]);
                    errorMsg.append(msg);
                    continue;
                }
                if (!StringUtils.isBlank((Object)this.getModel().getValue(arg[i][0]))) continue;
                msg = String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizUnitPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), arg[i][1]);
                errorMsg.append(msg);
            }
            if (!"".equals(errorMsg.toString())) {
                this.getView().showTipNotification(errorMsg.toString());
                evt.setCancel(true);
                return;
            }
            String regex = "[a-z0-9A-Z_]+";
            String number = (String)this.getModel().getValue(KEY_NUMBER);
            Boolean flag = Pattern.matches(regex, number);
            if (!flag.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5fc5\u987b\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"BizUnitPlugin_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(5000));
                evt.setCancel(true);
                return;
            }
            if (number.startsWith("_") || number.endsWith("_")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4ee5\u4e0b\u5212\u7ebf\u5f00\u5934\u6216\u7ed3\u5c3e\u3002", (String)"BizUnitPlugin_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(5000));
                evt.setCancel(true);
                return;
            }
            String bizAppId = (String)this.getModel().getValue("bizapp_id");
            AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataById((String)bizAppId, (boolean)false);
            String appType = metadata.getDevType();
            if ("2".equals(appType)) {
                String appParentId = metadata.getParentId();
                if (!this.checkNumberDup(bizAppId) || !this.checkNumberDup(appParentId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"BizUnitPlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
            } else if (!this.checkNumberDup(bizAppId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"BizUnitPlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (StringUtils.isBlank((Object)this.getModel().getValue(PARENTUNIT))) {
                this.getModel().setValue(PARENTUNITID, (Object)" ");
            }
            List functionPackets = metadata.getAppFunctionPackets();
            IDataModel model = this.getModel();
            DynamicObject appFuncObj = model.getDataEntity();
            FormShowParameter fsp = this.getView().getFormShowParameter();
            String bizUnitId = "";
            if (fsp.getStatus().equals((Object)OperationStatus.EDIT)) {
                bizUnitId = this.getPageCache().get(THISUNITID);
                for (AppFunctionPacketElement functionPacket : functionPackets) {
                    if (!bizUnitId.equals(functionPacket.getId())) continue;
                    Integer seq = (Integer)model.getValue("seq");
                    functionPacket.setSeq(seq.shortValue());
                    functionPacket.setName(LocaleString.fromMap((Map)appFuncObj.getLocaleString("name")));
                    functionPacket.setNumber((String)model.getValue(KEY_NUMBER));
                    functionPacket.setDescription(LocaleString.fromMap((Map)appFuncObj.getLocaleString(DESCRIPTION)));
                    functionPacket.setLeaf(model.getValue(ISLEAF).toString());
                    functionPacket.setParentId((String)model.getValue(PARENTUNITID));
                    functionPacket.setParentName((String)model.getValue(PARENTUNIT));
                    break;
                }
            } else if (fsp.getStatus().equals((Object)OperationStatus.ADDNEW)) {
                AppFunctionPacketElement functionPacket = AppMetaServiceHelper.CreateBlankAppFunctionPacketElement();
                bizUnitId = Uuid16.create().toString();
                functionPacket.setId(bizUnitId);
                Integer seq = (Integer)model.getValue("seq");
                functionPacket.setSeq(seq.shortValue());
                functionPacket.setName(LocaleString.fromMap((Map)appFuncObj.getLocaleString("name")));
                functionPacket.setNumber((String)model.getValue(KEY_NUMBER));
                functionPacket.setDescription(LocaleString.fromMap((Map)appFuncObj.getLocaleString(DESCRIPTION)));
                functionPacket.setLeaf(model.getValue(ISLEAF).toString());
                functionPacket.setParentId((String)model.getValue(PARENTUNITID));
                functionPacket.setParentName((String)model.getValue(PARENTUNIT));
                functionPackets.add(functionPacket);
            }
            AppMetaServiceHelper.save((AppMetadata)metadata);
            BizUnitPlugin.writeLog(bizAppId);
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "BizUnitPlugin_9", BOS_DEVPORTAL_PLUGIN);
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u4fdd\u5b58\u529f\u80fd\u5206\u7ec4", "BizUnitPlugin_10", BOS_DEVPORTAL_PLUGIN);
            AppUtils.addOpLog((String)"bos_devportal_bizunit", (String)"save", (String)"bos_devportal_bizunit", (String)"1", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, (String[])new String[0]);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("selectedUnit", (Object)bizUnitId);
            this.getView().returnDataToParent((Object)jsonObject);
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }

    private void openParentUnit() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devportal_parentunit");
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam(THISUNITID, this.getView().getFormShowParameter().getCustomParam(THISUNITID));
        String pageId = UUID.randomUUID().toString();
        parameter.setPageId(pageId);
        parameter.setCustomParam("pageId", (Object)pageId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "chooseParentUnit"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map ret;
        if ("chooseParentUnit".equals(e.getActionId()) && (ret = (Map)e.getReturnData()) != null) {
            String parentUnitId = ret.get("id").toString();
            this.getModel().setValue(PARENTUNIT, ret.get("name"));
            this.getModel().setValue(PARENTUNITID, (Object)parentUnitId);
            IDataModel model = this.getView().getModel();
            String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
            int seq = DevportalUtil.getMaxUnitSeq(bizAppId, false) + 1;
            model.setValue("seq", (Object)String.valueOf(seq));
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String bizAppId = (String)formShowParameter.getCustomParam(BIZAPPID);
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SAVE});
        }
        IDataModel model = this.getModel();
        if (OperationStatus.ADDNEW.equals((Object)formShowParameter.getStatus())) {
            if (bizAppId == null || "".equals(bizAppId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u65b0\u589e\u4e1a\u52a1\u5e94\u7528\uff0c\u5728\u4e1a\u52a1\u5e94\u7528\u4e0b\u65b0\u589e\u4e1a\u52a1\u5355\u5143\u3002", (String)"BizUnitPlugin_11", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put(BIZAPPID, bizAppId);
            model.setValue(BIZAPP, (Object)bizAppId);
            String parentUnitId = (String)formShowParameter.getCustomParam(PARENTUNITID);
            String parentUnitName = (String)formShowParameter.getCustomParam("parentunitname");
            String appType = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false).getDevType();
            this.getPageCache().put("appType", appType);
            if (StringUtils.isNotBlank((CharSequence)parentUnitId) && StringUtils.isNotBlank((CharSequence)parentUnitName)) {
                model.setValue(PARENTUNIT, (Object)parentUnitName);
                model.setValue(PARENTUNITID, (Object)parentUnitId);
                int seq = DevportalUtil.getMaxUnitSeq(bizAppId, false) + 1;
                model.setValue("seq", (Object)String.valueOf(seq));
            } else {
                int seq = DevportalUtil.getMaxUnitSeq(bizAppId, true) + 1;
                model.setValue("seq", (Object)String.valueOf(seq));
            }
        } else if (OperationStatus.EDIT.equals((Object)formShowParameter.getStatus())) {
            String bizUnitId = (String)this.getView().getFormShowParameter().getCustomParam(THISUNITID);
            this.getPageCache().put(THISUNITID, bizUnitId);
            AppFunctionPacketElement unitObject = AppMetaServiceHelper.getFunctionPacketById((String)bizUnitId, (String)bizAppId, (boolean)false);
            short seq = unitObject.getSeq();
            LocaleString bizUnitName = unitObject.getName();
            String bizUnitNumber = unitObject.getNumber();
            LocaleString description = unitObject.getDescription();
            String isleaf = unitObject.getLeaf();
            String parentId = unitObject.getParentId();
            if (StringUtils.isNotBlank((CharSequence)parentId)) {
                AppFunctionPacketElement parentUnit = AppMetaServiceHelper.getFunctionPacketById((String)parentId, (String)bizAppId, (boolean)false);
                String parentName = parentUnit.getName().getLocaleValue();
                model.setValue(PARENTUNIT, (Object)parentName);
            } else {
                model.setValue(PARENTUNIT, (Object)" ");
                this.getView().setVisible(Boolean.FALSE, new String[]{PARENTUNIT});
            }
            model.setValue("seq", (Object)seq);
            model.setValue("name", (Object)bizUnitName);
            model.setValue(KEY_NUMBER, (Object)bizUnitNumber);
            model.setValue(DESCRIPTION, (Object)description);
            model.setValue(BIZAPP, (Object)bizAppId);
            model.setValue(ISLEAF, (Object)isleaf);
            model.setValue(PARENTUNITID, (Object)parentId);
        }
    }

    private boolean checkNumberDup(String bizAppId) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String number = (String)this.getModel().getValue(KEY_NUMBER);
        if (OperationStatus.ADDNEW.equals((Object)parameter.getStatus())) {
            AppFunctionPacketElement functionPacketByNumber = AppMetaServiceHelper.getFunctionPacketByNumber((String)number, (String)bizAppId, (boolean)false);
            if (functionPacketByNumber != null) {
                return false;
            }
        } else if (OperationStatus.EDIT.equals((Object)parameter.getStatus())) {
            String id = this.getPageCache().get(THISUNITID);
            AppFunctionPacketElement functionPacketByNumber = AppMetaServiceHelper.getFunctionPacketByNumber((String)number, (String)bizAppId, (boolean)false);
            if (functionPacketByNumber != null && !id.equals(functionPacketByNumber.getId())) {
                return false;
            }
        }
        return true;
    }

    private static void writeLog(String appId) {
        try {
            long logId = DB.genGlobalLongId();
            MetadataLogService logService = (MetadataLogService)ServiceFactory.getService(MetadataLogService.class);
            logService.addAppMetaLog(appId, (int)MetaLogType.AppFunctionSave.getValue(), logId, (int)MetaType.App.getValue());
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
    }
}

