/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.business.hosting.SVNCodeHostingServiceImpl;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.encrypt.Encrypters;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.smc.SchemeServiceHelper;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;

public class ConfirmDelAppPlugin
extends AbstractFormPlugin
implements ClickListener,
IConfirmCallBack {
    private static final Log log = LogFactory.getLog(ConfirmDelAppPlugin.class);
    private static final String DELAPP = "DELAPP";
    private static final String MESSAGE = "message";
    private static final String BIZAPPID = "bizappid";
    private static final String SVNLOGINCALLBACK = "svnlogincallback";
    private static final String USERNAME = "username";
    private static final String P = "password";
    private static final String JSESSIONID = "jsessionid";
    private static final String SVNAUTHCALLBACK = "svnAuthCallBack";
    private static final String BOS_DEVP_SVNLOGIN = "bos_devp_svnlogin";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String DEL_APP = "delapp";
    private static final String KEY_SUCCESS = "success";
    private static final String KEY_NUMBER = "number";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok", "details"});
    }

    public void afterCreateNewData(EventObject e) {
        Label msg = (Label)this.getControl(MESSAGE);
        msg.setText((String)this.getView().getFormShowParameter().getCustomParams().get(MESSAGE));
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        String codeManageType = DevportalUtil.getCodeManageTypeByBizAppId(bizAppId);
        String svnPath = AppUtils.getSVNPathByAppId((String)bizAppId);
        if (StringUtils.isBlank((CharSequence)svnPath) || !"svn".equals(codeManageType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"delsvn"});
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase()) {
            case "btnok": {
                this.confirm();
                break;
            }
            case "details": {
                this.goToAppDesc();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        JSONObject sourceMsg;
        if (SVNLOGINCALLBACK.equals(e.getActionId()) && (sourceMsg = JSONObject.parseObject((String)((String)e.getReturnData()))) != null) {
            String userName = sourceMsg.getString(USERNAME);
            String passWord = sourceMsg.getString(P);
            Boolean isChecked = sourceMsg.getBoolean("ischecked");
            String svnPath = sourceMsg.getString("svnpath");
            this.getPageCache().put(USERNAME, userName);
            this.getPageCache().put(P, passWord);
            if (isChecked.booleanValue()) {
                String uuid = this.getPageCache().get(JSESSIONID);
                SessionDAO sessionDao = SessionDAOFactory.getSessionDAO((String)uuid);
                String sessionKey = AppUtils.getSessionKey((String)svnPath, (String)uuid);
                JSONObject userObj = new JSONObject();
                userObj.put(USERNAME, (Object)userName);
                userObj.put(P, (Object)passWord);
                String userInfo = userObj.toJSONString();
                sessionDao.setAttribute(sessionKey, userInfo);
                JSONObject session = new JSONObject();
                session.put("svnmsg", (Object)uuid);
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("SAVE_JSESSION_ID", (Object)session);
            }
            this.deleteSVNMeta(userName, passWord, svnPath);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (SVNAUTHCALLBACK.equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
            FormShowParameter parameter = new FormShowParameter();
            parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId(BOS_DEVP_SVNLOGIN);
            parameter.setCaption(ResManager.loadKDString((String)"\u767b\u5f55SVN", (String)"ConfirmDelAppPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, SVNLOGINCALLBACK);
            parameter.setCloseCallBack(callBack);
            this.getView().showForm(parameter);
        } else if ("deletesvncallBack".equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            String jsessionId = (String)this.getView().getFormShowParameter().getCustomParam(JSESSIONID);
            String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
            String svnPath = AppUtils.getSVNPathByAppId((String)bizAppId);
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(BOS_DEVP_SVNLOGIN);
            parameter.setCaption(ResManager.loadKDString((String)"\u767b\u5f55SVN", (String)"ConfirmDelAppPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
            CloseCallBack callBack = null;
            if (StringUtils.isBlank((CharSequence)jsessionId) || "undefined".equals(jsessionId) || "null".equals(jsessionId)) {
                jsessionId = UUID.randomUUID().toString();
                this.getPageCache().put(JSESSIONID, jsessionId);
                callBack = new CloseCallBack((IFormPlugin)this, SVNLOGINCALLBACK);
                parameter.setCloseCallBack(callBack);
                this.getView().showForm(parameter);
            } else {
                SessionDAO sessionDao = SessionDAOFactory.getSessionDAO((String)jsessionId);
                String sessionKey = AppUtils.getSessionKey((String)svnPath, (String)jsessionId);
                String loginInfo = sessionDao.getAttribute(sessionKey);
                this.getPageCache().put(JSESSIONID, jsessionId);
                if (StringUtils.isBlank((CharSequence)loginInfo)) {
                    callBack = new CloseCallBack((IFormPlugin)this, SVNLOGINCALLBACK);
                    parameter.setCloseCallBack(callBack);
                    this.getView().showForm(parameter);
                } else {
                    JSONObject userLogin = JSONObject.parseObject((String)loginInfo);
                    String userName = userLogin.getString(USERNAME);
                    String passWord = userLogin.getString(P);
                    if (StringUtils.isBlank((CharSequence)userName) || StringUtils.isBlank((CharSequence)passWord)) {
                        callBack = new CloseCallBack((IFormPlugin)this, SVNLOGINCALLBACK);
                        parameter.setCloseCallBack(callBack);
                        this.getView().showForm(parameter);
                    } else {
                        this.deleteSVNMeta(userName, passWord, svnPath);
                    }
                }
            }
        }
    }

    private void goToAppDesc() {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(this.isModel() ? "bos_devp_bizappdetail_mod" : "bos_devp_bizappdetails");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("appid", (Object)bizAppId);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "appDetails");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private boolean isModel() {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            return parentView.getFormShowParameter().getFormId().equals("bos_devpn_modelist");
        }
        return false;
    }

    private void confirm() {
        boolean isDelSVN = (Boolean)this.getView().getModel().getValue("delsvn");
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        String jsessionId = (String)this.getView().getFormShowParameter().getCustomParam(JSESSIONID);
        if (isDelSVN) {
            String svnPath = AppUtils.getSVNPathByAppId((String)bizAppId);
            if (StringUtils.isBlank((CharSequence)svnPath)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6eSVN\u8def\u5f84\u3002", (String)"ConfirmDelAppPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            QFilter qFilter = new QFilter("baseapp", "=", (Object)bizAppId);
            QFilter[] filters = new QFilter[]{qFilter};
            Boolean baseApp = QueryServiceHelper.exists((String)"bos_devportal_bizcloud", (QFilter[])filters);
            if (baseApp.booleanValue()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u662f\u57fa\u7840\u5e94\u7528\uff0c\u5220\u9664\u65f6\uff0c\u540c\u65f6\u4f1a\u5c06\u8be5\u5e94\u7528\u6240\u5728\u4e1a\u52a1\u4e91\u7684\u5143\u6570\u636e\u5220\u9664\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"ConfirmDelAppPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("deletesvncallBack"));
            } else {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId(BOS_DEVP_SVNLOGIN);
                parameter.setCaption(ResManager.loadKDString((String)"\u767b\u5f55SVN", (String)"ConfirmDelAppPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
                CloseCallBack callBack = null;
                if (StringUtils.isBlank((CharSequence)jsessionId) || "undefined".equals(jsessionId) || "null".equals(jsessionId)) {
                    jsessionId = UUID.randomUUID().toString();
                    this.getPageCache().put(JSESSIONID, jsessionId);
                    callBack = new CloseCallBack((IFormPlugin)this, SVNLOGINCALLBACK);
                    parameter.setCloseCallBack(callBack);
                    this.getView().showForm(parameter);
                } else {
                    SessionDAO sessionDao = SessionDAOFactory.getSessionDAO((String)jsessionId);
                    String sessionKey = AppUtils.getSessionKey((String)svnPath, (String)jsessionId);
                    String loginInfo = sessionDao.getAttribute(sessionKey);
                    this.getPageCache().put(JSESSIONID, jsessionId);
                    if (StringUtils.isBlank((CharSequence)loginInfo)) {
                        callBack = new CloseCallBack((IFormPlugin)this, SVNLOGINCALLBACK);
                        parameter.setCloseCallBack(callBack);
                        this.getView().showForm(parameter);
                    } else {
                        JSONObject userLogin = JSONObject.parseObject((String)loginInfo);
                        String userName = userLogin.getString(USERNAME);
                        String passWord = userLogin.getString(P);
                        if (StringUtils.isBlank((CharSequence)userName) || StringUtils.isBlank((CharSequence)passWord)) {
                            callBack = new CloseCallBack((IFormPlugin)this, SVNLOGINCALLBACK);
                            parameter.setCloseCallBack(callBack);
                            this.getView().showForm(parameter);
                        } else {
                            this.deleteSVNMeta(userName, passWord, svnPath);
                        }
                    }
                }
            }
        } else {
            JSONObject returnMsg = new JSONObject();
            returnMsg.put(DEL_APP, (Object)DELAPP);
            this.getView().returnDataToParent((Object)returnMsg.toJSONString());
            this.getView().close();
        }
    }

    private void deleteSVNMeta(String username, String password, String svnPath) {
        JSONObject returnMsg;
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        try {
            password = Encrypters.decode((String)password);
        }
        catch (Exception passwordException) {
            log.error((Throwable)passwordException);
            this.getView().showErrorNotification(passwordException.getMessage());
        }
        SVNCodeHostingServiceImpl ssi = new SVNCodeHostingServiceImpl();
        ArrayList<Object> metaList = new ArrayList<Object>();
        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        String appNumber = appMetadata.getNumber();
        String appXmlName = String.format("%s/%s.xml", svnPath, appNumber.toLowerCase());
        Map appXmlNamePath = ssi.checkSvnPath(appXmlName, username, password);
        String appXmlMessage = (String)appXmlNamePath.get(MESSAGE);
        if (KEY_SUCCESS.equals(appXmlMessage)) {
            metaList.add(appXmlName);
        }
        String bizCloudId = appMetadata.getBizCloudID();
        List list = MetadataDao.getCloudDeployFile((String)bizCloudId);
        for (DeployFile deployFile : list) {
            String cloudName = deployFile.getFileName();
            String cloudMeta = String.format("%s/metadata/%s", svnPath, cloudName);
            Map cloudPath = ssi.checkSvnPath(cloudMeta, username, password);
            String cloudMessage = (String)cloudPath.get(MESSAGE);
            if (!KEY_SUCCESS.equals(cloudMessage)) continue;
            metaList.add(cloudMeta);
        }
        String appMetadata_app = String.format("%s/metadata/%s.app", svnPath, appNumber.toLowerCase());
        String appMetadata_cn_appx = String.format("%s/metadata/%s.zh_CN.appx", svnPath, appNumber.toLowerCase());
        String appMetadata_en_appx = String.format("%s/metadata/%s.en.appx", svnPath, appNumber.toLowerCase());
        String appMetadata_en_US_appx = String.format("%s/metadata/%s.en_US.appx", svnPath, appNumber.toLowerCase());
        String appMetadata_tw_appx = String.format("%s/metadata/%s.zh_TW.appx", svnPath, appNumber.toLowerCase());
        ArrayList<String> appMetaList = new ArrayList<String>();
        appMetaList.add(appMetadata_app);
        appMetaList.add(appMetadata_cn_appx);
        appMetaList.add(appMetadata_en_appx);
        appMetaList.add(appMetadata_en_US_appx);
        appMetaList.add(appMetadata_tw_appx);
        for (int i = 0; i < appMetaList.size(); ++i) {
            String appMeta = (String)appMetaList.get(i);
            Map sourcePath = ssi.checkSvnPath(appMeta, username, password);
            String message = (String)sourcePath.get(MESSAGE);
            if (!KEY_SUCCESS.equals(message)) continue;
            metaList.add(appMeta);
        }
        DynamicObjectCollection homeAppMenus = SchemeServiceHelper.getSchemeByAppID((String)bizAppId);
        for (DynamicObject dynamicObject : homeAppMenus) {
            String schemaNumber = dynamicObject.getString(KEY_NUMBER);
            String schemaMeta = String.format("%s/metadata/%s.sch", svnPath, schemaNumber.toLowerCase());
            Map sourcePath = ssi.checkSvnPath(schemaMeta, username, password);
            String message = (String)sourcePath.get(MESSAGE);
            if (!KEY_SUCCESS.equals(message)) continue;
            metaList.add(schemaMeta);
        }
        Object[] ids = new Object[]{bizAppId};
        QFilter bizFilter = new QFilter("bizapp", "=", (Object)bizAppId);
        QFilter[] filters = new QFilter[]{bizFilter};
        String selectFields = "id,form";
        DynamicObjectCollection docPages = QueryServiceHelper.query((String)"bos_devportal_unitrelform", (String)selectFields, (QFilter[])filters);
        for (DynamicObject dynamicObject : docPages) {
            String pageId = dynamicObject.getString("form");
            String pageNumber = BusinessDataServiceHelper.loadSingleFromCache((Object)pageId, (String)"bos_formmeta", (String)KEY_NUMBER).getString(KEY_NUMBER);
            String pageDymMetadata = String.format("%s/metadata/%s.dym", svnPath, pageNumber);
            String pageDymxMetadata = String.format("%s/metadata/%s.zh_CN.dymx", svnPath, pageNumber);
            String pageDymxMetadata_en = String.format("%s/metadata/%s.en.dymx", svnPath, pageNumber);
            String pageDymxMetadata_en_US = String.format("%s/metadata/%s.en_US.dymx", svnPath, pageNumber);
            String pageDymxMetadata_TW = String.format("%s/metadata/%s.zh_TW.dymx", svnPath, pageNumber);
            ArrayList<Object> pageMetaList = new ArrayList<Object>();
            pageMetaList.add(pageDymMetadata);
            pageMetaList.add(pageDymxMetadata);
            pageMetaList.add(pageDymxMetadata_en);
            pageMetaList.add(pageDymxMetadata_en_US);
            pageMetaList.add(pageDymxMetadata_TW);
            for (int i = 0; i < pageMetaList.size(); ++i) {
                String pageMeta = (String)pageMetaList.get(i);
                Map sourcePath = ssi.checkSvnPath(pageMeta, username, password);
                String message = (String)sourcePath.get(MESSAGE);
                if (!KEY_SUCCESS.equals(message)) continue;
                metaList.add(pageMeta);
            }
        }
        String selectScriptFields = "id,txt_scriptnumber";
        QFilter scriptFilter = new QFilter(BIZAPPID, "=", (Object)bizAppId);
        QFilter[] scriptFilters = new QFilter[]{scriptFilter};
        DynamicObjectCollection docScriptIds = QueryServiceHelper.query((String)"ide_pluginscript", (String)selectScriptFields, (QFilter[])scriptFilters);
        for (DynamicObject dynamicObject : docScriptIds) {
            String scriptNumber = dynamicObject.getString("txt_scriptnumber");
            String scriptMetadata = String.format("%s/metadata/%s.ks", svnPath, scriptNumber.toLowerCase());
            Map sourcePath = ssi.checkSvnPath(scriptMetadata, username, password);
            String message = (String)sourcePath.get(MESSAGE);
            if (!KEY_SUCCESS.equals(message)) continue;
            metaList.add(scriptMetadata);
        }
        if (metaList != null && metaList.size() > 0) {
            try {
                ssi.deleteSVN(svnPath, username, password, metaList, ResManager.loadKDString((String)"\u5220\u9664\u5143\u6570\u636e\u3002", (String)"ConfirmDelAppPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                returnMsg = new JSONObject();
                returnMsg.put(DEL_APP, (Object)DELAPP);
                this.getView().returnDataToParent((Object)returnMsg.toJSONString());
                this.getView().close();
            }
            catch (Exception svnException) {
                log.error((Throwable)svnException);
                String svnMsg = svnException.getMessage();
                if (svnMsg.contains("Authentication required")) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524dSVN\u8d26\u53f7\u4ec5\u5177\u5907\u8bfb\u53d6\u6743\u9650\uff0c\u662f\u5426\u9700\u8981\u5207\u6362\u8d26\u53f7\u5e76\u91cd\u65b0\u767b\u5f55\uff1f", (String)"ConfirmDelAppPlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(SVNAUTHCALLBACK));
                } else if (svnMsg.contains("403 Forbidden")) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524dSVN\u8d26\u53f7\u4ec5\u5177\u5907\u8bfb\u53d6\u6743\u9650\uff0c\u662f\u5426\u9700\u8981\u5207\u6362\u8d26\u53f7\u5e76\u91cd\u65b0\u767b\u5f55\uff1f", (String)"ConfirmDelAppPlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(SVNAUTHCALLBACK));
                }
            }
        } else {
            returnMsg = new JSONObject();
            returnMsg.put(DEL_APP, (Object)DELAPP);
            this.getView().returnDataToParent((Object)returnMsg.toJSONString());
            this.getView().close();
        }
    }
}

