/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.business.git.GitContext;
import kd.bos.devportal.business.git.GitLoginHandler;
import kd.bos.devportal.business.git.GitOperateHandler;
import kd.bos.devportal.business.hosting.SVNCodeHostingServiceImpl;
import kd.bos.devportal.business.hosting.SvnOperationUtil;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.encrypt.Encrypters;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;

public class ConfirmDelPlugin
extends AbstractFormPlugin
implements ClickListener,
IConfirmCallBack {
    private static final Log log = LogFactory.getLog(ConfirmDelPlugin.class);
    private static final String BIZAPPID = "bizappid";
    private static final String ISDELSVNMETADATA = "isdelsvnmetadata";
    private static final String ISDELGITMETADATA = "isdelgitmetadata";
    private static final String KEY_MESSAGE = "message";
    private static final String SVNLOGINCALLBACK = "svnlogincallback";
    private static final String USRENAME = "username";
    private static final String P = "password";
    private static final String KEY_JESSIONID = "jsessionid";
    private static final String AUTHENTICATION_REQUIRED = "Authentication required";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String SVNAUTHCALLBACK = "svnAuthCallBack";
    private static final String FORBIDDEN = "403 Forbidden";
    private static final String KEY_SCRIPT = "script";
    private static final String KEY_SUCCESS = "success";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        String codeManageType = DevportalUtil.getCodeManageTypeByBizAppId(bizAppId);
        String svnPath = AppUtils.getSVNPathByAppId((String)bizAppId);
        Map gitPath = AppUtils.getGitPathByAppId((String)bizAppId);
        if ("none".equals(codeManageType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{ISDELSVNMETADATA});
            this.getView().setVisible(Boolean.FALSE, new String[]{ISDELGITMETADATA});
        } else if ("svn".equals(codeManageType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{ISDELSVNMETADATA});
            this.getView().setVisible(Boolean.FALSE, new String[]{ISDELGITMETADATA});
        } else if ("git".equals(codeManageType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{ISDELSVNMETADATA});
            this.getView().setVisible(Boolean.TRUE, new String[]{ISDELGITMETADATA});
        }
        String message = (String)this.getView().getFormShowParameter().getCustomParam(KEY_MESSAGE);
        Label msg = (Label)this.getControl(KEY_MESSAGE);
        msg.setText(message);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() == null) {
            return;
        }
        if (SVNLOGINCALLBACK.equals(e.getActionId())) {
            JSONObject sourceMsg = JSONObject.parseObject((String)((String)e.getReturnData()));
            if (sourceMsg != null) {
                String userName = sourceMsg.getString(USRENAME);
                String passWord = sourceMsg.getString(P);
                String svnPath = sourceMsg.getString("svnpath");
                Boolean isChecked = sourceMsg.getBoolean("ischecked");
                this.getPageCache().put(USRENAME, userName);
                this.getPageCache().put(P, passWord);
                if (isChecked.booleanValue()) {
                    String uuid = this.getPageCache().get(KEY_JESSIONID);
                    SessionDAO sessionDao = SessionDAOFactory.getSessionDAO((String)uuid);
                    String sessionKey = AppUtils.getSessionKey((String)svnPath, (String)uuid);
                    JSONObject userObj = new JSONObject();
                    userObj.put(USRENAME, (Object)userName);
                    userObj.put(P, (Object)passWord);
                    String userInfo = userObj.toJSONString();
                    sessionDao.setAttribute(sessionKey, userInfo);
                    JSONObject session = new JSONObject();
                    session.put("svnmsg", (Object)uuid);
                    ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("SAVE_JSESSION_ID", (Object)session);
                }
                String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
                String source = (String)this.getView().getFormShowParameter().getCustomParam("source");
                JSONArray sourceInfos = JSONArray.parseArray((String)source);
                if ("page".equals(type)) {
                    for (int i = 0; i < sourceInfos.size(); ++i) {
                        String sourceInfo = sourceInfos.getString(i);
                        String[] sourceInfoArr = sourceInfo.split("-");
                        String sourceId = sourceInfoArr[0];
                        try {
                            this.svnDeleteSource(svnPath, sourceId, type, userName, passWord);
                            continue;
                        }
                        catch (Exception svnException) {
                            log.error((Throwable)svnException);
                            String svnMsg = svnException.getMessage();
                            if (svnMsg.contains(AUTHENTICATION_REQUIRED)) {
                                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524dSVN\u8d26\u53f7\u4ec5\u5177\u5907\u8bfb\u53d6\u6743\u9650\uff0c\u662f\u5426\u9700\u8981\u5207\u6362\u8d26\u53f7\u5e76\u91cd\u65b0\u767b\u5f55\uff1f", (String)"ConfirmDelPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(SVNAUTHCALLBACK));
                            } else if (svnMsg.contains(FORBIDDEN)) {
                                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524dSVN\u8d26\u53f7\u4ec5\u5177\u5907\u8bfb\u53d6\u6743\u9650\uff0c\u662f\u5426\u9700\u8981\u5207\u6362\u8d26\u53f7\u5e76\u91cd\u65b0\u767b\u5f55\uff1f", (String)"ConfirmDelPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(SVNAUTHCALLBACK));
                            } else {
                                this.getView().showErrorNotification(svnMsg);
                            }
                            return;
                        }
                    }
                } else if (KEY_SCRIPT.equals(type)) {
                    for (int i = 0; i < sourceInfos.size(); ++i) {
                        String sourceId = sourceInfos.getString(i);
                        try {
                            this.svnDeleteSource(svnPath, sourceId, type, userName, passWord);
                            continue;
                        }
                        catch (Exception svnException) {
                            log.error((Throwable)svnException);
                            String svnMsg = svnException.getMessage();
                            if (svnMsg.contains(AUTHENTICATION_REQUIRED)) {
                                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524dSVN\u8d26\u53f7\u4ec5\u5177\u5907\u8bfb\u53d6\u6743\u9650\uff0c\u662f\u5426\u9700\u8981\u5207\u6362\u8d26\u53f7\u5e76\u91cd\u65b0\u767b\u5f55\uff1f", (String)"ConfirmDelPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(SVNAUTHCALLBACK));
                            } else if (svnMsg.contains(FORBIDDEN)) {
                                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524dSVN\u8d26\u53f7\u4ec5\u5177\u5907\u8bfb\u53d6\u6743\u9650\uff0c\u662f\u5426\u9700\u8981\u5207\u6362\u8d26\u53f7\u5e76\u91cd\u65b0\u767b\u5f55\uff1f", (String)"ConfirmDelPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(SVNAUTHCALLBACK));
                            } else {
                                this.getView().showErrorNotification(svnMsg);
                            }
                            return;
                        }
                    }
                }
            }
        } else if ("gitlogincallback".equals(e.getActionId())) {
            if (e.getReturnData() == null) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u6b63\u786e\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002", (String)"GITLoginPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            JSONObject sourceMsg = JSONObject.parseObject((String)((String)e.getReturnData()));
            String userName = sourceMsg.getString(USRENAME);
            String passWord = sourceMsg.getString(P);
            boolean isDelGITMetaData = Boolean.parseBoolean(this.getPageCache().get(ISDELGITMETADATA));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("btn", "ok");
            map.put(KEY_SUCCESS, KEY_SUCCESS);
            map.put(ISDELGITMETADATA, isDelGITMetaData);
            map.put(USRENAME, userName);
            map.put(P, passWord);
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (SVNAUTHCALLBACK.equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
            FormShowParameter parameter = new FormShowParameter();
            parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("bos_devp_svnlogin");
            parameter.setCaption(ResManager.loadKDString((String)"\u767b\u5f55SVN", (String)"ConfirmDelPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, SVNLOGINCALLBACK);
            parameter.setCloseCallBack(callBack);
            this.getView().showForm(parameter);
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "btnok": {
                this.confirm();
                break;
            }
        }
    }

    private void confirm() {
        boolean isDelSVNMetaData = (Boolean)this.getView().getModel().getValue(ISDELSVNMETADATA);
        String jsessionId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_JESSIONID);
        String source = (String)this.getView().getFormShowParameter().getCustomParam("source");
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        String bizUnitId = (String)this.getView().getFormShowParameter().getCustomParam("bizunitid");
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        JSONArray sourceInfos = JSONArray.parseArray((String)source);
        if (isDelSVNMetaData) {
            String svnPath = AppUtils.getSVNPathByAppId((String)bizAppId);
            if (StringUtils.isBlank((CharSequence)svnPath)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6eSVN\u8def\u5f84\u3002", (String)"ConfirmDelPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bos_devp_svnlogin");
            parameter.setCaption(ResManager.loadKDString((String)"\u767b\u5f55SVN", (String)"ConfirmDelPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
            CloseCallBack callBack = null;
            if (StringUtils.isBlank((CharSequence)jsessionId) || "undefined".equals(jsessionId) || "null".equals(jsessionId)) {
                jsessionId = UUID.randomUUID().toString();
                this.getPageCache().put(KEY_JESSIONID, jsessionId);
                callBack = new CloseCallBack((IFormPlugin)this, SVNLOGINCALLBACK);
                parameter.setCloseCallBack(callBack);
                this.getView().showForm(parameter);
            } else {
                this.getPageCache().put(KEY_JESSIONID, jsessionId);
                SessionDAO sessionDao = SessionDAOFactory.getSessionDAO((String)jsessionId);
                String sessionKey = AppUtils.getSessionKey((String)svnPath, (String)jsessionId);
                String loginInfo = sessionDao.getAttribute(sessionKey);
                if (StringUtils.isBlank((CharSequence)loginInfo)) {
                    callBack = new CloseCallBack((IFormPlugin)this, SVNLOGINCALLBACK);
                    parameter.setCloseCallBack(callBack);
                    this.getView().showForm(parameter);
                } else {
                    JSONObject userLogin = JSONObject.parseObject((String)loginInfo);
                    String userName = userLogin.getString(USRENAME);
                    String passWord = userLogin.getString(P);
                    if (StringUtils.isBlank((CharSequence)userName) || StringUtils.isBlank((CharSequence)passWord)) {
                        callBack = new CloseCallBack((IFormPlugin)this, SVNLOGINCALLBACK);
                        parameter.setCloseCallBack(callBack);
                        this.getView().showForm(parameter);
                    } else if ("page".equals(type)) {
                        for (int i = 0; i < sourceInfos.size(); ++i) {
                            String sourceInfo = sourceInfos.getString(i);
                            String[] sourceInfoArr = sourceInfo.split("-");
                            String sourceId = sourceInfoArr[0];
                            try {
                                this.svnDeleteSource(svnPath, sourceId, type, userName, passWord);
                                continue;
                            }
                            catch (Exception svnException) {
                                log.error((Throwable)svnException);
                                String svnMsg = svnException.getMessage();
                                if (svnMsg.contains(AUTHENTICATION_REQUIRED)) {
                                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524dSVN\u8d26\u53f7\u4ec5\u5177\u5907\u8bfb\u53d6\u6743\u9650\uff0c\u662f\u5426\u9700\u8981\u5207\u6362\u8d26\u53f7\u5e76\u91cd\u65b0\u767b\u5f55\uff1f", (String)"ConfirmDelPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(SVNAUTHCALLBACK));
                                } else if (svnMsg.contains(FORBIDDEN)) {
                                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524dSVN\u8d26\u53f7\u4ec5\u5177\u5907\u8bfb\u53d6\u6743\u9650\uff0c\u662f\u5426\u9700\u8981\u5207\u6362\u8d26\u53f7\u5e76\u91cd\u65b0\u767b\u5f55\uff1f", (String)"ConfirmDelPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(SVNAUTHCALLBACK));
                                } else if (svnMsg.contains("Locked")) {
                                    String lockUser = SvnOperationUtil.getSVNLockUser((String)sourceId, (String)type, (String)userName, (String)passWord);
                                    this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u8d44\u6e90\u88ab%s", (String)"ConfirmDelPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), lockUser));
                                } else {
                                    this.getView().showErrorNotification(svnMsg);
                                }
                                return;
                            }
                        }
                    } else if (KEY_SCRIPT.equals(type)) {
                        for (int i = 0; i < sourceInfos.size(); ++i) {
                            String sourceId = sourceInfos.getString(i);
                            try {
                                this.svnDeleteSource(svnPath, sourceId, type, userName, passWord);
                                continue;
                            }
                            catch (Exception svnException) {
                                log.error((Throwable)svnException);
                                String svnMsg = svnException.getMessage();
                                if (svnMsg.contains(AUTHENTICATION_REQUIRED)) {
                                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524dSVN\u8d26\u53f7\u4ec5\u5177\u5907\u8bfb\u53d6\u6743\u9650\uff0c\u662f\u5426\u9700\u8981\u5207\u6362\u8d26\u53f7\u5e76\u91cd\u65b0\u767b\u5f55\uff1f", (String)"ConfirmDelPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(SVNAUTHCALLBACK));
                                } else if (svnMsg.contains(FORBIDDEN)) {
                                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524dSVN\u8d26\u53f7\u4ec5\u5177\u5907\u8bfb\u53d6\u6743\u9650\uff0c\u662f\u5426\u9700\u8981\u5207\u6362\u8d26\u53f7\u5e76\u91cd\u65b0\u767b\u5f55\uff1f", (String)"ConfirmDelPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(SVNAUTHCALLBACK));
                                } else if (svnMsg.contains("Locked")) {
                                    String lockUser = SvnOperationUtil.getSVNLockUser((String)sourceId, (String)type, (String)userName, (String)passWord);
                                    this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u8d44\u6e90\u88ab%s", (String)"ConfirmDelPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), lockUser));
                                } else {
                                    this.getView().showErrorNotification(svnMsg);
                                }
                                return;
                            }
                        }
                    }
                }
            }
        } else if (DevportalUtil.isGitManageType()) {
            boolean isDelGITMetaData = (Boolean)this.getView().getModel().getValue(ISDELGITMETADATA);
            if (isDelGITMetaData) {
                GitContext context = new GitContext();
                context.setBizAppId(bizAppId);
                context.setSessionId(jsessionId);
                context.setType(type);
                String id = this.getIdByType(context.getType(), sourceInfos);
                if (StringUtils.isNotBlank((CharSequence)id)) {
                    context.setId(id);
                    if (GitLoginHandler.hasLogin((GitContext)context, (AbstractFormPlugin)this)) {
                        return;
                    }
                    this.gitDeleteSource(context, sourceInfos);
                    if (!context.isDeleteResult()) {
                        return;
                    }
                }
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("btn", "ok");
            map.put(KEY_SUCCESS, KEY_SUCCESS);
            map.put(ISDELGITMETADATA, isDelGITMetaData);
            this.getView().returnDataToParent(map);
            this.getView().close();
        } else {
            boolean isDelGITMetaData = (Boolean)this.getView().getModel().getValue(ISDELGITMETADATA);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("btn", "ok");
            map.put(KEY_SUCCESS, KEY_SUCCESS);
            map.put(ISDELGITMETADATA, isDelGITMetaData);
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }

    private void gitDeleteSource(GitContext context, JSONArray jsonArray) {
        String id = this.getIdByType(context.getType(), jsonArray);
        if (StringUtils.isBlank((CharSequence)id)) {
            return;
        }
        context.setDeleteId(id);
        context.setOperateKey("delete");
        GitOperateHandler handler = new GitOperateHandler();
        handler.handler(context, (AbstractFormPlugin)this);
    }

    private String getIdByType(String type, JSONArray jsonArray) {
        if (jsonArray.size() < 1) {
            return null;
        }
        String id = null;
        if ("page".equals(type)) {
            id = jsonArray.getString(0).split("-")[0];
        } else if (KEY_SCRIPT.equals(type)) {
            id = jsonArray.getString(0);
        }
        return id;
    }

    private void showGitLoginPage(String type, String bizAppId, String bizUnitId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devp_gitlogin");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "gitlogincallback"));
        parameter.setCustomParam("gitoperatetype", (Object)type);
        parameter.setCustomParam("gitmsg", (Object)UUID.randomUUID().toString());
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam("bizunitid", (Object)bizUnitId);
        this.getView().showForm(parameter);
    }

    private void svnDeleteSource(String svnPath, String sourceId, String type, String userName, String passWord) {
        SVNCodeHostingServiceImpl ssi = new SVNCodeHostingServiceImpl();
        try {
            passWord = Encrypters.decode((String)passWord);
        }
        catch (Exception passwordException) {
            log.error((Throwable)passwordException);
            this.getView().showErrorNotification(passwordException.getMessage());
            return;
        }
        ArrayList<String> metaList = new ArrayList<String>();
        if ("page".equals(type)) {
            List list = MetadataDao.getFormDeployFile((String)sourceId);
            for (int i = 0; i < list.size(); ++i) {
                String sourceName = ((DeployFile)list.get(i)).getFileName();
                String sourceUrl = svnPath + "/metadata/" + sourceName;
                Map sourcePath = ssi.checkSvnPath(sourceUrl, userName, passWord);
                String message = (String)sourcePath.get(KEY_MESSAGE);
                if (!KEY_SUCCESS.equals(message)) continue;
                metaList.add(sourceUrl);
            }
        } else if (KEY_SCRIPT.equals(type)) {
            List deployFileList = MetadataDao.getScriptDeployFile((String[])new String[]{sourceId});
            DeployFile df = (DeployFile)deployFileList.get(0);
            String sourceName = df.getFileName().toLowerCase();
            String sourceUrl = svnPath + "/metadata/" + sourceName;
            Map sourcePath = ssi.checkSvnPath(sourceUrl, userName, passWord);
            String message = (String)sourcePath.get(KEY_MESSAGE);
            if (KEY_SUCCESS.equals(message)) {
                metaList.add(sourceUrl);
            }
        }
        if (metaList != null && metaList.size() > 0) {
            ssi.deleteSVN(svnPath, userName, passWord, metaList, ResManager.loadKDString((String)"\u5220\u9664\u5143\u6570\u636e\u3002", (String)"ConfirmDelPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("btn", "ok");
        map.put(KEY_SUCCESS, KEY_SUCCESS);
        this.getView().returnDataToParent(map);
        this.getView().close();
    }
}

