/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class DeleteResourceDetailPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String ENTRYENTITY = "entryentity";
    private static final String BIZAPPID = "bizappid";

    public void registerListener(EventObject e) {
        EntryGrid c = (EntryGrid)this.getControl(ENTRYENTITY);
        c.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        JSONArray useResources;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String sceneType = (String)parameter.getCustomParam("scenetype");
        if ("prodevportal".equals(sceneType)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
            entryGrid.setColumnProperty("number", "ln", (Object)false);
        }
        if ((useResources = JSONArray.parseArray((String)((String)parameter.getCustomParam("useresource")))) != null && useResources.size() > 0) {
            int count = useResources.size();
            IDataModel model = this.getModel();
            model.deleteEntryData(ENTRYENTITY);
            model.batchCreateNewEntryRow(ENTRYENTITY, count);
            for (int i = 0; i < count; ++i) {
                JSONObject useResource = useResources.getJSONObject(i);
                model.setValue("bizappname", (Object)useResource.getString("bizappname"), i);
                model.setValue("bizunitname", (Object)useResource.getString("bizunitname"), i);
                model.setValue("type", (Object)useResource.getString("type"), i);
                model.setValue("name", (Object)useResource.getString("name"), i);
                model.setValue("number", (Object)useResource.getString("number"), i);
                model.setValue("usetype", (Object)useResource.getString("usetype"), i);
                model.setValue(BIZAPPID, (Object)useResource.getString(BIZAPPID), i);
                model.setValue("bizunitid", (Object)useResource.getString("bizunitid"), i);
                model.setValue("id", (Object)useResource.getString("id"), i);
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String sceneType = (String)this.getView().getFormShowParameter().getCustomParam("scenetype");
        if ("devportal".equals(sceneType)) {
            int index = evt.getRowIndex();
            String type = (String)this.getModel().getValue("type", index);
            if (StringUtils.isBlank((CharSequence)type)) {
                return;
            }
            switch (type) {
                case "\u5e94\u7528": {
                    this.goto_bizapp(index);
                    break;
                }
                case "\u5e94\u7528\u83dc\u5355": {
                    this.goto_appmenu(index);
                    break;
                }
            }
        }
    }

    private void goto_bizapp(int index) {
        Tab tab = (Tab)this.getView().getParentView().getControl("tabap");
        tab.activeTab("tabpageap1");
        this.getView().sendFormAction(this.getView().getParentView());
        String bizAppId = (String)this.getModel().getValue(BIZAPPID, index);
        String bizCloudId = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false).getBizCloudID();
        JSONArray cloudItems = DevportalUtil.getCloudsInfo(this.getView());
        JSONArray appItems = DevportalUtil.getAppsInfoByCloudId(bizCloudId, this.getView());
        String bizCloudName = DevportalUtil.getBizCloudNameById(bizCloudId);
        JSONObject data = new JSONObject();
        data.put(BIZAPPID, (Object)bizAppId);
        data.put("bizcloudid", (Object)bizCloudId);
        data.put("clouditems", (Object)cloudItems);
        data.put("appitems", (Object)appItems);
        data.put("bizcloudname", (Object)bizCloudName);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("RESET_APPPAGE", (Object)data);
    }

    private void goto_appmenu(int index) {
        Tab tab = (Tab)this.getView().getParentView().getControl("tabap");
        tab.activeTab("tabpageap1");
        this.getView().sendFormAction(this.getView().getParentView());
        String bizAppId = (String)this.getModel().getValue(BIZAPPID, index);
        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        String bizCloudId = appMetadata.getBizCloudID();
        String bizCloudName = BusinessDataServiceHelper.loadSingle((Object)bizCloudId, (String)"bos_devportal_bizcloud").getString("name");
        JSONArray cloudItems = DevportalUtil.getCloudsInfo(this.getView());
        JSONArray appItems = DevportalUtil.getAppsInfoByCloudId(bizCloudId, this.getView());
        JSONObject data = new JSONObject();
        data.put(BIZAPPID, (Object)bizAppId);
        data.put("bizcloudid", (Object)bizCloudId);
        data.put("clouditems", (Object)cloudItems);
        data.put("appitems", (Object)appItems);
        data.put("bizcloudname", (Object)bizCloudName);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("RESET_APPPAGE", (Object)data);
        String menuId = (String)this.getModel().getValue("id", index);
        AppMenuElement appMenuElement = AppMetaServiceHelper.getMenuById((String)menuId, (String)bizAppId, (boolean)false);
        String parentMenuId = appMenuElement.getParentId();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("nodeid", menuId);
        map.put("parentnodeid", parentMenuId);
        map.put(BIZAPPID, bizAppId);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setFormId("bos_devp_appmenumeta");
        parameter.setCaption(ResManager.loadKDString((String)"\u4fee\u6539\u83dc\u5355", (String)"DeleteResourceDetailPlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        parameter.setCustomParams(map);
        this.getView().showForm(parameter);
    }
}

