/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.business.PermissionVerify;
import kd.bos.devportal.business.util.DevportalVerify;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;

public class DevPermissionListPlugin
extends AbstractListPlugin {
    private static List<String> permItem = new ArrayList<String>(3);
    public PermissionVerify verify = new PermissionVerify();
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String ADDNEW = "ADDNEW";
    private static final String EDIT = "EDIT";
    private static final String DELETE = "delete";

    public void setFilter(SetFilterEvent e) {
        Object mode = DevportalVerify.getParameter((String)"dev_governance_mode");
        if (mode == null) {
            return;
        }
        String devMode = (String)mode;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
        long userId = RequestContext.get().getCurrUserId();
        QFilter qFilter = new QFilter("creater.masterid", "=", (Object)userId);
        if (StringUtils.equals((CharSequence)"centred", (CharSequence)devMode) || StringUtils.isBlank((CharSequence)devMode)) {
            QFilter qFilter2 = new QFilter("admin", "=", (Object)true);
            QFilter filter = qFilter2.or(qFilter);
            filters.add(filter);
        } else {
            filters.add(qFilter);
        }
        e.setCustomQFilters(filters);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        String status = e.getParameter().getStatus().name();
        if (ADDNEW.equals(status)) {
            e.getParameter().setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u5e94\u7528\u6743\u9650", (String)"DevPermissionListPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (EDIT.equals(status)) {
            e.getParameter().setCaption(ResManager.loadKDString((String)"\u4fee\u6539\u5e94\u7528\u6743\u9650", (String)"DevPermissionListPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (permItem.contains(operateKey)) {
            if (DevportalVerify.isApart()) {
                return;
            }
            boolean permission = this.verify.hasPermission();
            if (!permission) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"DevPermissionListPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (DELETE.equals(operateKey) && args.getOperationResult().isSuccess()) {
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", "BizAppListPlugin_35", BOS_DEVPORTAL_PLUGIN);
            MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u5220\u9664\u5e94\u7528\u6743\u9650", "DevPermissionPlugin_6", BOS_DEVPORTAL_PLUGIN);
            AppUtils.addOpLog((String)"bos_app_isolation", (String)DELETE, (String)"bos_app_isolation", (String)"1", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[0]);
        }
    }

    static {
        permItem.add("new");
        permItem.add("modify");
        permItem.add(DELETE);
    }
}

