/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import java.util.EventObject;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.devportal.business.PermissionVerify;
import kd.bos.devportal.business.util.DevportalVerify;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;

public class DevPermissionPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ISOLATION = "isolationapp";
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String ADMIN = "admin";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    public PermissionVerify verify = new PermissionVerify();
    private static final String ADDNEW = "ADDNEW";
    private static final String EDIT = "EDIT";
    private static final String SAVE = "save";

    public void initialize() {
        super.initialize();
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(ISOLATION);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{ADMIN});
    }

    public void afterCreateNewData(EventObject e) {
        if (this.verify.hasPermission()) {
            this.getModel().setValue(ADMIN, (Object)true);
        } else {
            this.getModel().setValue(ADMIN, (Object)false);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
        parameter.setCustomParam("hideNoCode", (Object)"true");
        if (this.verify.hasPermission()) {
            return;
        }
        long userId = RequestContext.get().getCurrUserId();
        Set apps = DevportalVerify.getAppByUser((Long)userId);
        QFilter qFilter = new QFilter("id", "in", (Object)apps);
        parameter.getListFilterParameter().setFilter(qFilter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (SAVE.equals(operateKey)) {
            DynamicObject account = (DynamicObject)this.getModel().getValue("account");
            DynamicObject creater = (DynamicObject)this.getModel().getValue("creater");
            if (account != null && creater != null) {
                Long accountId = (Long)account.get("id");
                Long createrId = (Long)creater.get("id");
                long userId = RequestContext.get().getCurrUserId();
                if (accountId != null && accountId.equals(createrId) || accountId != null && accountId == userId) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u7ed9\u81ea\u5df1\u5206\u914d\u6743\u9650", (String)"DevPermissionPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            if (DevportalVerify.isApart()) {
                return;
            }
            boolean permission = this.verify.hasPermission();
            if (!permission) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"DevPermissionPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult operationResult;
        super.afterDoOperation(args);
        if (SAVE.equals(args.getOperateKey()) && (operationResult = args.getOperationResult()).isSuccess()) {
            this.writeLog();
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"DevPermissionPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        }
    }

    private void writeLog() {
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        String formId = parameter.getFormId();
        BillOperationStatus billStatus = parameter.getBillStatus();
        MultiLangEnumBridge opName = null;
        MultiLangEnumBridge opDescription = null;
        if (billStatus == BillOperationStatus.ADDNEW) {
            opName = new MultiLangEnumBridge("\u65b0\u589e", "BizAppListPlugin_82", BOS_DEVPORTAL_PLUGIN);
            opDescription = new MultiLangEnumBridge("\u65b0\u589e\u5e94\u7528\u6743\u9650", "DevPermissionPlugin_4", BOS_DEVPORTAL_PLUGIN);
        } else if (billStatus == BillOperationStatus.EDIT) {
            opName = new MultiLangEnumBridge("\u4fee\u6539", "BizAppListPlugin_83", BOS_DEVPORTAL_PLUGIN);
            opDescription = new MultiLangEnumBridge("\u4fee\u6539\u5e94\u7528\u6743\u9650", "DevPermissionPlugin_5", BOS_DEVPORTAL_PLUGIN);
        }
        if (opName == null) {
            return;
        }
        AppUtils.addOpLog((String)formId, (String)SAVE, (String)formId, (String)"1", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[0]);
    }
}

