/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.TreeEntryEntity;

public class FieldSelectPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
TreeNodeCheckListener {
    private static final String FTARGETPROPS = "ftargetprops";
    private static final String NUMBER = "number";
    private static final String FIELDTREE = "FieldTree";
    private static final String FTNAME = "ftname";
    private static final String CHECKNODES = "checkNodes";
    private static final String ENTRYFIELDITEMS = "entryfielditems";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btnremove"});
        EntryGrid grid = (EntryGrid)this.getControl(FTARGETPROPS);
        grid.addRowClickListener((RowClickEventListener)this);
        TreeView fieldtree = (TreeView)this.getView().getControl(FIELDTREE);
        fieldtree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Object value;
        String entityId = "";
        entityId = (String)this.getView().getFormShowParameter().getCustomParam("metadataid");
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        List fields = entityMetadata.getRootEntity().getItems();
        this.removeNoSupportObject(fields);
        ArrayList<Map<String, Object>> nodeList = new ArrayList<Map<String, Object>>();
        String entryEntityId = "";
        for (EntityItem field : fields) {
            HashMap<String, Object> fieldItem = new HashMap<String, Object>();
            String key = (String)this.getView().getFormShowParameter().getCustomParam("key");
            if ("bill".equals(key)) {
                if (field instanceof EntryEntity) continue;
                fieldItem.put("id", field.getId());
                fieldItem.put(NUMBER, field.getKey());
                fieldItem.put("name", field.getName().toString());
                nodeList.add(fieldItem);
                continue;
            }
            if (!"entry".equals(key) || !(field instanceof EntryEntity)) continue;
            this.loadEntryEntityNode((EntryEntity)field, fieldItem);
            nodeList.add(fieldItem);
            entryEntityId = field.getId();
            break;
        }
        TreeView tree = (TreeView)this.getView().getControl(FIELDTREE);
        TreeNode root = new TreeNode();
        root.setId(entityMetadata.getId());
        root.setLongNumber(entityMetadata.getKey());
        root.setText(entityMetadata.getName().toString());
        root.setIsOpened(true);
        tree.addNode(this.setTreeNode(root, nodeList, entityMetadata.getId()));
        if (StringUtils.isNotBlank((CharSequence)entryEntityId)) {
            TreeNode node = root.getTreeNode(entryEntityId, 16);
            node.setIsOpened(true);
        }
        if ((value = this.getView().getFormShowParameter().getCustomParams().get("value")) == null || StringUtils.isBlank(value)) {
            value = new ArrayList();
        }
        List refProps = (List)value;
        ArrayList<TreeNode> checkNodes = new ArrayList<TreeNode>();
        ArrayList<String> checkNodeIds = new ArrayList<String>();
        this.getModel().deleteEntryData(FTARGETPROPS);
        for (Map refprop : refProps) {
            String nodeId = (String)refprop.get("fieldid");
            TreeNode node = root.getTreeNode(nodeId, 16);
            if (nodeId == null || node == null) continue;
            checkNodes.add(node);
            checkNodeIds.add(nodeId);
            int rowindex = this.getModel().createNewEntryRow(FTARGETPROPS);
            this.getModel().setValue(FTNAME, (Object)node.getText(), rowindex);
            this.getModel().setValue("ftid", (Object)node.getId(), rowindex);
        }
        tree.checkNodes(checkNodes);
        this.getPageCache().put(FIELDTREE, SerializationUtils.toJsonString((Object)root));
        this.getPageCache().put(CHECKNODES, SerializationUtils.toJsonString(checkNodeIds));
    }

    private void loadEntryEntityNode(EntryEntity field, Map<String, Object> fieldItem) {
        List entryItems = field.getItems();
        this.removeNoSupportObject(entryItems);
        ArrayList entryNodeList = new ArrayList(entryItems.size());
        for (EntityItem entryItem : entryItems) {
            HashMap<String, String> entryItemInfo = new HashMap<String, String>();
            if (entryItem instanceof EntryEntity) continue;
            entryItemInfo.put("id", entryItem.getId());
            entryItemInfo.put(NUMBER, entryItem.getKey());
            entryItemInfo.put("name", entryItem.getName().toString());
            entryNodeList.add(entryItemInfo);
        }
        fieldItem.put(ENTRYFIELDITEMS, entryNodeList);
        fieldItem.put("id", field.getId());
        fieldItem.put(NUMBER, field.getKey());
        fieldItem.put("name", field.getName().toString());
    }

    private TreeNode setTreeNode(TreeNode root, List<Map<String, Object>> rootNodeList, String rootNodeId) {
        for (Map<String, Object> map : rootNodeList) {
            TreeNode node = new TreeNode();
            if (map.get(ENTRYFIELDITEMS) != null) {
                TreeNode entityNode = new TreeNode();
                entityNode.setParentid(rootNodeId);
                entityNode.setId((String)map.get("id"));
                entityNode.setLongNumber((String)map.get(NUMBER));
                entityNode.setText((String)map.get("name"));
                root.addChild(entityNode);
                String entryHeadId = (String)map.get("id");
                List entryNodeList = (List)map.get(ENTRYFIELDITEMS);
                this.setTreeNode(entityNode, entryNodeList, entryHeadId);
                continue;
            }
            node.setParentid(rootNodeId);
            node.setId((String)map.get("id"));
            node.setLongNumber((String)map.get(NUMBER));
            node.setText((String)map.get("name"));
            root.addChild(node);
        }
        return root;
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (FTARGETPROPS.equals(source.getKey())) {
            this.delete();
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btnremove".equals(key)) {
            this.delete();
        } else if ("btnok".equals(key)) {
            this.returnData();
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(FIELDTREE), TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl(FIELDTREE);
        List currChecks = tree.getTreeState().getCheckedNodeIds();
        List checkNodes = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(CHECKNODES), List.class);
        if (evt.getChecked().booleanValue()) {
            if (checkNodes.isEmpty() || currChecks.removeAll(checkNodes)) {
                for (String id : currChecks) {
                    TreeNode node = root.getTreeNode(id, 16);
                    if (node == null || node.getChildren() != null) continue;
                    int row = this.getModel().createNewEntryRow(FTARGETPROPS);
                    this.getModel().setValue("ftid", (Object)node.getId(), row);
                    this.getModel().setValue(FTNAME, (Object)node.getText(), row);
                }
            }
        } else if (currChecks.isEmpty() || checkNodes.removeAll(currChecks)) {
            ArrayList<String> nodeIds = new ArrayList<String>(10);
            for (int i = 0; i < checkNodes.size(); ++i) {
                TreeNode node = root.getTreeNode((String)checkNodes.get(i), 16);
                if (node == null || node.getChildren() == null) continue;
                String nodeId = node.getId();
                nodeIds.add(nodeId);
            }
            checkNodes.removeAll(nodeIds);
            int[] rows = new int[checkNodes.size()];
            int j = 0;
            for (int i = this.getModel().getEntryRowCount(FTARGETPROPS) - 1; i >= 0; --i) {
                if (!checkNodes.contains(this.getModel().getValue("ftid", i))) continue;
                rows[j++] = i;
            }
            this.getModel().deleteEntryRows(FTARGETPROPS, rows);
        }
        this.getPageCache().put(CHECKNODES, SerializationUtils.toJsonString((Object)tree.getTreeState().getCheckedNodeIds()));
    }

    protected void returnData() {
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(FIELDTREE), TreeNode.class);
        DynamicObjectCollection fields = this.getModel().getEntryEntity(FTARGETPROPS);
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        ArrayList listFields = new ArrayList();
        String entryentityId = "";
        for (DynamicObject field : fields) {
            HashMap<String, String> map = new HashMap<String, String>();
            String fieldName = (String)field.get(FTNAME);
            String fieldId = (String)field.get("ftid");
            map.put("fieldname", fieldName);
            map.put("fieldid", fieldId);
            listFields.add(map);
            TreeNode node = root.getTreeNode(fieldId, 16);
            String nodeParentId = node.getParentid();
            if (!StringUtils.isNotBlank((CharSequence)nodeParentId) || nodeParentId.equals(root.getId()) || nodeParentId.equals(entryentityId)) continue;
            entryentityId = nodeParentId;
        }
        returnData.put("listfields", listFields);
        returnData.put("entryentityid", entryentityId);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private void delete() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(FTARGETPROPS);
        int[] rows = grid.getEntryState().getSelectedRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u9664\u7684\u884c\u3002", (String)"FieldSelectPlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> nodeIds = new ArrayList<String>();
        for (int row : rows) {
            if (row < 0) continue;
            nodeIds.add((String)this.getModel().getValue("ftid", row));
        }
        this.getModel().deleteEntryRows(FTARGETPROPS, rows);
        TreeView tree = (TreeView)this.getView().getControl(FIELDTREE);
        tree.uncheckNodes(nodeIds);
        this.getPageCache().put(CHECKNODES, SerializationUtils.toJsonString((Object)tree.getTreeState().getCheckedNodeIds()));
    }

    private void removeNoSupportObject(List<EntityItem<?>> fields) {
        if (fields != null) {
            fields.removeIf(i -> i instanceof TreeEntryEntity);
        }
    }
}

