/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.product.ProductSettingService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class FormTreeListPlugin
extends StandardTreeListPlugin {
    private static final Log log = LogFactory.getLog(FormTreeListPlugin.class);
    private static final String BIZAPPIDS = "bizappids";
    private static final String RUNTIME = "runtime";
    private static final String SCENCE = "scence";
    private static final String SELECTMAINPAGEINAPP = "selectMainPageInApp";
    private static final String BIZAPPID = "bizappid";
    private static final String MASTERID = "masterid";
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String INDUSTRY = "industry";
    private static final String BOS_FOEMMETA = "bos_formmeta";
    private static final String NUMBER = "number";
    private static final ProductSettingService service = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);

    public void initializeTree(EventObject e) {
        TreeNode root;
        List appids;
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String[] bizCloudIds = null;
        String[] bizAppIds = null;
        List cloudids = (List)listShowParameter.getCustomParam("bizcloudids");
        if (cloudids != null && cloudids.size() > 0) {
            bizCloudIds = cloudids.toArray(new String[cloudids.size()]);
        }
        if ((appids = (List)listShowParameter.getCustomParam(BIZAPPIDS)) != null && appids.size() > 0) {
            bizAppIds = appids.toArray(new String[appids.size()]);
        }
        String industryId = (String)listShowParameter.getCustomParam("industryid");
        boolean runtime = true;
        if (listShowParameter.getCustomParam(RUNTIME) != null) {
            runtime = (Boolean)listShowParameter.getCustomParam(RUNTIME);
        }
        boolean onlyVisible = false;
        boolean onlyDeployed = false;
        if (runtime) {
            onlyVisible = listShowParameter.getCustomParam("onlyvisible") != null ? (Boolean)listShowParameter.getCustomParam("onlyvisible") : true;
            onlyDeployed = listShowParameter.getCustomParam("onlydeployed") != null ? (Boolean)listShowParameter.getCustomParam("onlydeployed") : true;
        }
        if ((root = AppUtils.getSubsysTree((String[])bizCloudIds, (String[])bizAppIds, (String)industryId, (String)"app", (boolean)runtime, (boolean)onlyVisible, (boolean)onlyDeployed)) != null) {
            this.getTreeModel().setRoot(root);
            String rootId = root.getId();
            this.getTreeModel().setCurrentNodeId((Object)rootId);
            log.debug("\u5b50\u7cfb\u7edf\u6811\u6839\u8282\u70b9ID\u4e3a\uff1a" + rootId);
        } else {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"F7\u6ca1\u6709\u7b26\u5408\u8fc7\u6ee4\u6761\u4ef6\u7684\u67e5\u8be2\u7ed3\u679c\uff0c\u8bf7\u68c0\u67e5\u8fc7\u6ee4\u6761\u4ef6\u7684\u8bbe\u7f6e\u3002", (String)"FormTreeListPlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.focusInitOrgTreeNode();
    }

    public void setFilter(SetFilterEvent e) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        Boolean runtime = (Boolean)listShowParameter.getCustomParam(RUNTIME);
        if (runtime == null) {
            runtime = Boolean.TRUE;
        }
        ArrayList appNodeList = new ArrayList();
        List cloudNodeList = this.getTreeModel().getRoot().getChildren();
        if (cloudNodeList != null && cloudNodeList.size() > 0) {
            DynamicObject[] objs;
            for (Object treeNode : cloudNodeList) {
                appNodeList.addAll(treeNode.getChildren());
            }
            ArrayList<String> bizAppIds = new ArrayList<String>(appNodeList.size());
            for (TreeNode treeNode : appNodeList) {
                bizAppIds.add(treeNode.getId());
            }
            if (runtime != null && runtime.booleanValue() && (objs = BusinessDataServiceHelper.load((String)BOS_DEVPORTAL_BIZAPP, (String)"id", (QFilter[])new QFilter[]{new QFilter(MASTERID, "in", bizAppIds)})).length > 0) {
                ArrayList<String> masterIds = new ArrayList<String>(objs.length);
                for (DynamicObject dynamicObject : objs) {
                    masterIds.add(dynamicObject.getString("id"));
                }
                bizAppIds.addAll(masterIds);
            }
            QFilter q = new QFilter(BIZAPPID, "in", bizAppIds);
            e.addCustomQFilter(q);
        }
    }

    private void focusInitOrgTreeNode() {
        TreeView treeView = this.treeListView.getTreeView();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String nodeId = (String)listShowParameter.getCustomParam("nodeid");
        if (StringUtils.isNotBlank((CharSequence)nodeId)) {
            TreeNode node = this.getTreeModel().getRoot().getTreeNode(nodeId, 5);
            if (node != null) {
                String leafType = (String)node.getData();
                if ("cloud".equals(leafType)) {
                    node.setIsOpened(true);
                } else {
                    TreeNode parentNode = this.getTreeModel().getRoot().getTreeNode(node.getParentid(), 5);
                    parentNode.setIsOpened(true);
                }
                treeView.focusNode(node);
                treeView.treeNodeClick(node.getParentid(), nodeId);
            }
        } else if (this.getTreeModel().getRoot() != null && this.getTreeModel().getRoot().getChildren() != null && this.getTreeModel().getRoot().getChildren().size() > 0) {
            ((TreeNode)this.getTreeModel().getRoot().getChildren().get(0)).setIsOpened(true);
            if (((TreeNode)this.getTreeModel().getRoot().getChildren().get(0)).getChildren().size() > 0) {
                TreeNode node = (TreeNode)((TreeNode)this.getTreeModel().getRoot().getChildren().get(0)).getChildren().get(0);
                treeView.focusNode(node);
            }
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        Boolean runtime = (Boolean)listShowParameter.getCustomParam(RUNTIME);
        if (runtime == null) {
            runtime = Boolean.TRUE;
        }
        String currentNodeId = (String)e.getNodeId();
        TreeNode currentNode = this.getTreeModel().getRoot().getTreeNode(currentNodeId, 5);
        String leafType = (String)currentNode.getData();
        ArrayList<String> appList = new ArrayList<String>();
        ArrayList<String> list = new ArrayList<String>();
        if ("cloud".equals(leafType)) {
            List appNodeList = currentNode.getChildren();
            if (appNodeList.size() > 0) {
                DynamicObject[] objs;
                for (TreeNode treeNode : appNodeList) {
                    String appId = treeNode.getId();
                    appList.add(appId);
                    list.add(appId);
                }
                if (runtime != null && runtime.booleanValue() && (objs = BusinessDataServiceHelper.load((String)BOS_DEVPORTAL_BIZAPP, (String)"id", (QFilter[])new QFilter[]{new QFilter(MASTERID, "in", list)})).length > 0) {
                    for (DynamicObject dynamicObject : objs) {
                        appList.add(dynamicObject.getString("id"));
                    }
                }
            }
        } else {
            QFilter[] filters;
            DynamicObject[] objs;
            if ("root".equals(leafType) && this.getTreeModel().getRoot().getChildren() != null && this.getTreeModel().getRoot().getChildren().size() > 0 && ((TreeNode)this.getTreeModel().getRoot().getChildren().get(0)).getChildren().size() > 0) {
                currentNodeId = ((TreeNode)((TreeNode)this.getTreeModel().getRoot().getChildren().get(0)).getChildren().get(0)).getId();
            }
            appList.add(currentNodeId);
            if (runtime != null && runtime.booleanValue() && (objs = BusinessDataServiceHelper.load((String)BOS_DEVPORTAL_BIZAPP, (String)"id", (QFilter[])(filters = new QFilter[]{new QFilter(MASTERID, "=", (Object)currentNodeId)}))).length > 0) {
                for (DynamicObject dynamicObject : objs) {
                    appList.add(dynamicObject.getString("id"));
                }
            }
        }
        QFilter q1 = new QFilter(BIZAPPID, "in", appList);
        e.addQFilter(q1);
        e.setCancel(true);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        Boolean runtime = Boolean.TRUE;
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.getCustomParam(RUNTIME) != null) {
            runtime = (Boolean)listShowParameter.getCustomParam(RUNTIME);
        }
        args.setListDataProvider((IListDataProvider)new FormListDataProvider(runtime, (IListView)this.getView(), (String)listShowParameter.getCustomParam(SCENCE)));
    }

    private static Map<String, Object> getFormListInfo(QFilter[] filters, String industryId, boolean isRuntime, String orderBy, int pageIndex, int limit) {
        QFilter mstEmpty;
        QFilter mstNotNUll;
        QFilter[] mstfilters;
        Map appExtends;
        HashMap<String, Object> rt = new HashMap<String, Object>();
        filters = FormTreeListPlugin.buildQueryFilters(filters, industryId, isRuntime);
        rt.put("datacount", 0);
        DynamicObjectType type = EntityMetadataCache.getSubDataEntityType((String)BOS_FOEMMETA, Arrays.asList("id,name,number,type,modeltype,bizappid".split(",")));
        DynamicObjectCollection col = new DynamicObjectCollection(type, null);
        DynamicObject[] formArray = BusinessDataServiceHelper.load((String)BOS_FOEMMETA, (String)"id,name,number,type,modeltype,bizappid", (QFilter[])filters, (String)orderBy, (int)pageIndex, (int)limit);
        HashSet<String> extendedFormPks = new HashSet<String>();
        if (isRuntime && (appExtends = BusinessDataServiceHelper.loadFromCache((String)BOS_FOEMMETA, (String)"masterid,visible", (QFilter[])(mstfilters = new QFilter[]{mstNotNUll = new QFilter(MASTERID, "is not null", (Object)Boolean.TRUE), mstEmpty = new QFilter(MASTERID, "!=", (Object)" ")}))).size() > 0) {
            for (DynamicObject obj : appExtends.values()) {
                String masterStr = obj.getString(MASTERID);
                extendedFormPks.add(masterStr);
            }
        }
        if (formArray != null) {
            for (DynamicObject obj : formArray) {
                String id = obj.getString("id");
                String formNum = obj.getString(NUMBER);
                String modelType = obj.getString("modeltype");
                if (isRuntime && !"PrintModel".equals(modelType) && extendedFormPks.contains(id)) {
                    try {
                        FormConfig cfg = FormMetadataCache.getFormConfig((String)formNum);
                        if (cfg != null) {
                            obj.set("name", (Object)cfg.getCaption());
                        }
                    }
                    catch (Exception e) {
                        log.error(String.format("\u83b7\u53d6\u8868\u5355\uff1a%s \u8fd0\u884c\u65f6\u540d\u79f0\u5931\u8d25\uff0c\u4e34\u65f6\u4f7f\u7528\u8bbe\u8ba1\u65f6\u540d\u79f0\u4ee3\u66ff\uff0c\u8bf7\u524d\u5f80\u8bbe\u8ba1\u5668\u8c03\u6574\u8bbe\u8ba1\u65f6\u540e\u91cd\u65b0\u8bbf\u95ee", formNum), (Throwable)e);
                    }
                }
                col.add((Object)obj);
            }
        }
        rt.put("data", col);
        return rt;
    }

    private static QFilter[] buildQueryFilters(QFilter[] filters, String industryId, boolean isRuntime) {
        QFilter filter;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        if (StringUtils.isNotBlank((CharSequence)industryId)) {
            filter = new QFilter(INDUSTRY, "=", (Object)industryId);
            filter.or(new QFilter(INDUSTRY, "=", (Object)0));
            filterList.add(filter);
        }
        if (isRuntime) {
            filter = new QFilter("type", "!=", (Object)"2");
            filterList.add(filter);
        }
        if (filters != null) {
            for (QFilter f : filters) {
                filterList.add(f);
            }
        }
        if (filterList.size() > 0) {
            filters = filterList.toArray(new QFilter[filterList.size()]);
        }
        return filters;
    }

    static class FormListDataProvider
    extends ListDataProvider {
        private QueryResult queryResult = null;
        private boolean runtime = true;
        private IListView listView = null;
        private String scence = null;

        public QueryResult getQueryResult() {
            return this.queryResult;
        }

        public void setQueryResult(QueryResult queryResult) {
            this.queryResult = queryResult;
        }

        public FormListDataProvider(boolean runtime, IListView listView, String scence) {
            this.runtime = runtime;
            this.listView = listView;
            this.scence = scence;
        }

        private QFilter[] buildFilters() {
            QFilter[] filters = null;
            List qFilters = this.getQFilters();
            if (FormTreeListPlugin.SELECTMAINPAGEINAPP.equals(this.scence)) {
                QFilter mainPageFilter = new QFilter("inheritpath", "like", (Object)"%ccd20bac000001ac%");
                mainPageFilter.or(new QFilter("inheritpath", "like", (Object)"%/8T+06O/GOEH%"));
                qFilters.add(mainPageFilter);
            }
            if (qFilters.size() > 0) {
                filters = qFilters.toArray(new QFilter[qFilters.size()]);
                filters = service.getFormBlacklistFilters(filters, FormTreeListPlugin.NUMBER);
            }
            return filters;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            QFilter[] filters = this.buildFilters();
            this.queryResult = new QueryResult();
            this.queryResult.setDataCount(0);
            DynamicObjectCollection data = new DynamicObjectCollection((DynamicObjectType)this.getEntityType(), null);
            int pageIndex = start / limit;
            Map<String, Object> rtData = this.getFormData(filters, null, this.runtime, this.getQueryBuilder().getOrderBys(), pageIndex, limit);
            if (rtData != null && rtData.get("datacount") != null) {
                Integer dataCount = Integer.valueOf(rtData.get("datacount").toString());
                data = (DynamicObjectCollection)rtData.get("data");
                while (rtData != null && data.size() <= 0 && pageIndex + 1 > 1) {
                    IClientViewProxy proxy = (IClientViewProxy)this.listView.getService(IClientViewProxy.class);
                    AbstractGrid.GridState entryState = proxy.getEntryState("billlistap");
                    int currentPageIndex = entryState.getCurrentPageIndex() - 1;
                    entryState.setCurrentPageIndex(Integer.valueOf(currentPageIndex));
                    rtData = this.getFormData(filters, null, this.runtime, this.getQueryBuilder().getOrderBys(), currentPageIndex - 1, limit);
                    data = (DynamicObjectCollection)rtData.get("data");
                }
                this.queryResult.setDataCount(dataCount.intValue());
                this.queryResult.setCollection(data);
            }
            return data;
        }

        private Map<String, Object> getFormData(QFilter[] filters, String industryId, boolean isRuntime, String orderBy, int pageIndex, int limit) {
            Map rtData = FormTreeListPlugin.getFormListInfo(filters, null, this.runtime, orderBy, pageIndex, limit);
            return rtData;
        }
    }
}

