/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.devportal.business.hosting.ResultMessage;
import kd.bos.devportal.business.hosting.SVNCodeHostingServiceImpl;
import kd.bos.devportal.common.hosting.SVNFileInfo;
import kd.bos.devportal.common.hosting.SVNUtil;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.encrypt.Encrypters;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.FileUtils;

public class FormmetaDisplayPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(FormmetaDisplayPlugin.class);
    private static final String LOCALPATH = System.getProperty("java.io.tmpdir") + File.separator + "KINGDEEDOWNLOAD";
    private static final String TRACEID = RequestContext.get().getTraceId();
    private static final String SQLENTRYENTITY = "sqlentryentity";
    private static final int MAX_THREADS = 5;
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"FormmetaDisplayPlugin", (int)5);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"infoconfirm"});
    }

    public void afterCreateNewData(EventObject evt) {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
        String userName = (String)this.getView().getFormShowParameter().getCustomParam("username");
        String password = (String)this.getView().getFormShowParameter().getCustomParam("password");
        try {
            password = Encrypters.decode((String)password);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        JSONObject svnMsg = SVNUtil.getSVNMsgByAppId((String)bizAppId);
        String svnPath = svnMsg.getString("svnpath") + "/metadata";
        SVNCodeHostingServiceImpl service = new SVNCodeHostingServiceImpl();
        Map map = service.getSvnFileDir(svnPath, userName, password);
        Map resultMap = (Map)map.get(ResultMessage.RESULT.toString());
        List listInfo = (List)resultMap.get("svnfileinfos");
        int i = 0;
        DateFormat dtf = DateFormat.getDateTimeInstance();
        for (SVNFileInfo file : listInfo) {
            if (!file.getFileName().endsWith(".dym")) continue;
            String sourceNum = file.getFileName().split(".dym")[0];
            this.getModel().batchCreateNewEntryRow(SQLENTRYENTITY, 1);
            this.getModel().setValue("sourcenum", (Object)sourceNum, i);
            this.getModel().setValue("sourcename", (Object)file.getAuthor(), i);
            this.getModel().setValue("date1", (Object)file.getVersionDate(), i);
            this.getModel().setValue("date", (Object)dtf.format(file.getVersionDate()), i);
            ++i;
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "infoconfirm": {
                EntryGrid grid = (EntryGrid)this.getView().getControl(SQLENTRYENTITY);
                int[] rows = grid.getSelectRows();
                if (rows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u3002", (String)"FormmetaDisplayPlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    break;
                }
                long startTime = System.currentTimeMillis();
                HashMap<String, String> errorMap = new HashMap<String, String>();
                String userName = (String)this.getView().getFormShowParameter().getCustomParam("username");
                String password = (String)this.getView().getFormShowParameter().getCustomParam("password");
                try {
                    password = Encrypters.decode((String)password);
                }
                catch (Exception e) {
                    logger.info(e.getMessage());
                }
                long start = System.currentTimeMillis();
                this.updateSource(errorMap, userName, password);
                long end = System.currentTimeMillis();
                logger.debug("svn\u66f4\u65b0\u8868\u5355\u5143\u6570\u636e\uff0c\u603b\u5171\u8017\u65f6: " + (end - start) / 1000L + "s");
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("bos_devp_updateformmsg");
                parameter.setCustomParam("errormap", errorMap);
                parameter.setCustomParam("num", (Object)rows.length);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().getParentView().showForm(parameter);
                this.getView().sendFormAction(this.getView().getParentView());
                this.getView().close();
                long endTime = System.currentTimeMillis();
                break;
            }
        }
    }

    private void updateSource(Map<String, String> errorMap, String userName, String password) {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
        String appNum = (String)this.getView().getFormShowParameter().getCustomParam("bizappnumber");
        long start = System.currentTimeMillis();
        SVNCodeHostingServiceImpl service = new SVNCodeHostingServiceImpl();
        String appPath = LOCALPATH + File.separator + appNum;
        String filePath = appPath + File.separator + TRACEID;
        String metadataPath = filePath + "/metadata";
        String checkFilePath = FileUtils.cleanString((String)DevportalUtil.checkFilePath(metadataPath));
        File file = new File(checkFilePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        String svnPath = AppUtils.getSVNPathByAppId((String)bizAppId);
        service.checkoutAppMetadata(file, svnPath + "/metadata", null, userName, password);
        long end = System.currentTimeMillis();
        logger.debug("\u62c9\u53d6svn\u8d44\u6e90\u5b8c\u6210,\u8017\u65f6: " + (end - start) / 1000L + "s");
        this.getPageCache().put("apppath", appPath);
        this.getPageCache().put("traceidpath", metadataPath);
        EntryGrid grid = (EntryGrid)this.getView().getControl(SQLENTRYENTITY);
        int[] rows = grid.getSelectRows();
        ArrayList<String> list = new ArrayList<String>(rows.length);
        for (int row : rows) {
            String string = (String)this.getModel().getValue("sourcenum", row);
            list.add(string);
        }
        List<Object> lists = new ArrayList<ArrayList<String>>(10);
        int size = list.size() / 4;
        if (size < 1) {
            lists.add(list);
        } else {
            lists = this.splitList(list, size);
        }
        if (lists != null) {
            CountDownLatch countDownLatch = new CountDownLatch(lists.size());
            for (List list2 : lists) {
                threadPool.execute((Runnable)new Worker(countDownLatch, list2, metadataPath, errorMap));
            }
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                logger.error("svn\u66f4\u65b0\u5143\u6570\u636e\u5f02\u5e38");
            }
        }
        this.delete(new File(FileUtils.cleanString((String)appPath)));
    }

    private List<List<String>> splitList(List<String> datas, int splitSize) {
        if (datas == null || splitSize < 1) {
            return null;
        }
        int totalSize = datas.size();
        int count = totalSize % splitSize == 0 ? totalSize / splitSize : totalSize / splitSize + 1;
        ArrayList<List<String>> rows = new ArrayList<List<String>>(10);
        for (int i = 0; i < count; ++i) {
            List<String> cols = datas.subList(i * splitSize, i == count - 1 ? totalSize : splitSize * (i + 1));
            rows.add(cols);
        }
        return rows;
    }

    private void readAndDeployFormMetadata(String filePath, String sourceNum, Map<String, String> errorMap) {
        String path = FileUtils.cleanString((String)filePath);
        File file = new File(path);
        String checkFilePath = FileUtils.cleanString((String)DevportalUtil.checkFilePath(filePath));
        Path zipPath = Paths.get(checkFilePath, new String[0]);
        try (InputStream in = Files.newInputStream(zipPath, new OpenOption[0]);){
            Long filelength = file.length();
            byte[] fileByte = new byte[filelength.intValue()];
            int count = 0;
            String fileContent = "";
            while ((count = in.read(fileByte)) > 0) {
                fileContent = new String(fileByte, StandardCharsets.UTF_8);
            }
            MetadataDao.deployMetadata((String)fileContent);
        }
        catch (Exception e) {
            String errorInfo = errorMap.get(sourceNum);
            if (errorInfo != null) {
                String message = errorInfo + "\n" + e.getMessage();
                errorMap.put(sourceNum, message);
            }
            errorMap.put(sourceNum, e.getMessage());
        }
    }

    private void delete(File file) {
        boolean fileDelete;
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                this.delete(f);
            }
        }
        if (fileDelete = file.delete()) {
            logger.debug(file + "delete:" + fileDelete);
        }
    }

    class Worker
    implements Runnable {
        private final CountDownLatch countDownLatch;
        private final List<String> form;
        private final String metadataPath;
        private final Map<String, String> errorMap;

        Worker(CountDownLatch countDownLatch, List<String> form, String metadataPath, Map<String, String> errorMap) {
            this.countDownLatch = countDownLatch;
            this.form = form;
            this.metadataPath = metadataPath;
            this.errorMap = errorMap;
        }

        @Override
        public void run() {
            for (String form : this.form) {
                String dymPath = this.metadataPath + File.separator + form + ".dym";
                String dymLangPath = String.format("%s%s%s.zh_CN.dymx", this.metadataPath, File.separator, form);
                FormmetaDisplayPlugin.this.readAndDeployFormMetadata(dymPath, form, this.errorMap);
                FormmetaDisplayPlugin.this.readAndDeployFormMetadata(dymLangPath, form, this.errorMap);
                logger.debug("\u6b63\u5728\u90e8\u7f72 " + form + "\u6587\u4ef6");
            }
            this.countDownLatch.countDown();
        }
    }
}

