/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.entity.IFrameMessage;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Tab;
import kd.bos.form.control.IFrame;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.session.SessionKeys;

public class GitDiff
extends AbstractFormPlugin {
    private static final String ISSAVE = "issave";
    private static final String TOOLBARAP1 = "toolbarap1";
    private static final String KEY_UPDATETOLOCALE = "updatetolocale";

    public void initialize() {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        String type;
        String scene;
        this.getPageCache().put(ISSAVE, "false");
        String urlParams = this.getUrlParams();
        urlParams = this.getKdcdUrl(urlParams);
        IFrame iframe = (IFrame)this.getView().getControl("iframeap");
        iframe.setSrc("devtools/built-compare/gitResolve.html?" + urlParams);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Boolean compare = (Boolean)parameter.getCustomParam("compare");
        if (compare != null && compare.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"toolbarap"});
        }
        if ("app".equals(scene = (String)parameter.getCustomParam("scene"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{TOOLBARAP1});
            type = (String)parameter.getCustomParam("type");
            if ("card".equals(type) || "script".equals(type)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"saveall"});
            }
        } else if ("cloud".equals(scene)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TOOLBARAP1, KEY_UPDATETOLOCALE, "allupdate"});
        } else {
            type = (String)parameter.getCustomParam("type");
            if (!"page".equals(type)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"allsubmit"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"allupdate"});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{TOOLBARAP1});
        }
        type = (String)parameter.getCustomParam("type");
        if ("cloud".equals(type)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"toolbarap"});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "updatetolocale": {
                this.updateToLocale();
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.getView().returnDataToParent((Object)this.getPageCache().get(ISSAVE));
        this.getPageCache().remove(ISSAVE);
    }

    private void updateToLocale() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5c06\u53f3\u4fa7\u5185\u5bb9\u66f4\u65b0\u5230\u672c\u5730\u5417?", (String)"GitDiff_0", (String)"bos-devportal-plugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("updateToLocaleCallBack"));
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        if (MessageBoxResult.Yes.equals((Object)mbce.getResult())) {
            String callBackId;
            switch (callBackId = mbce.getCallBackId()) {
                case "updateToLocaleCallBack": {
                    this.postMessageToIframe("", KEY_UPDATETOLOCALE);
                    break;
                }
            }
        }
    }

    private void postMessageToIframe(String content, String type) {
        IFrame iframe = (IFrame)this.getView().getControl("iframeap");
        String scene = (String)this.getView().getFormShowParameter().getCustomParam("scene");
        IFrameMessage msg = new IFrameMessage();
        if ("app".equals(scene)) {
            Tab tab = (Tab)this.getView().getParentView().getControl("tabap");
            String currenTab = tab.getCurrentTab();
            msg.setContent((Object)currenTab);
        } else {
            msg.setContent((Object)content);
        }
        String urlParams = this.getUrlParams();
        urlParams = this.getKdcdUrl(urlParams);
        msg.setOrigin(RequestContext.get().getClientFullContextPath() + "devtools/built-compare/gitResolve.html?" + urlParams);
        msg.setType(type);
        iframe.postMessage(msg);
        this.getPageCache().put(ISSAVE, "true");
    }

    private String getUrlParams() {
        String uuid = Uuid8.generateShortUuid();
        String projectURL = (String)this.getView().getFormShowParameter().getCustomParam("projecturl");
        String gitRepository = (String)this.getView().getFormShowParameter().getCustomParam("gitrepository");
        String personalGitRepository = (String)this.getView().getFormShowParameter().getCustomParam("personalgitrepository");
        String filePath = (String)this.getView().getFormShowParameter().getCustomParam("filepath");
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        String id = (String)this.getView().getFormShowParameter().getCustomParam("id");
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
        String pageId = this.getView().getPageId();
        Boolean isSave = (Boolean)this.getView().getFormShowParameter().getCustomParam(ISSAVE);
        return "uuid#" + uuid + "&pageid#" + pageId + "&projecturl#" + projectURL + "&gitrepository#" + gitRepository + "&personalgitrepository#" + personalGitRepository + "&filepath#" + filePath + "&id#" + id + "&bizappid#" + bizAppId + "&type#" + type + "&issave#" + isSave;
    }

    private String getKdcdUrl(String path) {
        return SessionKeys.isAccountSession((String)RequestContext.get().getTenantId()) ? path + "&kdcdc#" + RequestContext.get().getAccountId() : path;
    }
}

