/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.util.GitOperateUtil;

public class GitImportPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String TREEVIEWAP = "treeviewap";
    private static final String BTNOK = "btnok";
    private static final String BIZAPPID = "bizappid";
    private static final String NUMBER = "number";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String PAGE = "_page";
    private static final String SCRIPT = "_script";
    private static final String TXT_SCRIPTNUMBER = "txt_scriptnumber";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEWAP);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{BTNOK});
    }

    public void afterCreateNewData(EventObject e) {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        TreeNode root = this.renderMenuTree(bizAppId);
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEWAP);
        treeView.addNode(root);
        treeView.treeNodeClick("", root.getId());
        TreeNode node = root.getTreeNode(bizAppId, 5);
        treeView.setMulti(true);
        treeView.showNode(node.getId());
    }

    private TreeNode renderMenuTree(String bizAppId) {
        TreeNode node = this.renderRoot(bizAppId);
        List<TreeNode> nodeList = this.getNodeList(bizAppId);
        node.addChildren(nodeList);
        return node;
    }

    private TreeNode renderRoot(String bizAppId) {
        String appName = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false).getName().getLocaleValue();
        TreeNode root = new TreeNode();
        root.setText(appName);
        root.setId(bizAppId);
        root.setParentid("");
        root.setIsOpened(true);
        return root;
    }

    private List<TreeNode> getNodeList(String bizAppId) {
        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        List functionPackets = appMetadata.getAppFunctionPackets();
        ArrayList<TreeNode> functions = new ArrayList<TreeNode>(functionPackets.size());
        Set<String> pages = this.getPages();
        Set<String> scripts = this.getScripts();
        for (AppFunctionPacketElement functionPacket : functionPackets) {
            TreeNode func = new TreeNode();
            String name = (String)functionPacket.getName().getDefaultItem();
            String id = functionPacket.getId();
            String number = functionPacket.getNumber();
            func.setId(id);
            func.setText(name);
            func.setParentid(bizAppId);
            func.setData((Object)number);
            func.setIsOpened(false);
            functions.add(func);
            TreeNode formNode = new TreeNode();
            formNode.setText(ResManager.loadKDString((String)"\u9875\u9762", (String)"BizAppTreePlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            formNode.setId(id + PAGE);
            formNode.setParentid(id);
            formNode.setIsOpened(false);
            func.addChild(formNode);
            QFilter qFilter = new QFilter("bizunit", "=", (Object)id);
            QFilter qFilter1 = new QFilter("bizapp", "=", (Object)bizAppId);
            QFilter[] qFilters = new QFilter[]{qFilter, qFilter1};
            String unitrelformFields = "bizapp, bizunit, form";
            String formFields = "id,number,name,type,parentid";
            try (DataSet unitFormDataSet = QueryServiceHelper.queryDataSet((String)"bos_devportal_unitrelform", (String)"bos_devportal_unitrelform", (String)unitrelformFields, (QFilter[])qFilters, (String)"form asc");
                 DataSet formDataSet = QueryServiceHelper.queryDataSet((String)"bos_formmeta", (String)"bos_formmeta", (String)formFields, null, (String)"number asc");
                 DataSet result = unitFormDataSet.join(formDataSet, JoinType.INNER).on("form", "id").select(new String[]{"bizunit", "form"}, new String[]{"id", NUMBER, "name", "type", "parentid"}).finish();){
                for (Row row : result) {
                    if (pages.add(row.getString(NUMBER))) {
                        pages.remove(row.getString(NUMBER));
                        continue;
                    }
                    TreeNode pageNode = new TreeNode();
                    pageNode.setId(row.getString("id"));
                    pageNode.setText(row.getString("name"));
                    pageNode.setParentid(id + PAGE);
                    pageNode.setData((Object)row.getString(NUMBER));
                    this.getPageCache().put(row.getString("id"), row.getString(NUMBER));
                    pageNode.setIsOpened(false);
                    formNode.addChild(pageNode);
                }
            }
            TreeNode scriptNode = new TreeNode();
            scriptNode.setId(id + SCRIPT);
            scriptNode.setText(ResManager.loadKDString((String)"\u811a\u672c", (String)"BizAppTreePlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            scriptNode.setParentid(bizAppId);
            scriptNode.setIsOpened(false);
            func.addChild(scriptNode);
            String scriptFields = "id, txt_scriptnumber, txt_scriptname";
            QFilter scriptQFilter = new QFilter(BIZAPPID, "=", (Object)bizAppId);
            QFilter scriptQFilter2 = new QFilter("bizunitid", "=", (Object)id);
            QFilter[] qFilters1 = new QFilter[]{scriptQFilter, scriptQFilter2};
            DynamicObjectCollection scriptResult = QueryServiceHelper.query((String)"ide_pluginscript", (String)scriptFields, (QFilter[])qFilters1, (String)TXT_SCRIPTNUMBER);
            for (DynamicObject script : scriptResult) {
                if (scripts.add(script.getString(TXT_SCRIPTNUMBER))) {
                    scripts.remove(script.getString(TXT_SCRIPTNUMBER));
                    continue;
                }
                TreeNode scNode = new TreeNode();
                scNode.setId(script.getString("id"));
                scNode.setText(script.getString("txt_scriptname"));
                scNode.setParentid(id + SCRIPT);
                scNode.setData((Object)script.getString(TXT_SCRIPTNUMBER));
                this.getPageCache().put(script.getString("id"), script.getString(TXT_SCRIPTNUMBER));
                scNode.setIsOpened(false);
                scriptNode.addChild(scNode);
            }
        }
        return functions;
    }

    private Set<String> getPages() {
        File[] files;
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        String path = GitOperateUtil.getPath((String)bizAppId);
        HashSet<String> pageList = new HashSet<String>(10);
        File file = new File(path);
        for (File f : files = file.listFiles()) {
            String fileName;
            if (f.isDirectory() || !(fileName = f.getName()).endsWith("dym")) continue;
            String[] dymName = fileName.split("\\.");
            pageList.add(dymName[0]);
        }
        return pageList;
    }

    private Set<String> getScripts() {
        File[] files;
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        String path = GitOperateUtil.getPath((String)bizAppId);
        HashSet<String> scriptList = new HashSet<String>(10);
        File file = new File(path);
        for (File f : files = file.listFiles()) {
            String fileName;
            if (f.isDirectory() || !(fileName = f.getName()).endsWith("ks")) continue;
            String[] ksName = fileName.split("\\.");
            scriptList.add(ksName[0]);
        }
        return scriptList;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btnok": {
                this.btnOK();
                break;
            }
        }
    }

    private void btnOK() {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            this.getView().showTipNotification(DevportalUtil.getNoPermissionTip());
            return;
        }
        JSONObject msg = new JSONObject();
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEWAP);
        List selectNodes = tree.getTreeState().getSelectedNodes();
        HashMap<String, String> pageIds = new HashMap<String, String>();
        HashMap<String, String> scriptIds = new HashMap<String, String>();
        ArrayList<String> unitTestIds = new ArrayList<String>();
        boolean checkinappFlag = (Boolean)this.getModel().getValue("appresource");
        if (selectNodes.isEmpty() && !checkinappFlag) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u5143\u6570\u636e\u3002", (String)"BizAppTreePlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        for (Map selectNode : selectNodes) {
            String parentid = (String)selectNode.get("parentid");
            String bizId = (String)selectNode.get("id");
            String[] s = parentid.split("_");
            if (parentid.endsWith(PAGE)) {
                String bizNumber = this.getPageCache().get(bizId);
                pageIds.put(bizNumber, s[0]);
                continue;
            }
            if (parentid.endsWith(SCRIPT)) {
                String scriptNumber = this.getPageCache().get(bizId);
                scriptIds.put(scriptNumber, s[0]);
                continue;
            }
            if (!parentid.endsWith("_unittest")) continue;
            unitTestIds.add(bizId);
        }
        msg.put("pageids", (Object)SerializationUtils.toJsonString(pageIds));
        msg.put("scriptids", (Object)SerializationUtils.toJsonString(scriptIds));
        msg.put("unittestids", (Object)SerializationUtils.toJsonString(unitTestIds));
        msg.put("checkinappflag", (Object)checkinappFlag);
        msg.put(BIZAPPID, (Object)bizAppId);
        this.getView().returnDataToParent((Object)msg.toJSONString());
        this.getView().close();
    }
}

