/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import com.tongtech.backport.java.util.Arrays;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.sqlscript.KSQLDataType;

public class KSQLExpDataPlugin
extends AbstractFormPlugin {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private BigDecimal ZERO = new BigDecimal("0.00");
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final int limitCnt = 100;

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void createNewData(BizDataEventArgs e) {
    }

    private String[] getFieldNames() {
        String fields = (String)this.getView().getFormShowParameter().getCustomParam("fields");
        if (StringUtils.isEmpty((CharSequence)fields)) {
            return new String[0];
        }
        String[] fieldNames = fields.split(",");
        if (fieldNames != null) {
            String[] newfieldNames = new String[fieldNames.length];
            for (int i = 0; i < fieldNames.length; ++i) {
                if (fieldNames[i] == null) continue;
                newfieldNames[i] = fieldNames[i].toUpperCase(Locale.ENGLISH);
            }
            fieldNames = newfieldNames;
        }
        return fieldNames;
    }

    public void beforeBindData(EventObject e) {
        String fields = (String)this.getView().getFormShowParameter().getCustomParam("fields");
        EntryAp dynamicEntryAp = this.createDynamicEntryAp(fields);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        List fieldEdits = ((Container)dynamicEntryAp.buildRuntimeControl()).getItems();
        for (Control fieldEdit : fieldEdits) {
            fieldEdit.setView(this.getView());
            entryGrid.getItems().add(fieldEdit);
        }
    }

    public void afterBindData(EventObject e) {
        this.getModel().deleteEntryData(KEY_ENTRYENTITY);
        String executorsql = (String)this.getView().getFormShowParameter().getCustomParam("executorsql");
        String routefield = (String)this.getView().getFormShowParameter().getCustomParam("routefield");
        String[] fieldNames = this.getFieldNames();
        if (StringUtils.isEmpty((CharSequence)executorsql) || StringUtils.isEmpty((CharSequence)routefield) || fieldNames == null || fieldNames.length == 0) {
            return;
        }
        try {
            List dataList = (List)DB.query((DBRoute)DBRoute.of((String)routefield), (String)executorsql, rs -> {
                ArrayList list = new ArrayList(8);
                HashMap<String, Integer> colTypes = new HashMap<String, Integer>(8);
                ResultSetMetaData resultSetMetaData = rs.getMetaData();
                int fieldCount = resultSetMetaData.getColumnCount();
                for (int i = 1; i <= fieldCount; ++i) {
                    String fieldName = resultSetMetaData.getColumnName(i);
                    int colType = resultSetMetaData.getColumnType(i);
                    String colTypeName = resultSetMetaData.getColumnTypeName(i);
                    if (colType == 2 && "NUMBER".equals(colTypeName) && resultSetMetaData.getScale(i) == 0) {
                        int precision = resultSetMetaData.getPrecision(i);
                        if (precision > 10 && precision <= 19) {
                            colType = 11;
                        } else if (precision <= 10) {
                            colType = 9;
                        }
                    } else {
                        colType = colType == 12 && "text".equals(resultSetMetaData.getColumnTypeName(i)) ? 8 : KSQLDataType.javaSqlType2KSQLDataType((int)colType);
                    }
                    colTypes.put(fieldName.toUpperCase(Locale.ENGLISH), colType);
                }
                DBType dbtype = DB.getDBType((DBRoute)DBRoute.of((String)routefield));
                int cnt = 0;
                while (rs.next()) {
                    if (++cnt >= 100) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u81f3\u591a\u67e5\u8be2100\u6761\u6570\u636e\uff0c\u8bf7\u8c03\u6574\u67e5\u8be2\u6761\u4ef6\u3002", (String)"KSQLExpDataPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                    }
                    HashMap<String, Object> row = new HashMap<String, Object>(fieldNames.length);
                    for (String fieldName : fieldNames) {
                        Object objVal = this.getObject(dbtype, rs, colTypes, fieldName);
                        row.put(fieldName, objVal);
                    }
                    list.add(row);
                }
                return list;
            });
            if (!dataList.isEmpty()) {
                this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, dataList.size());
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
                for (int i = 0; i < dataList.size(); ++i) {
                    Map objects = (Map)dataList.get(i);
                    DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                    for (Map.Entry entry : objects.entrySet()) {
                        dynamicObject.set((String)entry.getKey(), entry.getValue());
                    }
                }
            }
        }
        catch (KDException exception) {
            if (exception.getCause() instanceof SQLException && exception.getCause().getCause() instanceof KDBizException) {
                this.getView().showTipNotification(exception.getCause().getCause().getMessage());
                return;
            }
            throw exception;
        }
        finally {
            this.getView().updateView(KEY_ENTRYENTITY);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getObject(DBType dbtype, ResultSet rs, Map<String, Integer> colTypes, String fieldName) throws SQLException {
        Integer colType;
        boolean isNull;
        Object objVal = rs.getObject(fieldName);
        boolean bl = isNull = objVal == null;
        if (isNull) {
            objVal = "NULL";
        }
        if ((colType = colTypes.get(fieldName)) == 14 && this.ZERO.equals(rs.getBigDecimal(fieldName))) {
            return "0.00";
        }
        if (colType == 15) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%1$s\u7c7b\u578b\u4e3a%2$s\uff0c\u4e0d\u652f\u6301\u7f16\u8f91\uff0c\u8bf7\u4f7f\u7528KSQL\u751f\u6210\u811a\u672c\u65b9\u5f0f\u3002", (String)"KSQLExpDataPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), fieldName, "XMLTYPE"));
        }
        if (colType == 8 || colType == 7) {
            Object clob = null;
            clob = dbtype == DBType.DM ? rs.getString(fieldName) : rs.getObject(fieldName);
            if (clob != null && clob.toString().length() >= 1000) throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%1$s\u7c7b\u578b\u4e3a%2$s\uff0c\u6570\u636e\u8fc7\u957f\u4e0d\u652f\u6301\u7f16\u8f91\uff0c\u8bf7\u4f7f\u7528KSQL\u751f\u6210\u811a\u672c\u65b9\u5f0f\u3002", (String)"KSQLExpDataPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), fieldName, "CLOB"));
            String value = clob == null ? "" : clob.toString();
            value = value.replace("'", "''");
            if (value.length() != 0) return value;
            return " ";
        }
        if (colType == 6) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%1$s\u7c7b\u578b\u4e3a%2$s\uff0c\u4e0d\u652f\u6301\u7f16\u8f91\uff0c\u8bf7\u4f7f\u7528KSQL\u751f\u6210\u811a\u672c\u65b9\u5f0f\u3002", (String)"KSQLExpDataPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), fieldName, "BLOB"));
        }
        if (colType != 12) return objVal;
        Date objValue = rs.getDate(fieldName);
        if (objValue == null) return "NULL";
        SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss", Locale.getDefault());
        String value = sFormat.format(objValue);
        return value;
    }

    public void onGetControl(OnGetControlArgs e) {
        HashSet hashSet = new HashSet(Arrays.asList((Object[])this.getFieldNames()));
        if (hashSet.contains(e.getKey().toUpperCase(Locale.ENGLISH))) {
            TextEdit textEdit = new TextEdit();
            textEdit.setKey(e.getKey());
            textEdit.setView(this.getView());
            e.setControl((Control)textEdit);
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        EntryAp entryAp = this.createDynamicEntryAp((String)formShowParameter.getCustomParam("fields"));
        HashMap<String, String> mapEntry = new HashMap<String, String>();
        mapEntry.put("id", KEY_ENTRYENTITY);
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        e.getItems().add(mapEntry);
    }

    private EntryAp createDynamicEntryAp(String fields) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey(KEY_ENTRYENTITY);
        if (StringUtils.isNotEmpty((CharSequence)fields)) {
            for (String filed : fields.split(",")) {
                EntryFieldAp fieldAp = new EntryFieldAp();
                fieldAp.setId(filed);
                fieldAp.setKey(filed);
                fieldAp.setName(new LocaleString(filed));
                fieldAp.setFireUpdEvt(true);
                TextField field = new TextField();
                field.setId(filed);
                field.setKey(filed);
                fieldAp.setField((Field)field);
                entryAp.getItems().add(fieldAp);
            }
        }
        return entryAp;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetas", exp.getMessage()), new Object[0]);
        }
        this.registDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    private void registDynamicProps(MainEntityType newMainType) {
        String[] fieldNames = this.getFieldNames();
        if (fieldNames == null || fieldNames.length == 0) {
            return;
        }
        EntryType entryType = (EntryType)newMainType.getAllEntities().get(KEY_ENTRYENTITY);
        for (String fieldName : fieldNames) {
            TextProp textProp2 = new TextProp();
            textProp2.setName(fieldName);
            textProp2.setDisplayName(new LocaleString(fieldName));
            textProp2.setDbIgnore(true);
            textProp2.setAlias("");
            entryType.registerSimpleProperty((DynamicSimpleProperty)textProp2);
        }
    }
}

