/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import java.util.EventObject;
import java.util.List;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.devportal.plugin.KSQLExpTable;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;

public class KSQLExpFieldsPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        DynamicObject data = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        DynamicObjectCollection rows = data.getDynamicObjectCollection("entryentity");
        String mainEntityId = (String)this.getView().getFormShowParameter().getCustomParam("mainentityid");
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityid");
        String parententityid = (String)this.getView().getFormShowParameter().getCustomParam("parententityid");
        KSQLExpTable ksqlExpTable = new KSQLExpTable(mainEntityId, parententityid, entityId);
        List<KSQLExpTable.Field> fields = ksqlExpTable.getFields();
        for (KSQLExpTable.Field fieldInfo : fields) {
            DynamicObject newRow = rows.addNew();
            newRow.set("fieldcomment", (Object)fieldInfo.getFieldComment());
            newRow.set("fieldname", (Object)fieldInfo.getFieldName());
            newRow.set("type", (Object)fieldInfo.getType());
            newRow.set("tablegroup", (Object)fieldInfo.getTableGroup());
        }
        e.setDataEntity((Object)data);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid entryentity = (EntryGrid)this.getView().getControl("entryentity");
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        if (rowCount > 0) {
            entryentity.selectRows(IntStream.range(0, rowCount).toArray(), 1);
        }
        this.getView().getPageCache().put("loadend", "true");
    }

    public void entryRowClick(RowClickEvent evt) {
        int rowCount;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == (rowCount = this.getModel().getEntryRowCount("entryentity"))) {
            this.getView().setFormTitle(new LocaleString((String)this.getView().getFormShowParameter().getCustomParam("caption")));
        } else {
            this.getView().setFormTitle(new LocaleString((String)this.getView().getFormShowParameter().getCustomParam("caption") + selectRows.length + "/" + rowCount));
        }
    }
}

