/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.FieldInfo;
import kd.bos.db.meta.MetaFactory;
import kd.bos.dc.api.model.DBObject;
import kd.bos.dc.mc.LoginMCService;
import kd.bos.devportal.plugin.KSQLExpTable;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.form.IFormController;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.sqlscript.BatchPreInsDataScriptBuilder;
import kd.bos.sqlscript.KSQLDataType;
import kd.bos.sqlscript.PreInsDataScriptBuilder;
import kd.bos.xdb.tablemanager.meta.Column;

public class KSQLExpNewPlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener {
    private static final String QUERY_DATA_PAGE_ID = "QueryDataPageId";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final Log log = LogFactory.getLog(KSQLExpNewPlugin.class);
    private static final String MAINOBJECT_PAGEIDS = "MAINOBJECT_PAGEIDS";
    private static final String SELECTIDS = "SELECTIDS";
    private static final String KSQLTEXT = "ksqltext";
    private BigDecimal ZERO = new BigDecimal("0.00");
    private static final String WHERE = " WHERE ";

    public void initialize() {
        this.addClickListeners(new String[]{"buttonap", "btn_exportsql", "btn_exportsqlprev"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"ids", "btnexportbase", "btn_querydata"});
        BasedataEdit exportobj = (BasedataEdit)this.getControl("exportobj");
        exportobj.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        ComboEdit ce = (ComboEdit)this.getControl("routefield");
        try {
            List dbInstanceList = LoginMCService.create().getDbInstanceList(RequestContext.get().getAccountId());
            if (dbInstanceList != null) {
                ArrayList<ComboItem> list = new ArrayList<ComboItem>(dbInstanceList.size());
                for (DBObject dbObject : dbInstanceList) {
                    ComboItem item = new ComboItem(new LocaleString(dbObject.getName()), dbObject.getNumber());
                    list.add(item);
                }
                ce.setComboItems(list);
            }
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
        }
        if (this.getCustomParam("exportbase") != null) {
            String pk = (String)this.getCustomParam("exportobj");
            BasedataProp property = (BasedataProp)this.getModel().getDataEntityType().getProperty("exportobj");
            IDataEntityType complexType = property.getComplexType();
            DynamicObject exportObj = BusinessDataReader.loadSingle((Object)pk, (DynamicObjectType)((DynamicObjectType)complexType));
            this.getModel().setValue("exportobj", (Object)exportObj);
            String selectIds = (String)this.getCustomParam("exportids");
            this.setSelectIds(selectIds);
        }
        this.getModel().putContextVariable("MODEL_BOSENTRYSERVERFILTERSORT", (Object)true);
    }

    private <T> T getCustomParam(String key) {
        return (T)this.getView().getFormShowParameter().getCustomParam(key);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.deleteTextClearButton("ids");
        if (this.getCustomParam("exportbase") != null) {
            this.doShowFields();
            Tab tab = (Tab)this.getControl("tabap");
            tab.activeTab("tabpagebyobject");
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabpagebytable"});
        }
        this.showBatchSize();
    }

    private void deleteTextClearButton(String buttonKey) {
        HashMap<String, Boolean> editor = new HashMap<String, Boolean>();
        HashMap<String, HashMap<String, Boolean>> item = new HashMap<String, HashMap<String, Boolean>>();
        editor.put("showClearButton", false);
        item.put("item", editor);
        this.getView().updateControlMetadata(buttonKey, item);
    }

    public void click(EventObject e) {
        Control control = (Control)e.getSource();
        switch (control.getKey()) {
            case "buttonap": {
                this.doButtonap();
                break;
            }
            case "ids": {
                this.doSelectIds();
                break;
            }
            case "btnexportbase": {
                this.doShowExportBase();
                break;
            }
            case "btn_exportsql": {
                this.doExportBySql();
                break;
            }
            case "btn_exportsqlprev": {
                this.doExportByPreview();
                break;
            }
            case "btn_querydata": {
                this.doQueryData();
                break;
            }
        }
    }

    private void doQueryData() {
        Tab tab = (Tab)this.getView().getControl("tabap");
        if ("tabpagebyobject".equals(tab.getCurrentTab())) {
            this.doQueryDataByObject();
        } else {
            this.doQueryDataBysql();
        }
    }

    private void doQueryDataBysql() {
        Map<String, Object> map = this.getSql();
        if (map == null || map.isEmpty()) {
            return;
        }
        String pageIdsInCache = this.getView().getPageCache().get(QUERY_DATA_PAGE_ID);
        if (StringUtils.isNotBlank((CharSequence)pageIdsInCache)) {
            this.closeTabClientAction(Arrays.asList(pageIdsInCache.split(",")));
        }
        String executorsql = (String)map.get("executorsql");
        String tablename = (String)map.get("tablename");
        String routefield = (String)this.getModel().getValue("routefield");
        String textareafield = (String)this.getModel().getValue("textareafield");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bos_exppreins_data");
        formShowParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        formShowParameter.getOpenStyle().setTargetKey("tabdata");
        formShowParameter.setParentFormId(this.getView().getFormShowParameter().getFormId());
        formShowParameter.setCustomParam("fields", (Object)textareafield);
        formShowParameter.setCustomParam("executorsql", (Object)executorsql);
        formShowParameter.setCustomParam("routefield", (Object)routefield);
        formShowParameter.setCustomParam("tablename", (Object)tablename);
        formShowParameter.setCaption(tablename);
        this.getView().showForm(formShowParameter);
        this.getView().getPageCache().put(QUERY_DATA_PAGE_ID, formShowParameter.getPageId());
    }

    private void doQueryDataByObject() {
        Map<String, Object> map = this.getSqlByObject();
        if (map == null || map.isEmpty()) {
            return;
        }
        String pageIdsInCache = this.getView().getPageCache().get(QUERY_DATA_PAGE_ID);
        if (StringUtils.isNotBlank((CharSequence)pageIdsInCache)) {
            this.closeTabClientAction(Arrays.asList(pageIdsInCache.split(",")));
        }
        List execSqlList = (List)map.get("execSqlList");
        List selectFieldsList = (List)map.get("selectFieldsList");
        List tables = (List)map.get("tables");
        String tablename = (String)map.get("tablename");
        String routefield = EntityMetadataCache.getDataEntityType((String)tablename).getDBRouteKey();
        StringBuilder pageIds = new StringBuilder();
        for (int i = 0; i < execSqlList.size(); ++i) {
            String executorsql = (String)execSqlList.get(i);
            String selectFields = (String)selectFieldsList.get(i);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bos_exppreins_data");
            formShowParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
            formShowParameter.getOpenStyle().setTargetKey("tabdata");
            formShowParameter.setParentFormId(this.getView().getFormShowParameter().getFormId());
            formShowParameter.setCustomParam("fields", (Object)selectFields);
            formShowParameter.setCustomParam("executorsql", (Object)executorsql);
            formShowParameter.setCustomParam("routefield", (Object)routefield);
            formShowParameter.setCustomParam("tablename", tables.get(i));
            formShowParameter.setCaption((String)tables.get(i));
            this.getView().showForm(formShowParameter);
            pageIds.append(formShowParameter.getPageId()).append(",");
        }
        this.getView().getPageCache().put(QUERY_DATA_PAGE_ID, pageIds.toString());
    }

    private void doButtonap() {
        Tab tab = (Tab)this.getView().getControl("tabap");
        if ("tabpagebyobject".equals(tab.getCurrentTab())) {
            this.execScriptByObject();
        } else {
            this.execScript();
        }
    }

    private void doExportByPreview() {
        String pageIdsInCache = this.getView().getPageCache().get(QUERY_DATA_PAGE_ID);
        if (StringUtils.isEmpty((CharSequence)pageIdsInCache)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u67e5\u8be2\u6570\u636e\u3002", (String)"KSQLExpNewPlugin_12", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String[] pageIds = pageIdsInCache.split(",");
        StringBuilder sqlList = new StringBuilder();
        for (String pageId : pageIds) {
            this.genInsertSQLByPreview(sqlList, pageId);
        }
        if (sqlList.length() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u5bfc\u51fa\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"KSQLExpNewPlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String sql = sqlList.toString();
        String tableName = (String)SessionManager.getCurrent().getViewNoPlugin(pageIds[0]).getFormShowParameter().getCustomParam("tablename");
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            String sqlFileName = (String)this.getModel().getValue("filename");
            if (StringUtils.isEmpty((CharSequence)sqlFileName)) {
                sqlFileName = String.format("%s_%s.sql", tableName, new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
            }
            try (ByteArrayInputStream ins = new ByteArrayInputStream(sql.getBytes(StandardCharsets.UTF_8));){
                this.exportFile(ins, sqlFileName);
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
            }
        }
    }

    private void doExportBySql() {
        CodeEdit codeSQLShow = (CodeEdit)this.getView().getControl(KSQLTEXT);
        String txt = codeSQLShow.getText();
        if (StringUtils.isEmpty((CharSequence)txt)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u751f\u6210\u811a\u672c\u3002", (String)"KSQLExpNewPlugin_13", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (!this.checkSql(txt)) {
            return;
        }
        Tab tab = (Tab)this.getView().getControl("tabap");
        Map<String, Object> map = "tabpagebyobject".equals(tab.getCurrentTab()) ? this.getSqlByObject() : this.getSql();
        if (map == null) {
            return;
        }
        String sql = (String)map.get("sql");
        Object xml = map.get("xml");
        String tableName = (String)map.get("tablename");
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            String sqlFileName = (String)this.getModel().getValue("filename");
            if (StringUtils.isEmpty((CharSequence)sqlFileName)) {
                sqlFileName = String.format("%s_%s.sql", tableName, new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
            }
            try {
                ByteArrayInputStream ins = new ByteArrayInputStream(sql.getBytes(StandardCharsets.UTF_8));
                Object object = null;
                try {
                    this.exportFile(ins, sqlFileName);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (ins != null) {
                        if (object != null) {
                            try {
                                ((InputStream)ins).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ((InputStream)ins).close();
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
            }
            if (xml != null) {
                HashMap longTextDataFile = (HashMap)xml;
                for (Map.Entry entry : longTextDataFile.entrySet()) {
                    StringWriter sw = (StringWriter)entry.getValue();
                    byte[] barray = sw.toString().getBytes(StandardCharsets.UTF_8);
                    try {
                        ByteArrayInputStream ins1 = new ByteArrayInputStream(barray);
                        Throwable throwable = null;
                        try {
                            this.exportFile(ins1, (String)entry.getKey());
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (ins1 == null) continue;
                            if (throwable != null) {
                                try {
                                    ((InputStream)ins1).close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                continue;
                            }
                            ((InputStream)ins1).close();
                        }
                    }
                    catch (Exception e) {
                        throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
                    }
                }
            }
        }
    }

    private boolean checkSql(String txt) {
        return true;
    }

    private void doShowExportBase() {
        String selectIds = this.getView().getPageCache().get(SELECTIDS);
        if (StringUtils.isBlank((CharSequence)selectIds)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u6570\u636e\u3002", (String)"KSQLExpNewPlugin_11", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        DynamicObject exportobj = (DynamicObject)this.getModel().getValue("exportobj");
        if (exportobj == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5bf9\u8c61\u3002", (String)"KSQLExpNewPlugin_10", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        KSQLExpTable ksqlExpTable = new KSQLExpTable(exportobj.getString("id"));
        Map<String, Set<Object>> baseDataIds = ksqlExpTable.getBaseDataIds(selectIds.split(","));
        String baseEntityId = (String)this.getModel().getValue("cmbbasedata");
        if (StringUtils.isBlank((CharSequence)baseEntityId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u5173\u57fa\u7840\u8d44\u6599\u3002", (String)"KSQLExpNewPlugin_14", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Set<Object> baseIds = baseDataIds.get(baseEntityId);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(this.getView().getFormShowParameter().getFormId());
        formShowParameter.setCustomParam("exportbase", (Object)"true");
        formShowParameter.setCustomParam("exportobj", (Object)baseEntityId);
        StringBuilder s = new StringBuilder();
        baseIds.forEach(o -> s.append(o.toString()).append(","));
        formShowParameter.setCustomParam("exportids", (Object)s.substring(0, s.length() - 1));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    private void doSelectIds() {
        DynamicObject exportobj = (DynamicObject)this.getModel().getValue("exportobj");
        if (exportobj == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5bf9\u8c61\u3002", (String)"KSQLExpNewPlugin_10", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String entityId = exportobj.getString("id");
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)entityId, (boolean)true, (int)2, (boolean)true);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectids"));
        String ids = this.getView().getPageCache().get(SELECTIDS);
        if (ids != null) {
            ids = ids.replace("'", "");
            listShowParameter.setSelectedRows((Object[])ids.split(","));
        }
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("selectids".equals(closedCallBackEvent.getActionId()) && closedCallBackEvent.getReturnData() != null) {
            StringBuilder s = new StringBuilder();
            ListSelectedRowCollection rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            boolean i = false;
            for (ListSelectedRow row : rows) {
                Object primaryKeyValue = row.getPrimaryKeyValue();
                if (primaryKeyValue instanceof Number) {
                    s.append(primaryKeyValue).append(",");
                    continue;
                }
                s.append("'").append(primaryKeyValue).append("',");
            }
            if (s.length() > 0) {
                this.setSelectIds(s.substring(0, s.length() - 1));
            }
        }
    }

    private void setSelectIds(String selectIds) {
        this.getPageCache().put(SELECTIDS, selectIds);
        this.getModel().setValue("ids", (Object)selectIds);
        DynamicObject exportobj = (DynamicObject)this.getModel().getValue("exportobj");
        KSQLExpTable ksqlExpTable = new KSQLExpTable(exportobj.getString("id"));
        Map<String, Set<Object>> mapBaseData = ksqlExpTable.getBaseDataIds(selectIds.split(","));
        ArrayList itemList = new ArrayList(16);
        mapBaseData.forEach((k, v) -> {
            MainEntityType baseDataEntityType = EntityMetadataCache.getDataEntityType((String)k);
            ComboItem comboItem = new ComboItem(new LocaleString(baseDataEntityType.getDisplayName().toString() + "(" + v.size() + ")"), baseDataEntityType.getName());
            itemList.add(comboItem);
        });
        ComboEdit comboEdit = (ComboEdit)this.getControl("cmbbasedata");
        comboEdit.setComboItems(itemList);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        switch (e.getProperty().getName()) {
            case "exportobj": {
                this.doShowFields();
                break;
            }
            case "genbatchsql": {
                this.showBatchSize();
                break;
            }
            case "routefield": {
                this.routefieldChange(e);
                break;
            }
            case "tablename": {
                this.tablenameChange(e);
                break;
            }
            case "exportmodel": {
                this.exportmodelChange(e);
                break;
            }
            case "bizapp": {
                this.bizappChange(e);
                break;
            }
            case "selectfield": {
                this.selectfieldChange(e);
            }
        }
    }

    private void selectfieldChange(PropertyChangedArgs e) {
        String textareafield = this.getSelectfieldStr();
        this.getModel().setValue("textareafield", (Object)textareafield);
    }

    private void bizappChange(PropertyChangedArgs e) {
        this.getModel().setValue("exportobj", (Object)"");
        this.getModel().setValue("ids", (Object)"");
    }

    private void exportmodelChange(PropertyChangedArgs e) {
        Tab tab = (Tab)this.getControl("tabap");
        ChangeData changeData = e.getChangeSet()[0];
        tab.selectTab((String)changeData.getNewValue());
        for (Control control : tab.getItems()) {
            if (!(control instanceof TabPage) || control.getKey().equals(changeData.getNewValue())) continue;
            this.getView().setEnable(Boolean.FALSE, new String[]{control.getKey()});
        }
        this.getView().updateView("tabap");
    }

    private void tablenameChange(PropertyChangedArgs e) {
        String tablename = (String)e.getChangeSet()[0].getNewValue();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(6);
        if (StringUtils.isNotEmpty((CharSequence)tablename)) {
            String routefield = (String)this.getModel().getValue("routefield");
            String dbRouteKey = routefield.trim();
            DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
            List columns = MetaFactory.getMeta((DBType)DB.getDBType((DBRoute)dbRoute)).queryColumns(dbRoute, tablename);
            for (int i = 0; i < columns.size(); ++i) {
                Column column = (Column)columns.get(i);
                ComboItem item = new ComboItem();
                item.setValue(column.getColumnName());
                item.setCaption(new LocaleString(column.getColumnName()));
                comboItems.add(item);
            }
        }
        ComboEdit selectfieldedit = (ComboEdit)this.getView().getControl("selectfield");
        selectfieldedit.setComboItems(comboItems);
        this.getModel().setValue("selectfield", (Object)"");
    }

    private void routefieldChange(PropertyChangedArgs e) {
        String dbRouteKey = (String)e.getChangeSet()[0].getNewValue();
        ComboEdit tablename = (ComboEdit)this.getView().getControl("tablename");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(6);
        if (StringUtils.isNotEmpty((CharSequence)dbRouteKey)) {
            dbRouteKey = dbRouteKey.trim();
            String sql = "SELECT KSQL_TABNAME FROM KSQL_USERTABLES order by KSQL_TABNAME";
            List tableList = (List)DB.query((DBRoute)DBRoute.of((String)dbRouteKey), (String)sql, resultSet -> {
                ArrayList<String> fids = new ArrayList<String>(resultSet.getFetchSize());
                while (resultSet.next()) {
                    String table = resultSet.getString(1);
                    if (!StringUtils.isNotBlank((CharSequence)table)) continue;
                    fids.add(resultSet.getString(1));
                }
                return fids;
            });
            for (String table : tableList) {
                ComboItem item = new ComboItem();
                item.setValue(table);
                item.setCaption(new LocaleString(table));
                comboItems.add(item);
            }
        }
        tablename.setComboItems(comboItems);
        this.getModel().setValue("tablename", null);
    }

    private void showBatchSize() {
        boolean genBatchSql = (Boolean)this.getModel().getValue("genbatchsql");
        this.getView().setVisible(Boolean.valueOf(genBatchSql), new String[]{"batchsize"});
    }

    private void closeTabClientAction(List<String> pageIds) {
        if (pageIds.isEmpty()) {
            return;
        }
        ArrayList tabListClose = new ArrayList(10);
        for (String pageId : pageIds) {
            if (!StringUtils.isNotBlank((CharSequence)pageId)) continue;
            HashMap<String, String> arg = new HashMap<String, String>();
            arg.put("pageId", pageId);
            tabListClose.add(arg);
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.addAction("closeWindow", tabListClose);
    }

    private void doShowFields() {
        DynamicObject exportobj = (DynamicObject)this.getModel().getValue("exportobj");
        if (exportobj == null) {
            return;
        }
        String entityId = exportobj.getString("id");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        String pageIdsInCache = this.getView().getPageCache().get(MAINOBJECT_PAGEIDS);
        if (StringUtils.isNotBlank((CharSequence)pageIdsInCache)) {
            this.closeTabClientAction(Arrays.asList(pageIdsInCache.split(",")));
        }
        StringBuilder pageIds = new StringBuilder();
        LinkedHashMap<String, IDataEntityType> allEntities = new LinkedHashMap<String, IDataEntityType>(16);
        allEntities.putAll(dataEntityType.getAllEntities());
        for (IDataEntityProperty property : dataEntityType.getProperties()) {
            if (!(property instanceof MulBasedataProp)) continue;
            allEntities.put(property.getName(), ((MulBasedataProp)property).getItemType());
        }
        allEntities.forEach((k, v) -> {
            String tableName = v.getAlias();
            if (StringUtils.isNotBlank((CharSequence)tableName)) {
                String caption = v.getDisplayName() == null ? dataEntityType.getProperty(v.getName()).getDisplayName().toString() : v.getDisplayName().toString();
                caption = caption + "\uff08" + tableName + "\uff09";
                String pageId = this.doShowTab(dataEntityType.getName(), v.getParent() == null ? "" : v.getParent().getName(), (String)k, caption);
                pageIds.append(pageId).append(",");
            }
            for (IDataEntityProperty property : v.getProperties()) {
                IDataEntityType itemType;
                if (!(property instanceof DynamicLocaleProperty) || !StringUtils.isNotBlank((CharSequence)(tableName = (itemType = ((DynamicLocaleProperty)property).getItemType()).getAlias()))) continue;
                String caption = property.getParent().getDisplayName().toString() + "\uff08" + tableName + "\uff09";
                String pageId = this.doShowTab(dataEntityType.getName(), v.getName(), property.getName(), caption);
                pageIds.append(pageId).append(",");
            }
        });
        if (pageIds.length() == 0) {
            this.getView().getPageCache().put(MAINOBJECT_PAGEIDS, "");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5bf9\u8c61\u6ca1\u6709\u7ef4\u62a4\u5b9e\u4f53\u8868\u540d\u3002", (String)"KSQLExpNewPlugin_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        this.getView().getPageCache().put(MAINOBJECT_PAGEIDS, pageIds.toString());
        this.getModel().setValue("ids", (Object)"");
        this.getView().getPageCache().put(SELECTIDS, null);
    }

    private String doShowTab(String mainEntityId, String parentEntityId, String entityPropId, String caption) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bos_exppreins_fields");
        formShowParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        formShowParameter.getOpenStyle().setTargetKey("tabfields");
        formShowParameter.setParentFormId(this.getView().getFormShowParameter().getFormId());
        formShowParameter.setCaption(caption);
        formShowParameter.setCustomParam("mainentityid", (Object)mainEntityId);
        formShowParameter.setCustomParam("parententityid", (Object)parentEntityId);
        formShowParameter.setCustomParam("entityid", (Object)entityPropId);
        formShowParameter.setCustomParam("caption", (Object)caption);
        this.getView().showForm(formShowParameter);
        return formShowParameter.getPageId();
    }

    private String getTableName(String tableName, String tableGroup) {
        if (StringUtils.isBlank((CharSequence)tableGroup)) {
            return tableName;
        }
        return tableName + "_" + tableGroup;
    }

    private void execScriptByObject() {
        boolean isAdmin = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId());
        if (!isAdmin) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u4f7f\u7528\u8be5\u529f\u80fd\u3002", (String)"KSQLExpNewPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Map<String, Object> map = this.getSqlByObject();
        if (map == null) {
            return;
        }
        String sqlList = (String)map.get("sql");
        CodeEdit codeSQLShow = (CodeEdit)this.getView().getControl(KSQLTEXT);
        if (sqlList.length() > 100000) {
            codeSQLShow.setText(String.format(ResManager.loadKDString((String)"\u811a\u672c\u592a\u5927\uff0c\u5c06\u88ab\u622a\u65ad\u5c55\u793a\uff0c\u5b8c\u6574\u811a\u672c\u5185\u5bb9\u53ef\u52fe\u9009\u3010\u4e0b\u8f7dSQL\u6587\u4ef6\u3011\u5bfc\u51fa\u540e\u67e5\u770b%1$s%2$s", (String)"KSQLExpNewPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), System.lineSeparator(), sqlList.substring(0, 100000)));
        } else {
            codeSQLShow.setText(sqlList);
        }
    }

    private Map<String, Object> getSqlByObject() {
        Object exportobj = this.getModel().getValue("exportobj");
        if (exportobj == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"KSQLExpNewPlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return null;
        }
        String mainPageIds = this.getView().getPageCache().get(MAINOBJECT_PAGEIDS);
        if (StringUtils.isBlank((CharSequence)mainPageIds)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u9700\u8981\u5bfc\u51fa\u7684\u8868\u3002", (String)"KSQLExpNewPlugin_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return null;
        }
        String selectIds = this.getView().getPageCache().get(SELECTIDS);
        if (StringUtils.isBlank((CharSequence)selectIds)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u4e00\u6761\u6570\u636e\u3002", (String)"KSQLExpNewPlugin_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return null;
        }
        StringBuilder sqlList = new StringBuilder();
        String[] pageIds = mainPageIds.split(",");
        ArrayList<String> execSqlList = new ArrayList<String>(6);
        ArrayList<String> selectFieldsList = new ArrayList<String>(6);
        ArrayList<String> tables = new ArrayList<String>(6);
        int count = 0;
        for (String pageId : pageIds) {
            boolean result = this.genInsertSQLByPageId(sqlList, pageId, execSqlList, selectFieldsList, tables);
            if (!result) continue;
            ++count;
        }
        if (count == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u9700\u8981\u5bfc\u51fa\u7684\u8868\u3002", (String)"KSQLExpNewPlugin_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return null;
        }
        if (sqlList.length() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u5bfc\u51fa\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"KSQLExpNewPlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        map.put("sql", sqlList.toString());
        Object id = ((DynamicObject)exportobj).get("id");
        map.put("tablename", String.valueOf(id));
        map.put("tables", tables);
        map.put("execSqlList", execSqlList);
        map.put("selectFieldsList", selectFieldsList);
        return map;
    }

    private boolean genInsertSQLByPageId(StringBuilder sqlList, String pageId, List<String> execSqlList, List<String> selectFieldsList, List<String> tables) {
        String ids;
        String where;
        IFormView view = SessionManager.getCurrent().getViewNoPlugin(pageId);
        if (view == null) {
            return false;
        }
        DynamicObject exportobj = (DynamicObject)this.getModel().getValue("exportobj");
        String mainEntityId = exportobj.getString("id");
        String entityId = (String)view.getFormShowParameter().getCustomParam("entityid");
        String parentEntityId = (String)view.getFormShowParameter().getCustomParam("parententityid");
        HashMap<String, StringBuilder> mapSelectField = new HashMap<String, StringBuilder>(16);
        KSQLExpTable ksqlExpTable = new KSQLExpTable(mainEntityId, parentEntityId, entityId);
        if (view.getPageCache().get("loadend") != null) {
            Iterator selectRows;
            EntryGrid entryentity = (EntryGrid)view.getControl("entryentity");
            for (Object selectRow : selectRows = (Iterator)entryentity.getSelectRows()) {
                String fieldname = (String)view.getModel().getValue("fieldname", (int)selectRow);
                String tableGroup = (String)view.getModel().getValue("tablegroup", (int)selectRow);
                StringBuilder selectFields = mapSelectField.computeIfAbsent(tableGroup, k -> new StringBuilder());
                selectFields.append(fieldname).append(",");
            }
        } else {
            List<KSQLExpTable.Field> fields = ksqlExpTable.getFields();
            for (KSQLExpTable.Field field : fields) {
                StringBuilder selectFields = mapSelectField.computeIfAbsent(field.getTableGroup() == null ? "" : field.getTableGroup(), k -> new StringBuilder());
                selectFields.append(field.getFieldName()).append(",");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(where = ksqlExpTable.getWhere(ids = this.getView().getPageCache().get(SELECTIDS))))) {
            for (Map.Entry kv : mapSelectField.entrySet()) {
                StringBuilder selectFields = (StringBuilder)kv.getValue();
                if (selectFields.length() <= 0) continue;
                selectFields.deleteCharAt(selectFields.length() - 1);
                String tableName = this.getTableName(ksqlExpTable.tableName(), (String)kv.getKey());
                Map<String, Object> map = this.genPreInsertSql(ksqlExpTable.getDbRouteKey(), tableName, selectFields.toString(), where, "", ksqlExpTable.getDbRouteKey() + " " + ksqlExpTable.tableName() + ids);
                String sql = (String)map.get("sql");
                sqlList.append(sql);
                execSqlList.add((String)map.get("executorsql"));
                selectFieldsList.add(selectFields.toString());
                tables.add(tableName);
            }
        }
        return true;
    }

    private void execScript() {
        boolean isAdmin = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId());
        if (!isAdmin) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u4f7f\u7528\u8be5\u529f\u80fd\u3002", (String)"KSQLExpNewPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Map<String, Object> map = this.getSql();
        String sql = (String)map.get("sql");
        if (sql == null) {
            return;
        }
        CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl(KSQLTEXT);
        boolean isEnable = true;
        if (sql.length() > 100000) {
            codeSQLshow.setText(String.format(ResManager.loadKDString((String)"\u811a\u672c\u592a\u5927\uff0c\u5c06\u88ab\u622a\u65ad\u3002%1$s%2$s", (String)"KSQLExpNewPlugin_16", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), System.lineSeparator(), sql.substring(0, 100000)));
            isEnable = Boolean.FALSE;
        } else {
            codeSQLshow.setText(sql);
        }
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{KSQLTEXT});
    }

    private Map<String, Object> getSql() {
        String textfield = (String)this.getModel().getValue("textfield");
        String routefield = (String)this.getModel().getValue("routefield");
        String tablename = (String)this.getModel().getValue("tablename");
        String wherefield = (String)this.getModel().getValue("wherefield");
        String orderfield = (String)this.getModel().getValue("orderfield");
        if (StringUtils.isBlank((CharSequence)routefield)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u5e93\u3002", (String)"KSQLExpNewPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return Collections.emptyMap();
        }
        routefield = routefield.trim();
        if (StringUtils.isBlank((CharSequence)tablename)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u8868\u540d\u3002", (String)"KSQLExpNewPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return Collections.emptyMap();
        }
        String textareafield = (String)this.getModel().getValue("textareafield");
        if (StringUtils.isBlank((CharSequence)textareafield)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u5b57\u6bb5\u540d\u3002", (String)"KSQLExpNewPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return Collections.emptyMap();
        }
        Map<String, Object> map = this.genPreInsertSql(routefield, tablename, textareafield, wherefield, orderfield, textfield);
        map.put("tablename", tablename);
        return map;
    }

    private String getSelectfieldStr() {
        String selectField = (String)this.getModel().getValue("selectfield");
        if (StringUtils.isNotEmpty((CharSequence)selectField)) {
            if (selectField.startsWith(",")) {
                selectField = selectField.substring(1);
            }
            if (selectField.endsWith(",")) {
                selectField = selectField.substring(0, selectField.length() - 1);
            }
        }
        return selectField;
    }

    private Map<String, Object> genPreInsertSql(String dbRouteKey, String tableName, String selectFields, String wherefield, String orderfield, String desc) {
        Map map;
        boolean genBatchSql = (Boolean)this.getModel().getValue("genbatchsql");
        int batchSize = (Integer)this.getModel().getValue("batchsize");
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        try {
            if (genBatchSql) {
                BatchPreInsDataScriptBuilder batchBuilder = new BatchPreInsDataScriptBuilder(batchSize);
                map = batchBuilder.genInsertSQLScript(DBRoute.of((String)dbRouteKey), tableName, selectFields, wherefield, orderfield, desc);
            } else {
                map = builder.genInsertSQLScript(DBRoute.of((String)dbRouteKey), tableName, selectFields, wherefield, orderfield, desc);
            }
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format("KSQLExpPlugin Error:%s.", e.getMessage())});
        }
        return map;
    }

    private void exportFile(InputStream ins, String sqlFileName) {
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(sqlFileName, ins, 5000);
        this.getView().openUrl(url);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String prop = evt.getProperty().getName();
        if ("exportobj".equals(prop)) {
            Object bizAppId = null;
            Object bizapp = this.getModel().getValue("bizapp");
            if (bizapp instanceof DynamicObject) {
                bizAppId = ((DynamicObject)bizapp).getPkValue();
            }
            if (bizAppId == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u5e94\u7528\u3002", (String)"KSQLExpNewPlugin_15", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
            }
            evt.getFormShowParameter().setCustomParam("treeRootNodeId", bizAppId);
        }
    }

    private boolean genInsertSQLByPreview(StringBuilder sqlList, String pageId) {
        IFormView view = SessionManager.getCurrent().getView(pageId);
        if (view == null) {
            return false;
        }
        if (!view.getModel().isDataLoaded()) {
            IFormController formController = (IFormController)view.getService(IFormController.class);
            formController.loadData();
        }
        String tablename = (String)view.getFormShowParameter().getCustomParam("tablename");
        String routefield = (String)view.getFormShowParameter().getCustomParam("routefield");
        String fields = (String)view.getFormShowParameter().getCustomParam("fields");
        DBRoute dbRoute = DBRoute.of((String)routefield);
        StringBuilder strSQL = new StringBuilder();
        strSQL.append("INSERT INTO ").append(tablename).append("(").append(fields.toUpperCase(Locale.ENGLISH)).append(") ");
        StringBuilder sbScript = new StringBuilder();
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("entryentity");
        DynamicObjectType entryEntityType = entryEntity.getDynamicObjectType();
        List fieldInfos = DB.getFieldInfo((DBRoute)dbRoute, (String)tablename);
        HashMap<String, FieldInfo> fieldInfoMap = new HashMap<String, FieldInfo>(fieldInfos.size());
        for (FieldInfo fieldInfo : fieldInfos) {
            fieldInfoMap.put(fieldInfo.getFieldName().toUpperCase(Locale.ENGLISH), fieldInfo);
        }
        List pkColNames = DB.getPrimaryKeys((DBRoute)dbRoute, (String)tablename);
        HashSet<String> mapPKCols = new HashSet<String>(16);
        for (String pk : pkColNames) {
            String upperPK = pk.toUpperCase();
            mapPKCols.add(upperPK);
        }
        for (DynamicObject dynamicObject : entryEntity) {
            StringBuilder valuesSQL = new StringBuilder();
            valuesSQL.append("VALUES (");
            HashMap<String, Object[]> dictPK = new HashMap<String, Object[]>();
            for (IDataEntityProperty property : entryEntityType.getProperties()) {
                if ("id".equals(property.getName()) || "seq".equals(property.getName())) continue;
                FieldInfo fieldInfo = (FieldInfo)fieldInfoMap.get(property.getName().toUpperCase(Locale.ENGLISH));
                Object value = property.getValue((Object)dynamicObject);
                if (mapPKCols.contains(fieldInfo.getFieldName().toUpperCase())) {
                    dictPK.put(fieldInfo.getFieldName().toUpperCase(Locale.ENGLISH), new Object[]{fieldInfo.getDataType(), value});
                }
                valuesSQL.append(this.GetStr(dbRoute, fieldInfo, value)).append(',');
            }
            String strVal = valuesSQL.toString();
            strVal = strVal.substring(0, strVal.length() - 1) + "); ";
            sbScript.append("DELETE FROM ").append(tablename);
            sbScript.append(WHERE);
            int i = 0;
            for (Map.Entry entry : dictPK.entrySet()) {
                if (i > 0) {
                    sbScript.append(" and ");
                }
                String type = (String)((Object[])entry.getValue())[0];
                String pkVal = ((Object[])entry.getValue())[1].toString();
                if ("char".equalsIgnoreCase(type) || "varchar".equalsIgnoreCase(type) || "nchar".equalsIgnoreCase(type) || "nvarchar".equalsIgnoreCase(type)) {
                    sbScript.append((String)entry.getKey()).append(" = '").append(pkVal).append("'");
                } else {
                    sbScript.append((String)entry.getKey()).append(" = ").append(pkVal);
                }
                ++i;
            }
            sbScript.append(';').append(System.getProperty("line.separator"));
            sbScript.append((CharSequence)strSQL);
            sbScript.append(strVal);
            sbScript.append(System.lineSeparator());
        }
        sqlList.append((CharSequence)sbScript);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String GetStr(DBRoute dbRoute, FieldInfo col, Object val) {
        boolean withMark;
        boolean isNull;
        if (val == null) return "NULL";
        if ("NULL".equals(val)) {
            return "NULL";
        }
        boolean bl = isNull = false;
        if (isNull) {
            return "NULL";
        }
        int colType = this.getColType(col);
        StringBuilder sb = new StringBuilder();
        DBType dbtype = DB.getDBType((DBRoute)dbRoute);
        if (DBType.SQLServer == dbtype) {
            if (colType == 3 || colType == 8 || colType == 2) {
                sb.append('N');
            }
        } else if (colType == 12) {
            sb.append("{ts'");
        }
        boolean bl2 = withMark = colType == 3 || colType == 8 || colType == 2 || colType == 1 || colType == 0 || colType == 7;
        if (withMark) {
            sb.append("'");
        }
        if (colType == 14 && this.ZERO.equals(val)) {
            sb.append("0.00");
        } else {
            if (colType == 15) {
                throw new RuntimeException("notsupport");
            }
            if (colType == 8 || colType == 7) {
                Object clob = val;
                if (clob != null) {
                    if (clob.toString().length() >= 1000) throw new RuntimeException("notsupport");
                }
                String value = clob == null ? "" : clob.toString();
                if ((value = value.replace("'", "''")).length() == 0) {
                    value = " ";
                }
                sb.append(value);
            } else if (colType == 12) {
                String value = (String)val;
                if ((value = value.replace("'", "''")).length() == 0) {
                    value = " ";
                }
                sb.append(value);
            } else {
                if (colType == 6) {
                    throw new RuntimeException("notsupport");
                }
                Object objValue = val;
                String value = objValue == null ? "" : objValue.toString();
                if ((value = value.replace("'", "''")).length() == 0) {
                    value = " ";
                }
                sb.append(value);
            }
        }
        if (withMark) {
            sb.append("'");
            return sb.toString();
        } else {
            if (colType != 12) return sb.toString();
            sb.append("'}");
        }
        return sb.toString();
    }

    private int getColType(FieldInfo col) {
        int colType = col.getJDBCDataType();
        String colTypeName = col.getDataType();
        if (colType == 2 && "number".equalsIgnoreCase(colTypeName) && col.getDataScale() == 0) {
            int precision = col.getDataPrecision();
            if (precision > 10 && precision <= 19) {
                colType = 11;
            } else if (precision <= 10) {
                colType = 9;
            }
        } else {
            colType = colType == 12 && "text".equalsIgnoreCase(colTypeName) ? KSQLDataType.javaSqlType2KSQLDataType((int)8) : KSQLDataType.javaSqlType2KSQLDataType((int)colType);
        }
        return colType;
    }
}

