/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.dc.api.model.DBObject;
import kd.bos.dc.mc.LoginMCService;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.sqlscript.BatchPreInsDataScriptBuilder;
import kd.bos.sqlscript.PreInsDataScriptBuilder;

public class KSQLExpPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final Log log = LogFactory.getLog(KSQLExpPlugin.class);

    public void initialize() {
        this.addClickListeners(new String[]{"buttonap"});
    }

    public void afterCreateNewData(EventObject e) {
        ComboEdit ce = (ComboEdit)this.getControl("routefield");
        try {
            List dbInstanceList = LoginMCService.create().getDbInstanceList(RequestContext.get().getAccountId());
            if (dbInstanceList != null) {
                ArrayList<ComboItem> list = new ArrayList<ComboItem>(dbInstanceList.size());
                for (DBObject dbObject : dbInstanceList) {
                    ComboItem item = new ComboItem(new LocaleString(dbObject.getName()), dbObject.getNumber());
                    list.add(item);
                }
                ce.setComboItems(list);
            }
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
        }
    }

    public void afterBindData(EventObject e) {
        this.showBatchSize();
    }

    public void click(EventObject e) {
        Control control = (Control)e.getSource();
        switch (control.getKey()) {
            case "buttonap": {
                this.execScript();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        switch (e.getProperty().getName()) {
            case "genbatchsql": {
                this.showBatchSize();
            }
        }
    }

    private void execScript() {
        Map map;
        boolean isAdmin = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId());
        if (!isAdmin) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u4f7f\u7528\u8be5\u529f\u80fd\u3002", (String)"KSQLExpPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String textfield = (String)this.getModel().getValue("textfield");
        String routefield = ((String)this.getModel().getValue("routefield")).trim();
        String selectField = (String)this.getModel().getValue("selectfield");
        String fromfield = ((String)this.getModel().getValue("fromfield")).trim();
        String wherefield = (String)this.getModel().getValue("wherefield");
        String orderfield = (String)this.getModel().getValue("orderfield");
        if (StringUtils.isBlank((CharSequence)routefield)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u5e93\u3002", (String)"KSQLExpPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)fromfield)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u8868\u540d\u3002", (String)"KSQLExpPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)selectField)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u5b57\u6bb5\u540d\u3002", (String)"KSQLExpPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        boolean genBatchSql = (Boolean)this.getModel().getValue("genbatchsql");
        int batchSize = (Integer)this.getModel().getValue("batchsize");
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        try {
            if (genBatchSql) {
                BatchPreInsDataScriptBuilder batchBuilder = new BatchPreInsDataScriptBuilder(batchSize);
                map = batchBuilder.genInsertSQLScript(DBRoute.of((String)routefield), fromfield, selectField, wherefield, orderfield, textfield);
            } else {
                map = builder.genInsertSQLScript(DBRoute.of((String)routefield), fromfield, selectField, wherefield, orderfield, textfield);
            }
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format("KSQLExpPlugin Error:%s.", e.getMessage())});
        }
        String sql = (String)map.get("sql");
        boolean bDownloadfile = (Boolean)this.getModel().getValue("downloadfile");
        if (bDownloadfile) {
            String sqlFileName = String.format("%s_%s.sql", fromfield, new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
            try (ByteArrayInputStream ins = new ByteArrayInputStream(sql.getBytes(StandardCharsets.UTF_8));){
                this.exportFile(ins, sqlFileName);
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
            }
            Object xml = map.get("xml");
            if (xml != null) {
                HashMap longTextDataFile = (HashMap)xml;
                for (Map.Entry entry : longTextDataFile.entrySet()) {
                    StringWriter sw = (StringWriter)entry.getValue();
                    byte[] barray = sw.toString().getBytes(StandardCharsets.UTF_8);
                    try {
                        ByteArrayInputStream ins1 = new ByteArrayInputStream(barray);
                        Throwable throwable = null;
                        try {
                            this.exportFile(ins1, (String)entry.getKey());
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (ins1 == null) continue;
                            if (throwable != null) {
                                try {
                                    ((InputStream)ins1).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            ((InputStream)ins1).close();
                        }
                    }
                    catch (Exception e) {
                        throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
                    }
                }
            }
        }
        CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl("ksqltext");
        if (sql.length() > 100000) {
            codeSQLshow.setText(String.format(ResManager.loadKDString((String)"\u811a\u672c\u592a\u5927\uff0c\u5c06\u88ab\u622a\u65ad\u5c55\u793a\uff0c\u5b8c\u6574\u811a\u672c\u5185\u5bb9\u53ef\u52fe\u9009\u3010\u4e0b\u8f7dSQL\u6587\u4ef6\u3011\u5bfc\u51fa\u540e\u67e5\u770b%1$s%2$s", (String)"KSQLExpPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), System.lineSeparator(), sql.substring(0, 100000)));
        } else {
            codeSQLshow.setText(sql);
        }
    }

    private void exportFile(InputStream ins, String sqlFileName) {
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(sqlFileName, ins, 5000);
        this.getView().openUrl(url);
    }

    private void showBatchSize() {
        boolean genBatchSql = (Boolean)this.getModel().getValue("genbatchsql");
        this.getView().setVisible(Boolean.valueOf(genBatchSql), new String[]{"batchsize"});
    }
}

