/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.FieldInfo;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ItemClassProp;

public class KSQLExpTable {
    private String dbRouteKey;
    private final IDataEntityType mainEntityType;
    private IDataEntityType dataEntityType;

    public KSQLExpTable(String mainEntityId, String parentEntityId, String entityPropKey) {
        this(mainEntityId);
        if (!mainEntityId.equals(entityPropKey)) {
            this.dataEntityType = this.getDataEntityType(this.dataEntityType, parentEntityId, entityPropKey);
        }
    }

    public KSQLExpTable(String mainEntityId) {
        this.dataEntityType = EntityMetadataCache.getDataEntityType((String)mainEntityId);
        if (!(this.dataEntityType instanceof BasedataEntityType) && !(this.dataEntityType instanceof BillEntityType)) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5355\u636e\u548c\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u3002", (String)"KSQLExpTable_0", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        }
        this.mainEntityType = this.dataEntityType;
        this.dbRouteKey = this.dataEntityType.getDBRouteKey();
    }

    private IDataEntityType getDataEntityType(IDataEntityType dataEntityType, String parentEntityID, String entityPropKey) {
        IDataEntityProperty property = (IDataEntityProperty)dataEntityType.getProperties().get((Object)entityPropKey);
        if (property != null && dataEntityType.getName().equals(parentEntityID)) {
            return ((ICollectionProperty)property).getItemType();
        }
        for (IDataEntityProperty prop : dataEntityType.getProperties()) {
            IDataEntityType type;
            if (!(prop instanceof ICollectionProperty) || (type = this.getDataEntityType(((ICollectionProperty)prop).getItemType(), parentEntityID, entityPropKey)) == null) continue;
            return type;
        }
        return null;
    }

    public String getDbRouteKey() {
        return this.dbRouteKey;
    }

    public String tableName() {
        return this.dataEntityType.getAlias();
    }

    public List<Field> getFields() {
        HashSet<String> tableGroupSet = new HashSet<String>();
        for (IDataEntityProperty property : this.dataEntityType.getProperties()) {
            tableGroupSet.add(property.getTableGroup());
        }
        ArrayList<Field> list = new ArrayList<Field>(16);
        for (String s : tableGroupSet) {
            List fieldInfoList = DB.getFieldInfo((DBRoute)DBRoute.of((String)this.dbRouteKey), (String)this.getTableName(this.dataEntityType.getAlias(), s));
            for (FieldInfo fieldInfo : fieldInfoList) {
                list.add(new Field(fieldInfo.getFieldComment(), fieldInfo.getFieldName(), fieldInfo.getDataType(), s));
            }
        }
        return list;
    }

    private String getTableName(String tableName, String tableGroup) {
        if (StringUtils.isBlank((CharSequence)tableGroup)) {
            return tableName;
        }
        return tableName + "_" + tableGroup;
    }

    public Map<String, Set<Object>> getBaseDataIds(String[] pks) {
        Object[] oPks;
        int dbType = this.mainEntityType.getPrimaryKey().getDbType();
        if (12 == dbType || -9 == dbType || 1 == dbType) {
            oPks = pks;
        } else {
            oPks = new Object[pks.length];
            int i = 0;
            for (String pk : pks) {
                oPks[i++] = Long.valueOf(pk);
            }
        }
        return this.getBaseDataIds(oPks);
    }

    private Map<String, Set<Object>> getBaseDataIds(Object[] pks) {
        Object[] data = BusinessDataReader.load((Object[])pks, (IDataEntityType)this.mainEntityType);
        HashMap<String, Set<Object>> mapBaseData = new HashMap<String, Set<Object>>(16);
        for (Object row : data) {
            DynamicObject dynamicObject = (DynamicObject)row;
            this.computeBaseData(dynamicObject, mapBaseData);
        }
        return mapBaseData;
    }

    private void computeBaseData(DynamicObject row, Map<String, Set<Object>> mapCount) {
        for (IDataEntityProperty property : row.getDynamicObjectType().getProperties()) {
            Object baseValue;
            if (property instanceof BasedataProp && (baseValue = row.get(property + "_id")) != null && !"0".equals(baseValue.toString()) && !"".equals(baseValue.toString())) {
                String baseEntityId;
                if (property instanceof ItemClassProp) {
                    String itemClassTypeProp = ((ItemClassProp)property).getTypePropName();
                    baseEntityId = (String)row.getDynamicObjectType().getProperty(itemClassTypeProp).getValueFast((Object)row);
                } else {
                    baseEntityId = ((BasedataProp)property).getBaseEntityId();
                }
                mapCount.compute(baseEntityId, (k, v) -> {
                    Set set = v == null ? new HashSet() : v;
                    set.add(baseValue);
                    return set;
                });
            }
            if (!(property instanceof ICollectionProperty)) continue;
            DynamicObjectCollection rows = row.getDynamicObjectCollection(property);
            for (DynamicObject entryRow : rows) {
                this.computeBaseData(entryRow, mapCount);
            }
        }
    }

    public String getWhere(String selectIds) {
        return this.getWhere0(this.dataEntityType, selectIds);
    }

    private String getWhere0(IDataEntityType type, String selectIds) {
        if (type.getParent() == null || type.getParent().getParent() == null) {
            String primaryKey = type.getParent() == null ? type.getPrimaryKey().getAlias() : type.getParent().getPrimaryKey().getAlias();
            return primaryKey + " in (" + selectIds + ")";
        }
        return type.getParent().getPrimaryKey().getAlias() + " in (select " + type.getParent().getPrimaryKey().getAlias() + " from " + type.getParent().getAlias() + " where " + this.getWhere0(type.getParent(), selectIds) + ")";
    }

    static class Field {
        private String fieldComment;
        private String fieldName;
        private String type;
        private String tableGroup;

        public Field(String fieldComment, String fieldName, String type, String tableGroup) {
            if (StringUtils.isBlank((CharSequence)fieldComment)) {
                fieldComment = fieldName;
            }
            this.fieldComment = fieldComment;
            this.fieldName = fieldName;
            this.type = type;
            this.tableGroup = tableGroup;
        }

        public String getFieldComment() {
            return this.fieldComment;
        }

        public void setFieldComment(String fieldComment) {
            this.fieldComment = fieldComment;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getTableGroup() {
            return this.tableGroup;
        }

        public void setTableGroup(String tableGroup) {
            this.tableGroup = tableGroup;
        }
    }
}

