/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.api.model.DBObject;
import kd.bos.dc.mc.LoginMCService;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.ksql.dom.stmt.SqlAlterTableStmt;
import kd.bos.ksql.dom.stmt.SqlCreateIndexStmt;
import kd.bos.ksql.dom.stmt.SqlCreateTableStmt;
import kd.bos.ksql.dom.stmt.SqlDeleteStmt;
import kd.bos.ksql.dom.stmt.SqlDropTableStmt;
import kd.bos.ksql.dom.stmt.SqlExecStmt;
import kd.bos.ksql.dom.stmt.SqlIfStmt;
import kd.bos.ksql.dom.stmt.SqlInsertStmt;
import kd.bos.ksql.dom.stmt.SqlStmt;
import kd.bos.ksql.dom.stmt.SqlUpdateStmt;
import kd.bos.ksql.exception.ParserException;
import kd.bos.ksql.parser.Lexer;
import kd.bos.ksql.parser.SqlParser;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class KSQLExpTestPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final Log log = LogFactory.getLog(KSQLExpTestPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_testsql"});
    }

    public void afterCreateNewData(EventObject e) {
        ComboEdit ce = (ComboEdit)this.getControl("list_db");
        try {
            List dbInstanceList = LoginMCService.create().getDbInstanceList(RequestContext.get().getAccountId());
            if (dbInstanceList != null) {
                ArrayList<ComboItem> list = new ArrayList<ComboItem>(dbInstanceList.size());
                for (DBObject dbObject : dbInstanceList) {
                    list.add(new ComboItem(new LocaleString(dbObject.getName()), dbObject.getNumber()));
                }
                ce.setComboItems(list);
            }
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
        }
    }

    public void click(EventObject e) {
        Control control = (Control)e.getSource();
        if ("btn_testsql".equals(control.getKey())) {
            this.testSql();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSql() {
        List stmtCol;
        this.showInfo("");
        String routeKey = (String)this.getModel().getValue("list_db");
        if (StringUtils.isEmpty((CharSequence)routeKey)) {
            this.showInfo("Please select a db.");
            return;
        }
        CodeEdit codeSQLShow = (CodeEdit)this.getView().getControl("txt_ksql");
        String ksql = codeSQLShow.getText();
        if (StringUtils.isEmpty((CharSequence)ksql)) {
            this.showInfo("KSQL is empty.");
            return;
        }
        try {
            Lexer lexer = new Lexer(ksql);
            SqlParser parser = new SqlParser(lexer);
            stmtCol = (List)parser.parseStmtList();
        }
        catch (ParserException e) {
            this.showInfo(e.getMessage());
            return;
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        for (SqlStmt sqlStmt : stmtCol) {
            if (this.checkSql(sqlStmt)) continue;
            sqlList.add(sqlStmt.toString());
        }
        if (!sqlList.isEmpty()) {
            this.showInfo("KSQL is not supported:\r\n" + String.join((CharSequence)"\r\n", sqlList));
        } else {
            try (TXHandle txHandler = TX.requiresNew((String)"testsqlTran");){
                try {
                    DB.execute((DBRoute)DBRoute.of((String)routeKey), (String)ksql);
                    this.showInfo("Check successfully.");
                }
                catch (Exception ex) {
                    this.showInfo(ex.getMessage());
                }
                finally {
                    txHandler.markRollback();
                }
            }
        }
    }

    private void showInfo(String info) {
        this.getModel().setValue("txt_info", (Object)info);
    }

    private boolean checkSql(SqlStmt sqlStmt) {
        if (sqlStmt instanceof SqlInsertStmt) {
            return true;
        }
        if (sqlStmt instanceof SqlDeleteStmt) {
            return true;
        }
        if (sqlStmt instanceof SqlUpdateStmt) {
            return true;
        }
        if (sqlStmt instanceof SqlIfStmt) {
            List list = ((SqlIfStmt)sqlStmt).trueStmtList;
            for (SqlStmt stmt : list) {
                if (this.checkSql(stmt)) continue;
                return false;
            }
            return true;
        }
        if (sqlStmt instanceof SqlCreateTableStmt) {
            return false;
        }
        if (sqlStmt instanceof SqlAlterTableStmt) {
            return false;
        }
        if (sqlStmt instanceof SqlDropTableStmt) {
            return false;
        }
        if (sqlStmt instanceof SqlCreateIndexStmt) {
            return false;
        }
        if (sqlStmt instanceof SqlExecStmt) {
            return false;
        }
        return false;
    }
}

