/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import java.util.Date;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.DevVerifyServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.util.GitLockAppUtil;

public class LockAppPlugin
extends AbstractFormPlugin {
    private static final String BTNOK = "btnok";
    private static final String MESSAGE = "message";
    private static final String NUMBER = "number";
    private static final String BOS_FORMMETA = "bos_formmeta";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{BTNOK});
        this.addClickListeners(new String[]{MESSAGE});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Label msg = (Label)this.getControl(MESSAGE);
        msg.setText((String)parameter.getCustomParam(MESSAGE));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        boolean flag = (Boolean)parameter.getCustomParam("flag");
        String type = (String)parameter.getCustomParam("type");
        String userName = null;
        if (StringUtils.equals((CharSequence)"sys", (CharSequence)type)) {
            userName = RequestContext.get().getUserName();
        }
        switch (c.getKey().toLowerCase()) {
            case "btnok": {
                if (flag) {
                    this.confirm(userName);
                    break;
                }
                this.cancelConfirm(userName);
                break;
            }
        }
    }

    private void confirm(String userName) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String bizId = (String)parameter.getCustomParam("bizId");
        String formNumber = (String)parameter.getCustomParam(NUMBER);
        String lockInfo = DevVerifyServiceHelper.getLockInfo((String)formNumber);
        if (StringUtils.equals((CharSequence)lockInfo, (CharSequence)userName)) {
            DevVerifyServiceHelper.deleteLock((String)formNumber);
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u89e3\u9501\u9875\u9762", "BizPageListPlugin_82", BOS_DEVPORTAL_PLUGIN);
            MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u89e3\u9501\u6210\u529f", "LockAppPlugin_0", BOS_DEVPORTAL_PLUGIN);
            AppUtils.addOpLog((String)formNumber, (String)"lock", (String)formNumber, (String)"1", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[0]);
            this.getView().showMessage(ResManager.loadKDString((String)"\u89e3\u9501\u6210\u529f", (String)"LockAppPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u8be5\u9875\u9762\u5df2\u88ab\u201c%s\u201d\u9501\u5b9a\u3002", (String)"GitPermissionUtil_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), lockInfo));
        }
        this.getView().returnDataToParent((Object)"SUCCESS");
        this.getView().close();
    }

    private void cancelConfirm(String userName) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String bizAppId = (String)parameter.getCustomParam("bizAppId");
        String type = (String)parameter.getCustomParam("type");
        String bizId = (String)parameter.getCustomParam("bizId");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)bizId, (String)BOS_FORMMETA);
        String formNumber = dynamicObject.getString(NUMBER);
        String formName = dynamicObject.getString("name");
        String bizUnitId = (String)parameter.getCustomParam("bizUnitId");
        AppFunctionPacketElement packet = GitLockAppUtil.getFunctionById((String)bizAppId, (String)bizUnitId);
        String bizUnitName = packet.getName().getLocaleValue();
        DynamicObject bizAppInfo = GitLockAppUtil.getAppInfo((String)bizAppId);
        DynamicObject appInfo = BusinessDataServiceHelper.newDynamicObject((String)"bos_app_locking");
        appInfo.set("formnumber", (Object)formNumber);
        appInfo.set("formname", (Object)formName);
        appInfo.set("unitid", (Object)bizUnitId);
        appInfo.set("unitname", (Object)bizUnitName);
        appInfo.set("bizappnumber", (Object)bizAppInfo.getString(NUMBER));
        appInfo.set("bizappname", (Object)bizAppInfo.getString("name"));
        appInfo.set("accounttype", (Object)type);
        appInfo.set("account", (Object)userName);
        appInfo.set("createtime", (Object)new Date());
        DynamicObject[] lockAppInfo = new DynamicObject[]{appInfo};
        SaveServiceHelper.save((DynamicObject[])lockAppInfo);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u9501\u5b9a\u9875\u9762", "BizPageListPlugin_83", BOS_DEVPORTAL_PLUGIN);
        MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u9501\u5b9a\u6210\u529f", "LockAppPlugin_1", BOS_DEVPORTAL_PLUGIN);
        AppUtils.addOpLog((String)formNumber, (String)"unlock", (String)formNumber, (String)"1", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[0]);
        this.getView().showMessage(ResManager.loadKDString((String)"\u9501\u5b9a\u6210\u529f", (String)"LockAppPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        this.getView().returnDataToParent((Object)"SUCCESS");
        this.getView().close();
    }
}

