/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.business.PermissionVerify;
import kd.bos.devportal.business.util.DevportalVerify;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.common.util.HttpClientUtils;
import kd.bos.entity.ISVInfo;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.isv.IsvParamCache;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.bos.mservice.svc.picture.IImage;
import kd.bos.mvc.SessionManager;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.productsetting.ProductSettingServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.util.GitPermissionUtil;
import kd.bos.servicehelper.util.TenantLoginConfigUtils;
import kd.bos.util.JSONUtils;

public class MainPlugin
extends AbstractFormPlugin
implements ItemClickListener,
ClickListener,
SearchEnterListener {
    private static Log logger = LogFactory.getLog(MainPlugin.class);
    public static final String SUPERADMIN_DEFAULT_ICON = "/icons/pc/other/superAdministrators_38_38.png";
    private static Object lockObj = new Object();
    private static final String TABAP = "tabap";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String SCPAGEID = "scpageid";
    private static final String SEARCHPAGEID = "searchpageid";
    private static final String APPPAGEID = "apppageid";
    private static final String BOS_DEVPORTAL_BIZAPPLIST = "bos_devportal_bizapplist";
    private static final String TABPAGEAP1 = "tabpageap1";
    private static final String ISSSHOW = "issshow";
    private static final String GETUSERTHEME = "getUserTheme";
    private static final String PNG_TALK2 = "/images/pc/other/talk2.png";
    private static final String HELP_CENTER_URL = "https://vip.kingdee.com/knowledge/specialDetail/218022218066869248?productLineId=29";

    public void preOpenForm(PreOpenFormEventArgs e) {
        e.getFormShowParameter().setHasRight(true);
    }

    public void registerListener(EventObject e) {
        Button logo;
        Button icon;
        Button userButton = (Button)this.getView().getControl("btnaccount");
        if (userButton != null) {
            userButton.addItemClickListener((ItemClickListener)this);
        }
        if ((icon = (Button)this.getControl("usericon")) != null) {
            icon.addClickListener((ClickListener)this);
        }
        if ((logo = (Button)this.getControl("imageap")) != null) {
            logo.addClickListener((ClickListener)this);
        }
        this.addClickListeners(new String[]{"imageap_collect", "tab", "navigation", "helpcenter", "isolation", "lockform"});
        Search search = (Search)this.getView().getControl("search");
        if (search != null) {
            search.addClickListener((ClickListener)this);
            search.addEnterListener((SearchEnterListener)this);
        }
        this.addClickListeners(new String[]{"switch2new", "gototabledict"});
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("openisvform_confirmcallback".equals(messageBoxClosedEvent.getCallBackId())) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.openISVRegister();
            } else {
                this.openForm();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCreateNewData(EventObject evt) {
        String str;
        String isv = "";
        try {
            IsvParamCache.setIsvParam((boolean)true);
            isv = ISVService.getISVInfo().getId();
        }
        catch (KDException e) {
            logger.error((Throwable)e);
            IsvParamCache.setIsvParam((boolean)true);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u5f00\u53d1\u5546\u8d44\u8d28\u6587\u4ef6\u3002", (String)"MainPlugin_13", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), e.getMessage()));
            this.openISVRegister();
            return;
        }
        if (EnvTypeHelper.isDeploying()) {
            String msg = ResManager.loadKDString((String)"\u5e73\u53f0\u6b63\u5728\u8fdb\u884c\u7cfb\u7edf\u5347\u7ea7\uff0c\u6682\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"MainPlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
            this.getView().showMessage(msg);
        }
        boolean dev_permission = (Boolean)GitPermissionUtil.getParameter((String)"dev_permission");
        boolean dev_form_lock = (Boolean)GitPermissionUtil.getParameter((String)"dev_form_lock");
        boolean hide_devnew = ProductSettingServiceHelper.hasBlackFeature((String)"devportal", (String)"devportal_hide_devnew");
        if (!dev_form_lock) {
            str = "lockform";
            this.getView().setVisible(Boolean.FALSE, new String[]{str});
        }
        if (!dev_permission) {
            str = "isolation";
            this.getView().setVisible(Boolean.FALSE, new String[]{str});
        }
        if (!PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId())) {
            str = "lockform";
            this.getView().setVisible(Boolean.FALSE, new String[]{str});
        }
        if (hide_devnew) {
            str = "switch2new";
            this.getView().setVisible(Boolean.FALSE, new String[]{str});
        }
        this.getView().addClientCallBack("gptInfo", Integer.valueOf(1000));
        if (StringUtils.isNotBlank((CharSequence)isv)) {
            if (!isv.equals(isv.toLowerCase(Locale.ENGLISH))) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f00\u53d1\u5546\u6807\u8bc6\u5fc5\u987b\u4e3a\u5c0f\u5199\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u8fdb\u884c\u4fee\u6539?", (String)"MainPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("openisvform_confirmcallback"));
            } else {
                this.openForm();
            }
            return;
        }
        isv = this.getMCDeveloperInfo();
        if (StringUtils.isNotBlank((CharSequence)isv) && !"kingdee".equals(isv)) {
            ISVInfo isvInfo = new ISVInfo();
            isvInfo.setId(isv);
            isvInfo.setName(isv);
            isvInfo.setType("1");
            try {
                Object object = lockObj;
                synchronized (object) {
                    isv = AppUtils.getDeveloperInfo();
                    if (StringUtils.isBlank((CharSequence)isv)) {
                        ISVService.save((ISVInfo)isvInfo);
                    }
                }
                this.openForm();
            }
            catch (Exception e) {
                isv = AppUtils.getDeveloperInfo();
                if (StringUtils.isNotBlank((CharSequence)isv)) {
                    this.openForm();
                    return;
                }
                this.openISVRegister();
            }
        } else {
            this.openISVRegister();
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if (Objects.equals("gptInfo", e.getName())) {
            this.showGPTPage();
        }
    }

    private void showGPTPage() {
        try {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("bos_chat_ai_customcontrol");
            fsp.getOpenStyle().setTargetKey("gpt_gai_panel");
            fsp.setCustomParam("slideEnv", (Object)"BOS");
            fsp.getOpenStyle().setShowType(ShowType.InContainer);
            this.getView().showForm(fsp);
        }
        catch (Exception e) {
            logger.warn("showGPTPage error" + e.getMessage(), (Throwable)e);
        }
    }

    private void openISVRegister() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_isv_register");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "isv_closecallback");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    public void afterBindData(EventObject e) {
        String userIdStr = RequestContext.get().getUserId();
        long userId = Long.parseLong(userIdStr);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        this.showUserInfo(userIdStr, userId, proxy);
        String logUrl = TenantLoginConfigUtils.getLogoUrlConfig();
        IImage logo = (IImage)this.getControl("imageap");
        if (TenantLoginConfigUtils.isUseTenantLoginConfig() && StringUtils.isNotBlank((CharSequence)logUrl)) {
            logo.setUrl(logUrl);
        } else if (Lang.zh_CN != Lang.get() && Lang.zh_TW != Lang.get()) {
            logo.setUrl("/images/pc/other/Dev_platform_en.png");
        }
    }

    private void showUserInfo(String userIdStr, long userId, IClientViewProxy proxy) {
        IImage icon = (IImage)this.getControl("usericon");
        Map userAvatarPathMap = UserServiceHelper.getUserAvatarPath(Collections.singletonList(userId), (boolean)true);
        String imgURL = (String)userAvatarPathMap.get(userId);
        if (StringUtils.isBlank((CharSequence)imgURL)) {
            icon.setUrl("/images/pc/emotion/default_person_82_82.png");
        } else {
            icon.setUrl(imgURL);
        }
    }

    public void click(EventObject e) {
        String key;
        Control control = (Control)e.getSource();
        switch (key = control.getKey()) {
            case "imageap_collect": {
                this.openShortCutWindow();
                break;
            }
            case "imageap": {
                this.openMainPage();
                break;
            }
            case "helpcenter": {
                this.openHelpingCenter();
                break;
            }
            case "isolation": {
                this.openAppIsolation();
                break;
            }
            case "lockform": {
                this.openLockForm();
                break;
            }
            case "switch2new": {
                this.switch2new();
                break;
            }
            case "gototabledict": {
                this.openTableDict();
                break;
            }
        }
    }

    private void switch2new() {
        this.getView().close();
        this.getView().openUrl("?formId=bos_devpn_portal_grid");
    }

    private void openTableDict() {
        this.getView().openUrl("?formId=bos_devp_tabletreelist&type=list&billFormId=bos_devp_tablelayout");
    }

    private void openHelpingCenter() {
        String locale = "zh-CN";
        Lang lang = Lang.get();
        if (Lang.zh_CN != lang && Lang.zh_TW != lang) {
            locale = "en-US";
        }
        this.getView().openUrl("https://vip.kingdee.com/knowledge/specialDetail/218022218066869248?productLineId=29&lang=" + locale);
    }

    private void openAppIsolation() {
        PermissionVerify verify = new PermissionVerify();
        if (!DevportalVerify.isApart() && !verify.hasPermission()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u76f8\u5e94\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5bf9\u3010\u5e94\u7528\u6743\u9650\u7ba1\u7406\u3011\u8fdb\u884c\u6388\u6743\u3002", (String)"MainPlugin_11", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        IFormView parentView = this.getView().getView(this.getView().getFormShowParameter().getRootPageId());
        if (StringUtils.isBlank((Object)parentView)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4f1a\u8bdd\u8d85\u65f6\u3002", (String)"MainPlugin_12", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String pageId = parentView.getPageId() + "isolation";
        IFormView childView = this.getView().getView(pageId);
        if (childView != null) {
            childView.activate();
            this.getView().sendFormAction(childView);
            return;
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setCaption(ResManager.loadKDString((String)"\u5e94\u7528\u6743\u9650\u7ba1\u7406", (String)"MainPlugin_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        parameter.setFormId("bos_list");
        parameter.setBillFormId("bos_app_isolation");
        parameter.getOpenStyle().setTargetKey(TABAP);
        parameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        parameter.setPageId(pageId);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void openLockForm() {
        IFormView parentView = this.getView().getView(this.getView().getFormShowParameter().getRootPageId());
        if (StringUtils.isBlank((Object)parentView)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4f1a\u8bdd\u8d85\u65f6\u3002", (String)"MainPlugin_12", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String pageId = parentView.getPageId() + "lock";
        IFormView childView = this.getView().getView(pageId);
        if (childView != null) {
            childView.activate();
            this.getView().sendFormAction(childView);
            return;
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setCaption(ResManager.loadKDString((String)"\u9501\u5b9a\u9875\u9762\u7ba1\u7406", (String)"MainPlugin_10", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        parameter.setFormId("bos_list");
        parameter.setBillFormId("bos_app_locking");
        parameter.getOpenStyle().setTargetKey(TABAP);
        parameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        parameter.setPageId(pageId);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void openMainPage() {
        this.getView().openUrl("index.html");
    }

    public void itemClick(ItemClickEvent evt) {
        String id;
        switch (id = evt.getItemKey()) {
            case "mbChangeTeam": {
                this.showSwitchTenant();
                break;
            }
            case "mbExit": {
                this.logout();
                break;
            }
            case "changetab": {
                Tab tab = (Tab)this.getControl(TABAP);
                tab.activeTab(evt.getOperationKey());
                break;
            }
        }
    }

    private void logout() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, String> mpURL = new HashMap<String, String>();
        mpURL.put("url", "auth/logout.do");
        mpURL.put("openStyle", "0");
        proxy.addAction("openUrl", mpURL);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("shortcutcloseaction".equals(e.getActionId())) {
            this.getPageCache().remove(SCPAGEID);
        } else if ("searchCloseCallBack".equals(e.getActionId())) {
            this.getPageCache().remove(SEARCHPAGEID);
        } else if ("isv_closecallback".equals(e.getActionId())) {
            String ret = "";
            if (e.getReturnData() != null && "1".equals(ret = (String)e.getReturnData())) {
                this.openForm();
            }
        }
    }

    private void openForm() {
        this.getPageCache().remove(SCPAGEID);
        this.getPageCache().remove(SEARCHPAGEID);
        String appPageId = UUID.randomUUID().toString();
        String devPageId = UUID.randomUUID().toString();
        this.getPageCache().put(APPPAGEID, appPageId);
        FormShowParameter parameter = new FormShowParameter();
        boolean addNewOperate = AppUtils.checkPagePermission((String)BOS_DEVPORTAL_BIZAPPLIST, (String)"47156aff000000ac");
        boolean editOperate = AppUtils.checkPagePermission((String)BOS_DEVPORTAL_BIZAPPLIST, (String)"4715a0df000000ac");
        boolean deleteOperate = AppUtils.checkPagePermission((String)BOS_DEVPORTAL_BIZAPPLIST, (String)"4715e1f1000000ac");
        if (addNewOperate || editOperate || deleteOperate) {
            parameter.setHasRight(true);
        }
        String isv = AppUtils.getDeveloperInfo();
        String acessType = (String)this.getView().getFormShowParameter().getCustomParam("accesstype");
        if ("home".equals(acessType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"main"});
            this.getView().setVisible(Boolean.FALSE, new String[]{TABPAGEAP1, "flexpanelap3"});
            parameter.setFormId(BOS_DEVPORTAL_BIZAPPLIST);
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey(TABPAGEAP1);
            parameter.setCustomParam("devpageid", (Object)devPageId);
            parameter.setPageId(appPageId);
            this.getView().showForm(parameter);
            Tab tab = (Tab)this.getView().getControl(TABAP);
            tab.activeTab("main");
        } else if ("kingdee".equals(isv)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"main"});
            parameter.setFormId(BOS_DEVPORTAL_BIZAPPLIST);
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey(TABPAGEAP1);
            parameter.setCustomParam("devpageid", (Object)devPageId);
            parameter.setPageId(appPageId);
            this.getView().showForm(parameter);
            Tab tab = (Tab)this.getView().getControl(TABAP);
            tab.activeTab(TABPAGEAP1);
        } else {
            parameter.setFormId(BOS_DEVPORTAL_BIZAPPLIST);
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey(TABPAGEAP1);
            parameter.setCustomParam("devpageid", (Object)devPageId);
            parameter.setPageId(appPageId);
            this.getView().showForm(parameter);
            Tab tab = (Tab)this.getView().getControl(TABAP);
            tab.activeTab(TABPAGEAP1);
        }
        this.getModel().setValue(ISSSHOW, (Object)Boolean.FALSE);
    }

    private void openShortCutWindow() {
        boolean isHasPermisson = AppUtils.checkPagePermission((String)"pc_devportal_main", (String)"47150e89000000ac");
        if (!isHasPermisson) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u5f00\u53d1\u8005\u95e8\u6237\u9996\u9875\u201d\u67e5\u8be2\u6743\u9650\uff0c\u8bf7\u5148\u6dfb\u52a0\u67e5\u8be2\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"MainPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (this.getPageCache().get(SCPAGEID) == null) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bos_devportal_sclist");
            parameter.getOpenStyle().setShowType(ShowType.NewTabPage);
            parameter.getOpenStyle().setTargetKey(TABAP);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "shortcutcloseaction"));
            parameter.setCaption(ResManager.loadKDString((String)"\u6211\u7684\u6536\u85cf", (String)"MainPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            String scPageId = UUID.randomUUID().toString();
            parameter.setPageId(scPageId);
            this.getView().showForm(parameter);
            this.getPageCache().put(SCPAGEID, scPageId);
        } else {
            String scPageId = this.getPageCache().get(SCPAGEID);
            this.getView().getView(scPageId).activate();
            this.getView().sendFormAction(this.getView().getView(scPageId));
        }
    }

    public void openSearchWindow(String text) {
        boolean isHasPermisson = AppUtils.checkPagePermission((String)"pc_devportal_main", (String)"47150e89000000ac");
        if (!isHasPermisson) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u5f00\u53d1\u8005\u95e8\u6237\u9996\u9875\u201d\u67e5\u8be2\u6743\u9650\uff0c\u8bf7\u5148\u6dfb\u52a0\u67e5\u8be2\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"MainPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (this.getPageCache().get(SEARCHPAGEID) == null) {
            String selectPageId = UUID.randomUUID().toString();
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bos_devportal_searchlist");
            parameter.getOpenStyle().setShowType(ShowType.NewTabPage);
            parameter.getOpenStyle().setTargetKey(TABAP);
            parameter.setCaption(ResManager.loadKDString((String)"\u641c\u7d22\u7ed3\u679c", (String)"MainPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "searchCloseCallBack"));
            parameter.setPageId(selectPageId);
            parameter.setCustomParam("searchtext", (Object)text);
            this.getView().showForm(parameter);
            this.getPageCache().put(SEARCHPAGEID, selectPageId);
        } else {
            String searchPageId = this.getPageCache().get(SEARCHPAGEID);
            if (this.getView().getView(searchPageId) != null) {
                FormShowParameter parameter = this.getView().getView(searchPageId).getFormShowParameter();
                parameter.setCustomParam("searchtext", (Object)text);
                this.getView().getView(searchPageId).activate();
                this.getView().getView(searchPageId).updateView();
                this.getView().sendFormAction(this.getView().getView(searchPageId));
            }
        }
    }

    private void showSwitchTenant() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("pc_main_switchtenant");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    public void search(SearchEnterEvent arg0) {
        this.openSearchWindow(arg0.getText());
    }

    public void customEvent(CustomEventArgs e) {
        String key = e.getKey();
        Long userID = 0L;
        Long themeID = 0L;
        String userIDStr = null;
        String themeIDStr = null;
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        switch (key) {
            case "getUserTheme": {
                userIDStr = RequestContext.get().getUserId();
                try {
                    userID = Long.valueOf(userIDStr);
                }
                catch (Exception ex) {
                    return;
                }
                Map theme = UserServiceHelper.getUserTheme((Long)userID);
                clientViewProxy.invokeControlMethod(this.getView().getPageId(), GETUSERTHEME, new Object[]{theme});
                break;
            }
            case "setUserTheme": {
                userIDStr = RequestContext.get().getUserId();
                themeIDStr = e.getEventArgs();
                try {
                    userID = Long.valueOf(userIDStr);
                }
                catch (Exception ex) {
                    return;
                }
                try {
                    themeID = Long.valueOf(themeIDStr);
                }
                catch (Exception ex) {
                    themeID = 0L;
                }
                if (themeID == 0L) {
                    UserServiceHelper.setUserTheme((Long)userID, (String)themeIDStr);
                } else {
                    UserServiceHelper.setUserTheme((Long)userID, (Long)themeID);
                }
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("themeNum", themeIDStr);
                AppCache.get((String)"bos").put("theme" + userID, (Object)SerializationUtils.toJsonString(result));
                break;
            }
            case "getThemeCSS": {
                String themeNum = themeIDStr = e.getEventArgs();
                if (StringUtils.isEmpty((CharSequence)themeNum)) {
                    String errorMessage = ResManager.loadKDString((String)"\u53c2\u6570\u89e3\u6790\u5f02\u5e38\uff1a \u4e0d\u5b58\u5728\u53c2\u6570 themeNum", (String)"MainPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
                    clientViewProxy.invokeControlMethod(this.getView().getPageId(), GETUSERTHEME, new Object[]{errorMessage});
                    return;
                }
                String css = UserServiceHelper.getThemeCSS((String)themeNum);
                clientViewProxy.invokeControlMethod(this.getView().getPageId(), "getThemeCSS", new Object[]{css});
                break;
            }
            case "closeGuide": {
                boolean issshow = (Boolean)this.getModel().getValue(ISSSHOW);
                String eventArgs = e.getEventArgs();
                JSONObject parse = (JSONObject)JSONObject.parse((String)eventArgs);
                if (!issshow && 3 != parse.getIntValue("sum")) {
                    this.getModel().setValue(ISSSHOW, (Object)Boolean.TRUE);
                    Map<String, Object> guideItem = this.getSingleHomepageGuideData();
                    clientViewProxy.addAction("showGuide", guideItem);
                    break;
                }
                this.getModel().setValue(ISSSHOW, (Object)Boolean.FALSE);
                break;
            }
        }
    }

    private Map<String, Object> getSingleHomepageGuideData() {
        String currentTab;
        Map<String, Object> guideItem = null;
        String isv = AppUtils.getDeveloperInfo();
        Tab tab = (Tab)this.getView().getView(this.getPageCache().get(APPPAGEID)).getControl(TABAP);
        guideItem = "kingdee".equals(isv) || tab == null ? this.getSingleGuideItemData("", "appCard", "", 3, PNG_TALK2, 40, -20) : ("developviewap".equals(currentTab = tab.getCurrentTab()) ? this.getSingleGuideItemData(this.getPageCache().get(APPPAGEID), "selfopenapp", "", 3, PNG_TALK2, 40, -20) : this.getSingleGuideItemData(this.getPageCache().get(APPPAGEID), "openapp", "", 3, PNG_TALK2, 40, -20));
        return guideItem;
    }

    private Map<String, Object> getSingleGuideItemData(String pageId, String key, String extendPic, int showPos, String explainPic, int alltop, int allleft) {
        HashMap<String, Object> guideItemsData = new HashMap<String, Object>();
        HashMap<String, Object> guideItem = new HashMap<String, Object>();
        guideItem.put("pageId", pageId);
        guideItem.put("key", key);
        guideItem.put("extendPic", extendPic);
        guideItem.put("showPos", showPos);
        guideItem.put("explainPic", explainPic);
        HashMap<String, Integer> alloffset = new HashMap<String, Integer>();
        alloffset.put("top", alltop);
        alloffset.put("left", allleft);
        guideItem.put("offset", alloffset);
        guideItemsData.put("guideItems", guideItem);
        return guideItemsData;
    }

    private String getMCDeveloperInfo() {
        String rt = "";
        String accountIsv = SessionManager.getCurrent().get("accountIsv");
        if (StringUtils.isNotBlank((CharSequence)accountIsv)) {
            rt = accountIsv;
        } else {
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Content-type", "application/json;charset=UTF-8");
            String tenentId = CacheKeyUtil.getAcctId();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("accountId", tenentId);
            String host = System.getProperty("mc.server.url");
            if (StringUtils.isNotBlank((CharSequence)host)) {
                try {
                    JSONObject data;
                    JSONObject resp;
                    String param = JSONUtils.toString(params);
                    String sHttpResponse = HttpClientUtils.postjson((String)(host + "/login/developerinfo"), header, (String)param);
                    if (StringUtils.isNotBlank((CharSequence)sHttpResponse) && (resp = JSONObject.parseObject((String)sHttpResponse)).getInteger("errorcode") == 100 && (data = resp.getJSONObject("data")) != null) {
                        rt = data.getString("developerno");
                        SessionManager.getCurrent().put("accountIsv", rt);
                    }
                }
                catch (IOException e) {
                    throw new KDException((Throwable)e, BosErrorCode.apiIO, new Object[]{ResManager.loadKDString((String)"\u8c03\u7528devops\u7684\u83b7\u53d6\u5f00\u53d1\u5546\u6807\u8bc6\u63a5\u53e3\u5931\u8d25\u3002", (String)"MainPlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0])});
                }
            }
        }
        return rt;
    }
}

