/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.devportal.business.util.DevportalVerify;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalPermissionUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetaLogType;
import kd.bos.metadata.dao.MetaType;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.Style;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataLogService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.DevVerifyServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.ExceptionUtils;

public class PageListLayoutPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
HyperLinkClickListener {
    private static final Log log = LogFactory.getLog(PageListLayoutPlugin.class);
    private static final String PAGETYPE = "PAGE_TYPE";
    private static final String PAGEITEMPAGEGROUP = "pageItemPageGroup";
    private static final String BIZUNITID = "bizunitid";
    private static final String BIZAPPID = "bizappid";
    private static final String KEY_BIZCLOUDID = "bizcloudid";
    private static final String DEVICEGROUP = "deviceGroup";
    private static final String KEY_BIZAPPTYPE = "bizapptype";
    private static final String KEY_PAGETYPE = "pagetype";
    private static final String BIZAPPPARENTID = "bizappparentid";
    private static final String SORTBIZPAGEGROUP = "SortBizPageGroup";
    private static final String ENTRYENTITY = "entryentity";
    private static final String EXTEND = "extend";
    private static final String IMPORT = "import";
    private static final String SVNREVERT = "svnrevert";
    private static final String KEY_SVNOPERATE = "svnoperate";
    private static final String SVNLOG = "svnlog";
    private static final String DELETE = "delete";
    private static final String KEY_CODEMANAGE = "codemanage";
    private static final String EXPORT = "export";
    private static final String SVNDIFF = "svndiff";
    private static final String PRINT = "print";
    private static final String GENERATE = "generate";
    private static final String SVNLOCK = "svnlock";
    private static final String INHERIT = "inherit";
    private static final String SVNUNLOCK = "svnunlock";
    private static final String SVNDELETE = "svndelete";
    private static final String KEY_LAYOUT = "layout";
    private static final String SVNCLEAN = "svnclean";
    private static final String ADDNEW = "addnew";
    private static final String KEY_GITOPERATE = "gitoperate";
    private static final String ENTITYID = "entityid";
    private static final String MODELTYPE = "modeltype";
    private static final String PAGEID = "pageid";
    private static final String PAGENUMBER = "pagenumber";
    private static final String NUMBER = "number";
    private static final String PAGENAME = "pagename";
    private static final String BILLFORMMODEL = "BillFormModel";
    private static final String BASEFORMMODEL = "BaseFormModel";
    private static final String MODIFYDATE = "modifydate";
    private static final String MODIFYTIME = "datetime";
    private static final String ISCOLLECTED = "iscollected";
    private static final String PAGEENTITYID = "pageentityid";
    private static final String SUCCESS = "success";
    private static final String MESSAGE = "message";
    private static final String FORMID = "formid";
    private static final String BOS_DEVPORTAL_BIZPAGELIST = "bos_devportal_bizpagelist";
    private static final String MEAASGE = "message";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String BIZPAGEID = "bizpageid";
    private static final String BOS_FORMMETA = "bos_formmeta";
    private static final String BIZCUSTOMLISTAP = "bizcustomlistap";
    private static final String PRINTMODEL = "PrintModel";
    private static final String REPORTFORMMODEL = "ReportFormModel";
    private static final String BIZ_APPID = "bizappid";
    private static String[] str = new String[]{"bizcloudid", "bizappid", "bizappparentid", "bizapptype", "bizunitid", "sortrule", "devicetype", "pagetype", "SortBizPageGroup", "deviceGroup", "pageItemPageGroup"};
    private static final String ISEXTENDED = "isextended";
    private static final String ISINHERIT = "isinherit";
    private static final String BIZID = "bizid";
    private static final String BIZNUMBER = "biznumber";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbar"});
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        grid.addRowClickListener((RowClickEventListener)this);
        grid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void pageRelease(EventObject e) {
        IPageCache page = this.getPageCache();
        for (String pageCache : str) {
            page.remove(pageCache);
        }
    }

    public void afterCreateNewData(EventObject e) {
        String bizAppId = this.getPageCache().get("bizappid");
        String bizAppType = "";
        String bizAppParentId = "";
        if (StringUtils.isNotBlank((CharSequence)bizAppId)) {
            AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
            bizAppType = appMetadata.getDevType();
            bizAppParentId = appMetadata.getParentId();
            this.getPageCache().put(KEY_BIZAPPTYPE, bizAppType);
            this.getPageCache().put(BIZAPPPARENTID, bizAppParentId);
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"unittestcontrol"});
        if (StringUtils.isNotBlank((CharSequence)bizAppId) && !AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{ADDNEW, DELETE, "edit", "update", KEY_CODEMANAGE, KEY_SVNOPERATE, SVNDIFF, SVNLOG, SVNREVERT, SVNDELETE, SVNLOCK, SVNUNLOCK, SVNCLEAN, KEY_GITOPERATE, EXPORT, IMPORT, GENERATE, EXTEND, INHERIT, KEY_LAYOUT, PRINT, "move", "copy"});
        } else {
            if (StringUtils.isNotBlank((CharSequence)bizAppId)) {
                String codeManageType = DevportalUtil.getCodeManageTypeByBizAppId(bizAppId);
                if ("code".equals(codeManageType) || "none".equals(codeManageType)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SVNOPERATE});
                    this.getView().setVisible(Boolean.FALSE, new String[]{KEY_GITOPERATE});
                } else if ("svn".equals(codeManageType)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{KEY_SVNOPERATE});
                    this.getView().setVisible(Boolean.FALSE, new String[]{KEY_GITOPERATE});
                } else if ("git".equals(codeManageType)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SVNOPERATE});
                    this.getView().setVisible(Boolean.TRUE, new String[]{KEY_GITOPERATE});
                }
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"copy", KEY_LAYOUT, PRINT, EXTEND});
            if ("2".equals(bizAppType)) {
                this.getView().setEnable(Boolean.TRUE, new String[]{EXTEND});
            }
        }
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (parameter.getCustomParam("tabledata") != null) {
            JSONArray pageInfos = JSONArray.parseArray((String)((String)parameter.getCustomParam("tabledata")));
            this.getModel().deleteEntryData(ENTRYENTITY);
            if (pageInfos.size() > 0) {
                this.getModel().batchCreateNewEntryRow(ENTRYENTITY, pageInfos.size());
                for (int i = 0; i < pageInfos.size(); ++i) {
                    JSONObject pageInfo = pageInfos.getJSONObject(i);
                    String formId = pageInfo.getString("id");
                    String entityId = pageInfo.getString(ENTITYID);
                    String modelType = pageInfo.getString(MODELTYPE);
                    this.getModel().setValue(PAGEID, (Object)formId, i);
                    this.getModel().setValue(PAGENUMBER, pageInfo.get((Object)NUMBER), i);
                    this.getModel().setValue(PAGENAME, pageInfo.get((Object)"name"), i);
                    if (!formId.equals(entityId) && (BILLFORMMODEL.equals(modelType) || BASEFORMMODEL.equals(modelType))) {
                        this.getModel().setValue(KEY_PAGETYPE, (Object)"PCLayout", i);
                    } else {
                        this.getModel().setValue(KEY_PAGETYPE, (Object)modelType, i);
                    }
                    this.getModel().setValue("modifier", pageInfo.get((Object)"modifiername"), i);
                    this.getModel().setValue(MODIFYDATE, pageInfo.get((Object)MODIFYDATE), i);
                    try {
                        Object modifyDate = pageInfo.get((Object)MODIFYDATE);
                        if (modifyDate instanceof Date) {
                            this.getModel().setValue(MODIFYTIME, modifyDate, i);
                        } else if (modifyDate instanceof String) {
                            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            dateFormat.setTimeZone(KDDateUtils.getUserTimeZone());
                            Date date = dateFormat.parse((String)modifyDate);
                            this.getModel().setValue(MODIFYTIME, (Object)date, i);
                        }
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    this.getModel().setValue("sourcepage", pageInfo.get((Object)"parentnumber"), i);
                    this.getModel().setValue(ISCOLLECTED, pageInfo.get((Object)"isCollection"), i);
                    this.getModel().setValue(PAGEENTITYID, (Object)entityId, i);
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() != null) {
            Map map;
            if ("newPageWindowClose".equals(e.getActionId())) {
                Map map2 = (Map)e.getReturnData();
                if (map2 != null && ((Boolean)map2.get(SUCCESS)).booleanValue()) {
                    String bizUnitId = this.getPageCache().get(BIZUNITID);
                    String bizAppId = this.getPageCache().get("bizappid");
                    String SortBizPageGroup = this.getPageCache().get(SORTBIZPAGEGROUP);
                    String deviceGroup = this.getPageCache().get(DEVICEGROUP);
                    String pageItemPageGroup = this.getPageCache().get(PAGEITEMPAGEGROUP);
                    String formId = (String)map2.get(FORMID);
                    this.refreshPageList(bizUnitId, bizAppId, deviceGroup, pageItemPageGroup, SortBizPageGroup);
                    try {
                        DevportalUtil.gotoPageDesinger(this.getView().getParentView(), formId, BOS_DEVPORTAL_BIZPAGELIST);
                        this.getView().getParentView().showSuccessNotification(map2.get("message").toString(), Integer.valueOf(2000));
                    }
                    catch (Exception ex) {
                        this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u8868\u5355\u5df2\u521b\u5efa\u6210\u529f\uff0c\u5728BOS\u8bbe\u8ba1\u5668\u4e2d\u6253\u5f00\u8868\u5355\u5931\u8d25\u3002", (String)"PageListLayoutPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                    }
                } else if (map2 != null && !((Boolean)map2.get(SUCCESS)).booleanValue()) {
                    this.getView().getParentView().showErrorNotification(map2.get("message").toString());
                }
                this.getView().sendFormAction(this.getView().getParentView());
            } else if ("viewcallback".equals(e.getActionId())) {
                JSONObject positionMsg = (JSONObject)e.getReturnData();
                String bizCloudId = positionMsg.getString(KEY_BIZCLOUDID);
                String bizAppId = positionMsg.getString("bizappid");
                String bizUnitId = positionMsg.getString(BIZUNITID);
                String bizPageId = positionMsg.getString(BIZPAGEID);
                this.markTargetPage(bizCloudId, bizAppId, bizUnitId, bizPageId);
            } else if ("movepagecallback".equals(e.getActionId())) {
                JSONObject arg = (JSONObject)e.getReturnData();
                String bizAppId = arg.getString("bizappid");
                String bizUnitId = arg.getString(BIZUNITID);
                this.getPageCache().put(BIZUNITID, bizUnitId);
                String bizPageId = arg.getString(BIZPAGEID);
                String bizCloudId = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false).getBizCloudID();
                this.markTargetPage(bizCloudId, bizAppId, bizUnitId, bizPageId);
                String SortBizPageGroup = this.getPageCache().get(SORTBIZPAGEGROUP);
                String deviceGroup = this.getPageCache().get(DEVICEGROUP);
                String pageItemPageGroup = this.getPageCache().get(PAGEITEMPAGEGROUP);
                this.refreshPageList(bizUnitId, bizAppId, deviceGroup, pageItemPageGroup, SortBizPageGroup);
            } else if ("inheritPageWindowClose".equals(e.getActionId())) {
                Map map3 = (Map)e.getReturnData();
                if (((Boolean)map3.get(SUCCESS)).booleanValue()) {
                    String bizCloudId = map3.get(KEY_BIZCLOUDID).toString();
                    String bizAppId = map3.get("bizappid").toString();
                    String bizUnitId = map3.get(BIZUNITID).toString();
                    this.getPageCache().put(BIZUNITID, bizUnitId);
                    String bizPageId = map3.get(BIZPAGEID).toString();
                    this.markTargetPage(bizCloudId, bizAppId, bizUnitId, bizPageId);
                    String SortBizPageGroup = this.getPageCache().get(SORTBIZPAGEGROUP);
                    String deviceGroup = this.getPageCache().get(DEVICEGROUP);
                    String pageItemPageGroup = this.getPageCache().get(PAGEITEMPAGEGROUP);
                    this.refreshPageList(bizUnitId, bizAppId, deviceGroup, pageItemPageGroup, SortBizPageGroup);
                } else if (!((Boolean)map3.get(SUCCESS)).booleanValue()) {
                    this.getView().getParentView().showErrorNotification(map3.get("message").toString());
                    this.getView().sendFormAction(this.getView().getParentView());
                }
            } else if ("extend_EAPageWindowClose".equals(e.getActionId())) {
                Map map4 = (Map)e.getReturnData();
                if (map4 != null && ((Boolean)map4.get(SUCCESS)).booleanValue()) {
                    JSONObject data = (JSONObject)map4.get("data");
                    String bizCloudId = data.getString(KEY_BIZCLOUDID);
                    String bizAppId = data.getString("bizappid");
                    String bizUnitId = data.getString(BIZUNITID);
                    this.getPageCache().put(BIZUNITID, bizUnitId);
                    String bizPageId = data.getString(BIZPAGEID);
                    this.markTargetPage(bizCloudId, bizAppId, bizUnitId, bizPageId);
                    String SortBizPageGroup = this.getPageCache().get(SORTBIZPAGEGROUP);
                    String deviceGroup = this.getPageCache().get(DEVICEGROUP);
                    String pageItemPageGroup = this.getPageCache().get(PAGEITEMPAGEGROUP);
                    this.refreshPageList(bizUnitId, bizAppId, deviceGroup, pageItemPageGroup, SortBizPageGroup);
                    String number = MetadataDao.getNumberById((String)bizPageId);
                    this.writeLog(bizPageId, number, MetaLogType.FormDesign);
                } else if (map4 != null && !((Boolean)map4.get(SUCCESS)).booleanValue()) {
                    this.getView().getParentView().showErrorNotification(map4.get("message").toString());
                    this.getView().sendFormAction(this.getView().getParentView());
                }
            } else if ("importpagecallback".equals(e.getActionId())) {
                Object data = e.getReturnData();
                JSONObject message = new JSONObject();
                if (data instanceof JSONObject) {
                    message = (JSONObject)e.getReturnData();
                } else if (data instanceof JSONArray) {
                    message = (JSONObject)((JSONArray)e.getReturnData()).get(0);
                }
                if (message != null) {
                    String errorMessage = message.getString("ERROR");
                    String successMessage = message.getString("SUCCESS");
                    if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
                        String bizAppId = message.getString("bizappid");
                        String bizUnitId = message.getString(BIZUNITID);
                        this.getPageCache().put(BIZUNITID, bizUnitId);
                        String bizPageId = message.getString(BIZPAGEID);
                        String bizCloudId = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false).getBizCloudID();
                        this.markTargetPage(bizCloudId, bizAppId, bizUnitId, bizPageId);
                        String SortBizPageGroup = this.getPageCache().get(SORTBIZPAGEGROUP);
                        String deviceGroup = this.getPageCache().get(DEVICEGROUP);
                        String pageItemPageGroup = this.getPageCache().get(PAGEITEMPAGEGROUP);
                        this.refreshPageList(bizUnitId, bizAppId, deviceGroup, pageItemPageGroup, SortBizPageGroup);
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u51fa\u9519\uff0c\u9519\u8bef\u539f\u56e0\uff1a%s", (String)"PageListLayoutPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), errorMessage));
                    } else if (StringUtils.isNotBlank((CharSequence)successMessage)) {
                        String bizAppId = message.getString("bizappid");
                        String bizUnitId = message.getString(BIZUNITID);
                        this.getPageCache().put(BIZUNITID, bizUnitId);
                        String bizPageId = message.getString(BIZPAGEID);
                        String bizCloudId = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false).getBizCloudID();
                        this.markTargetPage(bizCloudId, bizAppId, bizUnitId, bizPageId);
                        String SortBizPageGroup = this.getPageCache().get(SORTBIZPAGEGROUP);
                        String deviceGroup = this.getPageCache().get(DEVICEGROUP);
                        String pageItemPageGroup = this.getPageCache().get(PAGEITEMPAGEGROUP);
                        this.refreshPageList(bizUnitId, bizAppId, deviceGroup, pageItemPageGroup, SortBizPageGroup);
                    }
                }
            } else if ("exportsourcecallback".equals(e.getActionId())) {
                String message = (String)e.getReturnData();
                if (StringUtils.isNotBlank((CharSequence)message) && "EXPORT_SUCCESS".equals(message)) {
                    this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"PageListLayoutPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(1000));
                    this.getView().sendFormAction(this.getView().getParentView());
                }
            } else if ("pringPageWindowClose".equals(e.getActionId())) {
                Map map5 = (Map)e.getReturnData();
                if (map5 != null) {
                    if (((Boolean)map5.get(SUCCESS)).booleanValue()) {
                        this.getView().showSuccessNotification(map5.get("message").toString());
                    } else if (!((Boolean)map5.get(SUCCESS)).booleanValue()) {
                        this.getView().showErrorNotification(map5.get("message").toString());
                    }
                    String bizAppId = this.getPageCache().get("bizappid");
                    String bizUnitId = this.getPageCache().get(BIZUNITID);
                    String bizPageId = this.getPageCache().get("bizprintpageid");
                    String bizCloudId = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false).getBizCloudID();
                    this.markTargetPage(bizCloudId, bizAppId, bizUnitId, bizPageId);
                    String SortBizPageGroup = this.getPageCache().get(SORTBIZPAGEGROUP);
                    String deviceGroup = this.getPageCache().get(DEVICEGROUP);
                    String pageItemPageGroup = this.getPageCache().get(PAGEITEMPAGEGROUP);
                    this.refreshPageList(bizUnitId, bizAppId, deviceGroup, pageItemPageGroup, SortBizPageGroup);
                }
            } else if ("layoutPageWindowClose".equals(e.getActionId())) {
                Map map6 = (Map)e.getReturnData();
                if (map6 != null) {
                    if (((Boolean)map6.get(SUCCESS)).booleanValue()) {
                        this.getView().showSuccessNotification(map6.get("message").toString());
                    } else if (!((Boolean)map6.get(SUCCESS)).booleanValue()) {
                        this.getView().showErrorNotification(map6.get("message").toString());
                    }
                    String bizAppId = this.getPageCache().get("bizappid");
                    String bizUnitId = this.getPageCache().get(BIZUNITID);
                    String bizPageId = this.getPageCache().get("bizlayoutpageid");
                    String bizCloudId = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false).getBizCloudID();
                    this.markTargetPage(bizCloudId, bizAppId, bizUnitId, bizPageId);
                    String SortBizPageGroup = this.getPageCache().get(SORTBIZPAGEGROUP);
                    String deviceGroup = this.getPageCache().get(DEVICEGROUP);
                    String pageItemPageGroup = this.getPageCache().get(PAGEITEMPAGEGROUP);
                    this.refreshPageList(bizUnitId, bizAppId, deviceGroup, pageItemPageGroup, SortBizPageGroup);
                }
            } else if ("copypagecallback".equals(e.getActionId()) && (map = (Map)e.getReturnData()) != null) {
                if (((Boolean)map.get(SUCCESS)).booleanValue()) {
                    String bizCloudId = map.get(KEY_BIZCLOUDID).toString();
                    String bizAppId = map.get("bizappid").toString();
                    String bizUnitId = map.get(BIZUNITID).toString();
                    String bizPageId = map.get(BIZPAGEID).toString();
                    this.markTargetPage(bizCloudId, bizAppId, bizUnitId, bizPageId);
                    String SortBizPageGroup = this.getPageCache().get(SORTBIZPAGEGROUP);
                    String deviceGroup = this.getPageCache().get(DEVICEGROUP);
                    String pageItemPageGroup = this.getPageCache().get(PAGEITEMPAGEGROUP);
                    this.refreshPageList(bizUnitId, bizAppId, deviceGroup, pageItemPageGroup, SortBizPageGroup);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9875\u9762\u590d\u5236\u6210\u529f\u3002", (String)"PageListLayoutPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                } else if (!((Boolean)map.get(SUCCESS)).booleanValue()) {
                    this.getView().showErrorNotification(map.get("message").toString());
                }
            }
        }
    }

    public void itemClick(ItemClickEvent e) {
        String key;
        boolean isHasPermission = DevportalPermissionUtils.isDevportalViewPermission("47150e89000000ac");
        if (!isHasPermission) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5f00\u53d1\u5e73\u53f0\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BizAppListPlugin_80", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        switch (key = e.getItemKey()) {
            case "addnew": {
                this.addNewPage();
                break;
            }
            case "edit": {
                this.editPage();
                break;
            }
            case "delete": {
                this.deletePageConfirm();
                break;
            }
            case "preview": {
                this.previewPage();
                break;
            }
            case "checkin": {
                this.checkIn();
                break;
            }
            case "svndiff": 
            case "svnlog": 
            case "svnrevert": 
            case "svndelete": 
            case "svnlock": 
            case "svnunlock": 
            case "svnclean": {
                this.svnOperate(key);
                break;
            }
            case "view": {
                this.pageView();
                break;
            }
            case "extend": {
                this.extendPage();
                break;
            }
            case "inherit": {
                this.inheritPage();
                break;
            }
            case "move": {
                this.movePage();
                break;
            }
            case "import": {
                this.importPage();
                break;
            }
            case "export": {
                this.exportPage();
                break;
            }
            case "print": {
                this.printTemplate();
                break;
            }
            case "copy": {
                this.copyPage();
                break;
            }
            case "layout": {
                this.layout();
                break;
            }
            case "unittestcontrol": {
                this.unittestcontrol();
                break;
            }
            case "commit": 
            case "push": 
            case "pull": 
            case "revert": {
                this.gitOperate(key);
                break;
            }
        }
    }

    private void gitOperate(String operateKey) {
        String bizSourceAppId;
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0 || selectIndex.length > 1) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"PageListLayoutPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        String formId = this.getModel().getValue(PAGEID, selectIndex[0]).toString();
        String bizAppId = this.getPageCache().get("bizappid");
        String bizAppParentId = this.getPageCache().get(BIZAPPPARENTID);
        if (StringUtils.isNotBlank((CharSequence)bizAppParentId) && !bizAppId.equals(bizSourceAppId = BusinessDataServiceHelper.loadSingleFromCache((Object)formId, (String)BOS_FORMMETA, (String)"bizappid").getString("bizappid"))) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u65e0\u6cd5\u64cd\u4f5c\u6e90\u8d44\u6e90\u3002", (String)"PageListLayoutPlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        if (!this.verifyPermissionAndLock()) {
            return;
        }
        String pageId = this.getView().getParentView().getPageId();
        JSONObject pageObject = new JSONObject();
        pageObject.put("id", (Object)formId);
        pageObject.put("operatekey", (Object)operateKey);
        pageObject.put(PAGEID, (Object)pageId);
        ((IClientViewProxy)this.getView().getParentView().getService(IClientViewProxy.class)).invokeControlMethod(BIZCUSTOMLISTAP, KEY_GITOPERATE, new Object[]{pageObject});
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private void writeLog(String formId, String formNumber, MetaLogType type) {
        try {
            long fid = DB.genGlobalLongId();
            MetadataLogService logService = (MetadataLogService)ServiceFactory.getService(MetadataLogService.class);
            logService.addMetaLog(formId, formNumber, (int)type.getValue(), fid, (int)MetaType.Form.getValue());
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u5143\u6570\u636e\u65e5\u5fd7\u5931\u8d25\uff0cerr\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        int rowIndex = evt.getRow();
        String bizAppType = this.getPageCache().get(KEY_BIZAPPTYPE);
        String bizAppId = this.getPageCache().get("bizappid");
        String pageId = (String)this.getModel().getValue(PAGEID, rowIndex);
        if (StringUtils.isNotBlank((CharSequence)pageId)) {
            DynamicObject pageObject = BusinessDataServiceHelper.loadSingleFromCache((Object)pageId, (String)BOS_FORMMETA, (String)"type,modeltype,parentid,basedatafield,isextended,bizappid");
            String modelType = pageObject.getString(MODELTYPE);
            String pageType = pageObject.getString("type");
            String entityId = pageObject.getString("basedatafield_id");
            boolean isextended = pageObject.getBoolean(ISEXTENDED);
            String bizSourceAppId = pageObject.getString("bizappid");
            if (StringUtils.isNotBlank((CharSequence)bizAppId) && !AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{ADDNEW, DELETE, "edit", "update", KEY_CODEMANAGE, KEY_SVNOPERATE, SVNDIFF, SVNLOG, SVNREVERT, SVNDELETE, SVNLOCK, SVNUNLOCK, SVNCLEAN, KEY_GITOPERATE, EXPORT, IMPORT, GENERATE, EXTEND, INHERIT, KEY_LAYOUT, PRINT, "move", "copy"});
            } else if ("2".equals(bizAppType)) {
                if (!bizAppId.equals(bizSourceAppId)) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{DELETE, "edit", KEY_SVNOPERATE, SVNDIFF, SVNLOG, SVNREVERT, SVNDELETE, SVNLOCK, SVNUNLOCK, SVNCLEAN, KEY_GITOPERATE, EXPORT, INHERIT, KEY_LAYOUT, PRINT, "move", "copy"});
                    this.getView().setEnable(Boolean.TRUE, new String[]{GENERATE, EXTEND, INHERIT});
                    if (PRINTMODEL.equals(modelType)) {
                        this.getView().setEnable(Boolean.FALSE, new String[]{GENERATE, EXTEND, INHERIT});
                        this.getView().setEnable(Boolean.TRUE, new String[]{"copy"});
                    } else if (!isextended && REPORTFORMMODEL.equals(modelType)) {
                        this.getView().setEnable(Boolean.FALSE, new String[]{GENERATE, EXTEND});
                    }
                    if (this.enableCopyForm(modelType, String.valueOf(pageObject.getPkValue()), entityId, pageType)) {
                        this.getView().setEnable(Boolean.TRUE, new String[]{"copy"});
                    }
                } else {
                    String codeManageType = DevportalUtil.getCodeManageTypeByBizAppId(bizAppId);
                    if ("code".equals(codeManageType) || "none".equals(codeManageType)) {
                        this.getView().setEnable(Boolean.FALSE, new String[]{KEY_SVNOPERATE, SVNDIFF, SVNLOG, SVNREVERT, SVNDELETE, SVNLOCK, SVNUNLOCK, SVNCLEAN});
                    } else if ("svn".equals(codeManageType)) {
                        this.getView().setEnable(Boolean.FALSE, new String[]{KEY_CODEMANAGE});
                        this.getView().setEnable(Boolean.TRUE, new String[]{KEY_SVNOPERATE, SVNDIFF, SVNLOG, SVNREVERT, SVNDELETE, SVNLOCK, SVNUNLOCK, SVNCLEAN});
                    }
                    this.getView().setEnable(Boolean.TRUE, new String[]{DELETE, "edit", "view", GENERATE, INHERIT, EXTEND, EXPORT, "move"});
                    this.getView().setEnable(Boolean.FALSE, new String[]{KEY_LAYOUT, PRINT, "copy"});
                    if ("2".equals(pageType)) {
                        this.getView().setEnable(Boolean.FALSE, new String[]{INHERIT, "move"});
                        if (PRINTMODEL.equals(modelType)) {
                            this.getView().setEnable(Boolean.FALSE, new String[]{GENERATE, EXTEND});
                            this.getView().setEnable(Boolean.TRUE, new String[]{"copy"});
                        } else if (!isextended && REPORTFORMMODEL.equals(modelType)) {
                            this.getView().setEnable(Boolean.FALSE, new String[]{EXTEND});
                        }
                        if (this.enableCopyForm(modelType, String.valueOf(pageObject.getPkValue()), entityId, pageType)) {
                            this.getView().setEnable(Boolean.TRUE, new String[]{"copy"});
                        }
                    } else if (BASEFORMMODEL.equals(modelType) || BILLFORMMODEL.equals(modelType)) {
                        this.getView().setEnable(Boolean.TRUE, new String[]{KEY_LAYOUT, PRINT});
                        if (this.enableCopyForm(modelType, String.valueOf(pageObject.getPkValue()), entityId, pageType)) {
                            this.getView().setEnable(Boolean.TRUE, new String[]{"copy"});
                        }
                    } else if (PRINTMODEL.equals(modelType)) {
                        this.getView().setEnable(Boolean.FALSE, new String[]{GENERATE, EXTEND, INHERIT});
                        this.getView().setEnable(Boolean.TRUE, new String[]{"copy"});
                    } else if (REPORTFORMMODEL.equals(modelType)) {
                        this.getView().setEnable(Boolean.TRUE, new String[]{PRINT});
                        if (!isextended) {
                            this.getView().setEnable(Boolean.FALSE, new String[]{EXTEND});
                        }
                    }
                }
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{DELETE, "edit", "view", GENERATE, EXPORT, INHERIT, "move"});
                this.getView().setEnable(Boolean.FALSE, new String[]{EXTEND, KEY_LAYOUT, PRINT, "copy"});
                if (BASEFORMMODEL.equals(modelType) || BILLFORMMODEL.equals(modelType)) {
                    if (pageId.equals(entityId)) {
                        this.getView().setEnable(Boolean.TRUE, new String[]{KEY_LAYOUT, PRINT, "copy"});
                    }
                } else if (PRINTMODEL.equals(modelType)) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{GENERATE, INHERIT});
                    this.getView().setEnable(Boolean.TRUE, new String[]{"copy"});
                } else if (REPORTFORMMODEL.equals(modelType)) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{PRINT});
                    if (!isextended) {
                        this.getView().setEnable(Boolean.FALSE, new String[]{EXTEND});
                    }
                }
                if ("2".equals(pageType)) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{GENERATE, INHERIT});
                }
            }
        }
    }

    private boolean enableCopyForm(String modelType, String formId, String entityId, String devType) {
        return !"2".equals(devType) && (BILLFORMMODEL.equals(modelType) || BASEFORMMODEL.equals(modelType) && StringUtils.equals((CharSequence)entityId, (CharSequence)String.valueOf(formId)));
    }

    private void unittestcontrol() {
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0 || selectIndex.length > 1) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"PageListLayoutPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        ListShowParameter sp = new ListShowParameter();
        ListFilterParameter fParameter = new ListFilterParameter();
        String formId = this.getModel().getValue(PAGEID, selectIndex[0]).toString();
        String pageNumber = BusinessDataServiceHelper.loadSingleFromCache((Object)formId, (String)BOS_FORMMETA, (String)NUMBER).getString(NUMBER);
        QFilter filter = new QFilter("txt_object.number", "=", (Object)pageNumber);
        fParameter.setFilter(filter);
        sp.setListFilterParameter(fParameter);
        sp.setBillFormId("ide_unit_test_detail");
        sp.getOpenStyle().setShowType(ShowType.Modal);
        sp.setCustomParam("mainentityinfoid", (Object)pageNumber);
        this.getView().showForm((FormShowParameter)sp);
    }

    private void svnOperate(String key) {
        String bizSourceAppId;
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0 || selectIndex.length > 1) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"PageListLayoutPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        String formId = this.getModel().getValue(PAGEID, selectIndex[0]).toString();
        String bizAppId = this.getPageCache().get("bizappid");
        String bizAppParentId = this.getPageCache().get(BIZAPPPARENTID);
        if (StringUtils.isNotBlank((CharSequence)bizAppParentId) && !bizAppId.equals(bizSourceAppId = BusinessDataServiceHelper.loadSingleFromCache((Object)formId, (String)BOS_FORMMETA, (String)"bizappid").getString("bizappid"))) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u65e0\u6cd5\u64cd\u4f5c\u6e90\u8d44\u6e90\u3002", (String)"PageListLayoutPlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        if (!this.verifyPermissionAndLock()) {
            return;
        }
        String pageId = this.getView().getParentView().getPageId();
        JSONObject pageObject = new JSONObject();
        pageObject.put("id", (Object)formId);
        pageObject.put("operatekey", (Object)key);
        pageObject.put(PAGEID, (Object)pageId);
        ((IClientViewProxy)this.getView().getParentView().getService(IClientViewProxy.class)).invokeControlMethod(BIZCUSTOMLISTAP, KEY_SVNOPERATE, new Object[]{pageObject});
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private void addNewPage() {
        if (EnvTypeHelper.isProductEnv()) {
            this.showDisableMessage();
            return;
        }
        boolean isHasPermisson = AppUtils.checkPagePermission((String)BOS_DEVPORTAL_BIZPAGELIST, (String)"47156aff000000ac");
        if (!isHasPermisson) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"PageListLayoutPlugin_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String bizUnitId = this.getPageCache().get(BIZUNITID);
        String bizAppId = this.getPageCache().get("bizappid");
        String bizCloudId = this.getPageCache().get(KEY_BIZCLOUDID);
        if (StringUtils.isBlank((CharSequence)bizUnitId)) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u529f\u80fd\u5206\u7ec4\uff0c\u518d\u5728\u8be5\u529f\u80fd\u5206\u7ec4\u4e0b\u65b0\u589e\u9875\u9762\u3002", (String)"PageListLayoutPlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        if (!this.verifyPermission()) {
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_entrance");
        parameter.setCustomParam(KEY_BIZCLOUDID, (Object)bizCloudId);
        parameter.setCustomParam("bizappid", (Object)bizAppId);
        parameter.setCustomParam(BIZUNITID, (Object)bizUnitId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(ResManager.loadKDString((String)"\u521b\u5efa\u9875\u9762\u5411\u5bfc", (String)"PageListLayoutPlugin_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "newPageWindowClose");
        parameter.setCloseCallBack(callBack);
        parameter.setStatus(OperationStatus.ADDNEW);
        this.getView().showForm(parameter);
    }

    private void editPage() {
        String bizSourceAppId;
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0 || selectIndex.length > 1) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"PageListLayoutPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        String bizAppId = this.getPageCache().get("bizappid");
        String bizAppParentId = this.getPageCache().get(BIZAPPPARENTID);
        String pageId = this.getModel().getValue(PAGEID, selectIndex[0]).toString();
        if (StringUtils.isNotBlank((CharSequence)bizAppParentId) && !bizAppId.equals(bizSourceAppId = BusinessDataServiceHelper.loadSingleFromCache((Object)pageId, (String)BOS_FORMMETA, (String)"bizappid").getString("bizappid"))) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u65e0\u6cd5\u64cd\u4f5c\u6e90\u8d44\u6e90\u3002", (String)"PageListLayoutPlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        DevportalUtil.gotoPageDesinger(this.getView(), pageId, BOS_DEVPORTAL_BIZPAGELIST);
    }

    private boolean verifyPermissionAndLock() {
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0 || selectIndex.length > 1) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"PageListLayoutPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return false;
        }
        String bizAppId = this.getPageCache().get("bizappid");
        String formId = this.getModel().getValue(PAGEID, selectIndex[0]).toString();
        String number = this.getModel().getValue(PAGENUMBER, selectIndex[0]).toString();
        boolean isPermission = DevVerifyServiceHelper.verifyPermission(null, (String)bizAppId);
        if (!isPermission) {
            this.getView().showTipNotification(DevportalVerify.getNoPermissionTip());
            return false;
        }
        Map lockInfo = DevVerifyServiceHelper.verifyLock(null, (String)number);
        if (((Boolean)lockInfo.get("result")).booleanValue()) {
            String userName = (String)lockInfo.get("username");
            this.getView().showTipNotification(DevportalVerify.getLockTip((String)userName));
            return false;
        }
        return true;
    }

    private boolean verifyPermission() {
        String bizAppId = this.getPageCache().get("bizappid");
        boolean isPermission = DevVerifyServiceHelper.verifyPermission(null, (String)bizAppId);
        if (!isPermission) {
            this.getView().showTipNotification(DevportalVerify.getNoPermissionTip());
            return false;
        }
        return true;
    }

    private void deletePageConfirm() {
        String bizAppId = this.getPageCache().get("bizappid");
        if (!this.verifyPermissionAndLock()) {
            return;
        }
        if (EnvTypeHelper.isProductEnv()) {
            this.showDisableMessage();
            return;
        }
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u3002", (String)"PageListLayoutPlugin_10", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        String bizAppParentId = this.getPageCache().get(BIZAPPPARENTID);
        JSONArray pageArray = new JSONArray();
        JSONObject pageObject = new JSONObject();
        for (int i = 0; i < selectIndex.length; ++i) {
            String bizSourceAppId;
            String formId = this.getModel().getValue(PAGEID, selectIndex[i]).toString();
            if (StringUtils.isNotBlank((CharSequence)bizAppParentId) && !bizAppId.equals(bizSourceAppId = BusinessDataServiceHelper.loadSingleFromCache((Object)formId, (String)BOS_FORMMETA, (String)"bizappid").getString("bizappid"))) {
                this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u65e0\u6cd5\u64cd\u4f5c\u6e90\u8d44\u6e90\u3002", (String)"PageListLayoutPlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                this.getView().sendFormAction(this.getView().getParentView());
                return;
            }
            String isCollection = this.getModel().getValue(ISCOLLECTED, selectIndex[i]).toString();
            pageArray.add((Object)(formId + "-" + isCollection));
        }
        String bizUnitId = this.getPageCache().get(BIZUNITID);
        String parentPageId = this.getView().getParentView().getPageId();
        String pageId = this.getView().getPageId();
        pageObject.put("pagesinfo", (Object)pageArray);
        pageObject.put("parentpageid", (Object)parentPageId);
        pageObject.put(PAGEID, (Object)pageId);
        pageObject.put("bizappid", (Object)bizAppId);
        pageObject.put(BIZUNITID, (Object)bizUnitId);
        ((IClientViewProxy)this.getView().getParentView().getService(IClientViewProxy.class)).invokeControlMethod(BIZCUSTOMLISTAP, "deletepage", new Object[]{pageObject});
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private void previewPage() {
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0 || selectIndex.length > 1) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"PageListLayoutPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        String pageId = this.getModel().getValue(PAGEID, selectIndex[0]).toString();
        DynamicObject pageObject = BusinessDataServiceHelper.loadSingleFromCache((Object)pageId, (String)BOS_FORMMETA, (String)"type,masterid");
        String pageType = pageObject.getString("type");
        String name = "";
        String number = "";
        String modelType = "";
        HashMap<String, String> map = new HashMap<String, String>();
        if ("CardModel".equals(this.getModel().getValue(KEY_PAGETYPE, selectIndex[0]))) {
            String formNumber = this.getModel().getValue(PAGENUMBER, selectIndex[0]).toString();
            if (StringUtils.isBlank((CharSequence)formNumber)) {
                return;
            }
            String formId = pageId;
            FormMetadata meta = (FormMetadata)MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Form);
            HashMap<String, Object> config = new HashMap<String, Object>(16);
            config.put("type", "cardform");
            config.put(FORMID, formNumber);
            config.put("appId", BizAppServiceHelp.getAppIdByFormNum((String)formId));
            config.put(PAGEID, this.getView().getPageId());
            config.put("language", meta.getRootAp().getLanguage());
            if (meta.getRootAp().getWidth() != null) {
                config.put("width", meta.getRootAp().getWidth().toString());
            }
            if (meta.getRootAp().getHeight() != null) {
                config.put("height", meta.getRootAp().getHeight().toString());
            }
            config.put("backgroundColor", meta.getRootAp().getBackColor());
            Style style = meta.getRootAp().getStyle();
            if (style != null) {
                config.put("style", style.getStyle());
            }
            String mobDomainUrl = UrlService.getMobileDomainContextUrl();
            config.put("ajaxUrl", mobDomainUrl);
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.addAction("showForm", config);
            return;
        }
        if ("2".equals(pageType)) {
            String masterId = pageObject.getString("masterid");
            DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)masterId, (String)BOS_FORMMETA, (String)"id,name,number,modeltype,basedatafield");
            name = obj.getString("name");
            number = obj.getString(NUMBER);
            modelType = obj.getString(MODELTYPE);
            String formNumber = MetadataDao.getNumberById((String)masterId);
            FormConfig formConfig = FormMetadataCache.getFormConfig((String)formNumber);
            FormRoot formRoot = FormMetadataCache.getRootControl((String)formNumber);
            if (formConfig != null && formRoot != null) {
                name = formConfig.getCaption().getLocaleValue();
                number = formRoot.getKey();
            }
        } else {
            number = this.getModel().getValue(PAGENUMBER, selectIndex[0]).toString();
            modelType = this.getModel().getValue(KEY_PAGETYPE, selectIndex[0]).toString();
            name = this.getModel().getValue(PAGENAME, selectIndex[0]).toString();
        }
        map.put("formname", name);
        map.put("formnumber", number);
        map.put("devtype", pageType);
        map.put(FORMID, pageId);
        map.put(MODELTYPE, modelType);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_pagepreview");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParams(map);
        parameter.setCaption(ResManager.loadKDString((String)"\u9884\u89c8\u4e0e\u8c03\u8bd5", (String)"PageListLayoutPlugin_11", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        this.getView().showForm(parameter);
    }

    private void checkIn() {
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0 || selectIndex.length > 1) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"PageListLayoutPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        String formId = this.getModel().getValue(PAGEID, selectIndex[0]).toString();
        String pageId = this.getView().getParentView().getPageId();
        String bizAppId = this.getPageCache().get("bizappid");
        JSONObject pageObject = new JSONObject();
        pageObject.put(BIZID, (Object)formId);
        pageObject.put(PAGEID, (Object)pageId);
        pageObject.put("bizappid", (Object)bizAppId);
        ((IClientViewProxy)this.getView().getParentView().getService(IClientViewProxy.class)).invokeControlMethod(BIZCUSTOMLISTAP, "checkinpage", new Object[]{pageObject});
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private void pageView() {
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0 || selectIndex.length > 1) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"PageListLayoutPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devportal_hierarchy");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(FORMID, (Object)this.getModel().getValue(PAGEID, selectIndex[0]).toString());
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "viewcallback");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void inheritPage() {
        boolean isInHerit;
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0 || selectIndex.length > 1) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"PageListLayoutPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        String bizAppId = this.getPageCache().get("bizappid");
        String parentId = this.getModel().getValue(PAGEID, selectIndex[0]).toString();
        String bizUnitId = this.getPageCache().get(BIZUNITID);
        String modeltype = this.getModel().getValue(KEY_PAGETYPE, selectIndex[0]).toString();
        String selectFields = "isinherit,modeltype";
        DynamicObject parent = BusinessDataServiceHelper.loadSingleFromCache((Object)parentId, (String)BOS_FORMMETA, (String)selectFields);
        boolean bl = isInHerit = parent == null ? true : parent.getBoolean(ISINHERIT);
        if (!isInHerit) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u9875\u9762\u4e0d\u5141\u8bb8\u7ee7\u627f\u3002", (String)"PageListLayoutPlugin_21", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (!this.verifyPermissionAndLock()) {
            return;
        }
        if (parent != null && "PCLayout".equals(modeltype)) {
            modeltype = parent.getString(MODELTYPE);
        }
        String parentName = this.getModel().getValue(PAGENAME, selectIndex[0]).toString();
        String parentNumber = this.getModel().getValue(PAGENUMBER, selectIndex[0]).toString();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_pageinherit");
        parameter.setCustomParam("bizAppId", (Object)bizAppId);
        parameter.setCustomParam(BIZUNITID, (Object)bizUnitId);
        parameter.setCustomParam(MODELTYPE, (Object)modeltype);
        parameter.setCustomParam("parentId", (Object)parentId);
        parameter.setCustomParam("parentName", (Object)parentName);
        parameter.setCustomParam("parentNumber", (Object)parentNumber);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(ResManager.loadKDString((String)"\u7ee7\u627f\u9875\u9762", (String)"PageListLayoutPlugin_12", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "inheritPageWindowClose");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void extendPage() {
        boolean isExtended;
        String selectFields;
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0 || selectIndex.length > 1) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"PageListLayoutPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        String extbizAppId = this.getPageCache().get("bizappid");
        String oriFormId = this.getModel().getValue(PAGEID, selectIndex[0]).toString();
        DynamicObject oriForm = BusinessDataServiceHelper.loadSingleFromCache((Object)oriFormId, (String)BOS_FORMMETA, (String)(selectFields = "isextended,modeltype"));
        boolean bl = isExtended = oriForm == null ? true : oriForm.getBoolean(ISEXTENDED);
        if (!isExtended) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u9875\u9762\u4e0d\u5141\u8bb8\u6269\u5c55\u3002", (String)"PageListLayoutPlugin_22", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (!this.verifyPermissionAndLock()) {
            return;
        }
        String bizUnitId = this.getPageCache().get(BIZUNITID);
        String bizPageName = this.getModel().getValue(PAGENAME, selectIndex[0]).toString();
        String bizPageNumber = this.getModel().getValue(PAGENUMBER, selectIndex[0]).toString();
        String modelType = this.getModel().getValue(KEY_PAGETYPE, selectIndex[0]).toString();
        String entityId = this.getModel().getValue(PAGEENTITYID, selectIndex[0]).toString();
        String count = DevportalUtil.getParallelExtCountByIsv(oriFormId, BOS_FORMMETA, "parentid");
        if (!"0".equals(count)) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u9875\u9762\u53ea\u5141\u8bb8\u6269\u5c551\u6b21\u3002", (String)"PageListLayoutPlugin_14", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        this.getPageCache().put(BIZUNITID, bizUnitId);
        this.getPageCache().put("extbizAppId", extbizAppId);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_extappextpage");
        parameter.setCustomParam("extBizAppId", (Object)extbizAppId);
        parameter.setCustomParam("oriBizunitId", (Object)bizUnitId);
        parameter.setCustomParam("oriFormId", (Object)oriFormId);
        parameter.setCustomParam("oriBizPageName", (Object)bizPageName);
        parameter.setCustomParam("oriBizPageNumber", (Object)bizPageNumber);
        parameter.setCustomParam("modelType", (Object)modelType);
        parameter.setCustomParam(ENTITYID, (Object)entityId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(ResManager.loadKDString((String)"\u6269\u5c55\u9875\u9762", (String)"PageListLayoutPlugin_13", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "extend_EAPageWindowClose");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void movePage() {
        String bizSourceAppId;
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0 || selectIndex.length > 1) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"PageListLayoutPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        String bizAppId = this.getPageCache().get("bizappid");
        String bizAppParentId = this.getPageCache().get(BIZAPPPARENTID);
        String pageId = this.getModel().getValue(PAGEID, selectIndex[0]).toString();
        if (StringUtils.isNotBlank((CharSequence)bizAppParentId) && !bizAppId.equals(bizSourceAppId = BusinessDataServiceHelper.loadSingleFromCache((Object)pageId, (String)BOS_FORMMETA, (String)"bizappid").getString("bizappid"))) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u65e0\u6cd5\u64cd\u4f5c\u6e90\u8d44\u6e90\u3002", (String)"PageListLayoutPlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        if (!this.verifyPermissionAndLock()) {
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devportal_movepage");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("bizappid", (Object)this.getPageCache().get("bizappid"));
        parameter.setCustomParam(BIZUNITID, (Object)this.getPageCache().get(BIZUNITID));
        parameter.setCustomParam("bizformid", (Object)this.getModel().getValue(PAGEID, selectIndex[0]).toString());
        parameter.setCustomParam("bizentityid", (Object)this.getModel().getValue(PAGEENTITYID, selectIndex[0]).toString());
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "movepagecallback");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void showDisableMessage() {
        String errorMsg = ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u73af\u5883\u7a33\u5b9a\uff0c\u751f\u4ea7\u73af\u5883\u6682\u4e0d\u5141\u8bb8\u7f16\u8f91\u5143\u6570\u636e\u3002", (String)"PageListLayoutPlugin_20", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
        IFormView parentView = this.getView().getParentView();
        parentView.showErrorNotification(errorMsg);
        this.getView().sendFormAction(parentView);
    }

    private void importPage() {
        if (EnvTypeHelper.isProductEnv()) {
            this.showDisableMessage();
            return;
        }
        if (!this.verifyPermission()) {
            return;
        }
        String bizAppId = this.getPageCache().get("bizappid");
        String selectedUnitId = this.getPageCache().get(BIZUNITID);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_importpage");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(BIZUNITID, (Object)selectedUnitId);
        parameter.setCustomParam("bizunitType", (Object)"1");
        parameter.setCustomParam("bizappid", (Object)bizAppId);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "importpagecallback");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void exportPage() {
        String bizSourceAppId;
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0 || selectIndex.length > 1) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"PageListLayoutPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        String bizAppId = this.getPageCache().get("bizappid");
        String bizAppParentId = this.getPageCache().get(BIZAPPPARENTID);
        String selectedUnitId = this.getPageCache().get(BIZUNITID);
        String bizFormid = this.getModel().getValue(PAGEID, selectIndex[0]).toString();
        if (StringUtils.isNotBlank((CharSequence)bizAppParentId) && !bizAppId.equals(bizSourceAppId = BusinessDataServiceHelper.loadSingleFromCache((Object)bizFormid, (String)BOS_FORMMETA, (String)"bizappid").getString("bizappid"))) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u65e0\u6cd5\u64cd\u4f5c\u6e90\u8d44\u6e90\u3002", (String)"PageListLayoutPlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        if (!this.verifyPermissionAndLock()) {
            return;
        }
        String bizFormNumber = this.getModel().getValue(PAGENUMBER, selectIndex[0]).toString();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCaption(ResManager.loadKDString((String)"\u5bfc\u51fa\u9875\u9762", (String)"PageListLayoutPlugin_15", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        parameter.setFormId("bos_devp_exportsource");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("bizappid", (Object)bizAppId);
        parameter.setCustomParam(BIZUNITID, (Object)selectedUnitId);
        parameter.setCustomParam("bizformnumber", (Object)bizFormNumber);
        parameter.setCustomParam(BIZID, (Object)bizFormid);
        parameter.setCustomParam("type", (Object)PAGETYPE);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "exportsourcecallback");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void printTemplate() {
        String bizSourceAppId;
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0 || selectIndex.length > 1) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"PageListLayoutPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        String bizAppId = this.getPageCache().get("bizappid");
        String bizAppParentId = this.getPageCache().get(BIZAPPPARENTID);
        String pageId = this.getModel().getValue(PAGEID, selectIndex[0]).toString();
        if (StringUtils.isNotBlank((CharSequence)bizAppParentId) && !bizAppId.equals(bizSourceAppId = BusinessDataServiceHelper.loadSingleFromCache((Object)pageId, (String)BOS_FORMMETA, (String)"bizappid").getString("bizappid"))) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u65e0\u6cd5\u64cd\u4f5c\u6e90\u8d44\u6e90\u3002", (String)"PageListLayoutPlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        if (!this.verifyPermissionAndLock()) {
            return;
        }
        String bizPageType = this.getModel().getValue(KEY_PAGETYPE, selectIndex[0]).toString();
        if (BASEFORMMODEL.equals(bizPageType) || BILLFORMMODEL.equals(bizPageType) || REPORTFORMMODEL.equals(bizPageType)) {
            String pageName = this.getModel().getValue(PAGENAME, selectIndex[0]).toString();
            String pageNumber = this.getModel().getValue(PAGENUMBER, selectIndex[0]).toString();
            String entityId = this.getModel().getValue(PAGEENTITYID, selectIndex[0]).toString();
            String bizUnitId = this.getPageCache().get(BIZUNITID);
            this.getPageCache().put("bizprintpageid", pageId);
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bos_devp_pageprint");
            parameter.setCustomParam("bizappid", (Object)bizAppId);
            parameter.setCustomParam(BIZUNITID, (Object)bizUnitId);
            parameter.setCustomParam(ENTITYID, (Object)entityId);
            parameter.setCustomParam(PAGENAME, (Object)pageName);
            parameter.setCustomParam(PAGENUMBER, (Object)pageNumber);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCaption(ResManager.loadKDString((String)"\u6253\u5370\u9875\u9762", (String)"PageListLayoutPlugin_16", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "pringPageWindowClose");
            parameter.setCloseCallBack(callBack);
            this.getView().showForm(parameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u7c7b\u578b\u9875\u9762\u4e0d\u652f\u6301\u6253\u5370\u529f\u80fd\u3002", (String)"PageListLayoutPlugin_17", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }

    private void copyPage() {
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0 || selectIndex.length > 1) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"PageListLayoutPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        if (!this.verifyPermissionAndLock()) {
            return;
        }
        String bizAppId = this.getPageCache().get("bizappid");
        String bizUnitId = this.getPageCache().get(BIZUNITID);
        String bizFormid = this.getModel().getValue(PAGEID, selectIndex[0]).toString();
        String pageName = this.getModel().getValue(PAGENAME, selectIndex[0]).toString();
        String pageNumber = this.getModel().getValue(PAGENUMBER, selectIndex[0]).toString();
        FormShowParameter parameter = new FormShowParameter();
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)bizFormid, (String)BOS_FORMMETA);
        String modelType = "";
        if (obj != null) {
            modelType = obj.getString(MODELTYPE);
        }
        if (StringUtils.equals((CharSequence)PRINTMODEL, (CharSequence)modelType)) {
            parameter.setFormId("bos_devportal_copypage");
        } else {
            parameter.setFormId("bos_devportal_formcopy");
        }
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(PAGENAME, (Object)pageName);
        parameter.setCustomParam(PAGENUMBER, (Object)pageNumber);
        parameter.setCustomParam("bizappid", (Object)bizAppId);
        parameter.setCustomParam(BIZUNITID, (Object)bizUnitId);
        parameter.setCustomParam("bizformid", (Object)bizFormid);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "copypagecallback");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void layout() {
        String bizSourceAppId;
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0 || selectIndex.length > 1) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"PageListLayoutPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        String bizAppId = this.getPageCache().get("bizappid");
        String bizAppParentId = this.getPageCache().get(BIZAPPPARENTID);
        String pageId = this.getModel().getValue(PAGEID, selectIndex[0]).toString();
        if (StringUtils.isNotBlank((CharSequence)bizAppParentId) && !bizAppId.equals(bizSourceAppId = BusinessDataServiceHelper.loadSingleFromCache((Object)pageId, (String)BOS_FORMMETA, (String)"bizappid").getString("bizappid"))) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u65e0\u6cd5\u64cd\u4f5c\u6e90\u8d44\u6e90\u3002", (String)"PageListLayoutPlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        if (!this.verifyPermissionAndLock()) {
            return;
        }
        String modelType = this.getModel().getValue(KEY_PAGETYPE, selectIndex[0]).toString();
        if (BASEFORMMODEL.equals(modelType) || BILLFORMMODEL.equals(modelType)) {
            String bizUnitId = this.getPageCache().get(BIZUNITID);
            String entityId = this.getModel().getValue(PAGEENTITYID, selectIndex[0]).toString();
            String pageName = this.getModel().getValue(PAGENAME, selectIndex[0]).toString();
            String pageNumber = this.getModel().getValue(PAGENUMBER, selectIndex[0]).toString();
            this.getPageCache().put("bizlayoutpageid", pageId);
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bos_devp_pagelayout");
            parameter.setCustomParam("bizappid", (Object)bizAppId);
            parameter.setCustomParam(BIZUNITID, (Object)bizUnitId);
            parameter.setCustomParam(MODELTYPE, (Object)modelType);
            parameter.setCustomParam(ENTITYID, (Object)entityId);
            parameter.setCustomParam(PAGENAME, (Object)pageName);
            parameter.setCustomParam(PAGENUMBER, (Object)pageNumber);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCaption(ResManager.loadKDString((String)"\u9875\u9762\u5e03\u5c40", (String)"PageListLayoutPlugin_18", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "layoutPageWindowClose");
            parameter.setCloseCallBack(callBack);
            this.getView().showForm(parameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u548c\u57fa\u7840\u8d44\u6599\u624d\u53ef\u4ee5\u4f7f\u7528\u5e03\u5c40\u529f\u80fd\u3002", (String)"PageListLayoutPlugin_19", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        int rowIndex = e.getRowIndex();
        String pageId = this.getModel().getValue(PAGEID, rowIndex).toString();
        DevportalUtil.gotoPageDesinger(this.getView(), pageId, BOS_DEVPORTAL_BIZPAGELIST);
    }

    private void refreshPageList(String bizUnitId, String bizAppId, String deviceType, String bizPageModelType, String sortBizPageGroupType) {
        if (StringUtils.isBlank((CharSequence)deviceType)) {
            deviceType = "all";
        }
        if (StringUtils.isBlank((CharSequence)bizPageModelType)) {
            bizPageModelType = "AllFormModel";
        }
        if (StringUtils.isBlank((CharSequence)sortBizPageGroupType)) {
            sortBizPageGroupType = NUMBER;
        }
        JSONArray pageInfos = DevportalUtil.getSelectedUnitPages(bizAppId, bizUnitId, deviceType, bizPageModelType, sortBizPageGroupType);
        this.getModel().deleteEntryData(ENTRYENTITY);
        if (pageInfos.size() > 0) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, pageInfos.size());
            for (int i = 0; i < pageInfos.size(); ++i) {
                JSONObject pageInfo = pageInfos.getJSONObject(i);
                this.getModel().setValue(PAGEID, pageInfo.get((Object)"id"), i);
                this.getModel().setValue(PAGENUMBER, pageInfo.get((Object)NUMBER), i);
                this.getModel().setValue(PAGENAME, pageInfo.get((Object)"name"), i);
                this.getModel().setValue(KEY_PAGETYPE, pageInfo.get((Object)MODELTYPE), i);
                this.getModel().setValue("modifier", pageInfo.get((Object)"modifiername"), i);
                this.getModel().setValue(MODIFYDATE, pageInfo.get((Object)MODIFYDATE), i);
                try {
                    Object modifyDate = pageInfo.get((Object)MODIFYDATE);
                    if (modifyDate instanceof Date) {
                        this.getModel().setValue(MODIFYTIME, modifyDate, i);
                    } else if (modifyDate instanceof String) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        Date date = dateFormat.parse((String)modifyDate);
                        this.getModel().setValue(MODIFYTIME, (Object)date, i);
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                this.getModel().setValue("sourcepage", pageInfo.get((Object)"parentnumber"), i);
                this.getModel().setValue(ISCOLLECTED, pageInfo.get((Object)"isCollection"), i);
                this.getModel().setValue(PAGEENTITYID, pageInfo.get((Object)ENTITYID), i);
            }
        }
    }

    private void markTargetPage(String bizCloudId, String bizAppId, String bizUnitId, String bizPageId) {
        JSONObject arg = new JSONObject();
        arg.put(KEY_BIZCLOUDID, (Object)bizCloudId);
        arg.put("bizappid", (Object)bizAppId);
        arg.put(BIZUNITID, (Object)bizUnitId);
        arg.put(BIZPAGEID, (Object)bizPageId);
        arg.put("isneedguide", (Object)Boolean.TRUE);
        DevportalUtil.locateResourcePos(arg, this.getView().getParentView(), "page");
        this.getView().sendFormAction(this.getView().getParentView());
    }
}

