/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.service.KDDateUtils;

public class PageOneSvnLog
extends AbstractFormPlugin
implements UploadListener {
    private static final String HIDEITEM = "version";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        List svnLogs = (List)parameter.getCustomParam("svnlogs");
        String fileName = (String)parameter.getCustomParam("filename");
        this.showSvnLogs(svnLogs, fileName);
    }

    private void showSvnLogs(List<JSONObject> svnLogs, String fileName) {
        Collections.sort(svnLogs, new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject a, JSONObject b) {
                Integer valA = a.getIntValue(PageOneSvnLog.HIDEITEM);
                Integer valB = b.getIntValue(PageOneSvnLog.HIDEITEM);
                return valB.compareTo(valA);
            }
        });
        if (svnLogs.size() > 0) {
            this.getModel().batchCreateNewEntryRow("entryentity", svnLogs.size());
            for (int i = 0; i < svnLogs.size(); ++i) {
                JSONObject listSvnLog = svnLogs.get(i);
                this.getModel().setValue(HIDEITEM, (Object)listSvnLog.getString(HIDEITEM), i);
                this.getModel().setValue("author", (Object)listSvnLog.getString("author"), i);
                try {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    dateFormat.setTimeZone(KDDateUtils.getUserTimeZone());
                    Date date = dateFormat.parse(listSvnLog.getString("date"));
                    this.getModel().setValue("date", (Object)date, i);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                this.getModel().setValue("message", (Object)listSvnLog.getString("message"), i);
                this.getModel().setValue("filename", (Object)fileName, i);
            }
        }
    }
}

