/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.business.hosting.SvnOperationUtil;
import kd.bos.devportal.common.hosting.SVNCommonUtil;
import kd.bos.devportal.common.hosting.SVNUtil;
import kd.bos.encrypt.Encrypters;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class PageSvnLog
extends AbstractFormPlugin
implements UploadListener {
    private static final Log logger = LogFactory.getLog(PageSvnLog.class);
    private static final String SVNPATH = "svnpath";
    private static final String TABAP = "tabap";
    private static final String FILENAME = "filename";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String USERNAME = "username";
    private static final String P = "password";
    private static final String ENTRYENTITY = "entryentity";
    private static final String VERSION = "version";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String formId = (String)parameter.getCustomParam("id");
        String svnPath = (String)parameter.getCustomParam(SVNPATH);
        String formNumber = MetadataDao.getNumberById((String)formId);
        JSONArray list = new JSONArray();
        list.add((Object)(formNumber + ".dym"));
        list.add((Object)(formNumber + ".zh_CN.dymx"));
        for (int i = 0; i < list.size(); ++i) {
            String fileName = list.get(i).toString();
            List<JSONObject> svnLogs = this.getSvnLog(svnPath, fileName);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
            formShowParameter.getOpenStyle().setTargetKey(TABAP);
            formShowParameter.setCustomParam(FILENAME, (Object)fileName);
            formShowParameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u6587\u4ef6", (String)"PageSvnLog_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), fileName.substring(fileName.indexOf(46) + 1, fileName.length())));
            formShowParameter.setFormId("bos_devp_pagesvnlog_one");
            formShowParameter.setCustomParam("svnlogs", svnLogs);
            this.getView().showForm(formShowParameter);
        }
        Tab tab = (Tab)this.getView().getControl(TABAP);
        tab.activeTab("");
    }

    private List<JSONObject> getSvnLog(String svnPath, String fileName) {
        final ArrayList<JSONObject> svnLogs = new ArrayList<JSONObject>();
        String svnFilePath = svnPath + "/metadata/" + fileName;
        String userName = (String)this.getView().getFormShowParameter().getCustomParam(USERNAME);
        String passWord = (String)this.getView().getFormShowParameter().getCustomParam(P);
        try {
            passWord = Encrypters.decode((String)passWord);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        boolean fileIsExist = SvnOperationUtil.isExitsFile((String)svnFilePath, (String)userName, (String)passWord);
        if (!fileIsExist) {
            return svnLogs;
        }
        final DateFormat dtf = DateFormat.getDateTimeInstance();
        SVNClientManager clientManager = SVNCommonUtil.authSvn((String)svnFilePath, (String)userName, (String)passWord);
        ISVNLogEntryHandler handler = new ISVNLogEntryHandler(){

            public void handleLogEntry(SVNLogEntry logEntry) {
                JSONObject svnLog = new JSONObject();
                svnLog.put(PageSvnLog.VERSION, (Object)logEntry.getRevision());
                svnLog.put("author", (Object)logEntry.getAuthor());
                svnLog.put("date", (Object)dtf.format(logEntry.getDate()));
                svnLog.put("message", (Object)logEntry.getMessage());
                svnLogs.add(svnLog);
            }
        };
        SVNCommonUtil.doLog((SVNClientManager)clientManager, (String)userName, (String)passWord, (String)svnFilePath, (String[])new String[0], (ISVNLogEntryHandler)handler);
        return svnLogs;
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "comparetosvn": {
                this.compareToSvn();
                break;
            }
            case "comparetovertions": {
                this.compareToVersions();
                break;
            }
            case "updatetoversion": {
                this.updateToVersion();
                break;
            }
            case "exit": {
                this.exit();
                break;
            }
        }
    }

    private void exit() {
        this.getView().close();
    }

    private void updateToVersion() {
        ILocaleString name;
        Tab tab = (Tab)this.getView().getControl(TABAP);
        String currentTab = tab.getCurrentTab();
        IFormView currentView = this.getView().getView(currentTab);
        EntryGrid entryentity = (EntryGrid)currentView.getControl(ENTRYENTITY);
        int[] selectedRows = entryentity.getEntryState().getSelectedRows();
        if (selectedRows.length == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u4e00\u6761\u8bb0\u5f55\u3002", (String)"PageSvnLog_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (selectedRows.length > 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4e0esvn\u6bd4\u8f83\uff0c\u53ea\u80fd\u9009\u4e2d\u4e00\u6761\u8bb0\u5f55\u3002", (String)"PageSvnLog_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String version = currentView.getModel().getValue(VERSION, selectedRows[0]).toString();
        String fileName = currentView.getModel().getValue(FILENAME, selectedRows[0]).toString();
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("id");
        String bizAppId = MetadataDao.getAppIdByFormId((String)formId);
        JSONObject svnMsg = SVNUtil.getSVNMsgByAppId((String)bizAppId);
        String svnPath = svnMsg.getString(SVNPATH);
        String scriptSvnPath = svnPath + "/metadata/" + fileName;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        String userName = (String)this.getView().getFormShowParameter().getCustomParam(USERNAME);
        String passWord = (String)this.getView().getFormShowParameter().getCustomParam(P);
        try {
            passWord = Encrypters.decode((String)passWord);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        SVNClientManager clientManager = SVNCommonUtil.authSvn((String)scriptSvnPath, (String)userName, (String)passWord);
        SVNCommonUtil.doGetFileContent((SVNClientManager)clientManager, (SVNRevision)SVNRevision.parse((String)version), (String)scriptSvnPath, (OutputStream)output);
        byte[] byteArr = output.toByteArray();
        String content = new String(byteArr, StandardCharsets.UTF_8);
        JSONObject consoleData = new JSONObject();
        consoleData.put("date", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        String consoleString = "";
        this.updatePageContent(formId, content);
        this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u66f4\u65b0\u5230\u7248\u672c\uff1a%s\u3002", (String)"PageSvnLog_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), version));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bos_formmeta", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)formId)});
        if (dynamicObject != null && (name = dynamicObject.getLocaleString("name")) != null) {
            consoleString = String.format(ResManager.loadKDString((String)"\u9875\u9762 %1$s \u5df2\u6210\u529f\u66f4\u65b0\u81f3\u7248\u672c %2$s", (String)"PageSvnLog_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), name, version);
        }
        consoleData.put("output", (Object)consoleString);
        this.getView().returnDataToParent((Object)consoleData);
        this.getView().close();
    }

    private boolean updatePageContent(String formId, String content) {
        QFilter qFormId = new QFilter("form", "=", (Object)formId);
        DynamicObject pageRelInfo = QueryServiceHelper.queryOne((String)"bos_devportal_unitrelform", (String)"bizunit,bizapp", (QFilter[])new QFilter[]{qFormId});
        String bizUnitId = pageRelInfo.getString("bizunit");
        String bizAppId = pageRelInfo.getString("bizapp");
        MetadataDao.deployMetadata((String)content, (String)bizUnitId, (String)bizAppId);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)formId, (String)"bos_formmeta", (String)"id,type,masterid");
        if (obj != null && obj.getString("type").equals("2") && StringUtils.isNotBlank((CharSequence)obj.getString("masterid"))) {
            formId = obj.getString("masterid");
        }
        MetadataDao.rebuildRuntimeMetaById((String)formId);
        return true;
    }

    private void compareToVersions() {
        Tab tab = (Tab)this.getView().getControl(TABAP);
        String currentTab = tab.getCurrentTab();
        IFormView currentView = this.getView().getView(currentTab);
        EntryGrid entryentity = (EntryGrid)currentView.getControl(ENTRYENTITY);
        int[] selectedRows = entryentity.getEntryState().getSelectedRows();
        if (selectedRows.length == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u4e24\u6761\u8bb0\u5f55\u3002", (String)"PageSvnLog_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (selectedRows.length != 2) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4e24\u7248\u672c\u6bd4\u8f83\uff0c\u53ea\u80fd\u9009\u4e2d\u4e24\u6761\u8bb0\u5f55\u3002", (String)"PageSvnLog_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String newVersion = currentView.getModel().getValue(VERSION, selectedRows[0]).toString();
        String oldVersion = currentView.getModel().getValue(VERSION, selectedRows[1]).toString();
        String fileName = currentView.getModel().getValue(FILENAME, selectedRows[0]).toString();
        this.CompareTwoVersions(newVersion, oldVersion, fileName, true);
    }

    private void compareToSvn() {
        Tab tab = (Tab)this.getView().getControl(TABAP);
        String currentTab = tab.getCurrentTab();
        IFormView currentView = this.getView().getView(currentTab);
        EntryGrid entryentity = (EntryGrid)currentView.getControl(ENTRYENTITY);
        int[] selectedRows = entryentity.getEntryState().getSelectedRows();
        if (selectedRows.length == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u4e00\u6761\u8bb0\u5f55\u3002", (String)"PageSvnLog_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (selectedRows.length > 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4e0esvn\u6bd4\u8f83\uff0c\u53ea\u80fd\u9009\u4e2d\u4e00\u6761\u8bb0\u5f55\u3002", (String)"PageSvnLog_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String oldVersion = currentView.getModel().getValue(VERSION, selectedRows[0]).toString();
        String fileName = currentView.getModel().getValue(FILENAME, selectedRows[0]).toString();
        this.CompareTwoVersions("head", oldVersion, fileName, false);
    }

    private void CompareTwoVersions(String newVersion, String oldVersion, String fileName, boolean isShowButtons) {
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("id");
        String bizAppId = MetadataDao.getAppIdByFormId((String)formId);
        JSONObject svnMsg = SVNUtil.getSVNMsgByAppId((String)bizAppId);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_svndiff");
        parameter.setCaption(String.format(ResManager.loadKDString((String)"svn\u5dee\u5f02\u6bd4\u8f83(%s)", (String)"PageSvnLog_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), fileName));
        parameter.setCustomParam("type", (Object)"page");
        parameter.setCustomParam("id", (Object)formId);
        parameter.setCustomParam(FILENAME, (Object)fileName);
        parameter.setCustomParam(SVNPATH, (Object)svnMsg.get((Object)SVNPATH).toString());
        parameter.setCustomParam("oldversion", (Object)oldVersion);
        parameter.setCustomParam("newversion", (Object)newVersion);
        parameter.setCustomParam("compare", (Object)isShowButtons);
        OpenStyle style = new OpenStyle();
        StyleCss cssStyle = new StyleCss();
        cssStyle.setHeight("760");
        cssStyle.setWidth("1200");
        style.setInlineStyleCss(cssStyle);
        style.setShowType(ShowType.Modal);
        parameter.setOpenStyle(style);
        this.getView().showForm(parameter);
    }
}

