/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.plugin.Builder;
import kd.bos.exception.KDException;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractDesignMeta;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.devportal.AppReader;
import kd.bos.metadata.devportal.DesignAppMetaL;
import kd.bos.metadata.form.DesignFormMetaL;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;

public class RepairApplicationNamePlugin
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(RepairApplicationNamePlugin.class);
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static ExecutorService es = ThreadPools.newExecutorService((String)"RepairApplicationNamePlugin-Thread", (int)3);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"repair", "repairform", "concurentrebuild"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "repair": {
                this.repairApplicationName();
                break;
            }
            case "repairform": {
                this.repairFormName();
                break;
            }
            case "concurentrebuild": {
                this.concurentRebuild();
            }
        }
    }

    private void repairApplicationName() {
        ORM orm = ORM.create();
        orm.hint().setLang(Lang.zh_CN);
        DynamicObjectCollection cols = orm.query("bos_devportal_bizapp", "id,number", new QFilter[]{new QFilter("name", "is null", (Object)"")});
        List appIds = cols.stream().map(t -> t.getString("id")).collect(Collectors.toList());
        ArrayList<DesignAppMetaL> metaLS = new ArrayList<DesignAppMetaL>(10);
        for (String it : appIds) {
            try {
                AppMetadata meta = AppReader.loadMeta((String)it, (boolean)false);
                if (meta == null) continue;
                MetadataWriter writer = new MetadataWriter("AppModel");
                List designMetas = writer.convertToDesignMeta(new AbstractMetadata[]{meta});
                for (AbstractDesignMeta designMeta : designMetas) {
                    if (!(designMeta instanceof DesignAppMetaL) || !"zh_CN".equals(((DesignAppMetaL)designMeta).getLocaleId())) continue;
                    metaLS.add((DesignAppMetaL)designMeta);
                }
            }
            catch (Exception exception) {
            }
        }
        if (metaLS.size() > 0) {
            BusinessDataWriter.save((IDataEntityType)OrmUtils.getDataEntityType(DesignAppMetaL.class), (Object[])metaLS.toArray(new DesignAppMetaL[metaLS.size()]));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u590d\u6210\u529f", (String)"RepairApplicationNamePlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void repairFormName() {
        ORM orm = ORM.create();
        orm.hint().setLang(Lang.zh_CN);
        DynamicObjectCollection cols = orm.query("bos_formmeta", "id,number", new QFilter[]{new QFilter("name", "is null", (Object)"")});
        List formIds = cols.stream().map(t -> t.getString("id")).collect(Collectors.toList());
        ArrayList<DesignFormMetaL> metaLS = new ArrayList<DesignFormMetaL>(10);
        for (String it : formIds) {
            try {
                AbstractMetadata meta = MetadataDao.readMeta((String)it, (MetaCategory)MetaCategory.Form);
                if (meta == null) continue;
                MetadataWriter writer = new MetadataWriter(meta.getModelType());
                List designMetas = writer.convertToDesignMeta(new AbstractMetadata[]{meta});
                for (AbstractDesignMeta designMeta : designMetas) {
                    if (!(designMeta instanceof DesignFormMetaL) || !"zh_CN".equals(((DesignFormMetaL)designMeta).getLocaleId())) continue;
                    metaLS.add((DesignFormMetaL)designMeta);
                }
            }
            catch (Exception exception) {
            }
        }
        if (metaLS.size() > 0) {
            BusinessDataWriter.save((IDataEntityType)OrmUtils.getDataEntityType(DesignFormMetaL.class), (Object[])metaLS.toArray(new DesignFormMetaL[metaLS.size()]));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u590d\u6210\u529f", (String)"RepairApplicationNamePlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void concurentRebuild() {
        String id;
        String number = (String)this.getModel().getValue("rebnumber");
        if (StringUtils.isBlank((CharSequence)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5143\u6570\u636e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"RepairApplicationNamePlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)(id = MetadataDao.getIdByNumber((String)number, (MetaCategory)MetaCategory.Form)))) {
            id = number;
        }
        ArrayList<Builder> builders = new ArrayList<Builder>(5);
        for (int i = 0; i < 5; ++i) {
            builders.add(new Builder(RequestContext.get(), id));
        }
        try {
            List results = es.invokeAll(builders);
            ArrayList faileList = new ArrayList(10);
            for (Future result : results) {
                Map map = (Map)result.get();
                for (Map.Entry entry : map.entrySet()) {
                    if (!StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
                    faileList.add(entry.getValue());
                }
            }
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u91cd\u5efa\u7ed3\u679c\uff1a%s", (String)"RepairApplicationNamePlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), SerializationUtils.toJsonString(faileList)));
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDException(e.getMessage());
        }
    }
}

