/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.extplugin.IPluginProxyUtil;
import kd.bos.devportal.common.extplugin.ISearchListExtPlugin;
import kd.bos.devportal.common.extplugin.PluginProxyImpl;
import kd.bos.devportal.common.extplugin.SearchAppDataEvent;
import kd.bos.devportal.common.extplugin.event.ResetAppPageEvent;
import kd.bos.devportal.common.kingscript.TSShowFormUtil;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.entity.plugin.Plugin;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BizCustomList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.DevVerifyServiceHelper;
import kd.bos.servicehelper.portal.InitailVersionServiceHelper;
import kd.bos.servicehelper.util.GitPermissionUtil;

public class SearchListPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(SearchListPlugin.class);
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String BIZUNITID = "bizunitid";
    private static final String BIZAPPID = "bizappid";
    private static final String BIZCLOUDID = "bizcloudid";
    private static final String KEY_NUMBER = "number";
    private static final String NAME_ASC = "name asc";
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String BIZCLOUD = "bizcloud";
    private static final String BASEDATAFIELD = "basedatafield";
    private static final String MODELTYPE = "modeltype";
    private static final String BIZAPP = "bizapp";
    private static final String BIZUNIT = "bizunit";
    private static final int ID_LENGTH = 10;
    private static final String JS_PLUGIN_TYPE = "14";
    private IPluginProxyUtil pluginProxyUtil = new PluginProxyImpl();
    private PluginProxy<ISearchListExtPlugin> extPluginPluginProxy;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BizCustomList searchList = (BizCustomList)this.getView().getControl("bizcustomlistap");
        searchList.addCustomListListener((ItemClickListener)this);
    }

    private PluginProxy<ISearchListExtPlugin> getExtPluginPluginProxy() {
        if (this.extPluginPluginProxy == null) {
            this.extPluginPluginProxy = this.pluginProxyUtil.create(null, ISearchListExtPlugin.class);
        }
        return this.extPluginPluginProxy;
    }

    public void afterBindData(EventObject evt) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String value = (String)parameter.getCustomParam("searchtext");
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.searchByNumberOrNameOrId(value);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        JSONObject arg;
        String id = evt.getOperationKey();
        JSONObject jSONObject = arg = evt.getItemKey() == null ? null : (JSONObject)JSON.parse((String)evt.getItemKey());
        if (StringUtils.isNotBlank((CharSequence)id) && arg != null) {
            switch (id) {
                case "search": {
                    break;
                }
                case "gotopagedesigner": {
                    this.gotoPageDesinger(arg);
                    break;
                }
                case "goto_bizapp": {
                    this.gotobizApp(arg);
                    break;
                }
                case "goto_bizpage": {
                    this.gotobizPage(arg);
                    break;
                }
                case "gotoscriptpos": {
                    this.gotoScriptPos(arg);
                    break;
                }
                case "gotokde": {
                    this.gotoKDE(arg);
                    break;
                }
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"SearchListPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
    }

    private void gotoPageDesinger(JSONObject arg) {
        String id = arg.getString("id");
        DevportalUtil.gotoPageDesinger(this.getView(), id, "bos_devportal_bizpagelist");
    }

    private void gotobizApp(JSONObject arg) {
        this.resetAppPage(arg);
    }

    private void gotobizPage(JSONObject arg) {
        arg.putIfAbsent((Object)"isneedguide", (Object)Boolean.FALSE);
        DevportalUtil.locateResourcePos(arg, this.getView(), "page");
    }

    private void gotoScriptPos(JSONObject arg) {
        DevportalUtil.locateResourcePos(arg, this.getView(), "script");
    }

    private void gotoKDE(JSONObject arg) {
        Map per = GitPermissionUtil.verifyPermission((JSONObject)arg, (String)"", (String)"app");
        if (!((Boolean)per.get("success")).booleanValue()) {
            this.getView().showTipNotification((String)per.get("message"));
            return;
        }
        String bizUnitId = arg.getString(BIZUNITID);
        if (StringUtils.isBlank((CharSequence)bizUnitId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u811a\u672c\u6240\u5c5e\u529f\u80fd\u5206\u7ec4\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8df3\u8f6c\u3002", (String)"SearchListPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String bizAppId = arg.getString(BIZAPPID);
        AppMetadata appInfo = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        Boolean flag = Boolean.TRUE;
        for (AppFunctionPacketElement funcPacket : appInfo.getAppFunctionPackets()) {
            String unitId = funcPacket.getId();
            if (!bizUnitId.equals(unitId)) continue;
            flag = Boolean.FALSE;
            break;
        }
        if (flag.booleanValue()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u811a\u672c\u6240\u5c5e\u529f\u80fd\u5206\u7ec4\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8df3\u8f6c\u3002", (String)"SearchListPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        boolean isGotoTDE = this.tryGotoTDE(appInfo, arg);
        if (isGotoTDE) {
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.NewWindow);
        parameter.setFormId("bos_devp_kde");
        parameter.setCustomParam(BIZAPPID, arg.get((Object)BIZAPPID));
        parameter.setCustomParam(BIZCLOUDID, (Object)appInfo.getBizCloudID());
        parameter.setCustomParam("bizscriptid", arg.get((Object)"bizpageid"));
        this.getView().showForm(parameter);
    }

    private boolean tryGotoTDE(AppMetadata appInfo, JSONObject arg) {
        DynamicObject scriptInfo;
        Object enginetype;
        Object bizAppId = arg.get((Object)BIZAPPID);
        Object scriptIdObj = arg.get((Object)"bizpageid");
        if (scriptIdObj != null && bizAppId != null && StringUtils.isNotBlank((CharSequence)scriptIdObj.toString()) && this.scriptIsBebongToApp(scriptIdObj.toString(), bizAppId.toString()) && (enginetype = (scriptInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)scriptIdObj.toString(), (String)"ide_pluginscript", (String)"enginetype")).get("enginetype")) != null && "1".equals(enginetype.toString())) {
            if (!Plugin.enableRegisterKingScript()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u5f00\u53d1\u5e73\u53f0\u672a\u542f\u7528\uff0c\u6682\u4e0d\u652f\u6301\u7f16\u8f91\u3002", (String)"PluginsPlugin_11", (String)"bos-designer-plugin", (Object[])new Object[0]));
                return true;
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.NewWindow);
            parameter.setCustomParam("bizscriptid", (Object)scriptIdObj.toString());
            parameter.setFormId("ide_register_ts_plugin");
            parameter.setCustomParam(BIZAPPID, (Object)bizAppId.toString());
            String serviceAppid = TSShowFormUtil.getTSEditerServiceAppid((String)bizAppId.toString(), null);
            parameter.setCustomParam("ServiceAppId", (Object)serviceAppid);
            this.getView().showForm(parameter);
            return true;
        }
        return false;
    }

    private boolean scriptIsBebongToApp(String scriptId, String bizAppId) {
        JSONArray bizAppIds = DevportalUtil.getBizAppIds(bizAppId);
        QFilter qScriptId = new QFilter("id", "=", (Object)scriptId);
        QFilter qBizAppId = new QFilter(BIZAPPID, "in", (Object)bizAppIds);
        QFilter[] filters = new QFilter[]{qScriptId, qBizAppId};
        boolean exists = QueryServiceHelper.exists((String)"ide_pluginscript", (QFilter[])filters);
        return exists;
    }

    private void searchByNumberOrNameOrId(String condition) {
        JSONArray appItems = this.searchAppData("%" + condition + "%");
        JSONArray pageItems = this.searchPageData("%" + condition + "%");
        JSONArray scriptItems = this.searchScriptData("%" + condition + "%");
        JSONObject data = new JSONObject();
        data.put("appitems", (Object)appItems);
        data.put("pageitems", (Object)pageItems);
        data.put("scriptitems", (Object)scriptItems);
        data.put("carditems", (Object)new JSONArray());
        data.put("value", (Object)condition);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("REFRESHSEARCHLIST", (Object)data);
    }

    private JSONArray searchAppData(String condition) {
        DynamicObject[] dObjs;
        ArrayList<String> idList = new ArrayList<String>();
        JSONArray AppArray = new JSONArray();
        String selectFields = "id, number, name, bizcloud, image";
        QFilter q = new QFilter(KEY_NUMBER, "like", (Object)condition);
        QFilter q1 = new QFilter("name", "like", (Object)condition);
        QFilter qFilter = q.or(q1);
        if (condition != null && condition.length() >= 10) {
            QFilter q2 = new QFilter("id", "like", (Object)condition);
            qFilter = q.or(q1).or(q2);
        }
        Object[] filters = new QFilter[]{qFilter};
        filters = (QFilter[])ArrayUtils.add((Object[])filters, (Object)new QFilter("id", "!=", (Object)"2HGKTA7HH43C"));
        filters = DevportalUtil.getPermissionListFilter((QFilter[])filters);
        for (DynamicObject dObj : dObjs = BusinessDataServiceHelper.load((String)BOS_DEVPORTAL_BIZAPP, (String)selectFields, (QFilter[])filters, (String)NAME_ASC)) {
            try {
                String id = dObj.getString("id");
                DynamicObject bizcloudDObj = dObj.getDynamicObject(BIZCLOUD);
                String bizcloud = null;
                if (bizcloudDObj != null) {
                    bizcloud = bizcloudDObj.getString("id");
                }
                if (idList.contains(id) || "2HGKCE94QELW".equalsIgnoreCase(bizcloud)) continue;
                idList.add(id);
                ILocaleString name = dObj.getLocaleString("name");
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)id);
                jsonObject.put(KEY_NUMBER, (Object)dObj.getString(KEY_NUMBER));
                jsonObject.put("name", (Object)(name == null ? "" : name.toString()));
                jsonObject.put(BIZCLOUDID, (Object)bizcloud);
                jsonObject.put("image", (Object)dObj.getString("image"));
                AppArray.add((Object)jsonObject);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        SearchAppDataEvent event = new SearchAppDataEvent(AppArray);
        this.getExtPluginPluginProxy().callReplace(o -> {
            o.afterSearchAppData(event);
            return null;
        });
        return event.getBizAppList();
    }

    private JSONArray searchPageData(String condition) {
        JSONArray pageArray = new JSONArray();
        Set apps = DevVerifyServiceHelper.getPermissionAppByUser((Long)RequestContext.get().getCurrUserId());
        boolean isSevenVersion = InitailVersionServiceHelper.isInitailVersion((int)7);
        boolean permission = DevportalUtil.isVerifyPermission();
        HashMap<String, AppMetadata> appMetadataMap = new HashMap<String, AppMetadata>();
        QFilter qName = new QFilter("name", "like", (Object)condition);
        QFilter qNumber = new QFilter(KEY_NUMBER, "like", (Object)condition);
        QFilter qFilter = qName.or(qNumber);
        if (condition != null && condition.length() >= 10) {
            QFilter qId = new QFilter("id", "like", (Object)condition);
            qFilter = qName.or(qNumber).or(qId);
        }
        if (isSevenVersion) {
            QFilter versionFilter = new QFilter(MODELTYPE, "!=", (Object)"PrintModel");
            qFilter.and(versionFilter);
        }
        HashMap<String, JSONObject> emptyNameDatas = new HashMap<String, JSONObject>(10);
        QFilter[] filters = new QFilter[]{qFilter};
        String selectFields = "id,number,name,modeltype,type,basedatafield";
        String unitrelForselectFields = "bizapp,bizunit,form";
        String bizAppselectFields = "id,name appname,bizcloud";
        DynamicObject[] dynamicObjectArray = null;
        try (DataSet dsNameCondition = QueryServiceHelper.queryDataSet((String)"bos_formmeta", (String)"bos_formmeta", (String)selectFields, (QFilter[])filters, (String)NAME_ASC);
             DataSet dsUnitRelForm = QueryServiceHelper.queryDataSet((String)"bos_devportal_unitrelform", (String)"bos_devportal_unitrelform", (String)unitrelForselectFields, null, (String)"form asc");
             DataSet dsApp = QueryServiceHelper.queryDataSet((String)BOS_DEVPORTAL_BIZAPP, (String)BOS_DEVPORTAL_BIZAPP, (String)bizAppselectFields, null, (String)NAME_ASC);
             DataSet result = dsNameCondition.join(dsUnitRelForm, JoinType.LEFT).on("id", "form").select(new String[]{"id", KEY_NUMBER, "name", MODELTYPE, "type", BASEDATAFIELD}, new String[]{BIZAPP, BIZUNIT}).finish().join(dsApp, JoinType.LEFT).on(BIZAPP, "id").select(new String[]{"id", KEY_NUMBER, "name", MODELTYPE, "type", BASEDATAFIELD, BIZAPP, BIZUNIT}, new String[]{"appname", BIZCLOUD}).finish().filter("bizapp<>null and bizunit<>null");){
            Iterator iter = result.iterator();
            while (iter.hasNext()) {
                try {
                    String bizAppId;
                    Row row = (Row)iter.next();
                    if ("2HGKCE94QELW".equalsIgnoreCase(row.getString(BIZCLOUD)) || "2HGKTA7HH43C".equalsIgnoreCase(bizAppId = row.getString(BIZAPP))) continue;
                    String modelType = row.getString(MODELTYPE);
                    String bizUnitId = row.getString(BIZUNIT);
                    String entityId = row.getString(BASEDATAFIELD);
                    JSONObject pageObject = new JSONObject();
                    String formId = row.getString("id");
                    pageObject.put("bizpageid", (Object)formId);
                    pageObject.put(KEY_NUMBER, (Object)row.getString(KEY_NUMBER));
                    if (StringUtils.isBlank((CharSequence)row.getString("name"))) {
                        emptyNameDatas.put(formId, pageObject);
                    } else {
                        pageObject.put("name", (Object)row.getString("name"));
                    }
                    if (formId.equals(entityId) || "PrintModel".equals(modelType) || "MobileBillFormModel".equals(modelType) || "QueryListModel".equals(modelType)) {
                        pageObject.put(MODELTYPE, (Object)modelType);
                    } else {
                        pageObject.put(MODELTYPE, (Object)"PCLayout");
                    }
                    pageObject.put(BIZAPPID, (Object)bizAppId);
                    if (permission && !apps.contains(bizAppId)) continue;
                    pageObject.put(BIZUNITID, (Object)bizUnitId);
                    pageObject.put("bizappname", (Object)row.getString("appname"));
                    pageObject.put(BIZCLOUDID, (Object)row.getString(BIZCLOUD));
                    AppMetadata appMetadata = (AppMetadata)appMetadataMap.get(bizAppId);
                    if (appMetadata == null) {
                        appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
                        appMetadataMap.put(bizAppId, appMetadata);
                    }
                    if (StringUtils.isBlank((Object)appMetadata)) continue;
                    List functionPackets = appMetadata.getAppFunctionPackets();
                    String appIsv = AppMetaServiceHelper.getIsvByApp((AppMetadata)appMetadata);
                    pageObject.put("isv", (Object)appIsv);
                    pageObject.put("apptype", (Object)appMetadata.getDevType());
                    pageObject.put("isowner", (Object)(appIsv.equals(AppUtils.getDeveloperInfo()) ? 1 : 0));
                    pageObject.put("ismobile", (Object)(modelType.startsWith("Mob") ? 1 : 0));
                    for (AppFunctionPacketElement functionPacket : functionPackets) {
                        if (!functionPacket.getId().equals(bizUnitId)) continue;
                        pageObject.put("bizunitname", (Object)functionPacket.getName().getLocaleValue());
                        String pageType = row.getString("type");
                        pageObject.put("devtype", (Object)pageType);
                        break;
                    }
                    pageArray.add((Object)pageObject);
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
        }
        catch (Throwable object) {
            dynamicObjectArray = object;
            throw object;
        }
        if (!emptyNameDatas.isEmpty()) {
            DynamicObject[] objs;
            for (DynamicObject obj : objs = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", new ArrayList(emptyNameDatas.keySet()))})) {
                String pk = obj.getString("id");
                String name = obj.getString("name");
                JSONObject jsonObject = (JSONObject)emptyNameDatas.get(pk);
                if (jsonObject == null) continue;
                jsonObject.put("name", (Object)(name == null ? "" : name));
            }
        }
        return pageArray;
    }

    private JSONArray searchScriptData(String condition) {
        JSONArray scriptInfos = new JSONArray();
        HashMap<String, AppMetadata> appMetadataMap = new HashMap<String, AppMetadata>();
        ArrayList<String> idList = new ArrayList<String>();
        String selectFields = "id,txt_scriptname,txt_scriptnumber,cbox_script_type,bizunitid,bizappid";
        QFilter qNumber = new QFilter("txt_scriptnumber", "like", (Object)condition);
        QFilter qName = new QFilter("txt_scriptname", "like", (Object)condition);
        QFilter qFilter = qName.or(qNumber);
        if (condition != null && condition.length() >= 10) {
            QFilter qId = new QFilter("id", "like", (Object)condition);
            qFilter = qName.or(qNumber).or(qId);
        }
        QFilter typeFilter = new QFilter("cbox_script_type", "!=", (Object)JS_PLUGIN_TYPE);
        QFilter[] filters = new QFilter[]{qFilter, typeFilter};
        filters = this.getScriptByAppIdFilter(filters);
        try (DataSet result = QueryServiceHelper.queryDataSet((String)"ide_pluginscript", (String)"ide_pluginscript", (String)selectFields, (QFilter[])filters, (String)"txt_scriptnumber asc");){
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                try {
                    Row script = (Row)iterator.next();
                    String id = script.getString("id");
                    if (idList.contains(id)) continue;
                    String bizUnitId = script.getString(BIZUNITID);
                    String bizAppId = script.getString(BIZAPPID);
                    JSONObject scriptInfo = new JSONObject();
                    scriptInfo.put("id", (Object)id);
                    scriptInfo.put("name", script.get("txt_scriptname"));
                    scriptInfo.put(KEY_NUMBER, script.get("txt_scriptnumber"));
                    scriptInfo.put("type", script.get("cbox_script_type"));
                    scriptInfo.put(BIZUNITID, (Object)bizUnitId);
                    scriptInfo.put(BIZAPPID, (Object)bizAppId);
                    AppMetadata appMetadata = (AppMetadata)appMetadataMap.get(bizAppId);
                    if (appMetadata == null) {
                        appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
                        appMetadataMap.put(bizAppId, appMetadata);
                    }
                    if (appMetadata == null) continue;
                    scriptInfo.put("bizappname", (Object)appMetadata.getName().getLocaleValue());
                    List functionPackets = appMetadata.getAppFunctionPackets();
                    for (AppFunctionPacketElement functionPacket : functionPackets) {
                        if (!functionPacket.getId().equals(bizUnitId)) continue;
                        scriptInfo.put("bizunitname", (Object)functionPacket.getName().getLocaleValue());
                        break;
                    }
                    scriptInfos.add((Object)scriptInfo);
                    idList.add(id);
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
        }
        return scriptInfos;
    }

    private QFilter[] getScriptByAppIdFilter(QFilter[] filters) {
        if (!DevportalUtil.isVerifyPermission()) {
            return filters;
        }
        Set apps = DevVerifyServiceHelper.getPermissionAppByUser((Long)RequestContext.get().getCurrUserId());
        if (!apps.isEmpty()) {
            ArrayList<QFilter> list = new ArrayList<QFilter>(Arrays.asList(filters));
            QFilter qFilter = new QFilter(BIZAPPID, "in", (Object)apps);
            list.add(qFilter);
            filters = list.toArray(new QFilter[list.size()]);
        }
        return filters;
    }

    private void resetAppPage(JSONObject arg) {
        String bizCloudName;
        String bizAppId = arg.getString(BIZAPPID);
        String bizCloudId = arg.getString(BIZCLOUDID);
        if (StringUtils.isBlank((CharSequence)bizCloudId)) {
            AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
            bizCloudId = appMetadata.getBizCloudID();
        }
        if (StringUtils.isBlank((CharSequence)(bizCloudName = DevportalUtil.getBizCloudNameById(bizCloudId)))) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u5e94\u7528\u6240\u5728\u7684\u4e1a\u52a1\u4e91\u3010%s\u3011\u4e0d\u5b58\u5728\u3002", (String)"SearchListPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), bizCloudId));
            return;
        }
        JSONArray cloudItems = DevportalUtil.getCloudsInfo(this.getView());
        JSONArray appItems = DevportalUtil.getAppsInfoByCloudId(bizCloudId, this.getView());
        ResetAppPageEvent event = new ResetAppPageEvent(arg, appItems);
        this.getExtPluginPluginProxy().callReplace(o -> {
            o.afterResetAppPage(event);
            return null;
        });
        Tab tab = (Tab)this.getView().getParentView().getControl("tabap");
        tab.activeTab("tabpageap1");
        this.getView().sendFormAction(this.getView().getParentView());
        JSONObject data = new JSONObject();
        data.put(BIZAPPID, (Object)bizAppId);
        data.put(BIZCLOUDID, (Object)bizCloudId);
        data.put("clouditems", (Object)cloudItems);
        data.put("appitems", (Object)event.getBizAppList());
        data.put("bizcloudname", (Object)bizCloudName);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("RESET_APPPAGE", (Object)data);
    }
}

