/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class SelectUnitPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String INFOLIST = "infolist";
    private static final String APPID = "appid";
    private static final String NUMBER = "number";
    private static final String REMARK = "remark";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok", "btnreset"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(INFOLIST);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void click(EventObject evt) {
        String btnKey = ((Button)evt.getSource()).getKey();
        if ("btnok".equalsIgnoreCase(btnKey)) {
            HashMap<String, Object> rowData = new HashMap<String, Object>();
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(INFOLIST);
            IDataModel model = this.getModel();
            int row = grid.getEntryState().getFocusRow();
            if (row >= 0) {
                String[] info = model.getValue("id", row).toString().split(",");
                if (info.length > 2 && !"cloud".equals(info[1])) {
                    rowData.put(APPID, info[2]);
                }
                rowData.put("nodeid", info[0]);
                rowData.put("nodenumber", model.getValue(NUMBER, row));
                rowData.put("nodename", model.getValue("name", row));
                this.getView().returnDataToParent(rowData);
                this.getView().close();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"SelectUnitPlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            }
        } else if ("btnreset".equalsIgnoreCase(btnKey)) {
            HashMap<String, String> resetData = new HashMap<String, String>();
            resetData.put(APPID, "");
            resetData.put("nodeid", "");
            resetData.put("nodenumber", "");
            resetData.put("nodename", "");
            this.getView().returnDataToParent(resetData);
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Map map = fsp.getCustomParams();
        JSONArray dataInfos = this.getDataInfos(map);
        this.renderTable(dataInfos);
    }

    private JSONArray getDataInfos(Map<String, Object> map) {
        String appId = map.get(APPID).toString();
        boolean runtime = (Boolean)map.get("runtime");
        return this.queryUnitData(appId, runtime);
    }

    private JSONArray queryUnitData(String appId, boolean runtime) {
        JSONArray unitInfos;
        block3: {
            List appFunctionPackets;
            AppMetadata appMetaData;
            block2: {
                unitInfos = new JSONArray();
                appMetaData = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)runtime);
                appFunctionPackets = appMetaData.getAppFunctionPackets();
                if (!"0".equals(appMetaData.getDevType())) break block2;
                for (AppFunctionPacketElement appFunctionPacket : appFunctionPackets) {
                    String functionPacketType = appFunctionPacket.getType();
                    if (functionPacketType != null && !"0".equals(functionPacketType)) continue;
                    JSONObject map = new JSONObject();
                    map.put("id", (Object)(appFunctionPacket.getId() + ",unit," + appId));
                    map.put(APPID, (Object)appId);
                    map.put("name", (Object)appFunctionPacket.getName().getLocaleValue());
                    map.put(NUMBER, (Object)appFunctionPacket.getNumber());
                    map.put("parentunitid", (Object)appFunctionPacket.getParentId());
                    LocaleString description = appFunctionPacket.getDescription();
                    map.put(REMARK, (Object)(description == null ? "" : description.getLocaleValue()));
                    unitInfos.add((Object)map);
                }
                break block3;
            }
            if (!"2".equals(appMetaData.getDevType())) break block3;
            for (AppFunctionPacketElement appFunctionPacket : appFunctionPackets) {
                String functionPacketType = appFunctionPacket.getType();
                if (!"1".equals(functionPacketType) && !"2".equals(functionPacketType) && !"3".equals(functionPacketType)) continue;
                JSONObject map = new JSONObject();
                map.put("id", (Object)(appFunctionPacket.getId() + ",unit," + appId));
                map.put(APPID, (Object)appId);
                map.put("name", (Object)appFunctionPacket.getName().getLocaleValue());
                map.put(NUMBER, (Object)appFunctionPacket.getNumber());
                map.put("parentunitid", (Object)appFunctionPacket.getParentId());
                LocaleString description = appFunctionPacket.getDescription();
                map.put(REMARK, (Object)(description == null ? "" : description.getLocaleValue()));
                unitInfos.add((Object)map);
            }
        }
        return unitInfos;
    }

    private void renderTable(JSONArray dataInfos) {
        int index = 0;
        String objectId = (String)this.getView().getFormShowParameter().getCustomParam("objectid");
        IDataModel model = this.getModel();
        if (dataInfos == null || dataInfos.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u76f8\u5e94\u7684\u5217\u8868\u6570\u636e\u3002", (String)"SelectUnitPlugin_1", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        } else {
            JSONObject map;
            int i;
            model.batchCreateNewEntryRow(INFOLIST, dataInfos.size());
            for (i = 0; i < dataInfos.size(); ++i) {
                map = (JSONObject)dataInfos.get(i);
                model.setValue(NUMBER, (Object)map.getString(NUMBER), i);
                model.setValue("name", (Object)map.getString("name"), i);
                model.setValue(REMARK, (Object)map.getString(REMARK), i);
                model.setValue("id", (Object)map.getString("id"), i);
            }
            for (i = 0; i < dataInfos.size(); ++i) {
                map = (JSONObject)dataInfos.get(i);
                String id = map.getString("id");
                if (objectId == null || !objectId.trim().equals(id)) continue;
                index = i;
                break;
            }
        }
        AbstractGrid grid = (AbstractGrid)this.getControl(INFOLIST);
        grid.getEntryState().setFocusRow(index);
    }
}

