/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BizCustomList;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class ShortCutListPlugin
extends AbstractFormPlugin {
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String BIZPAGE = "bizpage";
    private static final String BOS_DEVPORTAL_SHORTCUT = "bos_devportal_shortcut";
    private static final String ID_ASC = "id asc";
    private static final String BIZAPP = "bizapp";
    private static final String BIZCLOUD = "bizcloud";
    private static final String BIZAPPID = "bizappid";
    private static final String BIZCLOUDID = "bizcloudid";
    private static final String BOS_FORMMETA = "bos_formmeta";
    private static final String BASEDATAFIELD = "basedatafield";
    private static final String MODELTYPE = "modeltype";
    private static final String NUMBER = "number";
    private static final String BIZUNIT = "bizunit";

    public void registerListener(EventObject e) {
        BizCustomList scList = (BizCustomList)this.getView().getControl("bizcustomlistap");
        scList.addCustomListListener((ItemClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        JSONObject arg;
        String id = evt.getOperationKey();
        JSONObject jSONObject = arg = evt.getItemKey() == null ? null : (JSONObject)JSON.parse((String)evt.getItemKey());
        if (StringUtils.isNotBlank((CharSequence)id) && arg != null) {
            switch (id) {
                case "listmyapp": {
                    this.listMyApp();
                    break;
                }
                case "deletemyapp": {
                    this.deleteMyApp(arg);
                    break;
                }
                case "listmypage": {
                    this.listMyPage();
                    break;
                }
                case "deletemypage": {
                    this.deleteMyPage(arg);
                    break;
                }
                case "goto_bizapp": {
                    this.gotobizApp(arg);
                    break;
                }
                case "goto_bizpage": {
                    this.gotobizPage(arg);
                    break;
                }
                case "gotopagedesigner": {
                    this.gotoPageDesinger(arg);
                    break;
                }
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"ShortCutListPlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            return;
        }
    }

    private void gotoPageDesinger(JSONObject arg) {
        String id = arg.getString("id");
        DevportalUtil.gotoPageDesinger(this.getView(), id, "bos_devportal_bizpagelist");
    }

    private void listMyApp() {
        JSONArray array = ShortCutListPlugin.listMyAppData();
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("myAppItems", (Object)array);
    }

    public static JSONArray listMyAppData() {
        JSONArray array = new JSONArray();
        QFilter qUser = new QFilter("user", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        QFilter qpageId = new QFilter(BIZPAGE, "=", (Object)" ");
        QFilter[] filters = new QFilter[]{qUser, qpageId};
        String selectFields = "id,user,bizapp";
        String bizAppselectFields = "id,name,bizcloud,image";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)BOS_DEVPORTAL_SHORTCUT, (String)BOS_DEVPORTAL_SHORTCUT, (String)selectFields, (QFilter[])filters, (String)ID_ASC);
             DataSet dsApp = QueryServiceHelper.queryDataSet((String)BOS_DEVPORTAL_BIZAPP, (String)BOS_DEVPORTAL_BIZAPP, (String)bizAppselectFields, null, (String)ID_ASC);
             DataSet dsInfo = ds.hashJoin(dsApp.toHashTable("id"), BIZAPP, new String[]{"name", BIZCLOUD, "image"}).selectLeftFields(new String[]{"id", "user", BIZAPP}).finish();){
            for (Row row : dsInfo) {
                JSONObject jsonObject = new JSONObject();
                String bizAppId = row.get(BIZAPP).toString();
                AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
                jsonObject.put("id", row.get("id"));
                jsonObject.put("userid", row.get("user"));
                jsonObject.put(BIZAPPID, (Object)bizAppId);
                jsonObject.put("name", (Object)appMetadata.getName().getLocaleValue());
                jsonObject.put(BIZCLOUDID, (Object)appMetadata.getBizCloudID());
                jsonObject.put("image", (Object)appMetadata.getAppElement().getImage());
                array.add((Object)jsonObject);
            }
        }
        return array;
    }

    private void deleteMyApp(JSONObject arg) {
        String id = arg.getString("id");
        String bizCloudId = arg.getString(BIZCLOUDID);
        String curCloudId = arg.getString("curcloudid");
        QFilter filter = new QFilter("id", "=", (Object)id);
        DeleteServiceHelper.delete((String)BOS_DEVPORTAL_SHORTCUT, (QFilter[])new QFilter[]{filter});
        JSONArray array = ShortCutListPlugin.listMyAppData();
        JSONObject data = new JSONObject();
        data.put("myAppItems", (Object)array);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("DELETE_MYAPPITEM", (Object)data);
        if (bizCloudId.equals(curCloudId)) {
            JSONArray appItems = DevportalUtil.getAppsInfoByCloudId(bizCloudId, this.getView());
            JSONObject appData = new JSONObject();
            appData.put("appItems", (Object)appItems);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("REFRESH_APP_COLLECTIONLIST", (Object)appData);
        }
    }

    private void listMyPage() {
        JSONArray array = ShortCutListPlugin.listMyPageData();
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("myPageItems", (Object)array);
    }

    /*
     * Exception decompiling
     */
    public static JSONArray listMyPageData() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 8 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void deleteMyPage(JSONObject arg) {
        String id = arg.getString("id");
        QFilter filter = new QFilter(BIZPAGE, "=", (Object)id);
        DeleteServiceHelper.delete((String)BOS_DEVPORTAL_SHORTCUT, (QFilter[])new QFilter[]{filter});
        JSONObject data = new JSONObject();
        JSONArray array = ShortCutListPlugin.listMyPageData();
        data.put("myPageItems", (Object)array);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("DELETE_MYPAGEITEM", (Object)data);
    }

    private void gotobizApp(JSONObject arg) {
        String bizAppId = arg.getString(BIZAPPID);
        String bizCloudId = arg.getString(BIZCLOUDID);
        this.resetAppPage(bizAppId, bizCloudId);
    }

    private void gotobizPage(JSONObject arg) {
        arg.put("isneedguide", (Object)Boolean.FALSE);
        DevportalUtil.locateResourcePos(arg, this.getView(), "page");
    }

    private void resetAppPage(String bizAppId, String bizCloudId) {
        Tab tab = (Tab)this.getView().getParentView().getControl("tabap");
        tab.activeTab("tabpageap1");
        this.getView().sendFormAction(this.getView().getParentView());
        JSONArray cloudItems = DevportalUtil.getCloudsInfo(this.getView());
        JSONArray appItems = DevportalUtil.getAppsInfoByCloudId(bizCloudId, this.getView());
        String bizCloudName = DevportalUtil.getBizCloudNameById(bizCloudId);
        JSONObject data = new JSONObject();
        data.put(BIZAPPID, (Object)bizAppId);
        data.put(BIZCLOUDID, (Object)bizCloudId);
        data.put("clouditems", (Object)cloudItems);
        data.put("appitems", (Object)appItems);
        data.put("bizcloudname", (Object)bizCloudName);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("RESET_APPPAGE", (Object)data);
    }
}

