/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.entity.IFrameMessage;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.IFrame;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;

public class SvnDiff
extends AbstractFormPlugin {
    private static final String TOOLBARAP1 = "toolbarap1";
    private static final String IFRAMEAP = "iframeap";
    private static final String SRC = "devtools/built-compare/svnDiff.html?";
    private static final String SCENE = "scene";
    private static final String KEY_SAVEALL = "saveall";
    private static final String KEY_UPDATETOLOCALE = "updatetolocale";
    private static final String KEY_ALLUPDATE = "allupdate";
    private static final String KEY_ALLSUBMIT = "allsubmit";
    private static final String KEY_SUBMITTOSVN = "submittosvn";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String KEY_BIZAPPID = "bizappid";
    private static final String KEY_SVNPATH = "svnpath";

    public void initialize() {
        this.addItemClickListeners(new String[]{"toolbarap", TOOLBARAP1});
    }

    public void afterCreateNewData(EventObject e) {
        String scene;
        String urlParams = this.getUrlParams();
        IFrame iframe = (IFrame)this.getView().getControl(IFRAMEAP);
        iframe.setSrc(SRC + urlParams);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Boolean compare = (Boolean)parameter.getCustomParam("compare");
        if (compare != null && compare.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"toolbarap"});
        }
        if ("app".equals(scene = (String)parameter.getCustomParam(SCENE))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{TOOLBARAP1});
            String type = (String)parameter.getCustomParam("type");
            if ("card".equals(type) || "script".equals(type)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SAVEALL});
            }
        } else if ("cloud".equals(scene)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TOOLBARAP1, KEY_UPDATETOLOCALE, KEY_ALLUPDATE});
        } else {
            String type = (String)parameter.getCustomParam("type");
            if (!"page".equals(type)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_ALLSUBMIT});
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_ALLUPDATE});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{TOOLBARAP1});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "save": {
                this.save();
                break;
            }
            case "saveall": {
                this.saveAll();
                break;
            }
            case "submittosvn": {
                this.submitToSvn(KEY_SUBMITTOSVN);
                break;
            }
            case "allsubmit": {
                this.submitToSvn(KEY_ALLSUBMIT);
                break;
            }
            case "allupdate": {
                this.allUpdate();
                break;
            }
            case "updatetolocale": {
                this.updateToLocale();
                break;
            }
            case "exit": {
                this.exit();
                break;
            }
        }
    }

    private void save() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5c06\u5f53\u524d\u5de6\u4fa7\u5185\u5bb9\u4fdd\u5b58\u5230\u672c\u5730\u6587\u4ef6\u5417?", (String)"SvnDiff_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("saveSvnCallBack"));
    }

    private void saveAll() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5c06\u5f53\u524d\u6240\u6709\u9875\u7b7e\u5de6\u4fa7\u5185\u5bb9\u4fdd\u5b58\u5230\u672c\u5730\u6587\u4ef6\u5417?", (String)"SvnDiff_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("saveAllToSvnCallBack"));
    }

    private void submitToSvn(String key) {
        String sourceName;
        String sourceType = (String)this.getView().getFormShowParameter().getCustomParam("type");
        String sourceId = (String)this.getView().getFormShowParameter().getCustomParam("id");
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_BIZAPPID);
        String bizCloudId = (String)this.getView().getFormShowParameter().getCustomParam("id");
        String svnPath = (String)this.getView().getFormShowParameter().getCustomParam(KEY_SVNPATH);
        ArrayList<String> sourceList = new ArrayList<String>();
        if ("page".equals(sourceType)) {
            sourceName = BusinessDataServiceHelper.loadSingleFromCache((Object)sourceId, (String)"bos_formmeta", (String)"name").getString("name");
            sourceList.add(sourceId + "-" + sourceName + "-");
        } else if ("script".equals(sourceType)) {
            sourceName = BusinessDataServiceHelper.loadSingleFromCache((Object)sourceId, (String)"ide_pluginscript", (String)"txt_scriptname,txt_scriptnumber").getString("txt_scriptname");
            sourceList.add(sourceId + "-" + sourceName + "-");
        } else if ("cloud".equals(sourceType)) {
            sourceName = BizCloudServiceHelp.getBizCloudByID((String)bizCloudId).getString("name");
            sourceList.add(bizCloudId + "-" + sourceName + "-");
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_svnannotatinon");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(KEY_BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam(KEY_SVNPATH, (Object)svnPath);
        parameter.setCustomParam("appresource", (Object)Boolean.TRUE);
        parameter.setCustomParam("commitmsg", (Object)SerializationUtils.toJsonString(sourceList));
        CloseCallBack callBack = null;
        if (KEY_SUBMITTOSVN.equals(key)) {
            callBack = new CloseCallBack((IFormPlugin)this, "submitsvnannotationcallback");
        } else if (KEY_ALLSUBMIT.equals(key)) {
            callBack = new CloseCallBack((IFormPlugin)this, "submitallsvnannotationcallback");
        }
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void updateToLocale() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5c06\u5de6\u4fa7\u5185\u5bb9\u66f4\u65b0\u5230\u672c\u5730\u5417?", (String)"SvnDiff_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("updateToLocaleCallBack"));
    }

    private void allUpdate() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5c06\u6240\u6709\u9875\u7b7e\u7684\u5de6\u4fa7\u5185\u5bb9\u66f4\u65b0\u5230\u672c\u5730\u5417?", (String)"SvnDiff_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("allUpdateCallBack"));
    }

    private void exit() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u9000\u51fa\u5417?", (String)"SvnDiff_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("exitCallBack"));
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() != null) {
            String annotation = (String)e.getReturnData();
            if ("submitsvnannotationcallback".equals(e.getActionId())) {
                this.postMessageToIframe("", KEY_SUBMITTOSVN, annotation);
            } else if ("submitallsvnannotationcallback".equals(e.getActionId())) {
                this.postMessageToIframe("", KEY_ALLSUBMIT, annotation);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        if (MessageBoxResult.Yes.equals((Object)mbce.getResult())) {
            String callBackId;
            switch (callBackId = mbce.getCallBackId()) {
                case "saveSvnCallBack": {
                    this.postMessageToIframe("", "save");
                    break;
                }
                case "saveAllToSvnCallBack": {
                    this.postMessageToIframe("", KEY_SAVEALL);
                    break;
                }
                case "updateToLocaleCallBack": {
                    this.postMessageToIframe("", KEY_UPDATETOLOCALE);
                    break;
                }
                case "allUpdateCallBack": {
                    this.postMessageToIframe("", KEY_ALLUPDATE);
                    break;
                }
                case "exitCallBack": {
                    this.getView().close();
                    break;
                }
            }
        }
    }

    private void postMessageToIframe(String content, String type) {
        IFrame iframe = (IFrame)this.getView().getControl(IFRAMEAP);
        String scene = (String)this.getView().getFormShowParameter().getCustomParam(SCENE);
        IFrameMessage msg = new IFrameMessage();
        if ("app".equals(scene)) {
            Tab tab = (Tab)this.getView().getParentView().getControl("tabap");
            String currenTab = tab.getCurrentTab();
            msg.setContent((Object)currenTab);
        } else {
            msg.setContent((Object)content);
        }
        msg.setOrigin(RequestContext.get().getClientFullContextPath() + SRC + this.getUrlParams());
        msg.setType(type);
        iframe.postMessage(msg);
    }

    private void postMessageToIframe(String content, String type, String annotation) {
        IFrame iframe = (IFrame)this.getView().getControl(IFRAMEAP);
        IFrameMessage msg = new IFrameMessage();
        msg.setContent((Object)annotation);
        msg.setOrigin(RequestContext.get().getClientFullContextPath() + SRC + this.getUrlParams());
        msg.setType(type);
        iframe.postMessage(msg);
    }

    private String getUrlParams() {
        String uuid = Uuid8.generateShortUuid();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String type = (String)parameter.getCustomParam("type");
        String id = (String)parameter.getCustomParam("id");
        String svnPath = (String)parameter.getCustomParam(KEY_SVNPATH);
        String oldVersion = (String)parameter.getCustomParam("oldversion");
        String newVersion = (String)parameter.getCustomParam("newversion");
        Boolean compare = (Boolean)parameter.getCustomParam("compare");
        String fileName = (String)parameter.getCustomParam("filename");
        String bizAppId = (String)parameter.getCustomParam(KEY_BIZAPPID);
        String scene = (String)parameter.getCustomParam(SCENE);
        String traceIdPath = (String)this.getView().getFormShowParameter().getCustomParam("traceidpath");
        String pageId = this.getView().getPageId();
        return "uuid#" + uuid + "&type#" + type + "&id#" + id + "&bizappid#" + bizAppId + "&svnpath#" + svnPath + "&oldversion#" + oldVersion + "&newversion#" + newVersion + "&compare#" + compare + "&pageid#" + pageId + "&filename#" + fileName + "&scene#" + scene + "&traceidpath#" + traceIdPath;
    }
}

