/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.devportal.business.hosting.SvnOperationUtil;
import kd.bos.devportal.common.hosting.SVNCommonUtil;
import kd.bos.devportal.common.hosting.SVNUtil;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCacheUtils;
import kd.bos.metadata.deploy.DeployScript;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SvnLog
extends AbstractFormPlugin
implements UploadListener {
    private static final Log logger = LogFactory.getLog(SvnLog.class);
    private static final String SVNPATH = "svnpath";
    private static final String SCRIPT = "script";
    private static final String IDE_PLUGINSCRIPT = "ide_pluginscript";
    private static final String TXT_SCRIPTNUMBER = "txt_scriptnumber";
    private static final String VERSION = "version";
    private static final String ENTRYENTITY = "entryentity";
    private static final String AUTHOR = "author";
    private static final String MESSAGE = "message";
    private static final String USERNAME = "username";
    private static final String P = "password";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String id = (String)parameter.getCustomParam("id");
        String type = (String)parameter.getCustomParam("type");
        String svnPath = (String)parameter.getCustomParam(SVNPATH);
        if (SCRIPT.equalsIgnoreCase(type)) {
            this.showScriptSvnLog(id, svnPath);
        }
    }

    private void showScriptSvnLog(String scriptId, String svnPath) {
        DynamicObject scriptInfo = BusinessDataServiceHelper.loadSingle((Object)scriptId, (String)IDE_PLUGINSCRIPT, (String)"txt_scriptnumber,txt_scriptcontext_tag");
        String scriptNumber = scriptInfo.getString(TXT_SCRIPTNUMBER);
        String scriptSvnPath = svnPath + "/metadata/" + scriptNumber + ".ks";
        List<JSONObject> svnLogs = this.getSvnLog(scriptSvnPath);
        Collections.sort(svnLogs, new Comparator<JSONObject>(){
            private static final String K_Version = "version";

            @Override
            public int compare(JSONObject a, JSONObject b) {
                Integer valA = a.getIntValue("version");
                Integer valB = b.getIntValue("version");
                return valB.compareTo(valA);
            }
        });
        if (svnLogs.size() > 0) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, svnLogs.size());
            for (int i = 0; i < svnLogs.size(); ++i) {
                JSONObject listSvnLog = svnLogs.get(i);
                this.getModel().setValue(VERSION, (Object)listSvnLog.getString(VERSION), i);
                this.getModel().setValue(AUTHOR, (Object)listSvnLog.getString(AUTHOR), i);
                this.getModel().setValue("date", (Object)listSvnLog.getString("date"), i);
                try {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    dateFormat.setTimeZone(KDDateUtils.getUserTimeZone());
                    Date date = dateFormat.parse(listSvnLog.getString("date"));
                    this.getModel().setValue("date1", (Object)date, i);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                this.getModel().setValue(MESSAGE, (Object)listSvnLog.getString(MESSAGE), i);
            }
        }
    }

    private List<JSONObject> getSvnLog(String scriptSvnPath) {
        final ArrayList<JSONObject> svnLogs = new ArrayList<JSONObject>();
        String userName = (String)this.getView().getFormShowParameter().getCustomParam(USERNAME);
        String passWord = (String)this.getView().getFormShowParameter().getCustomParam(P);
        try {
            passWord = Encrypters.decode((String)passWord);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        boolean fileIsExist = SvnOperationUtil.isExitsFile((String)scriptSvnPath, (String)userName, (String)passWord);
        if (!fileIsExist) {
            return svnLogs;
        }
        final DateFormat dtf = DateFormat.getDateTimeInstance();
        SVNClientManager clientManager = SVNCommonUtil.authSvn((String)scriptSvnPath, (String)userName, (String)passWord);
        ISVNLogEntryHandler handler = new ISVNLogEntryHandler(){

            public void handleLogEntry(SVNLogEntry logEntry) {
                JSONObject svnLog = new JSONObject();
                svnLog.put(SvnLog.VERSION, (Object)logEntry.getRevision());
                svnLog.put(SvnLog.AUTHOR, (Object)logEntry.getAuthor());
                svnLog.put("date", (Object)dtf.format(logEntry.getDate()));
                svnLog.put(SvnLog.MESSAGE, (Object)logEntry.getMessage());
                svnLogs.add(svnLog);
            }
        };
        SVNCommonUtil.doLog((SVNClientManager)clientManager, (String)userName, (String)passWord, (String)scriptSvnPath, (String[])new String[0], (ISVNLogEntryHandler)handler);
        return svnLogs;
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "comparetosvn": {
                this.compareToSvn();
                break;
            }
            case "comparetovertions": {
                this.compareToVersions();
                break;
            }
            case "updatetoversion": {
                this.updateToVersion();
                break;
            }
            case "exit": {
                this.exit();
                break;
            }
        }
    }

    private void exit() {
        this.getView().close();
    }

    private void updateToVersion() {
        EntryGrid entryentity = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        int[] selectedRows = entryentity.getEntryState().getSelectedRows();
        if (selectedRows.length == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u4e00\u6761\u8bb0\u5f55\u3002", (String)"SvnLog_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (selectedRows.length > 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u4e2d\u4e00\u6761\u8bb0\u5f55\uff0c\u4e0eSVN\u6bd4\u8f83\u3002", (String)"SvnLog_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String version = this.getModel().getValue(VERSION, selectedRows[0]).toString();
        String id = (String)this.getView().getFormShowParameter().getCustomParam("id");
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        String fileNumber = null;
        String filetSvnPath = null;
        DynamicObject scriptInfo = new DynamicObject();
        String svnPath = null;
        if (SCRIPT.equals(type)) {
            scriptInfo = BusinessDataServiceHelper.loadSingle((Object)id, (String)IDE_PLUGINSCRIPT, (String)"txt_scriptnumber,txt_scriptcontext_tag,bizappid,modifier,modifydate");
            String bizAppId = scriptInfo.getString("bizappid");
            fileNumber = scriptInfo.getString(TXT_SCRIPTNUMBER);
            JSONObject svnMsg = SVNUtil.getSVNMsgByAppId((String)bizAppId);
            svnPath = svnMsg.getString(SVNPATH);
            filetSvnPath = svnMsg.get((Object)SVNPATH).toString() + "/metadata/" + fileNumber + ".ks";
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        String sessionId = (String)this.getView().getFormShowParameter().getCustomParam("sessionid");
        String sessionKey = AppUtils.getSessionKey(svnPath, (String)sessionId);
        SessionDAO sessionDao = SessionDAOFactory.getSessionDAO((String)sessionId);
        JSONObject userInfo = JSONObject.parseObject((String)sessionDao.getAttribute(sessionKey));
        String userName = userInfo.getString(USERNAME);
        String passWord = userInfo.getString(P);
        try {
            passWord = Encrypters.decode((String)passWord);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        SVNClientManager clientManager = SVNCommonUtil.authSvn((String)filetSvnPath, (String)userName, (String)passWord);
        SVNCommonUtil.doGetFileContent((SVNClientManager)clientManager, (SVNRevision)SVNRevision.parse((String)version), (String)filetSvnPath, (OutputStream)output);
        byte[] byteArr = output.toByteArray();
        String content = new String(byteArr, StandardCharsets.UTF_8);
        if (SCRIPT.equals(type)) {
            DcxmlSerializer serializer = new DcxmlSerializer(DeployScript.getDCBinder());
            serializer.setColloctionIgnorePKValue(true);
            DeployScript deployNew = (DeployScript)serializer.deserializeFromString(content, null);
            List dynamicObjects = deployNew.getScripts();
            String scriptContent = ((DynamicObject)dynamicObjects.get(0)).getString("context");
            scriptInfo.set("txt_scriptcontext_tag", (Object)scriptContent);
            scriptInfo.set("modifier", (Object)Long.valueOf(RequestContext.get().getUserId()));
            scriptInfo.set("modifydate", (Object)Timestamp.valueOf(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scriptInfo});
            MetaCacheUtils.removeDistributeCache((String[])new String[]{fileNumber});
        }
        this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u66f4\u65b0\u5230\u7248\u672c\uff1a%s\u3002", (String)"SvnLog_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), version));
        JSONObject consoleData = new JSONObject();
        consoleData.put("date", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        consoleData.put("output", (Object)String.format(ResManager.loadKDString((String)"\u811a\u672c %1$s.ks \u6210\u529f\u66f4\u65b0\u81f3\u7248\u672c %2$s", (String)"SvnLog_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), fileNumber, version));
        this.getView().returnDataToParent((Object)consoleData);
        this.getView().close();
    }

    private void compareToVersions() {
        EntryGrid entryentity = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        int[] selectedRows = entryentity.getEntryState().getSelectedRows();
        if (selectedRows.length == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u4e24\u6761\u8bb0\u5f55\u3002", (String)"SvnLog_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (selectedRows.length != 2) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6bd4\u8f83\u4e24\u4e2a\u7248\u672c\uff0c\u53ea\u80fd\u9009\u62e9\u4e24\u6761\u8bb0\u5f55\u3002", (String)"SvnLog_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String newVersion = this.getModel().getValue(VERSION, selectedRows[0]).toString();
        String oldVersion = this.getModel().getValue(VERSION, selectedRows[1]).toString();
        this.CompareTwoVersions(newVersion, oldVersion, true);
    }

    private void compareToSvn() {
        EntryGrid entryentity = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        int[] selectedRows = entryentity.getEntryState().getSelectedRows();
        if (selectedRows.length == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u4e00\u6761\u8bb0\u5f55\u3002", (String)"SvnLog_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (selectedRows.length > 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u4e2d\u4e00\u6761\u8bb0\u5f55\uff0c\u4e0eSVN\u6bd4\u8f83\u3002", (String)"SvnLog_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String oldVersion = this.getModel().getValue(VERSION, selectedRows[0]).toString();
        this.CompareTwoVersions("head", oldVersion, false);
    }

    private void CompareTwoVersions(String newVersion, String oldVersion, boolean isShowButtons) {
        String bizAppId = null;
        String fileName = null;
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        String id = (String)this.getView().getFormShowParameter().getCustomParam("id");
        if (SCRIPT.equalsIgnoreCase(type)) {
            DynamicObject scriptInfo = BusinessDataServiceHelper.loadSingle((Object)id, (String)IDE_PLUGINSCRIPT, (String)"txt_scriptnumber,txt_scriptcontext_tag,bizappid");
            bizAppId = scriptInfo.getString("bizappid");
            fileName = scriptInfo.getString(TXT_SCRIPTNUMBER) + ".ks";
        }
        JSONObject svnMsg = SVNUtil.getSVNMsgByAppId(bizAppId);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_svndiff");
        parameter.setCaption(String.format(ResManager.loadKDString((String)"svn\u5dee\u5f02\u6bd4\u8f83(%s)", (String)"SvnLog_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), fileName));
        parameter.setCustomParam("type", (Object)type);
        parameter.setCustomParam("id", (Object)id);
        parameter.setCustomParam(SVNPATH, (Object)svnMsg.get((Object)SVNPATH).toString());
        parameter.setCustomParam("oldversion", (Object)oldVersion);
        parameter.setCustomParam("newversion", (Object)newVersion);
        parameter.setCustomParam("compare", (Object)isShowButtons);
        OpenStyle style = new OpenStyle();
        StyleCss cssStyle = new StyleCss();
        cssStyle.setHeight("760");
        cssStyle.setWidth("1200");
        style.setInlineStyleCss(cssStyle);
        style.setShowType(ShowType.Modal);
        parameter.setOpenStyle(style);
        this.getView().showForm(parameter);
    }
}

