/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.devportal.util.LoginMCServiceUtil;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mc.webclient.File;
import kd.bos.mc.webclient.WebClientFiles;
import kd.bos.metadata.form.control.HyperlinkAp;
import kd.bos.mservice.svc.attach.IAttachmentModelProxy;
import kd.bos.mservice.svc.attach.IAttachmentPanel;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;

public class TenantLoginConfigPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static Log logger = LogFactory.getLog(TenantLoginConfigPlugin.class);
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String ADVCLOSE = "advclose";
    private static final String ADVOPEN = "advopen";
    private static final String ADVLABEL = "advlabel";
    private static final String FILE_KEY = "_tenant_login_config_files_";
    private static final String CONFIG_KEY = "_tenant_login_config_values_";
    private static final String TAB_WORD = "tabword";
    private static final String BG_IMG = "bgimg";
    private static final String LOGO_IMG = "logoimg";
    private static final String TAB_IMG = "tabimg";
    private static final String LEFT_TOP_LOGO_IMG = "lefttoplogoimg";
    private static final String ACCOUNT_TYPE_DESC = "accounttypedesc";
    private static final String WELCOME_MSG = "welcomemsg";
    private static final String ACCOUNT_PLACEHOLDER = "accountplaceholder";
    private static final String RESET_PD = "resetpwd";
    private static final String HIDDEN_RESET_PD = "hiddenresetpwd";
    private static final String LINK_DATA = "linkdata";
    private static final String ATTACH_FILES = "attachfiles";
    private static final String GLOBAL_PATH = "globalfiles";
    private static final String FILE_PANEL_KEY = "filepanel";
    private static final String USER_NAME_PSW = "usernamepsw";
    private static final String[] wordTypeArray = new String[]{"tabword", "bgimg", "logoimg", "tabimg", "lefttoplogoimg", "accounttypedesc", "welcomemsg", "accountplaceholder", "hiddenresetpwd", "usernamepsw"};
    private static final String VALIDATE = "validate";
    private static final String VALIEDATA_TIPS = "validate_tips";
    private static final String ADV_SETTING_PANEL_KEY = "advsetting";
    private static final String ADV_SETTING_PANEL_STATUS = "__advsetting_status__";
    private static final String LINK_KEY = "_tenantlogin_linksetting_";
    private static final String LINK_ZOON_KEY = "linkzoon";
    private static final String URL_CACHE_KEY = "_custom_logo_url_";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"save", "cancel", ADVLABEL, ADVCLOSE, ADVOPEN, LINK_ZOON_KEY, "linksettinglabel"});
        IAttachmentPanel filePanel = (IAttachmentPanel)this.getControl(FILE_PANEL_KEY);
        filePanel.addUploadListener((UploadListener)this);
    }

    public void afterBindData(EventObject event) {
        try {
            List<Map<String, Object>> files;
            String attachFileStrs = this.getPageCache().get(ATTACH_FILES);
            if (StringUtils.isEmpty((String)attachFileStrs) || "null".equals(attachFileStrs)) {
                attachFileStrs = LoginMCServiceUtil.getMcData(FILE_KEY);
            }
            if (StringUtils.isNotEmpty((String)attachFileStrs) && !"null".equals(attachFileStrs) && (files = this.attachNewSessionId((List)SerializationUtils.fromJsonString((String)attachFileStrs, List.class))) != null && files.size() > 0) {
                IAttachmentPanel filePanel = (IAttachmentPanel)this.getControl(FILE_PANEL_KEY);
                filePanel.bindData(files);
                this.getPageCache().put(ATTACH_FILES, attachFileStrs);
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u81ea\u5b9a\u4e49\u6587\u4ef6\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
    }

    public void afterCreateNewData(EventObject event) {
        try {
            String configData = LoginMCServiceUtil.getMcData(CONFIG_KEY);
            if (StringUtils.isNotEmpty((String)configData)) {
                Map dataMap = (Map)SerializationUtils.fromJsonString((String)configData, Map.class);
                dataMap.forEach((k, v) -> {
                    if (LINK_DATA.equals(k)) {
                        this.getPageCache().put(LINK_KEY, v);
                    } else if (ACCOUNT_TYPE_DESC.equals(k) || ACCOUNT_PLACEHOLDER.equals(k) || TAB_WORD.equals(k) || WELCOME_MSG.equals(k)) {
                        if (v.contains("[") && v.contains("]")) {
                            String multiValue = v.substring(1, v.length() - 1);
                            String[] multivalueArr = multiValue.split(",");
                            HashMap<String, String> map = new HashMap<String, String>();
                            for (String value : multivalueArr) {
                                String[] valueArr = value.split("=");
                                if (valueArr.length == 2) {
                                    map.put(StringUtils.trim((String)valueArr[0]), valueArr[1]);
                                    continue;
                                }
                                map.put(StringUtils.trim((String)valueArr[0]), "");
                            }
                            this.getModel().setValue(k, map);
                        } else {
                            this.getModel().setValue(k, v);
                        }
                    } else {
                        this.getModel().setValue(k, v);
                    }
                });
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u767b\u5f55\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
        }
        String attachFileStrs = "";
        try {
            this.getPageCache().remove(ATTACH_FILES);
            attachFileStrs = LoginMCServiceUtil.getMcData(FILE_KEY);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u81ea\u5b9a\u4e49\u6587\u4ef6\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        if (StringUtils.isNotEmpty((String)attachFileStrs) && !"null".equals(attachFileStrs)) {
            this.getPageCache().put(ATTACH_FILES, attachFileStrs);
            this.getPageCache().put(ADV_SETTING_PANEL_STATUS, "true");
            Label advSettingSwitch = (Label)this.getControl(ADVLABEL);
            advSettingSwitch.setText(ResManager.loadKDString((String)"\u9690\u85cf\u9ad8\u7ea7\u8bbe\u7f6e", (String)"TenantLoginConfigPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{ADVCLOSE});
            this.getView().setVisible(Boolean.TRUE, new String[]{ADVOPEN});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{ADVOPEN, ADV_SETTING_PANEL_KEY});
            this.getPageCache().put(ADV_SETTING_PANEL_STATUS, "false");
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("save".equals(control.getKey())) {
            this.save2MC();
        } else if (ADVLABEL.equals(control.getKey()) || ADVOPEN.equals(control.getKey()) || ADVCLOSE.equals(control.getKey())) {
            Label advSettingSwitch = (Label)this.getControl(ADVLABEL);
            String advPanelStatus = this.getPageCache().get(ADV_SETTING_PANEL_STATUS);
            if (Boolean.parseBoolean(advPanelStatus)) {
                this.hideAdvSettingPanel();
                this.getPageCache().put(ADV_SETTING_PANEL_STATUS, "false");
                advSettingSwitch.setText(ResManager.loadKDString((String)"\u9ad8\u7ea7\u8bbe\u7f6e", (String)"TenantLoginConfigPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                this.getView().setVisible(Boolean.TRUE, new String[]{ADVCLOSE});
                this.getView().setVisible(Boolean.FALSE, new String[]{ADVOPEN});
            } else {
                this.showAdvSettingPanel();
                this.getPageCache().put(ADV_SETTING_PANEL_STATUS, "true");
                advSettingSwitch.setText(ResManager.loadKDString((String)"\u9690\u85cf\u9ad8\u7ea7\u8bbe\u7f6e", (String)"TenantLoginConfigPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                this.getView().setVisible(Boolean.FALSE, new String[]{ADVCLOSE});
                this.getView().setVisible(Boolean.TRUE, new String[]{ADVOPEN});
            }
        } else if (LINK_ZOON_KEY.equals(control.getKey()) || "linksettinglabel".equals(control.getKey())) {
            this.showSettingForm();
        }
    }

    private void showSettingForm() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("sys_linksetting");
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Modal);
        parameter.setOpenStyle(openStyle);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "linksetting");
        parameter.setCloseCallBack(closeCallBack);
        try {
            Map dataMap;
            String linkDataStr;
            String configData = LoginMCServiceUtil.getMcData(CONFIG_KEY);
            if (StringUtils.isNotEmpty((String)configData) && StringUtils.isNotEmpty((String)(linkDataStr = (String)(dataMap = (Map)SerializationUtils.fromJsonString((String)configData, Map.class)).get(LINK_DATA)))) {
                List collection = (List)SerializationUtils.fromJsonString((String)linkDataStr, List.class);
                parameter.setCustomParam("linkData", (Object)collection);
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u94fe\u63a5\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map data;
        DynamicObjectCollection collection;
        Map returnData;
        if ("linksetting".equals(evt.getActionId()) && (returnData = (Map)evt.getReturnData()) != null && (collection = (DynamicObjectCollection)(data = (Map)returnData.get("value")).get("linkData")) != null) {
            this.getPageCache().put(LINK_KEY, SerializationUtils.toJsonString((Object)collection));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (HIDDEN_RESET_PD.equals(propertyName)) {
            boolean newValue = (Boolean)e.getChangeSet()[0].getNewValue();
            this.getView().setVisible(Boolean.valueOf(!newValue), new String[]{RESET_PD});
        }
    }

    private void createHyperLink(String key, String name, String url) {
        Container linkZoon = (Container)this.getControl(LINK_ZOON_KEY);
        HyperlinkAp hyper = new HyperlinkAp();
        hyper.setKey(key);
        hyper.setId(key);
        hyper.setName(new LocaleString(name));
        hyper.setLinkUrl(url);
        Map runtimeMeta = hyper.createControl();
        ArrayList<Map> items = new ArrayList<Map>();
        items.add(runtimeMeta);
        linkZoon.addControls(items);
    }

    public void afterUpload(UploadEvent evt) {
        Object[] data = evt.getUrls();
        if (data != null && data.length > 0) {
            ArrayList<Object> newFileInfos = new ArrayList<Object>(Arrays.asList(data));
            boolean validate = this.check(newFileInfos);
            this.getPageCache().put(VALIDATE, Boolean.toString(validate));
            if (validate) {
                this.getPageCache().put(ATTACH_FILES, SerializationUtils.toJsonString(newFileInfos));
            }
        }
    }

    public void afterRemove(UploadEvent evt) {
        this.getPageCache().remove(VALIDATE);
        this.getPageCache().remove(ATTACH_FILES);
    }

    private boolean check(List<Object> newFileInfos) {
        if (newFileInfos == null) {
            return false;
        }
        for (Map map : newFileInfos) {
            List<FileInfo> fileInfos = this.getFileInfo((String)map.get("url"));
            if (fileInfos.size() == 0) {
                return false;
            }
            if (!this.checkSuffix(fileInfos)) {
                return false;
            }
            if (this.checkExist(fileInfos)) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u538b\u7f29\u5305\u6839\u76ee\u5f55\u6ca1\u6709index.js\u6216index_m.js\u7684\u5165\u53e3\u6587\u4ef6\uff0c\u8bf7\u5904\u7406\u3002", (String)"TenantLoginConfigPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getPageCache().put(VALIEDATA_TIPS, ResManager.loadKDString((String)"\u538b\u7f29\u5305\u6839\u76ee\u5f55\u6ca1\u6709index.js\u6216index_m.js\u7684\u5165\u53e3\u6587\u4ef6\uff0c\u8bf7\u5904\u7406\u3002", (String)"TenantLoginConfigPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private List<FileInfo> getFileInfo(String url) {
        String failedTips = new LocaleString(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (String)"TenantLoginConfigPlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0])).toString();
        ZipEntry zipEntry = null;
        ArrayList<FileInfo> data = new ArrayList<FileInfo>();
        try (InputStream in = this.getInputStreamByUrl(url);
             ZipInputStream zipInput = new ZipInputStream(in, StandardCharsets.UTF_8);){
            if (in != null) {
                while ((zipEntry = zipInput.getNextEntry()) != null) {
                    if (zipEntry.isDirectory()) continue;
                    String fileFullPath = zipEntry.getName();
                    int idx = fileFullPath.lastIndexOf(46);
                    String suffix = idx != -1 ? fileFullPath.substring(idx, fileFullPath.length()) : null;
                    data.add(new FileInfo(fileFullPath, suffix, zipEntry));
                }
                if (data.size() == 0) {
                    this.getPageCache().put(VALIEDATA_TIPS, ResManager.loadKDString((String)"\u4e0a\u4f20\u4e86\u4e00\u4e2a\u7a7a\u7684\u538b\u7f29\u5305", (String)"TenantLoginConfigPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0a\u4f20\u4e86\u4e00\u4e2a\u7a7a\u7684\u538b\u7f29\u5305", (String)"TenantLoginConfigPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                }
            } else {
                this.getView().showErrMessage(String.format(ResManager.loadKDString((String)"\u6587\u4ef6url: %s", (String)"TenantLoginConfigPlugin_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), url), failedTips);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.getView().showErrMessage(e.getMessage() + "\r\n" + url, failedTips);
        }
        return data;
    }

    private boolean checkSuffix(List<FileInfo> fileInfos) {
        HashSet<String> FILE_WHITE_LIST = new HashSet<String>(10);
        FILE_WHITE_LIST.add(".js");
        FILE_WHITE_LIST.add(".css");
        FILE_WHITE_LIST.add(".html");
        FILE_WHITE_LIST.add(".tpl");
        FILE_WHITE_LIST.add(".png");
        FILE_WHITE_LIST.add(".jpg");
        FILE_WHITE_LIST.add(".jpeg");
        FILE_WHITE_LIST.add(".svg");
        FILE_WHITE_LIST.add(".gif");
        FILE_WHITE_LIST.add(".ico");
        for (FileInfo fileInfo : fileInfos) {
            if (fileInfo.getSuffix() != null && FILE_WHITE_LIST.contains(fileInfo.getSuffix().toLowerCase())) continue;
            String tips = String.format(ResManager.loadKDString((String)"\u538b\u7f29\u5305\u4e2d\u5305\u542b\u975e\u6cd5\u6587\u4ef6\u7c7b\u578b%s\uff0c\u8bf7\u5904\u7406\u3002", (String)"TenantLoginConfigPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), fileInfo.getFullPath());
            this.getView().showErrorNotification(tips);
            this.getPageCache().put(VALIEDATA_TIPS, tips);
            return false;
        }
        return true;
    }

    private boolean checkExist(List<FileInfo> fileInfos) {
        ArrayList fileNames = new ArrayList();
        fileInfos.forEach(fileInfo -> fileNames.add(fileInfo.getFullPath()));
        return fileNames.containsAll(new ArrayList<String>(Arrays.asList("index.js", "index_m.js")));
    }

    private String save2FileService(String tempUrl, String uid, String fileName) {
        if (this.isTempUrl(tempUrl)) {
            IAttachmentModelProxy attachmentModelProxy = (IAttachmentModelProxy)ServiceFactory.getService(IAttachmentModelProxy.class);
            return attachmentModelProxy.getEncreptURL(UrlService.getAttachmentFullUrl((String)this.encodeUrl(attachmentModelProxy.saveTempToFileService(tempUrl, this.getView().getFormShowParameter().getServiceAppId(), this.getView().getFormShowParameter().getFormId(), uid, fileName))));
        }
        return tempUrl;
    }

    private boolean isTempUrl(String url) {
        return StringUtils.isNotEmpty((String)url) && url.contains("configKey");
    }

    private LocalMemoryCache getCache() {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(1200);
        info.setMaxItemSize(50);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(RequestContext.getOrCreate().getAccountId(), "custLoginConfig", info);
    }

    private void save2MC() {
        String validateFromPageCache = this.getPageCache().get(VALIDATE);
        if (StringUtils.isNotEmpty((String)validateFromPageCache) && !Boolean.parseBoolean(validateFromPageCache)) {
            this.getView().showErrorNotification(this.getPageCache().get(VALIEDATA_TIPS));
            return;
        }
        try {
            String attachFiles = this.getPageCache().get(ATTACH_FILES);
            if (StringUtils.isNotEmpty((String)attachFiles)) {
                String[] data = (String[])SerializationUtils.fromJsonString((String)attachFiles, List.class);
                data.forEach(map -> {
                    String url = (String)map.get("url");
                    String newURL = this.isTempUrl(url) ? this.save2FileService(url, (String)map.get("uid"), (String)map.get("name")) : this.replaceEnableSessionId(url);
                    map.put("url", newURL);
                });
                this.setWebClientFiles(this.getListFile((List<Map<String, Object>>)data));
                String serialData = SerializationUtils.toJsonString((Object)data);
                LoginMCServiceUtil.saveMcData(FILE_KEY, serialData);
                this.getPageCache().put(ATTACH_FILES, serialData);
            } else {
                this.setWebClientFiles(null);
                LoginMCServiceUtil.saveMcData(FILE_KEY, "null");
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.getView().showErrMessage(this.getErrorMsg(e), ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"TenantLoginConfigPlugin_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        try {
            HashMap<String, String> data = new HashMap<String, String>(wordTypeArray.length);
            for (String key : wordTypeArray) {
                Object object = this.getModel().getValue(key);
                if (object instanceof OrmLocaleValue) {
                    String valueOrm = ((OrmLocaleValue)this.getModel().getValue(key)).entrySet().toString();
                    data.put(key, StringUtils.trim((String)valueOrm));
                    continue;
                }
                if (object instanceof String) {
                    String value = (String)this.getModel().getValue(key);
                    data.put(key, StringUtils.trim((String)value));
                    continue;
                }
                if (!(object instanceof Boolean)) continue;
                boolean valueBoolean = (Boolean)object;
                data.put(key, Boolean.toString(valueBoolean));
            }
            String linkDataStr = this.getPageCache().get(LINK_KEY);
            if (StringUtils.isNotEmpty((String)linkDataStr)) {
                data.put(LINK_DATA, linkDataStr);
            }
            this.getCache().remove(new String[]{URL_CACHE_KEY});
            LoginMCServiceUtil.saveMcData(CONFIG_KEY, SerializationUtils.toJsonString(data));
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.getView().showErrMessage(this.getErrorMsg(e), ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"TenantLoginConfigPlugin_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"TenantLoginConfigPlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
    }

    private String getUniqueId(String suffix) {
        return "_tenant_login_config_" + RequestContext.get().getTenantId() + "_" + suffix;
    }

    private List<Map<String, Object>> getUnionCollectionWithPageCache(List<Object> newFileInfos) {
        String filesFromCacheStr = this.getPageCache().get(ATTACH_FILES);
        if (StringUtils.isNotEmpty((String)filesFromCacheStr)) {
            List filesFromCache = (List)SerializationUtils.fromJsonString((String)filesFromCacheStr, List.class);
            Iterator it = filesFromCache.iterator();
            while (it.hasNext()) {
                Map map = (Map)it.next();
                String oldFileId = (String)map.get("uid");
                newFileInfos.forEach(item -> {
                    Map sourceData = (Map)item;
                    if (oldFileId.equals(sourceData.get("uid"))) {
                        it.remove();
                    }
                });
            }
            return filesFromCache.size() > 0 ? filesFromCache : Collections.EMPTY_LIST;
        }
        return Collections.EMPTY_LIST;
    }

    private void setWebClientFiles(List<File> listFile) throws Exception {
        WebClientFiles client = new WebClientFiles();
        client.setDcid(RequestContext.get().getAccountId());
        client.setIsv(ISVServiceHelper.getISVInfo().getId());
        client.setKeys(this.getUniqueId(ATTACH_FILES));
        client.setTenantId(RequestContext.get().getTenantId());
        client.setFiles(listFile == null ? Collections.EMPTY_LIST : listFile);
        LoginMCServiceUtil.getMcService().setWebClientFiles(client);
    }

    private List<File> getListFile(List<Map<String, Object>> data) {
        if (data != null) {
            ArrayList<File> listFile = new ArrayList<File>();
            data.forEach(item -> {
                String url = (String)item.get("url");
                String name = (String)item.get("name");
                File file = new File();
                file.setDestPath(GLOBAL_PATH);
                file.setName(name);
                file.setServerType("FS");
                file.setNeedUpdate(true);
                file.setFileServerPath(url);
                listFile.add(file);
            });
            return listFile;
        }
        return Collections.EMPTY_LIST;
    }

    private List<Map<String, Object>> attachNewSessionId(List<Map<String, Object>> data) {
        if (data != null && data.size() > 0) {
            data.forEach(map -> map.put("url", this.replaceEnableSessionId((String)map.get("url"))));
        }
        return data;
    }

    private String replaceEnableSessionId(String url) {
        String newUrl;
        if (!StringUtils.isNotEmpty((String)url)) {
            return url;
        }
        String _temp_url = url.replace('?', ';');
        String sessionIdStr = "";
        if (_temp_url.contains(";")) {
            String[] arr;
            for (String s : arr = _temp_url.split(";")[1].split("&")) {
                if (!"kdedcba".equals(s.split("=")[0])) continue;
                sessionIdStr = s;
                break;
            }
        }
        if ((newUrl = url.replace(sessionIdStr, "")).endsWith("&")) {
            newUrl = newUrl.substring(0, newUrl.length() - 1);
        }
        IAttachmentModelProxy attachmentModelProxy = (IAttachmentModelProxy)ServiceFactory.getService(IAttachmentModelProxy.class);
        return StringUtils.isNotEmpty((String)sessionIdStr) ? attachmentModelProxy.getEncreptURL(newUrl) : url;
    }

    private String encodeUrl(String url) {
        try {
            return StringUtils.isNotEmpty((String)url) ? URLEncoder.encode(url, StandardCharsets.UTF_8.name()) : url;
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Throwable)e);
            this.getView().showErrMessage(e.getMessage(), ResManager.loadKDString((String)"URL\u7f16\u7801\u5f02\u5e38\u3002", (String)"TenantLoginConfigPlugin_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return url;
        }
    }

    private void hideAdvSettingPanel() {
        this.getView().setVisible(Boolean.FALSE, new String[]{ADV_SETTING_PANEL_KEY});
    }

    private void showAdvSettingPanel() {
        this.getView().setVisible(Boolean.TRUE, new String[]{ADV_SETTING_PANEL_KEY});
    }

    private String getErrorMsg(Exception e) {
        if (e == null) {
            return "";
        }
        if (e instanceof KDException) {
            KDException kde = (KDException)((Object)e);
            Object[] args = kde.getArgs();
            StringBuilder buf = new StringBuilder();
            if (args != null && args.length > 0) {
                for (Object o : args) {
                    buf.append(o);
                }
            }
            buf.append("\r\n");
            buf.append(kde.getMessage());
            buf.append("\r\n");
            buf.append(kde.getStackTraceMessage());
            return buf.toString();
        }
        return e.getMessage();
    }

    private InputStream getInputStreamByUrl(String url) {
        if (StringUtils.isNotEmpty((String)url)) {
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            return cache.getInputStream(url);
        }
        return null;
    }

    private static class FileInfo {
        private String fullPath;
        private String suffix;
        private ZipEntry zipEntry;

        public FileInfo(String fullPath, String suffix, ZipEntry zipEntry) {
            this.fullPath = fullPath;
            this.suffix = suffix;
            this.zipEntry = zipEntry;
        }

        public String getFullPath() {
            return this.fullPath;
        }

        public void setFullPath(String fullPath) {
            this.fullPath = fullPath;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public void setSuffix(String suffix) {
            this.suffix = suffix;
        }

        public ZipEntry getZipEntry() {
            return this.zipEntry;
        }

        public void setZipEntry(ZipEntry zipEntry) {
            this.zipEntry = zipEntry;
        }
    }
}

